/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tccit.common.utils.BigDecimalUtils;
import kd.taxc.tccit.formplugin.taxbook.ExtendAbstractBillPlugin;

public class InvestDisposeEdit
extends ExtendAbstractBillPlugin
implements BeforeF7SelectListener {
    private static final String ASSET_LOSS_TYPE = "assetlosstype";
    private static final String TRANS_TYPE = "transtype";
    private static final String BUSSI_DATE = "bussidate";
    private static final String BILL_NO = "billno";
    private static final String SYCZTSXSWCL = "sycztsxswcl";
    private static final String TSXSWCLSSJE = "tsxswclssje";
    protected static final String INVEST_DISPOSE = "tccit_invest_dispose";
    private static final String INVEST_DISPOSE_CZ_ENT = "tccit_invest_cz_ent";
    private static final String CZZCZMJZ = "czzczmjz";
    private static final String SWCZSYSS = "swczsyss";
    private static final String SSJE = "ssje";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit transType = (BasedataEdit)this.getView().getControl(TRANS_TYPE);
        transType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit assetLossType = (BasedataEdit)this.getView().getControl(ASSET_LOSS_TYPE);
        assetLossType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit type = (BasedataEdit)this.getView().getControl("name");
        type.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent bfse) {
        String key = ((BasedataEdit)bfse.getSource()).getKey();
        if (TRANS_TYPE.equals(key)) {
            bfse.getFormShowParameter().setCustomParam("parentNum", (Object)"3");
            bfse.getFormShowParameter().setCustomParam("containParent", (Object)Boolean.TRUE);
            bfse.getFormShowParameter().setCustomParam("caption", (Object)ResManager.loadKDString((String)"\u6295\u8d44\u8d44\u4ea7\u5904\u7f6e\u4ea4\u6613\u7c7b\u578b", (String)"InvestDisposeEdit_0", (String)"taxc-tccit", (Object[])new Object[0]));
        } else if (ASSET_LOSS_TYPE.equals(key)) {
            this.assetLossTypeF7(bfse);
        } else if ("name".equals(key)) {
            bfse.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6295\u8d44\u6807\u7684\u540d\u79f0", (String)"InvestDisposeEdit_1", (String)"taxc-tccit", (Object[])new Object[0]));
            Object value = this.getModel().getValue("org");
            if (value != null) {
                DynamicObject org = (DynamicObject)value;
                String orgNumber = org.getString("number");
                bfse.addCustomQFilter(new QFilter("org.number", "=", (Object)orgNumber));
                bfse.addCustomQFilter(new QFilter("assetstatus", "=", (Object)"0"));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7", (String)"InvestDisposeEdit_2", (String)"taxc-tccit", (Object[])new Object[0]));
                bfse.setCancel(true);
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Save) {
            DynamicObjectCollection investCzEnt = this.getModel().getEntryEntity(INVEST_DISPOSE_CZ_ENT);
            if (CollectionUtils.isEmpty((Collection)investCzEnt) || investCzEnt.stream().filter(s -> s.getBigDecimal(CZZCZMJZ).compareTo(BigDecimal.ZERO) < 0).findAny().isPresent()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5904\u7f6e\u8d44\u4ea7\u8d26\u9762\u4ef7\u503c\u5e94\u4e3a\u5927\u4e8e\u7b49\u4e8e0\u7684\u6570\u503c", (String)"InvestDisposeEdit_3", (String)"taxc-tccit", (Object[])new Object[0]));
                args.setCancel(true);
            }
            BigDecimal totalczzczmjz = BigDecimal.ZERO;
            for (DynamicObject object : investCzEnt) {
                totalczzczmjz = BigDecimalUtil.addObject((Object)totalczzczmjz, (Object)object.getBigDecimal(CZZCZMJZ));
            }
            if (BigDecimalUtils.largeMaxValue(totalczzczmjz)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5904\u7f6e\u8d44\u4ea7\u8d26\u9762\u4ef7\u503c\u5408\u8ba1\u503c\u6574\u6570\u4f4d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc713\u4f4d\u3002", (String)"InvestDisposeEdit_4", (String)"taxc-tccit", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        Comparable<Date> newValue;
        ChangeData[] changeSet;
        String name = args.getProperty().getName();
        if ("name".equals(name)) {
            String billno = (String)this.getModel().getValue(BILL_NO);
            BigDecimal ljtzcbrzje = this.getLjtzcbrzje(billno);
            this.getModel().setValue("ljtzcbrzje", (Object)ljtzcbrzje);
        }
        if (BUSSI_DATE.equals(name)) {
            long nameId;
            DynamicObjectCollection obtainDates;
            Date obtainDate;
            changeSet = args.getChangeSet();
            newValue = (Date)changeSet[0].getNewValue();
            DynamicObject investName = (DynamicObject)this.getModel().getValue("name");
            if (investName != null && newValue != null && (obtainDate = (Date)(obtainDates = QueryServiceHelper.query((String)"tccit_new_invest_asset", (String)"tccit_new_invest_detail.date obtainDate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(nameId = investName.getLong("id")))})).stream().map(d -> d.getDate("obtainDate")).filter(Objects::nonNull).min(Date::compareTo).orElse(null)) != null && ((Date)newValue).compareTo(obtainDate) < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u4ea7\u5904\u7f6e\u65f6\u95f4\u4e0d\u5e94\u65e9\u4e8e\u8be5\u8d44\u4ea7\u7684\u5165\u8d26\u65f6\u95f4", (String)"InvestDisposeEdit_5", (String)"taxc-tccit", (Object[])new Object[0]));
                int rowIndex = changeSet[0].getRowIndex();
                Date oldValue = (Date)changeSet[0].getOldValue();
                if (oldValue != null && oldValue.compareTo(obtainDate) >= 0) {
                    this.getModel().setValue(name, (Object)oldValue, rowIndex);
                } else {
                    this.getModel().setValue(name, null, rowIndex);
                }
            }
        } else if (SSJE.equals(name)) {
            changeSet = args.getChangeSet();
            newValue = (BigDecimal)changeSet[0].getNewValue();
            int rowIndex = changeSet[0].getRowIndex();
            this.getModel().setValue(SWCZSYSS, (Object)this.setSwczsyss((BigDecimal)newValue), rowIndex);
        }
    }

    public void afterLoadData(EventObject e) {
        String billno = (String)this.getModel().getValue(BILL_NO);
        BigDecimal ljtzcbrzje = this.getLjtzcbrzje(billno);
        this.getModel().setValue("ljtzcbrzje", (Object)ljtzcbrzje);
        this.getModel().setDataChanged(false);
    }

    public void beforeImportData(BeforeImportDataEventArgs args) {
        Map sourceData = args.getSourceData();
        Map option = args.getOption();
        String importtype = (String)option.get("importtype");
        boolean isUpdate = option.containsKey("importtype") && ("override".equals(importtype) || "overridenew".equals(importtype));
        JSONObject org = (JSONObject)sourceData.get("org");
        String billno = (String)sourceData.get(BILL_NO);
        QFilter[] qFilters = new QFilter[]{new QFilter(BILL_NO, "=", (Object)billno), new QFilter("org.number", "=", org.get((Object)"number"))};
        boolean exists = QueryServiceHelper.exists((String)INVEST_DISPOSE, (QFilter[])qFilters);
        if (!isUpdate && exists) {
            args.setCancel(true);
            args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u8d44\u4ea7\u7f16\u53f7\uff0c\u8bf7\u4fee\u6539", (String)"InvestDisposeEdit_6", (String)"taxc-tccit", (Object[])new Object[0])));
            return;
        }
        boolean inNewInvestAsset = QueryServiceHelper.exists((String)"tccit_new_invest_asset", (QFilter[])qFilters);
        if (!inNewInvestAsset) {
            args.setCancel(true);
            args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6", (String)"InvestDisposeEdit_7", (String)"taxc-tccit", (Object[])new Object[0]), billno)));
            return;
        }
        DynamicObject dynObj = QueryServiceHelper.queryOne((String)"tccit_new_invest_asset", (String)"id,assetstatus,name,assettype.id assetTypeId,investtype.id investTypeId", (QFilter[])new QFilter[]{new QFilter(BILL_NO, "=", (Object)billno)});
        if (dynObj == null) {
            args.setCancel(true);
            args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6", (String)"InvestDisposeEdit_7", (String)"taxc-tccit", (Object[])new Object[0]), billno)));
            return;
        }
        String status = dynObj.getString("assetstatus");
        if ("1".equals(status)) {
            args.setCancel(true);
            args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(ResManager.loadKDString((String)"\u8be5\u8d44\u4ea7\u5df2\u5904\u7f6e\uff0c\u8bf7\u68c0\u67e5\u5df2\u5f55\u5165\u7684\u8d44\u4ea7\u4fe1\u606f", (String)"InvestDisposeEdit_8", (String)"taxc-tccit", (Object[])new Object[0])));
            return;
        }
        long assetTypeId = dynObj.getLong("assetTypeId");
        sourceData.put("assettype.id", assetTypeId);
        long investTypeId = dynObj.getLong("investTypeId");
        sourceData.put("investtype.id", investTypeId);
        sourceData.put("assetstatus", status);
        long assetId = dynObj.getLong("id");
        sourceData.put("name", new JSONObject().fluentPut("id", (Object)assetId));
        DynamicObjectCollection obtainDates = QueryServiceHelper.query((String)"tccit_new_invest_asset", (String)"tccit_new_invest_detail.date obtainDate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)assetId)});
        Date obtainDate = obtainDates.stream().map(d -> d.getDate("obtainDate")).filter(Objects::nonNull).min(Date::compareTo).orElse(null);
        if (obtainDate != null) {
            List detailList = ((JSONArray)JSONArray.toJSON(sourceData.get(INVEST_DISPOSE_CZ_ENT))).stream().map(o -> (JSONObject)JSONObject.toJSON((Object)o)).collect(Collectors.toList());
            for (JSONObject detail : detailList) {
                JSONObject transtype;
                Object transNum;
                boolean transtypeExists;
                if (detail.getBigDecimal(TSXSWCLSSJE) == null) {
                    detail.put(TSXSWCLSSJE, (Object)BigDecimal.ZERO);
                }
                if (!(transtypeExists = QueryServiceHelper.exists((String)"tpo_tccit_bizdef_entry", (QFilter[])new QFilter[]{new QFilter("number", "=", transNum = (transtype = (JSONObject)detail.get((Object)TRANS_TYPE)).get((Object)"number"))}))) {
                    args.setCancel(true);
                    args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(ResManager.loadKDString((String)"\u4ea4\u6613\u7c7b\u578b\u4e0d\u5b58\u5728", (String)"InvestDisposeEdit_9", (String)"taxc-tccit", (Object[])new Object[0])));
                    return;
                }
                Date bookedTime = detail.getDate(BUSSI_DATE);
                if (bookedTime.compareTo(obtainDate) < 0) {
                    args.setCancel(true);
                    args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(ResManager.loadKDString((String)"\u8d44\u4ea7\u4ef7\u503c\u53d8\u52a8\u65f6\u95f4\u4e0d\u5e94\u65e9\u4e8e\u8be5\u8d44\u4ea7\u7684\u53d6\u5f97\u65f6\u95f4", (String)"InvestDisposeEdit_10", (String)"taxc-tccit", (Object[])new Object[0])));
                    return;
                }
                String cycztsxswcl = detail.getString(SYCZTSXSWCL);
                if (("1".equals(cycztsxswcl) || "2".equals(cycztsxswcl)) && detail.get((Object)TSXSWCLSSJE) == null) {
                    args.setCancel(true);
                    args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u3010\u7279\u6b8a\u6027\u7a0e\u52a1\u5904\u7406\u7a0e\u6536\u91d1\u989d\u3011", (String)"InvestDisposeEdit_11", (String)"taxc-tccit", (Object[])new Object[0])));
                    return;
                }
                if (this.isInvalidNumeric(args, detail, CZZCZMJZ, ResManager.loadKDString((String)"\u5904\u7f6e\u8d44\u4ea7\u8d26\u9762\u4ef7\u503c", (String)"InvestDisposeEdit_12", (String)"taxc-tccit", (Object[])new Object[0]))) {
                    return;
                }
                if (this.isInvalidNumeric(args, detail, "czsyzjjrbnsyje", ResManager.loadKDString((String)"\u5904\u7f6e\u635f\u76ca\u76f4\u63a5\u8ba1\u5165\u672c\u5e74\u635f\u76ca\u91d1\u989d", (String)"InvestDisposeEdit_13", (String)"taxc-tccit", (Object[])new Object[0]))) {
                    return;
                }
                if (this.isInvalidNumeric(args, detail, "czsszbjhxje", ResManager.loadKDString((String)"\u5904\u7f6e\u635f\u5931\u51c6\u5907\u91d1\u6838\u9500\u91d1\u989d", (String)"InvestDisposeEdit_14", (String)"taxc-tccit", (Object[])new Object[0]))) {
                    return;
                }
                if (this.isInvalidNumeric(args, detail, "zcczsr", ResManager.loadKDString((String)"\u8d44\u4ea7\u5904\u7f6e\u6536\u5165", (String)"InvestDisposeEdit_15", (String)"taxc-tccit", (Object[])new Object[0]))) {
                    return;
                }
                if (this.isInvalidNumeric(args, detail, "qshczgxhlsr", ResManager.loadKDString((String)"\u5176\u4e2d\uff1a\u6e05\u7b97\u6216\u64a4\u8d44\u5c5e\u4e8e\u80a1\u606f\u7ea2\u5229\u7684\u6536\u5165", (String)"InvestDisposeEdit_16", (String)"taxc-tccit", (Object[])new Object[0]))) {
                    return;
                }
                if (this.isInvalidNumeric(args, detail, "pcsr", ResManager.loadKDString((String)"\u8d54\u507f\u6536\u5165", (String)"InvestDisposeEdit_17", (String)"taxc-tccit", (Object[])new Object[0]))) {
                    return;
                }
                if (this.isInvalidNumeric(args, detail, "jsjc", ResManager.loadKDString((String)"\u8ba1\u7a0e\u57fa\u7840", (String)"InvestDisposeEdit_18", (String)"taxc-tccit", (Object[])new Object[0]))) {
                    return;
                }
                if (this.isInvalidNumeric(args, detail, TSXSWCLSSJE, ResManager.loadKDString((String)"\u7279\u6b8a\u6027\u7a0e\u52a1\u5904\u7406\u7a0e\u6536\u91d1\u989d", (String)"InvestDisposeEdit_19", (String)"taxc-tccit", (Object[])new Object[0]))) {
                    return;
                }
                BigDecimal zcczsr = detail.getBigDecimal("zcczsr");
                BigDecimal pcsr = detail.getBigDecimal("pcsr") != null ? detail.getBigDecimal("pcsr") : BigDecimal.ZERO;
                BigDecimal jsjc = detail.getBigDecimal("jsjc");
                BigDecimal ssje = zcczsr.add(pcsr).subtract(jsjc);
                detail.put(SSJE, (Object)ssje);
                detail.put(SWCZSYSS, (Object)this.setSwczsyss(detail.getBigDecimal(SSJE)));
            }
        }
    }

    private boolean isInvalidNumeric(BeforeImportDataEventArgs args, JSONObject detail, String fieldKey, String fieldName) {
        boolean isInvalid = false;
        try {
            BigDecimal num = detail.getBigDecimal(fieldKey);
            if (num != null && num.compareTo(BigDecimal.ZERO) < 0) {
                args.setCancel(true);
                args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(String.format(ResManager.loadKDString((String)"%s\u5e94\u4e3a\u5927\u4e8e\u7b49\u4e8e0\u7684\u6570\u503c", (String)"InvestDisposeEdit_20", (String)"taxc-tccit", (Object[])new Object[0]), fieldName)));
                isInvalid = true;
            }
        }
        catch (NumberFormatException e) {
            args.setCancel(true);
            args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(String.format(ResManager.loadKDString((String)"%s\u5e94\u4e3a\u5927\u4e8e\u7b49\u4e8e0\u7684\u6570\u503c", (String)"InvestDisposeEdit_20", (String)"taxc-tccit", (Object[])new Object[0]), fieldName)));
            isInvalid = true;
        }
        return isInvalid;
    }

    private void assetLossTypeF7(BeforeF7SelectEvent bfse) {
        FormShowParameter fsp = bfse.getFormShowParameter();
        fsp.setCustomParam("startdate", (Object)new Date());
        fsp.setCustomParam("enddate", (Object)DateUtils.stringToDate((String)"2021-01-07 00:00:00"));
        fsp.setCustomParam("pnumber", Arrays.asList("7010308", "701030801", "70103080101", "70103080102", "70103080103", "70103080104", "70103080105", "701030802", "7010309", "701030901", "701030902", "7010310", "7010311", "7010312"));
    }

    private BigDecimal getLjtzcbrzje(String billno) {
        QFilter filter = new QFilter(BILL_NO, "=", (Object)billno);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_new_invest_asset", (String)"ljtzcbrzje as amount", (QFilter[])new QFilter[]{filter});
        return CollectionUtils.isEmpty((Collection)query) ? BigDecimal.ZERO : ((DynamicObject)query.get(0)).getBigDecimal("amount");
    }

    private String setSwczsyss(BigDecimal amount) {
        int i = amount.compareTo(BigDecimal.ZERO);
        return i == 0 ? "0" : (i > 0 ? "1" : "2");
    }
}

