/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.sync.MbksTaxbookSyncHandle;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MbyqksAccountDialogPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String TCCIT_DG_B105060_SUM = "tccit_dg_b105060_sum";
    private static final String TCCIT_MBYQKS_ACC = "tccit_mbyqks_acc";
    private static final String SYNDATABT = "syndatabt";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Object org = this.getView().getFormShowParameter().getCustomParam("org");
        if (Objects.nonNull(org)) {
            this.getModel().setValue("org", org);
        }
        this.getModel().setValue("year", (Object)DateUtils.addYear((Date)new Date(), (int)-1));
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        HasPermOrgResult permOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView().getParentView(), (String)"47156aff000000ac");
        if (EmptyCheckUtils.isNotEmpty((Object)permOrgResult) && !permOrgResult.hasAllOrgPerm() && EmptyCheckUtils.isNotEmpty((Object)permOrgResult.getHasPermOrgs())) {
            List orgList = permOrgResult.getHasPermOrgs();
            QFilter idsFilter = new QFilter("id", "in", (Object)orgList);
            ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(idsFilter);
        }
    }

    public void click(EventObject evt) {
        String msg = "success";
        String orgid = Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(s -> s.getString("id")).orElse(null);
        if (StringUtil.isBlank((CharSequence)orgid)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6570\u636e\u540c\u6b65\u7684\u7ec4\u7ec7", (String)"MbyqksAccountDialogPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection org = TreeUtils.queryOrgListByCondition((Map)TreeUtils.convertParam((String)"id", (Object)orgid));
        if (OrgCheckUtil.orgEnable((IFormView)this.getView(), (DynamicObjectCollection)org, (boolean)true)) {
            return;
        }
        Object year = this.getModel().getValue("year");
        if (Objects.isNull(year)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6570\u636e\u540c\u6b65\u7684\u5e74\u5ea6", (String)"MbyqksAccountDialogPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        if (!this.isYearReportExists(Long.valueOf(orgid), (Date)year)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u5f53\u524d\u4e0d\u5b58\u5728\u53ef\u4ee5\u540c\u6b65\u7684\u7533\u62a5\u8868\u6570\u636e", (String)"MbyqksAccountDialogPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]), ((DynamicObject)org.get(0)).getString("name")));
            return;
        }
        if (!this.isYearDgBillExists(Long.valueOf(orgid), (Date)year)) {
            msg = ResManager.loadKDString((String)"\u67e5\u8be2\u5e74\u5ea6\u4e0d\u5b58\u5728\u5e95\u7a3f\uff0c\u540c\u4e00\u4e8f\u635f\u5e74\u5ea6\u5b58\u5728\u591a\u6761\u4e8f\u635f\u53f0\u8d26\u6570\u636e\u7684\u573a\u666f\u53ef\u80fd\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u5148\u7f16\u5236\u5e95\u7a3f\u3002", (String)"MbyqksAccountDialogPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]);
        }
        this.syncHjData(orgid, (Date)year);
        this.closeDialogBox(msg);
    }

    private void syncHjData(String orgid, Date year) {
        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)year);
        Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)year);
        DynamicObject object = YbnsrService.queryYbnsr((String)orgid, (String)"qysdsnb", (String)DateUtils.format((Date)firstDateOfYear), (String)DateUtils.format((Date)lastDateOfYear), null);
        if (Objects.isNull(object)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5e74\u5ea6\u6ca1\u6709\u53ef\u540c\u6b65\u7684\u7533\u62a5\u8868\u6570\u636e", (String)"MbyqksAccountDialogPlugin_4", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        String id = object.getString("id");
        MbksTaxbookSyncHandle mbksTaxbookSyncHandle = new MbksTaxbookSyncHandle();
        mbksTaxbookSyncHandle.syncData(Collections.singletonList(id));
    }

    private void addUpdateData(Date firstDateOfYear, DynamicObjectCollection needUpdate, DynamicObject dgObject, DynamicObject dynamicObject, Date happenyear) {
        dynamicObject.set("happenyear", (Object)happenyear);
        dynamicObject.set("losstype", (Object)dgObject.getString("losstype"));
        dynamicObject.set("lossqiyetype", dgObject.get("lossqiyetype"));
        dynamicObject.set("yjjznx", dgObject.get("yjjznx"));
        dynamicObject.set("ksdqnd", (Object)DateUtils.stringToDate((String)(dgObject.getInt("ksdqnd") + "-01-01"), (String)"yyyy-MM-dd"));
        dynamicObject.set("lossmoney", dgObject.get("lossmoney"));
        dynamicObject.set("jydmbje", (Object)BigDecimal.ZERO);
        DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
        List list = entryentity.stream().filter(s -> s.getDate("mbnd") != null && s.getDate("mbnd").compareTo(firstDateOfYear) == 0 && "mbks".equals(s.getString("mbkslx"))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(list)) {
            list.stream().forEach(s -> s.set("mbzcksje", (Object)dgObject.getBigDecimal("syjnsdmb")));
        } else {
            DynamicObject addNew = entryentity.addNew();
            addNew.set("mbnd", (Object)firstDateOfYear);
            addNew.set("mbkslx", (Object)"mbks");
            addNew.set("mbzcksje", (Object)dgObject.getBigDecimal("syjnsdmb"));
        }
        needUpdate.add((Object)dynamicObject);
    }

    private void save(String orgid, Date firstDateOfYear, DynamicObjectCollection org, DynamicObject dgObject) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCCIT_MBYQKS_ACC);
        dynamicObject.set("org", org.get(0));
        String readNumber = CodeRuleServiceHelper.getNumber((String)TCCIT_MBYQKS_ACC, (DynamicObject)dynamicObject, (String)orgid);
        dynamicObject.set("billno", (Object)readNumber);
        dynamicObject.set("billstatus", (Object)"A");
        dynamicObject.set("happenyear", (Object)firstDateOfYear);
        dynamicObject.set("losstype", (Object)dgObject.getString("losstype"));
        dynamicObject.set("lossqiyetype", dgObject.get("lossqiyetype"));
        dynamicObject.set("yjjznx", dgObject.get("yjjznx"));
        dynamicObject.set("ksdqnd", (Object)DateUtils.stringToDate((String)(dgObject.getInt("ksdqnd") + "-01-01"), (String)"yyyy-MM-dd"));
        dynamicObject.set("lossmoney", dgObject.get("lossmoney"));
        dynamicObject.set("jydmbje", (Object)BigDecimal.ZERO);
        DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
        DynamicObject dynamicObject1 = entryentity.addNew();
        dynamicObject1.set("mbnd", (Object)firstDateOfYear);
        dynamicObject1.set("mbkslx", (Object)"mbks");
        dynamicObject1.set("mbzcksje", (Object)dgObject.getBigDecimal("syjnsdmb"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private DynamicObject[] getMbyqksAcc(String orgid) {
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)TCCIT_MBYQKS_ACC, (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)Long.valueOf(orgid))});
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
            return BusinessDataServiceHelper.load((Object[])dynamicObjects.stream().map(s -> s.get("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCCIT_MBYQKS_ACC));
        }
        return new DynamicObject[0];
    }

    private DynamicObjectCollection getDgB105060Sum(String orgid, Date firstDateOfYear) {
        QFilter orgidFilter = new QFilter("orgid", "=", (Object)Long.valueOf(orgid));
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)firstDateOfYear);
        return QueryServiceHelper.query((String)TCCIT_DG_B105060_SUM, (String)" *,lossqiyetype ", (QFilter[])new QFilter[]{skssqqFilter, orgidFilter});
    }

    private boolean isYearDgBillExists(Long orgId, Date year) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter typeFilter = new QFilter("type", "=", (Object)"WP01");
        QFilter billstatusFilter = new QFilter("billstatus", "!=", (Object)"A");
        QFilter templatetypeFilter = new QFilter("templatetype", "=", (Object)"draft_qysdsnb");
        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)year);
        QFilter dateFilter = new QFilter("startdate", "=", (Object)firstDateOfYear);
        return QueryServiceHelper.exists((String)"tccit_year_dg_bill", (QFilter[])new QFilter[]{orgFilter, typeFilter, billstatusFilter, templatetypeFilter, dateFilter});
    }

    private boolean isYearReportExists(Long orgId, Date year) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)year);
        QFilter sbbTypeFilter = new QFilter("type", "in", (Object)Lists.newArrayList((Object[])new String[]{"qysdsnb"}));
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)firstDateOfYear);
        QFilter declareStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        return QueryServiceHelper.exists((String)"tccit_quarterly_report", (QFilter[])new QFilter[]{orgFilter, sbbTypeFilter, skssqqFilter, declareStatusFilter});
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (SYNDATABT.equals(callBackId) && e.getResult() == MessageBoxResult.Yes) {
            String orgid = e.getCustomVaule();
            DynamicObjectCollection org = TreeUtils.queryOrgListByCondition((Map)TreeUtils.convertParam((String)"id", (Object)orgid));
            Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)DateUtils.addMonth((Date)new Date(), (int)-12));
            DynamicObjectCollection dgObjects = this.getDgB105060Sum(orgid, firstDateOfYear);
            DynamicObject[] tccitMbyqksAccs = this.getMbyqksAcc(orgid);
            DynamicObjectCollection needUpdate = new DynamicObjectCollection();
            for (DynamicObject dgObject : dgObjects) {
                if (BigDecimal.ZERO.compareTo(dgObject.getBigDecimal("lossmoney")) < 0) continue;
                String billno = dgObject.getString("billno");
                if (StringUtils.isNotEmpty((CharSequence)billno)) {
                    List resultTem = Arrays.stream(tccitMbyqksAccs).filter(s -> s.getString("billno").equals(billno)).collect(Collectors.toList());
                    if (!CollectionUtils.isNotEmpty(resultTem)) continue;
                    this.addUpdateData(firstDateOfYear, needUpdate, dgObject, (DynamicObject)resultTem.get(0), DateUtils.stringToDate((String)(dgObject.getInt("happenyear") + "-01-01"), (String)"yyyy-MM-dd"));
                    continue;
                }
                if (BigDecimal.ZERO.compareTo(dgObject.getBigDecimal("lossmoney")) < 0 || StringUtils.isEmpty((CharSequence)dgObject.getString("number"))) continue;
                List collect = Arrays.stream(tccitMbyqksAccs).filter(s -> s.getDate("happenyear").compareTo(firstDateOfYear) == 0).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(collect)) {
                    this.save(orgid, firstDateOfYear, org, dgObject);
                    continue;
                }
                if (collect.size() == 1) {
                    this.addUpdateData(firstDateOfYear, needUpdate, dgObject, (DynamicObject)collect.get(0), firstDateOfYear);
                    continue;
                }
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53f0\u8d26\u4e2d\u5b58\u5728\u591a\u6761\u3010%s\uff08\u53d1\u751f\u5e74\u5ea6\uff09\u3011\u6570\u636e\uff0c\u8bf7\u624b\u52a8\u66f4\u65b0\u53f0\u8d26\u4e2d\u8be5\u90e8\u5206\u6570\u636e", (String)"MbyqksAccountDialogPlugin_5", (String)"taxc-tccit", (Object[])new Object[0]), DateUtils.getYearOfDate((Date)firstDateOfYear)));
            }
            if (CollectionUtils.isNotEmpty((Collection)needUpdate)) {
                SaveServiceHelper.save((DynamicObject[])((DynamicObject[])needUpdate.toArray((Object[])new DynamicObject[0])));
                this.closeDialogBox("success");
            }
        }
    }

    private void closeDialogBox(String msg) {
        this.getView().returnDataToParent((Object)msg);
        this.getView().close();
    }
}

