/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.formplugin.taxbook.ExtendAbstractBillPlugin;

public class MbyqksAccountEditPlugin
extends ExtendAbstractBillPlugin
implements BeforeF7SelectListener {
    private static final String LOSS_QIYE_TYPE = "lossqiyetype";
    private static final String ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit lossqiyetype = (BasedataEdit)this.getView().getControl(LOSS_QIYE_TYPE);
        lossqiyetype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent bfse) {
        String key = ((BasedataEdit)bfse.getSource()).getKey();
        if (LOSS_QIYE_TYPE.equals(key)) {
            bfse.getFormShowParameter().setCustomParam("caption", (Object)ResManager.loadKDString((String)"\u4e8f\u635f\u4f01\u4e1a\u7c7b\u578b", (String)"MbyqksAccountEditPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        Object happenyear;
        Object yjjznx;
        BigDecimal ljmbzcksje;
        Object lossmoney;
        Object newValue;
        String name = args.getProperty().getName();
        if ("mbzcksje".equals(name)) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
            BigDecimal amount = entryentity.stream().map(s -> s.getBigDecimal("mbzcksje")).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.getModel().setValue("ljmbzcksje", (Object)amount);
        }
        if ((newValue = args.getChangeSet()[0].getNewValue()) == null) {
            return;
        }
        if ("ljmbzcksje".equals(name) && (lossmoney = this.getModel().getValue("lossmoney")) != null) {
            this.getModel().setValue("jydmbje", (Object)((BigDecimal)lossmoney).add((BigDecimal)newValue));
        }
        if ("lossmoney".equals(name) && (ljmbzcksje = (BigDecimal)this.getModel().getValue("ljmbzcksje")) != null) {
            this.getModel().setValue("jydmbje", (Object)ljmbzcksje.add((BigDecimal)newValue));
        }
        if ("happenyear".equals(name) && (yjjznx = this.getModel().getValue("yjjznx")) != null) {
            int yearOfDate = DateUtils.getYearOfDate((Date)((Date)newValue));
            int result = yearOfDate + (Integer)yjjznx;
            this.getModel().setValue("ksdqnd", (Object)DateUtils.stringToDate((String)(result + ""), (String)"yyyy"));
        }
        if ("yjjznx".equals(name) && (happenyear = this.getModel().getValue("happenyear")) != null) {
            int result = (Integer)newValue + DateUtils.getYearOfDate((Date)((Date)happenyear));
            this.getModel().setValue("ksdqnd", (Object)DateUtils.stringToDate((String)(result + ""), (String)"yyyy"));
        }
        if ("mbnd".equals(name)) {
            this.validateMbnd(newValue, this.getModel().getValue("happenyear"), this.getModel().getValue("ksdqnd"));
        }
        if ("happenyear".equals(name) || "ksdqnd".equals(name)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            Object happenyear2 = this.getModel().getValue("happenyear");
            Object ksdqnd = this.getModel().getValue("ksdqnd");
            for (DynamicObject object : entryEntity) {
                this.validateMbnd(object.getDate("mbnd"), happenyear2, ksdqnd);
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            Object happenyear = this.getModel().getValue("happenyear");
            Object ksdqnd = this.getModel().getValue("ksdqnd");
            for (DynamicObject object : entryEntity) {
                if (this.validateMbnd(object.getDate("mbnd"), happenyear, ksdqnd)) continue;
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("deleteentry1".equals(operateKey)) {
            BigDecimal lossmoney = Optional.ofNullable((BigDecimal)this.getModel().getValue("lossmoney")).orElseGet(() -> BigDecimal.ZERO);
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
            BigDecimal mbzcksje = entryentity.stream().map(s -> s.getBigDecimal("mbzcksje")).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.getModel().setValue("jydmbje", (Object)lossmoney.add(mbzcksje));
        }
    }

    private boolean validateMbnd(Object mbnd, Object happenyear, Object ksdqnd) {
        if (mbnd != null) {
            String billno;
            mbnd = DateUtils.getFirstDateOfYear((Date)((Date)mbnd));
            String msg = "";
            String string = billno = StringUtil.isNotEmpty((CharSequence)((String)this.getModel().getValue("billno"))) ? this.getModel().getValue("billno") + ": " : "";
            if (happenyear != null && ((Date)mbnd).compareTo(DateUtils.getFirstDateOfYear((Date)((Date)happenyear))) < 0) {
                msg = String.format(ResManager.loadKDString((String)"%s\u5f25\u8865\u4e8f\u635f\u5e74\u5ea6\u5e94\u4e0d\u65e9\u4e8e\u4e8f\u635f\u7684\u53d1\u751f\u5e74\u5ea6", (String)"MbyqksAccountEditPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]), billno);
            } else if (ksdqnd != null && ((Date)mbnd).compareTo(DateUtils.getFirstDateOfYear((Date)((Date)ksdqnd))) > 0) {
                msg = String.format(ResManager.loadKDString((String)"%s\u5f25\u8865\u5e74\u5ea6\u5e94\u4e0d\u665a\u4e8e\u4e8f\u635f\u5230\u671f\u5e74\u5ea6", (String)"MbyqksAccountEditPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]), billno);
            }
            if (StringUtil.isNotEmpty((CharSequence)msg)) {
                this.getView().showErrorNotification(msg);
                return false;
            }
        }
        return true;
    }
}

