/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;

public class MbyqksAccountListPlugin
extends AbstractListPlugin
implements BeforeFilterF7SelectListener {
    private static final String LOSSQIYETYPE_NUMBER = "lossqiyetype.number";
    private static final String PROJECT_NAME = "projectname";
    private static final String TCCIT_BIZDEF_ENTRY = "tpo_tccit_bizdef_entry";
    private static final String TOOLBARAP = "toolbarap";
    private static final String SYNDATABT = "syndatabt";
    private static final String ENTITY = "mbyqks_acc_dialog";

    public void itemClick(ItemClickEvent evt) {
        if (SYNDATABT.equals(evt.getItemKey())) {
            HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView(), (String)"tccit_mbyqks_acc", (String)"47156aff000000ac");
            List hasPermOrgs = hasPermOrgResult.getHasPermOrgs();
            if (!hasPermOrgResult.hasAllOrgPerm() && hasPermOrgs.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5f25\u8865\u4ee5\u524d\u5e74\u5ea6\u4e8f\u635f\u53f0\u8d26\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MbyqksAccountListPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]));
                return;
            }
            HashMap orgMap = new HashMap(16);
            if (hasPermOrgs.size() == 1) {
                orgMap.put("org", hasPermOrgs.get(0));
            }
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)ENTITY, (IFormView)this.getView(), orgMap, (IFormPlugin)this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (ENTITY.equals(evt.getActionId()) && EmptyCheckUtils.isNotEmpty((Object)evt.getReturnData())) {
            BillList billlist = (BillList)this.getControl("billlistap");
            billlist.refresh();
            if ("success".equals(evt.getReturnData())) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u5b8c\u6bd5", (String)"MbyqksAccountListPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)String.valueOf(evt.getReturnData()), (String)"MbyqksAccountListPlugin_22", (String)"MbyqksAccountListPlugin_1", (Object[])new Object[0]));
            }
        }
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{TOOLBARAP});
        super.registerListener(e);
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
        filterContainer.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.setTccitBizDefFilterComboItems(args, LOSSQIYETYPE_NUMBER);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent bffe) {
        String fieldName = bffe.getFieldName();
        if (LOSSQIYETYPE_NUMBER.equals(fieldName) || "lossqiyetype.projectname".equals(fieldName)) {
            bffe.addCustomParam("caption", (Object)ResManager.loadKDString((String)"\u4e8f\u635f\u4f01\u4e1a\u7c7b\u578b", (String)"MbyqksAccountListPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]));
            bffe.setQfilters(Collections.singletonList(this.getScopeFiter()));
        }
    }

    private void setTccitBizDefFilterComboItems(FilterContainerInitArgs args, String fieldName) {
        CommonFilterColumn cfc = (CommonFilterColumn)args.getFilterColumn(fieldName);
        DynamicObjectCollection assetType = QueryServiceHelper.query((String)TCCIT_BIZDEF_ENTRY, (String)"id,projectname", (QFilter[])new QFilter[]{this.getScopeFiter()}, (String)"number");
        List collect = assetType.stream().map(at -> {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(String.valueOf(at.getLong("id")));
            comboItem.setCaption(new LocaleString(at.getString(PROJECT_NAME)));
            return comboItem;
        }).collect(Collectors.toList());
        cfc.setComboItems(collect);
    }

    private QFilter getScopeFiter() {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tpo_tccit_bizdef", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"BKQYLX")});
        QFilter bizdefFilter = new QFilter("bizdef", "=", dynamicObject.get("id"));
        return bizdefFilter;
    }
}

