/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class MiddleStatusChangeList
extends AbstractListPlugin {
    private static final Map<String, String> middleMap = new HashMap<String, String>();

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String optKey = args.getOperateKey();
        if ("disable".equals(optKey)) {
            List successPkIds = args.getOperationResult().getSuccessPkIds();
            this.updateBillStatus(successPkIds, "0");
        } else if ("enable".equals(optKey)) {
            List successPkIds = args.getOperationResult().getSuccessPkIds();
            this.updateBillStatus(successPkIds, "1");
        } else if ("delete".equals(optKey)) {
            List successPkIds = args.getOperationResult().getSuccessPkIds();
            this.deleteMiddleData(successPkIds);
        }
    }

    private void updateBillStatus(List<Object> successPkIds, String status) {
        ListView view = (ListView)this.getView();
        String formId = view.getBillFormId();
        String middle = middleMap.get(formId);
        if (StringUtils.isNotBlank((CharSequence)middle)) {
            ListSelectedRowCollection selectedRows = view.getSelectedRows();
            for (ListSelectedRow row : selectedRows) {
                DynamicObject[] dyos;
                if (!successPkIds.contains(row.getPrimaryKeyValue())) continue;
                for (DynamicObject dyo : dyos = BusinessDataServiceHelper.load((String)middle, (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)row.getMainOrgId()), new QFilter("billno", "=", (Object)row.getBillNo())})) {
                    dyo.set("billstatus", (Object)status);
                }
                SaveServiceHelper.update((DynamicObject[])dyos);
            }
        }
    }

    private void deleteMiddleData(List<Object> successPkIds) {
        ListView view = (ListView)this.getView();
        String formId = view.getBillFormId();
        String middle = middleMap.get(formId);
        if (StringUtils.isNotBlank((CharSequence)middle)) {
            ListSelectedRowCollection selectedRows = view.getSelectedRows();
            for (ListSelectedRow row : selectedRows) {
                if (!successPkIds.contains(row.getPrimaryKeyValue())) continue;
                DeleteServiceHelper.delete((String)middle, (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)row.getMainOrgId()), new QFilter("billno", "=", (Object)row.getBillNo())});
            }
        }
    }

    static {
        middleMap.put("tccit_gov_subsidy_defer", "tccit_govdefer_middle");
        middleMap.put("tccit_not_taccrual_basis", "tccit_nottaccrual_middle");
    }
}

