/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tccit.common.utils.BigDecimalUtils;
import kd.taxc.tccit.formplugin.taxbook.ExtendAbstractBillPlugin;

public class NewInvestAssetEdit
extends ExtendAbstractBillPlugin
implements BeforeF7SelectListener {
    protected static final String NEW_INVEST_DETAIL = "tccit_new_invest_detail";
    protected static final String NEW_INVEST_ASSET = "tccit_new_invest_asset";
    private static final String TZCBRZJE = "tzcbrzje";
    private static final String TRADETAXFEE = "tradetaxfee";
    private static final String TAXBASE = "taxbase";
    private static final String TZBL = "tzbl";
    private static final String LJTZCBRZJE = "ljtzcbrzje";
    private static final String LJJYSF = "ljjysf";
    private static final String LJJSJC = "ljjsjc";
    private static final String BILL_NO = "billno";
    private static final String ASSET_TYPE = "assettype";
    private static final String INVEST_TYPE = "investtype";
    private static final String ASSET_STATUS = "assetstatus";
    private static final String YCZZCZMJZ = "yczzczmjz";
    private static final List<String> syncSaveEntry = Arrays.asList("tccit_invest_asset_jzbd", "tccit_invest_dispose", "tccit_invest_cysy");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit assettype = (BasedataEdit)this.getView().getControl(ASSET_TYPE);
        assettype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit investtype = (BasedataEdit)this.getView().getControl(INVEST_TYPE);
        investtype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent bfse) {
        String fieldKey;
        BasedataEdit source = (BasedataEdit)bfse.getSource();
        switch (fieldKey = source.getFieldKey()) {
            case "assettype": {
                bfse.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u8d44\u4ea7\u7c7b\u578b", (String)"NewInvestAssetEdit_0", (String)"taxc-tccit", (Object[])new Object[0]));
                break;
            }
            case "investtype": {
                bfse.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6295\u8d44\u6027\u8d28", (String)"NewInvestAssetEdit_1", (String)"taxc-tccit", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.updateLjAmount();
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if (Lists.newArrayList((Object[])new String[]{TZCBRZJE, TRADETAXFEE, TAXBASE}).contains(name)) {
            this.updateLjAmount();
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection collection;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Save && EmptyCheckUtils.isNotEmpty((Object)(collection = this.getModel().getEntryEntity(NEW_INVEST_DETAIL)))) {
            BigDecimal totaltzcbrzje = BigDecimal.ZERO;
            for (DynamicObject object : collection) {
                totaltzcbrzje = BigDecimalUtil.addObject((Object)totaltzcbrzje, (Object)object.getBigDecimal(TZCBRZJE));
            }
            if (BigDecimalUtils.largeMaxValue(totaltzcbrzje)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6295\u8d44\u6210\u672c\u5165\u8d26\u91d1\u989d\u5408\u8ba1\u503c\u6574\u6570\u4f4d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc713\u4f4d\u3002", (String)"NewInvestAssetEdit_2", (String)"taxc-tccit", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String optKey = args.getOperateKey();
        if ("save".equals(optKey) && args.getOperationResult().isSuccess()) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            long orgId = org.getLong("id");
            Object id = this.getModel().getValue("id");
            this.updateRefTaxBook(id, orgId, this.getModel().getValue(ASSET_TYPE), this.getModel().getValue(INVEST_TYPE), this.getModel().getValue(ASSET_STATUS));
        }
        if ("deleteentry".equals(optKey)) {
            this.updateLjAmount();
        }
    }

    public void initImportData(InitImportDataEventArgs args) {
        List sourceDataList = args.getSourceDataList();
        for (Map data : sourceDataList) {
            List detailList = ((JSONArray)JSONArray.toJSON(data.get(NEW_INVEST_DETAIL))).stream().map(o -> (JSONObject)JSONObject.toJSON((Object)o)).collect(Collectors.toList());
            BigDecimal ljtzcbrzje = BigDecimal.ZERO;
            BigDecimal ljjysf = BigDecimal.ZERO;
            BigDecimal ljjsjc = BigDecimal.ZERO;
            for (JSONObject detail : detailList) {
                ljtzcbrzje = ljtzcbrzje.add(detail.getBigDecimal(TZCBRZJE));
                BigDecimal tradeTaxFee = detail.getBigDecimal(TRADETAXFEE);
                ljjysf = ljjysf.add(Optional.ofNullable(tradeTaxFee).orElse(BigDecimal.ZERO));
                ljjsjc = ljjsjc.add(detail.getBigDecimal(TAXBASE));
            }
            data.put(LJTZCBRZJE, ljtzcbrzje);
            data.put(LJJYSF, ljjysf);
            data.put(LJJSJC, ljjsjc);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs args) {
        Map sourceData = args.getSourceData();
        Map option = args.getOption();
        String importtype = (String)option.get("importtype");
        boolean isUpdate = option.containsKey("importtype") && ("override".equals(importtype) || "overridenew".equals(importtype));
        List detailList = ((JSONArray)JSONArray.toJSON(sourceData.get(NEW_INVEST_DETAIL))).stream().map(o -> (JSONObject)JSONObject.toJSON((Object)o)).collect(Collectors.toList());
        for (int i = 0; i < detailList.size(); ++i) {
            JSONObject detail = (JSONObject)detailList.get(i);
            BigDecimal tzcbrzje = detail.getBigDecimal(TZCBRZJE);
            if (tzcbrzje.compareTo(BigDecimal.ZERO) < 0) {
                args.setCancel(true);
                args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(i), Collections.singletonList(ResManager.loadKDString((String)"\u6295\u8d44\u6210\u672c\u5165\u8d26\u91d1\u989d\u5e94\u4e3a\u5927\u4e8e\u7b49\u4e8e\u96f6\u7684\u6570\u503c", (String)"NewInvestAssetEdit_3", (String)"taxc-tccit", (Object[])new Object[0])));
                return;
            }
            BigDecimal tradetaxfee = Optional.ofNullable(detail.getBigDecimal(TRADETAXFEE)).orElse(BigDecimal.ZERO);
            if (tradetaxfee.compareTo(BigDecimal.ZERO) < 0) {
                args.setCancel(true);
                args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(i), Collections.singletonList(ResManager.loadKDString((String)"\u4ea4\u6613\u7a0e\u8d39\u5e94\u4e3a\u5927\u4e8e\u7b49\u4e8e\u96f6\u7684\u6570\u503c", (String)"NewInvestAssetEdit_4", (String)"taxc-tccit", (Object[])new Object[0])));
                return;
            }
            BigDecimal taxbase = detail.getBigDecimal(TAXBASE);
            if (taxbase.compareTo(BigDecimal.ZERO) < 0) {
                args.setCancel(true);
                args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(i), Collections.singletonList(ResManager.loadKDString((String)"\u8ba1\u7a0e\u57fa\u7840\u5e94\u4e3a\u5927\u4e8e\u7b49\u4e8e\u96f6\u7684\u6570\u503c", (String)"NewInvestAssetEdit_5", (String)"taxc-tccit", (Object[])new Object[0])));
                return;
            }
            BigDecimal tzbl = detail.getBigDecimal(TZBL);
            if (tzbl == null || tzbl.compareTo(BigDecimal.ZERO) >= 0 && tzbl.compareTo(BigDecimal.ONE) <= 0) continue;
            args.setCancel(true);
            args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(i), Collections.singletonList(ResManager.loadKDString((String)"\u6295\u8d44\u6bd4\u4f8b\u53ea\u80fd\u5f55\u51650-1\u4e4b\u5185\u7684\u5c0f\u6570", (String)"NewInvestAssetEdit_6", (String)"taxc-tccit", (Object[])new Object[0])));
            return;
        }
        JSONObject org = (JSONObject)sourceData.get("org");
        String billno = (String)sourceData.get(BILL_NO);
        boolean exists = QueryServiceHelper.exists((String)NEW_INVEST_ASSET, (QFilter[])new QFilter[]{new QFilter(BILL_NO, "=", (Object)billno), new QFilter("org.number", "=", org.get((Object)"number"))});
        if (!isUpdate && exists) {
            args.setCancel(true);
            args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u8d44\u4ea7\u7f16\u7801\uff0c\u8bf7\u4fee\u6539", (String)"NewInvestAssetEdit_7", (String)"taxc-tccit", (Object[])new Object[0])));
        }
    }

    private void updateRefTaxBook(Object id, Object orgId, Object assetType, Object investType, Object assetStatus) {
        for (String entryName : syncSaveEntry) {
            DynamicObject dyo;
            QFilter[] qFilters = new QFilter[]{new QFilter("name", "=", id), new QFilter("org", "=", orgId)};
            boolean exists = QueryServiceHelper.exists((String)entryName, (QFilter[])qFilters);
            if (!exists) continue;
            if ("tccit_invest_dispose".equals(entryName)) {
                dyo = BusinessDataServiceHelper.loadSingle((String)entryName, (String)"id,assettype,investtype", (QFilter[])qFilters);
            } else {
                dyo = BusinessDataServiceHelper.loadSingle((String)entryName, (String)"id,assettype,investtype,assetstatus", (QFilter[])qFilters);
                dyo.set(ASSET_STATUS, assetStatus);
            }
            dyo.set(ASSET_TYPE, assetType);
            dyo.set(INVEST_TYPE, investType);
            SaveServiceHelper.update((DynamicObject)dyo);
        }
    }

    private void updateLjAmount() {
        BigDecimal ljtzcbrzje = BigDecimal.ZERO;
        BigDecimal ljjysf = BigDecimal.ZERO;
        BigDecimal ljjsjc = BigDecimal.ZERO;
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount(NEW_INVEST_DETAIL);
        for (int i = 0; i < count; ++i) {
            ljtzcbrzje = ljtzcbrzje.add((BigDecimal)model.getValue(TZCBRZJE, i));
            ljjysf = ljjysf.add((BigDecimal)model.getValue(TRADETAXFEE, i));
            ljjsjc = ljjsjc.add((BigDecimal)model.getValue(TAXBASE, i));
        }
        model.setValue(LJTZCBRZJE, (Object)ljtzcbrzje);
        model.setValue(LJJYSF, (Object)ljjysf);
        model.setValue(LJJSJC, (Object)ljjsjc);
        model.setValue(YCZZCZMJZ, (Object)this.getYczzczmjz(String.valueOf(model.getValue(BILL_NO))));
    }

    private BigDecimal getYczzczmjz(String billno) {
        QFilter filter = new QFilter(BILL_NO, "=", (Object)billno);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tccit_invest_dispose", (String)"sum(tccit_invest_cz_ent.czzczmjz) as amount", (QFilter[])new QFilter[]{filter});
        return CollectionUtils.isEmpty((Collection)query) ? BigDecimal.ZERO : ((DynamicObject)query.get(0)).getBigDecimal("amount");
    }
}

