/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import org.apache.commons.lang.StringUtils;

public class NewInvestAssetList
extends AbstractListPlugin
implements BeforeFilterF7SelectListener {
    private static ExecutorService executorService = ThreadPools.newExecutorService((String)"newInvestAssetListValid", (int)3);
    private static final String ASSET_TYPE_NAME = "assettype.projectname";
    private static final String INVEST_TYPE_NAME = "investtype.projectname";
    private static final String ASSET_TYPE_ID = "assettype.id";
    private static final String INVEST_TYPE_ID = "investtype.id";
    private static final String PROJECT_NAME = "projectname";
    private static final String ASSET_TYPE_PARENT_NUM = "1";
    private static final String INVEST_TYPE_PARENT_NUM = "2";
    private static final String PARENT_NUMBER = "parent.number";
    private static final String TCCIT_BIZDEF_ENTRY = "tpo_tccit_bizdef_entry";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
        filterContainer.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.setTccitBizDefFilterComboItems(args, ASSET_TYPE_NAME, ASSET_TYPE_PARENT_NUM);
        this.setTccitBizDefFilterComboItems(args, INVEST_TYPE_NAME, INVEST_TYPE_PARENT_NUM);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent bffe) {
        String fieldName = bffe.getFieldName();
        if (ASSET_TYPE_ID.equals(fieldName) || ASSET_TYPE_NAME.equals(fieldName)) {
            bffe.addCustomParam("caption", (Object)ResManager.loadKDString((String)"\u8d44\u4ea7\u7c7b\u578b", (String)"NewInvestAssetList_0", (String)"taxc-tccit", (Object[])new Object[0]));
            bffe.setQfilters(Collections.singletonList(new QFilter(PARENT_NUMBER, "=", (Object)ASSET_TYPE_PARENT_NUM)));
        } else if (INVEST_TYPE_ID.equals(fieldName) || INVEST_TYPE_NAME.equals(fieldName)) {
            bffe.addCustomParam("caption", (Object)ResManager.loadKDString((String)"\u6295\u8d44\u6027\u8d28", (String)"NewInvestAssetList_1", (String)"taxc-tccit", (Object[])new Object[0]));
            bffe.setQfilters(Collections.singletonList(new QFilter(PARENT_NUMBER, "=", (Object)INVEST_TYPE_PARENT_NUM)));
        }
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        List<Long> ids;
        List<String> validNumbers;
        BillList billlist;
        super.beforeDoOperation(args);
        if ("delete".equals(((FormOperate)args.getSource()).getOperateKey()) && (billlist = (BillList)this.getControl("billlistap")) != null && billlist.getSelectedRows() != null && billlist.getSelectedRows().size() > 0 && "tccit_new_invest_asset".equals(billlist.getBillFormId()) && !CollectionUtils.isEmpty(validNumbers = this.validNumbers(ids = billlist.getSelectedRows().stream().map(s -> Long.valueOf(s.getPrimaryKeyValue().toString())).collect(Collectors.toList())))) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u5b58\u5728\u5df2\u7ecf\u5173\u8054\u7684\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"NewInvestAssetList_2", (String)"taxc-tccit", (Object[])new Object[0]), validNumbers.stream().collect(Collectors.joining(","))));
            args.setCancel(true);
        }
    }

    public List<String> validNumbers(List<Long> ids) {
        ArrayList tables = Lists.newArrayList((Object[])new String[]{"tccit_invest_dispose", "tccit_invest_asset_jzbd", "tccit_invest_cysy"});
        List completableFutures = tables.stream().map(entityname -> CompletableFuture.supplyAsync(() -> {
            RequestContext requestContext = RequestContext.getOrCreate();
            RequestContext.copyAndSet((RequestContext)requestContext);
            return this.getNumbers((String)entityname, ids);
        }, executorService)).collect(Collectors.toList());
        List collect = completableFutures.stream().map(CompletableFuture::join).collect(Collectors.toList());
        return CollectionUtils.isEmpty(collect) ? new ArrayList<String>() : collect.stream().flatMap(s -> s.stream()).distinct().collect(Collectors.toList());
    }

    public List<String> getNumbers(String table, List<Long> ids) {
        DynamicObjectCollection collections = QueryServiceHelper.query((String)table, (String)"id,name.number as number", (QFilter[])new QFilter[]{new QFilter("name", "in", ids)});
        return CollectionUtils.isEmpty((Collection)collections) ? new ArrayList<String>() : collections.stream().map(a -> a.getString("number")).collect(Collectors.toList());
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String billFormId = ((ListView)this.getView()).getBillFormId();
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((String)"delete", (String)callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            ListSelectedRowCollection collection = ((IListView)this.getView()).getSelectedRows();
            List bizNos = collection.stream().map(ListSelectedRow::getBillNo).collect(Collectors.toList());
            DeleteServiceHelper.delete((String)billFormId, (QFilter[])new QFilter[]{new QFilter("billno", "in", bizNos)});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"NewInvestAssetList_3", (String)"taxc-tccit", (Object[])new Object[0]));
            String operateName = ResManager.loadKDString((String)"\u5220\u9664", (String)"NewInvestAssetList_4", (String)"taxc-tccit", (Object[])new Object[0]);
            String operateDescription = String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u53f7\u4e3a%s\u7684\u53f0\u8d26\u5220\u9664\u6210\u529f", (String)"NewInvestAssetList_5", (String)"taxc-tccit", (Object[])new Object[0]), bizNos.toString().replace("[", "").replace("]", ""));
            OperatorDialogUtils.operateDialog((String)"qysds", (String)"tccit_new_invest_asset", (String)operateName, (String)operateDescription);
            BillList billlist = (BillList)this.getControl("billlistap");
            billlist.clearSelection();
            billlist.refreshData();
        }
    }

    private void setTccitBizDefFilterComboItems(FilterContainerInitArgs args, String fieldName, String parentNum) {
        CommonFilterColumn cfc = (CommonFilterColumn)args.getFilterColumn(fieldName);
        QFilter parentFilter = new QFilter(PARENT_NUMBER, "=", (Object)parentNum);
        DynamicObjectCollection assetType = QueryServiceHelper.query((String)TCCIT_BIZDEF_ENTRY, (String)"id,projectname", (QFilter[])new QFilter[]{parentFilter}, (String)"number");
        List collect = assetType.stream().map(at -> {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(String.valueOf(at.getLong("id")));
            comboItem.setCaption(new LocaleString(at.getString(PROJECT_NAME)));
            return comboItem;
        }).collect(Collectors.toList());
        cfc.setComboItems(collect);
    }
}

