/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.EventObject;
import java.util.HashMap;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.tccit.business.taxbook.NotTaccrualBasisService;
import kd.taxc.tccit.common.utils.LocalDateUtils;
import kd.taxc.tccit.formplugin.taxbook.ExtendAbstractBillPlugin;
import org.apache.commons.lang.StringUtils;

public class NotTaccrualBasisEdit
extends ExtendAbstractBillPlugin {
    private static final String TAX_INCOME_REG = "tccit_tax_income_reg";
    private static final String BOOK_INCOME_REG = "tccit_book_income_reg";
    private static final String SS_DELETE_ENTRY = "ss_deleteentry";
    private static final String ZZ_DELETE_ENTRY = "zz_deleteentry";
    private static final String SS_AMOUNT = "ss_amount";
    private static final String ZZ_AMOUNT = "zz_amount";
    private static final String LJ_BOOK_INCOME = "ljbookincome";
    private static final String LJ_TAX_INCOME = "ljtaxincome";
    private static final String TOTAL_AMOUNT = "totalamt";
    private static NotTaccrualBasisService notTaccrualBasisService = new NotTaccrualBasisService();

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.updateLjTaxIncome();
        this.updateLjBookIncome();
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String key = source.getOperateKey();
        if (SS_DELETE_ENTRY.equals(key) && this.isBookIncomeMoreThanTaxIncome()) {
            args.setCancel(true);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        var3_3 = optKey = args.getOperateKey();
        var4_4 = -1;
        switch (var3_3.hashCode()) {
            case 870199880: {
                if (!var3_3.equals("ss_deleteentry")) break;
                var4_4 = 0;
                break;
            }
            case -427564248: {
                if (!var3_3.equals("zz_deleteentry")) break;
                var4_4 = 1;
                break;
            }
            case 3522941: {
                if (!var3_3.equals("save")) break;
                var4_4 = 2;
            }
        }
        switch (var4_4) {
            case 0: {
                this.updateLjTaxIncome();
                break;
            }
            case 1: {
                this.updateLjBookIncome();
                break;
            }
            case 2: {
                if (!args.getOperationResult().isSuccess()) break;
                h = TX.required();
                var6_6 = null;
                try {
                    org = (DynamicObject)this.getModel().getValue("org");
                    orgId = org.getLong("id");
                    DeleteServiceHelper.delete((String)"tccit_nottaccrual_middle", (QFilter[])new QFilter[]{new QFilter("billno", "=", this.getModel().getValue("billno")), new QFilter("org", "=", (Object)orgId)});
                    tir = this.getModel().getEntryEntity("tccit_tax_income_reg");
                    bir = this.getModel().getEntryEntity("tccit_book_income_reg");
                    NotTaccrualBasisEdit.notTaccrualBasisService.saveNotTaccrualMiddle(tir, bir, (Function<Integer, DynamicObject>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$afterDoOperation$0(java.lang.Integer ), (Ljava/lang/Integer;)Lkd/bos/dataentity/entity/DynamicObject;)((NotTaccrualBasisEdit)this));
                }
                catch (Throwable t) {
                    h.markRollback();
                    throw t;
                }
                if (h == null) break;
                if (var6_6 == null) ** GOTO lbl48
                try {
                    h.close();
                }
                catch (Throwable var7_9) {
                    var6_6.addSuppressed(var7_9);
                }
                break;
lbl48:
                // 1 sources

                h.close();
                break;
                catch (Throwable var7_10) {
                    try {
                        var6_6 = var7_10;
                        throw var7_10;
                    }
                    catch (Throwable var12_14) {
                        if (h != null) {
                            if (var6_6 != null) {
                                try {
                                    h.close();
                                }
                                catch (Throwable var13_15) {
                                    var6_6.addSuppressed(var13_15);
                                }
                            } else {
                                h.close();
                            }
                        }
                        throw var12_14;
                    }
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name;
        switch (name = args.getProperty().getName()) {
            case "ss_amount": {
                this.checkAndUpdateLjTaxIncome(args);
                break;
            }
            case "zz_amount": {
                this.checkAndUpdateLjBookIncome(args);
                break;
            }
            case "totalamt": {
                this.totalAmountChange(args);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((String)"modifyTotalAmt", (String)callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getModel().deleteEntryData(TAX_INCOME_REG);
                this.getModel().deleteEntryData(BOOK_INCOME_REG);
            } else if (MessageBoxResult.Cancel.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getPageCache().put("cancelFlag", "true");
                this.getModel().setValue(TOTAL_AMOUNT, (Object)new BigDecimal(messageBoxClosedEvent.getCustomVaule()));
                this.getPageCache().put("cancelFlag", "false");
            }
        }
    }

    private void totalAmountChange(PropertyChangedArgs args) {
        boolean modifyExistBillTotalAmount;
        BigDecimal oldValue = (BigDecimal)args.getChangeSet()[0].getOldValue();
        BigDecimal newValue = (BigDecimal)args.getChangeSet()[0].getNewValue();
        Long billId = this.getModel().getDataEntity().getLong("id");
        String cancelFlag = this.getPageCache().get("cancelFlag");
        boolean bl = modifyExistBillTotalAmount = !"true".equals(cancelFlag) && billId != 0L;
        if (modifyExistBillTotalAmount && oldValue.compareTo(BigDecimal.ZERO) != 0 && oldValue.compareTo(newValue) != 0) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("modifyTotalAmt", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u5408\u540c\u603b\u91d1\u989d\u4f1a\u5bfc\u81f4\u53f0\u8d26\u6570\u636e\u88ab\u6e05\u7a7a\uff0c\u662f\u5426\u786e\u8ba4\u64cd\u4f5c\uff1f", (String)"NotTaccrualBasisEdit_0", (String)"taxc-tccit", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener, new HashMap(), oldValue.toString());
        }
    }

    private void checkAndUpdateLjTaxIncome(PropertyChangedArgs args) {
        BigDecimal totalAmt;
        IDataModel model = this.getModel();
        BigDecimal ljtaxincome = this.calcLjAmount(TAX_INCOME_REG, SS_AMOUNT);
        if (ljtaxincome.compareTo(totalAmt = (BigDecimal)model.getValue(TOTAL_AMOUNT)) > 0) {
            this.rollbackPropertyChange(args);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u6536\u6536\u5165\u91d1\u989d\u5408\u8ba1\u4e0d\u5f97\u8d85\u8fc7\u5408\u540c\u603b\u91d1\u989d", (String)"NotTaccrualBasisEdit_1", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        if (this.isBookIncomeMoreThanTaxIncome()) {
            this.rollbackPropertyChange(args);
            return;
        }
        model.setValue(LJ_TAX_INCOME, (Object)ljtaxincome);
    }

    private void checkAndUpdateLjBookIncome(PropertyChangedArgs args) {
        if (this.isBookIncomeMoreThanTaxIncome()) {
            this.rollbackPropertyChange(args);
            return;
        }
        BigDecimal ljbookincome = this.calcLjAmount(BOOK_INCOME_REG, ZZ_AMOUNT);
        IDataModel model = this.getModel();
        model.setValue(LJ_BOOK_INCOME, (Object)ljbookincome);
    }

    private BigDecimal calcLjAmount(String entryName, String amountName) {
        BigDecimal ljAmount = BigDecimal.ZERO;
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount(entryName);
        for (int i = 0; i < count; ++i) {
            ljAmount = ljAmount.add((BigDecimal)model.getValue(amountName, i));
        }
        return ljAmount;
    }

    private boolean isBookIncomeMoreThanTaxIncome() {
        BigDecimal ljsssramount = this.calcLjAmount(TAX_INCOME_REG, SS_AMOUNT);
        BigDecimal ljzzsramount = this.calcLjAmount(BOOK_INCOME_REG, ZZ_AMOUNT);
        if (ljzzsramount.compareTo(ljsssramount) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d26\u8f7d\u91d1\u989d\u6536\u5165\u5408\u8ba1\u5927\u4e8e\u7a0e\u6536\u6536\u5165\u91d1\u989d\u5408\u8ba1\uff0c\u8bf7\u6ce8\u610f\u6570\u636e\u6b63\u786e\u6027", (String)"NotTaccrualBasisEdit_2", (String)"taxc-tccit", (Object[])new Object[0]));
            return false;
        }
        return false;
    }

    private DynamicObject newMiddleObject(Integer year) {
        DynamicObject middle = BusinessDataServiceHelper.newDynamicObject((String)"tccit_nottaccrual_middle");
        middle.set("org", this.getModel().getValue("org"));
        middle.set("billno", this.getModel().getValue("billno"));
        middle.set("incometype", this.getModel().getValue("incometype"));
        middle.set("htzje", this.getModel().getValue(TOTAL_AMOUNT));
        middle.set("year", (Object)LocalDateUtils.localDate2Date(LocalDate.of((int)year, 1, 1)));
        middle.set("name", this.getModel().getValue("name"));
        middle.set(LJ_TAX_INCOME, this.getModel().getValue(LJ_TAX_INCOME));
        middle.set(LJ_BOOK_INCOME, this.getModel().getValue(LJ_BOOK_INCOME));
        middle.set("syjzamount", this.getModel().getValue("syjzamount"));
        middle.set("billstatus", this.getModel().getValue("billstatus"));
        return middle;
    }

    private void rollbackPropertyChange(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        Object oldValue = changeSet[0].getOldValue();
        this.getModel().setValue(name, oldValue, rowIndex);
    }

    private void updateLjTaxIncome() {
        IDataModel model = this.getModel();
        BigDecimal ljtaxincome = this.calcLjAmount(TAX_INCOME_REG, SS_AMOUNT);
        model.setValue(LJ_TAX_INCOME, (Object)ljtaxincome);
    }

    private void updateLjBookIncome() {
        IDataModel model = this.getModel();
        BigDecimal ljbookincome = this.calcLjAmount(BOOK_INCOME_REG, ZZ_AMOUNT);
        model.setValue(LJ_BOOK_INCOME, (Object)ljbookincome);
    }

    private /* synthetic */ DynamicObject lambda$afterDoOperation$0(Integer year) {
        return this.newMiddleObject(year);
    }
}

