/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;

public class SalaryIntedeductBillListPlugin
extends AbstractListPlugin {
    private static final String TCCIT_SALARY_INTEDEDUCT = "tccit_salary_intededuct";
    private static final String ACCOUNTTYPE = "accounttype";
    private static final String MONEY = "money";

    public void afterCreateNewData(EventObject evt) {
        Long defaultOrgId = Long.valueOf(this.getDefaultOrgId());
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCCIT_SALARY_INTEDEDUCT, (String)"accounttype,money", (QFilter[])new QFilter[]{new QFilter("org.id", "=", (Object)defaultOrgId)});
        this.getModel().setValue("zmjtje", (Object)this.calcMoney(query, "zmjt"));
        this.getModel().setValue("sjzfje", (Object)this.calcMoney(query, "sjzf"));
        this.getModel().setValue("bksqkcje", (Object)this.calcMoney(query, "bksqkc"));
    }

    private String getDefaultOrgId() {
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
        Long orgId = OrgCheckUtil.setDefaultOrg((IFormView)this.getView(), (Long)RequestContext.get().getOrgId(), (DynamicObjectCollection)col);
        return orgId != null ? String.valueOf(orgId) : "0";
    }

    public void afterBindData(EventObject evt) {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection collection = billlist.getCurrentListAllRowCollection();
        ArrayList arr = collection.stream().map(e -> (Long)e.getPrimaryKeyValue()).collect(Collectors.toCollection(ArrayList::new));
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCCIT_SALARY_INTEDEDUCT, (String)"accounttype,money", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)arr)});
        this.getModel().setValue("zmjtje", (Object)this.calcMoney(query, "zmjt"));
        this.getModel().setValue("sjzfje", (Object)this.calcMoney(query, "sjzf"));
        this.getModel().setValue("bksqkcje", (Object)this.calcMoney(query, "bksqkc"));
    }

    private BigDecimal calcMoney(DynamicObjectCollection query, String accounttype) {
        return query.stream().filter(q -> accounttype.equals(q.get(ACCOUNTTYPE))).map(x -> x.getBigDecimal(MONEY)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }
}

