/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;

public class SalaryIntedeductBillPlugin
extends AbstractBillPlugIn {
    private static final String COSTTYPE = "costtype";
    private static final String ACCOUNTTYPE = "accounttype";
    private static final String SALARYPAYTYPE = "salarypaytype";
    private static final String PRETAXDEDUCTDATE = "pretaxdeductdate";
    private static final String MONEY = "money";
    private static final String REMARKS = "remarks";
    private static final boolean ON = true;
    private static final boolean OFF = false;
    private static final String SAVE = "save";

    public void afterCreateNewData(EventObject e) {
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
        Object object = this.getModel().getValue("org");
        Long orgid = null;
        orgid = object == null ? OrgCheckUtil.setDefaultOrg((IFormView)this.getView(), (Long)RequestContext.get().getOrgId(), (DynamicObjectCollection)col) : (this.isTaxAccount(((DynamicObject)object).getLong("id")) ? Long.valueOf(((DynamicObject)object).getLong("id")) : OrgCheckUtil.setDefaultOrg((IFormView)this.getView(), (Long)RequestContext.get().getOrgId(), (DynamicObjectCollection)col));
        this.getModel().setValue("org", (Object)orgid);
    }

    private boolean isTaxAccount(Long orgid) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        return QueryServiceHelper.exists((String)"bastax_taxorg", (QFilter[])new QFilter[]{orgFilter});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject org;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String key = source.getOperateKey();
        if (SAVE.equals(key) && (org = (DynamicObject)this.getModel().getValue("org")) != null && !((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).getData()).booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"SalaryIntedeductBillPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (ACCOUNTTYPE.equals(name)) {
            if ("sjzf".equals(this.getModel().getValue(ACCOUNTTYPE))) {
                this.mustInputSwitch(true, PRETAXDEDUCTDATE);
                if ("gzxj".equals(this.getModel().getValue(COSTTYPE))) {
                    this.mustInputSwitch(true, SALARYPAYTYPE);
                }
            } else {
                this.mustInputSwitch(false, PRETAXDEDUCTDATE, SALARYPAYTYPE);
            }
            this.clearValue(SALARYPAYTYPE, PRETAXDEDUCTDATE, MONEY, REMARKS);
        } else if (COSTTYPE.equals(name)) {
            this.clearValue(ACCOUNTTYPE, SALARYPAYTYPE, PRETAXDEDUCTDATE, MONEY, REMARKS);
            if (!"qtkqkcxm".equals(this.getModel().getValue(COSTTYPE))) {
                this.validateBranch();
            }
        }
    }

    private void validateBranch() {
        Long orgid;
        boolean notAuthorize;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null && (notAuthorize = LicenseCheckServiceHelper.check((Object)(orgid = Long.valueOf(org.getLong("id"))), (IFormView)this.getView(), (String)"tccit"))) {
            this.getModel().setValue("org", null);
            return;
        }
    }

    private void mustInputSwitch(boolean onOff, String ... keys) {
        for (String key : keys) {
            FieldEdit control = (FieldEdit)this.getControl(key);
            control.setMustInput(onOff);
        }
    }

    private void clearValue(String ... keys) {
        for (String key : keys) {
            this.getModel().setValue(key, null);
        }
    }
}

