/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class ShareRateAdjustPlugin
extends AbstractListPlugin {
    private static final String ENTITY_NAME = "tccit_branch_share_bill";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("updatenum", this.getView().getFormShowParameter().getCustomParam("initsharerate"));
        this.getModel().setValue("postupdate", this.getView().getFormShowParameter().getCustomParam("sharerate"));
    }

    public void beforeClick(BeforeClickEvent evt) {
        Button btn = (Button)evt.getSource();
        String itemKey = btn.getKey();
        if ("btnok".equals(itemKey)) {
            BigDecimal postupdate = (BigDecimal)this.getModel().getValue("postupdate");
            if (BigDecimal.ZERO.compareTo(postupdate) > 0 || BigDecimal.ONE.compareTo(postupdate) < 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d85\u8fc7\u6570\u503c\u8303\u56f4[0,1]\u3002", (String)"ShareRateAdjustPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
                return;
            }
            Object id = this.getView().getFormShowParameter().getCustomParam("id");
            DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
            DynamicObject sumscheme = (DynamicObject)dyo.get("sumscheme");
            String participation = sumscheme.getString("participation");
            dyo.set("sharerate", (Object)postupdate);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyo});
            Date period = DateUtils.stringToDate((String)dyo.getString("period"));
            Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)period);
            Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)period);
            QFilter sumschemeFilter = new QFilter("sumscheme", "=", (Object)sumscheme.getLong("id"));
            if ("false".equals(participation)) {
                sumschemeFilter = sumschemeFilter.and(new QFilter("declaration", "=", (Object)"3"));
            }
            QFilter firstFilter = new QFilter("period", ">=", (Object)firstDateOfYear);
            QFilter lastFilter = new QFilter("period", "<=", (Object)lastDateOfYear);
            QFilter usableFilter = new QFilter("usable", "=", (Object)"1");
            DynamicObjectCollection result = QueryServiceHelper.query((String)ENTITY_NAME, (String)"sharerate", (QFilter[])new QFilter[]{sumschemeFilter, firstFilter, lastFilter, usableFilter});
            BigDecimal sumrate = result.stream().map(s -> s.getBigDecimal("sharerate")).reduce(BigDecimal::add).get();
            this.getView().returnDataToParent((Object)sumrate);
            ShareRateAdjustPlugin.writeOperate(id);
            this.getView().close();
        }
    }

    private static void writeOperate(Object id) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_NAME);
        RequestContext context = RequestContext.get();
        dynamicObject.set("operator", (Object)context.getUserName());
        dynamicObject.set("operatetime", (Object)DateUtils.formatHMS((Date)new Date()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }
}

