/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.formplugin.taxbook.ExtendAbstractBillPlugin;

public class SoftIcQyyhEdit
extends ExtendAbstractBillPlugin {
    protected static final String CDTITLE = "cdtitle";
    protected static final String ROW = "row";
    protected static final String ZBNAME = "zbname";
    protected static final String ZBZ = "zbz";
    protected static final String MODIDY_DATE = "modifydate";
    private static final String YEAR = "year";
    private static final String ENTITY_NAME = "tccit_soft_ic_qyyh";
    private static final String VECTORAP = "vectorap";
    private static final String JYDXZKYSXLZGRS = "jydxzkysxlzgrs";
    private static final String BNYPJZGZRS = "bnypjzgzrs";
    private static final String YJKFRYRS = "yjkfryrs";
    private static final String YFFYZE = "yffyze";
    private static final String JNYFFYJE = "jnyffyje";
    private static final String qysrzeQYSRZE = "qysrze";
    private static final String FHTJDXSSR = "fhtjdxssr";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{VECTORAP});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount("entryentity");
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                model.setValue(CDTITLE, (Object)String.format(ResManager.loadKDString((String)"\u5176\u4ed6\u6307\u6807%s", (String)"SoftIcQyyhEdit_0", (String)"taxc-tccit", (Object[])new Object[0]), i + 1), i);
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                int newRow = model.createNewEntryRow("entryentity");
                model.setValue(CDTITLE, (Object)String.format(ResManager.loadKDString((String)"\u5176\u4ed6\u6307\u6807%s", (String)"SoftIcQyyhEdit_0", (String)"taxc-tccit", (Object[])new Object[0]), i + 1), newRow);
                model.setValue(ZBZ, (Object)BigDecimal.ZERO, newRow);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name;
        switch (name = args.getProperty().getName()) {
            case "jydxzkysxlzgrs": {
                this.getModel().setValue(YJKFRYRS, (Object)0);
                this.checkZb(args, BNYPJZGZRS, ResManager.loadKDString((String)"\u5177\u6709\u5927\u5b66\u4e13\u79d1\u4ee5\u4e0a\u5b66\u5386\u804c\u5de5\u4eba\u6570\u4e0d\u80fd\u8d85\u8fc7\u4f01\u4e1a\u672c\u5e74\u6708\u5e73\u5747\u804c\u5de5\u603b\u4eba\u6570", (String)"SoftIcQyyhEdit_1", (String)"taxc-tccit", (Object[])new Object[0]));
                break;
            }
            case "yjkfryrs": {
                this.checkZb(args, BNYPJZGZRS, ResManager.loadKDString((String)"\u7814\u7a76\u5f00\u53d1\u4eba\u5458\u4eba\u6570\u4e0d\u80fd\u8d85\u8fc7\u4f01\u4e1a\u672c\u5e74\u6708\u5e73\u5747\u804c\u5de5\u603b\u4eba\u6570", (String)"SoftIcQyyhEdit_2", (String)"taxc-tccit", (Object[])new Object[0]));
                break;
            }
            case "bnypjzgzrs": {
                this.getModel().setValue(JYDXZKYSXLZGRS, (Object)0);
                this.getModel().setValue(YJKFRYRS, (Object)0);
                break;
            }
            case "yffyze": {
                this.getModel().setValue(JNYFFYJE, (Object)0);
                break;
            }
            case "jnyffyje": {
                this.checkZb(args, YFFYZE, ResManager.loadKDString((String)"\u5883\u5185\u7814\u53d1\u8d39\u7528\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u7814\u53d1\u8d39\u7528\u603b\u989d", (String)"SoftIcQyyhEdit_3", (String)"taxc-tccit", (Object[])new Object[0]));
                break;
            }
            case "qysrze": {
                this.getModel().setValue(FHTJDXSSR, (Object)0);
                break;
            }
            case "fhtjdxssr": {
                this.checkZb(args, qysrzeQYSRZE, ResManager.loadKDString((String)"\u7b26\u5408\u6761\u4ef6\u7684\u9500\u552e\uff08\u8425\u4e1a\uff09\u6536\u5165\u4e0d\u80fd\u8d85\u8fc7\u4f01\u4e1a\u6536\u5165\u603b\u989d", (String)"SoftIcQyyhEdit_4", (String)"taxc-tccit", (Object[])new Object[0]));
                break;
            }
            case "year": {
                this.getModel().setValue(BNYPJZGZRS, (Object)0);
                this.getModel().setValue(JYDXZKYSXLZGRS, (Object)0);
                this.getModel().setValue(YJKFRYRS, (Object)0);
                this.getModel().setValue(YFFYZE, (Object)0);
                this.getModel().setValue(JNYFFYJE, (Object)0);
                this.getModel().setValue(qysrzeQYSRZE, (Object)0);
                this.getModel().setValue(FHTJDXSSR, (Object)0);
                IDataModel model = this.getModel();
                int count = model.getEntryRowCount("entryentity");
                for (int i = 0; i < count; ++i) {
                    model.setValue(ZBNAME, null, i);
                    model.setValue(ZBZ, (Object)0, i);
                    model.setValue(MODIDY_DATE, null, i);
                }
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (VECTORAP.equals(key)) {
            EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryentity.getSelectRows();
            int length = selectRows.length;
            int selectRow = 0;
            if (length > 0) {
                selectRow = selectRows[length - 1];
            }
            DynamicObject dynObj = this.getModel().getEntryRowEntity("entryentity", selectRow);
            this.openQtzbForm(dynObj, selectRow);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String key = source.getOperateKey();
        int statusValue = this.getView().getFormShowParameter().getStatusValue();
        if ("save".equals(key) && OperationStatus.ADDNEW.getValue() == statusValue) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            String orgName = org.getString("name");
            Date year = (Date)this.getModel().getValue(YEAR);
            Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)year);
            Date lastDateOfYear = DateUtils.getLastDateOfYear1((Date)year);
            String yyyy = DateUtils.format((Date)year, (String)"yyyy");
            boolean exists = QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("org", "=", org.get("id")), new QFilter(YEAR, ">=", (Object)firstDateOfYear), new QFilter(YEAR, "<=", (Object)lastDateOfYear)});
            if (exists) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u5728%2$s\u5e74\u5df2\u5b58\u5728\u300a\u8f6f\u4ef6\u3001\u96c6\u6210\u7535\u8def\u4f01\u4e1a\u4f18\u60e0\u60c5\u51b5\u53f0\u8d26\u300b\uff0c\u8bf7\u52ff\u91cd\u590d\u5efa\u7acb\u53f0\u8d26", (String)"SoftIcQyyhEdit_5", (String)"taxc-tccit", (Object[])new Object[0]), orgName, yyyy));
                args.setCancel(true);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        Object id = this.getModel().getValue("id");
        boolean exists = QueryServiceHelper.exists((String)ENTITY_NAME, (Object)id);
        if (!exists) {
            IDataModel model = this.getModel();
            model.deleteEntryData("entryentity");
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        CardEntry entryentity = (CardEntry)this.getControl("entryentity");
        entryentity.getView().updateView();
        Map returnData = (Map)e.getReturnData();
        if (returnData != null) {
            Integer row = (Integer)returnData.get(ROW);
            this.getModel().setValue(ZBNAME, returnData.get(ZBNAME), row.intValue());
            this.getModel().setValue(ZBZ, returnData.get(ZBZ), row.intValue());
            this.getModel().setValue(MODIDY_DATE, returnData.get(MODIDY_DATE), row.intValue());
        }
    }

    private void checkZb(PropertyChangedArgs args, String compareName, String msg) {
        String name = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        Comparable newValue = (Comparable)changeSet[0].getNewValue();
        Comparable compare = (Comparable)this.getModel().getValue(compareName);
        if (newValue != null && newValue.compareTo(compare) > 0) {
            this.getView().showTipNotification(msg);
            int rowIndex = changeSet[0].getRowIndex();
            this.getModel().setValue(name, null, rowIndex);
        }
    }

    private void openQtzbForm(DynamicObject dynObj, int selectRow) {
        Object pkid = dynObj.getPkValue();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.NonModal);
        String formId = "tccit_soft_ic_qyyh_qtzb";
        showParameter.setFormId(formId);
        if (Long.valueOf(0L).equals(pkid)) {
            showParameter.setStatus(OperationStatus.ADDNEW);
        } else {
            showParameter.setStatus(OperationStatus.EDIT);
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put(CDTITLE, dynObj.get(CDTITLE));
        customParams.put("name", dynObj.get(ZBNAME));
        customParams.put(ZBZ, dynObj.get(ZBZ));
        customParams.put(ROW, selectRow);
        showParameter.setCustomParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, formId);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }
}

