/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.formplugin.taxbook.ExtendAbstractBillPlugin;

public class SpecificBusinessRealDevEnterEditPlugin
extends ExtendAbstractBillPlugin
implements BeforeF7SelectListener {
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Date end;
        Date start;
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        int rowIndex = changeSet[0].getRowIndex();
        String name = e.getProperty().getName();
        if (newValue != null && name.endsWith("periodstart")) {
            this.getModel().setValue(name, (Object)DateUtils.getFirstDateOfMonth((Date)((Date)newValue)), rowIndex);
        }
        if (newValue != null && name.endsWith("periodend")) {
            this.getModel().setValue(name, (Object)DateUtils.getLastDateOfMonth2((Date)((Date)newValue)), rowIndex);
        }
        if (name.equals("nofinishperiodstart") || name.equals("nofinishperiodend")) {
            start = (Date)this.getModel().getValue("nofinishperiodstart", rowIndex);
            end = (Date)this.getModel().getValue("nofinishperiodend", rowIndex);
            if (start != null && end != null && start.after(end)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f1a\u8ba1\u671f\u95f4\u8d77\u4e0d\u80fd\u5927\u4e8e\u6b62\uff01", (String)"SpecificBusinessRealDevEnterEditPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
                this.rollbackPropertyChange(e);
                return;
            }
            if (start != null && end != null && !this.isMatchDate(start, end)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u5fc5\u987b\u4e3a\u81ea\u7136\u6708\u3001\u81ea\u7136\u5b63\u3001\u81ea\u7136\u5e74\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01", (String)"SpecificBusinessRealDevEnterEditPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
                this.rollbackPropertyChange(e);
                return;
            }
        }
        if (name.equals("finishperiodstart") || name.equals("finishperiodend")) {
            start = (Date)this.getModel().getValue("finishperiodstart", rowIndex);
            end = (Date)this.getModel().getValue("finishperiodend", rowIndex);
            if (start != null && end != null && start.after(end)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f1a\u8ba1\u671f\u95f4\u8d77\u4e0d\u80fd\u5927\u4e8e\u6b62\uff01", (String)"SpecificBusinessRealDevEnterEditPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
                this.rollbackPropertyChange(e);
                return;
            }
            if (start != null && end != null && !this.isMatchDate(start, end)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u5fc5\u987b\u4e3a\u81ea\u7136\u6708\u3001\u81ea\u7136\u5b63\u3001\u81ea\u7136\u5e74\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01", (String)"SpecificBusinessRealDevEnterEditPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
                this.rollbackPropertyChange(e);
                return;
            }
        }
        if (Lists.newArrayList((Object[])new String[]{"nofinishperiodstart", "nofinishperiodend", "finishperiodstart", "finishperiodend"}).contains(name)) {
            this.reBuildEntity(this.getPeriods(), true);
        }
        if (Lists.newArrayList((Object[])new String[]{"nofinishnstz", "finishnstz"}).contains(name)) {
            this.reBuildEntity(null, false);
        }
    }

    private boolean isMatchDate(Date start, Date end) {
        if (start == null || end == null) {
            return true;
        }
        int monthDiff = DateUtils.getMonthDiff((Date)end, (Date)start);
        if (monthDiff == 0) {
            return true;
        }
        if (monthDiff == 2) {
            int startMonth = DateUtils.getMonthOfDate((Date)start);
            int endMonth = DateUtils.getMonthOfDate((Date)end);
            return Lists.newArrayList((Object[])new Integer[]{1, 4, 7, 10}).contains(startMonth) && Lists.newArrayList((Object[])new Integer[]{3, 6, 9, 12}).contains(endMonth);
        }
        if (monthDiff == 11) {
            int startMonth = DateUtils.getMonthOfDate((Date)start);
            int endMonth = DateUtils.getMonthOfDate((Date)end);
            return startMonth == 1 && endMonth == 12;
        }
        return false;
    }

    private void rollbackPropertyChange(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        Object oldValue = changeSet[0].getOldValue();
        this.getModel().setValue(name, oldValue, rowIndex);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("deleteentry".equals(operateKey) || "deleteentry1".equals(operateKey)) {
            this.reBuildEntity(this.getPeriods(), true);
        }
        if ("batchcopyentry".equals(operateKey) || "batchcopyentry1".equals(operateKey)) {
            this.reBuildEntity(null, false);
        }
    }

    public List<Date> getPeriods() {
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
        DynamicObjectCollection entity1 = this.getModel().getEntryEntity("entryentity1");
        Stream<Date> nofinishperiodstart = entity.stream().map(s -> s.getDate("nofinishperiodstart"));
        Stream<Date> nofinishperiodend = entity.stream().map(s -> s.getDate("nofinishperiodend"));
        Stream<Date> finishperiodstart = entity1.stream().map(s -> s.getDate("finishperiodstart"));
        Stream<Date> finishperiodend = entity1.stream().map(s -> s.getDate("finishperiodend"));
        List<Date> periods = Streams.concat((Stream[])new Stream[]{nofinishperiodstart, nofinishperiodend, finishperiodstart, finishperiodend}).filter(Objects::nonNull).map(s -> DateUtils.getFirstDateOfYear((Date)s)).distinct().sorted().collect(Collectors.toList());
        return periods;
    }

    private void reBuildEntity(List<Date> periods, boolean rebuildPeriod) {
        IDataModel model = this.getModel();
        if (rebuildPeriod) {
            model.deleteEntryData("entryentity2");
            if (periods == null || periods.size() == 0) {
                return;
            }
            model.batchCreateNewEntryRow("entryentity2", periods.size());
            model.beginInit();
            int index = 0;
            for (Date period : periods) {
                this.getModel().setValue("period", (Object)period, index);
                BigDecimal salenofinishnstz = this.getSumSalenofinishnstz(model, period);
                this.getModel().setValue("salenofinishnstz", (Object)salenofinishnstz, index);
                BigDecimal salefinishnstz = this.getSumSalefinishnstz(model, period);
                this.getModel().setValue("salefinishnstz", (Object)salefinishnstz, index);
                this.getModel().setValue("specbusrealdevnstz", (Object)salenofinishnstz.subtract(salefinishnstz), index);
                ++index;
            }
            model.endInit();
            this.getView().updateView("entryentity2");
        } else {
            DynamicObjectCollection entity = model.getEntryEntity("entryentity2");
            if (CollectionUtils.isEmpty((Collection)entity)) {
                return;
            }
            for (DynamicObject object : entity) {
                Date period = object.getDate("period");
                BigDecimal salenofinishnstz = this.getSumSalenofinishnstz(model, period);
                object.set("salenofinishnstz", (Object)salenofinishnstz);
                BigDecimal salefinishnstz = this.getSumSalefinishnstz(model, period);
                object.set("salefinishnstz", (Object)salefinishnstz);
                object.set("specbusrealdevnstz", (Object)salenofinishnstz.subtract(salefinishnstz));
            }
            this.getView().updateView("entryentity2");
        }
    }

    private BigDecimal getSumSalenofinishnstz(IDataModel model, Date period) {
        DynamicObjectCollection entity = model.getEntryEntity("entryentity");
        BigDecimal sumnofinishnstz = entity.stream().filter(d -> {
            Optional<Date> startOptional = Optional.ofNullable(d.getDate("nofinishperiodstart")).filter(s -> DateUtils.getYearOfDate((Date)s) == DateUtils.getYearOfDate((Date)period));
            Optional<Date> endOptional = Optional.ofNullable(d.getDate("nofinishperiodend")).filter(s -> DateUtils.getYearOfDate((Date)s) == DateUtils.getYearOfDate((Date)period));
            return startOptional.isPresent() || endOptional.isPresent();
        }).map(s -> s.getBigDecimal("nofinishnstz")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sumnofinishnstz;
    }

    private BigDecimal getSumSalefinishnstz(IDataModel model, Date period) {
        DynamicObjectCollection entity1 = model.getEntryEntity("entryentity1");
        BigDecimal sumfinishnstz = entity1.stream().filter(d -> {
            Optional<Date> startOptional = Optional.ofNullable(d.getDate("finishperiodstart")).filter(s -> DateUtils.getYearOfDate((Date)s) == DateUtils.getYearOfDate((Date)period));
            Optional<Date> endOptional = Optional.ofNullable(d.getDate("finishperiodend")).filter(s -> DateUtils.getYearOfDate((Date)s) == DateUtils.getYearOfDate((Date)period));
            return startOptional.isPresent() || endOptional.isPresent();
        }).map(s -> s.getBigDecimal("finishnstz")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sumfinishnstz;
    }
}

