/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.taxbook.ZeroRatingInOutService;
import kd.taxc.tccit.formplugin.taxbook.ExtendAbstractBillPlugin;

public class ZeroRatingInOutPlugin
extends ExtendAbstractBillPlugin {
    private static final String FISCAL_AMOUNT = "fiscalamount";
    private static final String ZERO_RATING_AMOUNT = "zeroratingamount";
    private static final String INCOMEDATE = "incomedate";
    private static final String IN_INCOME_REG = "tccit_in_income_reg";
    private static final String PAY_REGISTER = "tccit_pay_register";
    private static final String FINANCIAL_REGISTER = "tccit_financial_register";
    private static final String BALANCE_REGISTER = "tccit_balance_register";
    private static final List<String> entryLists = Lists.newArrayList((Object[])new String[]{"tccit_in_income_reg", "tccit_pay_register", "tccit_financial_register", "tccit_balance_register"});
    private static final String SUM_REGISTER_INCOME = "sumregisterincome";
    private static final String SUM_REGISTERPAY = "sumregisterpay";
    private static final String SUM_FINANCIAL = "sumfinancial";
    private static final String SUM_INCLUDED_TAXABLE = "sumincludedtaxable";
    private static final String BALANCE_AMOUNT = "balanceamount";
    private static final String INCOME_REG_AMOUNT = "income_reg_amount";
    private static final String PAY_REG_AMOUNT = "pay_reg_amount";
    private static final String FINANCIAL_REG_AMOUNT = "financial_reg_amount";
    private static final String BALANCE_REG_AMOUNT = "balance_reg_amount";
    private static final String INCOME_REG_DATE = "income_reg_date";
    private static final String PAY_REG_DATE = "pay_reg_date";
    private static final String FINANCIAL_REG_DATE = "financial_reg_date";
    private static final String BALANCE_REG_DATE = "balance_reg_date";
    private static final Set<String> dateFields = Sets.newHashSet((Object[])new String[]{"income_reg_date", "pay_reg_date", "financial_reg_date", "balance_reg_date"});
    private static final String INCOME_REG_DELETE = "income_reg_deleteentry";
    private static final String PAY_REG_DELETE = "pay_reg_deleteentry";
    private static final String FINANCIAL_REG_DELETE = "financial_reg_deleteentry";
    private static final String BALANCE_REG_DELETE = "balance_reg_deleteentry";
    private static final String SAVE = "save";
    private static ZeroRatingInOutService zeroRatingInOutService = new ZeroRatingInOutService();

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.updateSumRegIncome();
        this.updateSumRegPay();
        this.updateSumfinancial();
        this.updateSumIncludedtaxable();
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    /*
     * Unable to fully structure code
     */
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        var3_3 = optKey = args.getOperateKey();
        var4_4 = -1;
        switch (var3_3.hashCode()) {
            case 1083880422: {
                if (!var3_3.equals("income_reg_deleteentry")) break;
                var4_4 = 0;
                break;
            }
            case -91560731: {
                if (!var3_3.equals("pay_reg_deleteentry")) break;
                var4_4 = 1;
                break;
            }
            case 560934598: {
                if (!var3_3.equals("financial_reg_deleteentry")) break;
                var4_4 = 2;
                break;
            }
            case 261536537: {
                if (!var3_3.equals("balance_reg_deleteentry")) break;
                var4_4 = 3;
                break;
            }
            case 3522941: {
                if (!var3_3.equals("save")) break;
                var4_4 = 4;
            }
        }
        switch (var4_4) {
            case 0: {
                this.updateSumRegIncome();
                break;
            }
            case 1: {
                this.updateSumRegPay();
                break;
            }
            case 2: {
                this.updateSumfinancial();
                break;
            }
            case 3: {
                this.updateSumIncludedtaxable();
                break;
            }
            case 4: {
                if (!args.getOperationResult().isSuccess()) break;
                incomeDate = (Date)this.getModel().getValue("incomedate");
                currentYear = DateUtils.getYearOfDate((Date)incomeDate);
                years = IntStream.range(currentYear, currentYear + 6).boxed().collect(Collectors.toList());
                h = TX.required();
                var9_9 = null;
                try {
                    DeleteServiceHelper.delete((String)"tccit_zero_rating_middle", (QFilter[])new QFilter[]{new QFilter("bizno", "=", this.getModel().getValue("billno"))});
                    ZeroRatingInOutPlugin.zeroRatingInOutService.saveZeroRatingMiddle(years, (Function<Integer, DynamicObject>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$afterDoOperation$0(java.lang.Integer ), (Ljava/lang/Integer;)Lkd/bos/dataentity/entity/DynamicObject;)((ZeroRatingInOutPlugin)this), (Function<String, DynamicObjectCollection>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$afterDoOperation$1(java.lang.String ), (Ljava/lang/String;)Lkd/bos/dataentity/entity/DynamicObjectCollection;)((ZeroRatingInOutPlugin)this));
                }
                catch (Throwable t) {
                    h.markRollback();
                    throw t;
                }
                if (h == null) break;
                if (var9_9 == null) ** GOTO lbl61
                try {
                    h.close();
                }
                catch (Throwable var10_11) {
                    var9_9.addSuppressed(var10_11);
                }
                break;
lbl61:
                // 1 sources

                h.close();
                break;
                catch (Throwable var10_12) {
                    try {
                        var9_9 = var10_12;
                        throw var10_12;
                    }
                    catch (Throwable var11_13) {
                        if (h != null) {
                            if (var9_9 != null) {
                                try {
                                    h.close();
                                }
                                catch (Throwable var12_14) {
                                    var9_9.addSuppressed(var12_14);
                                }
                            } else {
                                h.close();
                            }
                        }
                        throw var11_13;
                    }
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if (INCOMEDATE.equals(name)) {
            entryLists.stream().forEach(s -> this.getModel().deleteEntryData(s));
            this.updateSumRegIncome();
            this.updateSumRegPay();
            this.updateSumfinancial();
            this.updateSumIncludedtaxable();
        }
        if (FISCAL_AMOUNT.equals(name)) {
            this.checkFinancialAmount(args);
        }
        if (ZERO_RATING_AMOUNT.equals(name)) {
            this.checkZeroRatingAmount(args);
            this.updateBalanceAmount();
        }
        if (INCOME_REG_AMOUNT.equals(name)) {
            this.checkAndUpdateSumIncomeReg(args);
        }
        if (PAY_REG_AMOUNT.equals(name)) {
            this.checkAndUpdateSumRegPay(args);
            this.updateBalanceAmount();
        }
        if (FINANCIAL_REG_AMOUNT.equals(name)) {
            this.checkAndUpdateSumFinancialReg(args);
            this.updateBalanceAmount();
        }
        if (BALANCE_REG_AMOUNT.equals(name)) {
            this.checkAndUpdateSumIncludedtaxable(args);
            this.updateBalanceAmount();
        }
        if (dateFields.contains(name)) {
            this.checkBizDate(args);
        }
    }

    private Boolean checkZeroRatingAmount(PropertyChangedArgs args) {
        BigDecimal fiscalAmount = (BigDecimal)this.getModel().getValue(FISCAL_AMOUNT);
        ChangeData[] changeSet = args.getChangeSet();
        BigDecimal newValue = (BigDecimal)changeSet[0].getNewValue();
        if (newValue.compareTo(BigDecimal.ZERO) < 0 || newValue.compareTo(fiscalAmount) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5f81\u7a0e\u6536\u5165\u91d1\u989d\u4e0d\u5f97\u4e3a\u8d1f\u6570\u4e14\u4e0d\u5f97\u8d85\u8fc7\u8d22\u653f\u6027\u8d44\u91d1", (String)"ZeroRatingInOutPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
            this.rollbackPropertyChange(args);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Boolean checkFinancialAmount(PropertyChangedArgs args) {
        BigDecimal zeroRatingAmount = (BigDecimal)this.getModel().getValue(ZERO_RATING_AMOUNT);
        ChangeData[] changeSet = args.getChangeSet();
        BigDecimal newValue = (BigDecimal)changeSet[0].getNewValue();
        if (newValue.compareTo(BigDecimal.ZERO) < 0 || zeroRatingAmount.compareTo(newValue) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5f81\u7a0e\u6536\u5165\u91d1\u989d\u4e0d\u5f97\u4e3a\u8d1f\u6570\u4e14\u4e0d\u5f97\u8d85\u8fc7\u8d22\u653f\u6027\u8d44\u91d1", (String)"ZeroRatingInOutPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
            this.rollbackPropertyChange(args);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void checkAndUpdateSumIncomeReg(PropertyChangedArgs args) {
        BigDecimal totalAmt;
        IDataModel model = this.getModel();
        BigDecimal sumInComeRegAmount = this.calcSumAmount(IN_INCOME_REG, INCOME_REG_AMOUNT, e -> this.getEntry((String)e));
        if (sumInComeRegAmount.compareTo(totalAmt = (BigDecimal)model.getValue(ZERO_RATING_AMOUNT)) > 0) {
            this.rollbackPropertyChange(args);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672c\u53f0\u8d26\u4ec5\u5bf9\u4e0d\u5f81\u7a0e\u6536\u5165\u7684\u5165\u8d26\u60c5\u51b5\u8fdb\u884c\u7ba1\u7406\uff0c\u8ba1\u5165\u6536\u76ca\u91d1\u989d\u5408\u8ba1\u4e0d\u5f97\u8d85\u8fc7\u4e0d\u5f81\u7a0e\u6536\u5165\u91d1\u989d", (String)"ZeroRatingInOutPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        model.setValue(SUM_REGISTER_INCOME, (Object)sumInComeRegAmount);
    }

    private void checkAndUpdateSumRegPay(PropertyChangedArgs args) {
        IDataModel model = this.getModel();
        ChangeData[] changeSet = args.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        BigDecimal sumPayRegAmount = this.calcSumAmount(PAY_REGISTER, PAY_REG_AMOUNT, e -> this.getEntry((String)e));
        BigDecimal balanceamount = (BigDecimal)model.getValue(BALANCE_AMOUNT);
        BigDecimal sumInComeRegAmount = (BigDecimal)model.getValue(SUM_REGISTER_INCOME);
        if (sumPayRegAmount.compareTo(sumInComeRegAmount) > 0) {
            this.rollbackPropertyChange(args);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u652f\u51fa\u60c5\u51b5\u767b\u8bb0\u91d1\u989d\u5408\u8ba1\u4e0d\u5f97\u8d85\u8fc7\u8ba1\u5165\u6536\u76ca\u91d1\u989d\u5408\u8ba1", (String)"ZeroRatingInOutPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        if (this.compareAmount().booleanValue()) {
            this.rollbackPropertyChange(args);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u652f\u51fa\u60c5\u51b5\u767b\u8bb0\u91d1\u989d\u3010%1$s\u3011\u4e0d\u5f97\u8d85\u8fc7\u7ed3\u4f59\u53ef\u7528\u91d1\u989d\u3010%2$s\u3011", (String)"ZeroRatingInOutPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]), newValue, balanceamount));
            return;
        }
        model.setValue(SUM_REGISTERPAY, (Object)sumPayRegAmount);
    }

    private void checkAndUpdateSumFinancialReg(PropertyChangedArgs args) {
        IDataModel model = this.getModel();
        ChangeData[] changeSet = args.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        BigDecimal sumFinancicalRegAmount = this.calcSumAmount(FINANCIAL_REGISTER, FINANCIAL_REG_AMOUNT, e -> this.getEntry((String)e));
        BigDecimal balanceamount = (BigDecimal)model.getValue(BALANCE_AMOUNT);
        if (this.compareAmount().booleanValue()) {
            this.rollbackPropertyChange(args);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4e0a\u7f34\u8d22\u653f\u767b\u8bb0\u91d1\u989d\u3010%1$s\u3011\u4e0d\u5f97\u8d85\u8fc7\u7ed3\u4f59\u53ef\u7528\u91d1\u989d\u3010%2$s\u3011", (String)"ZeroRatingInOutPlugin_4", (String)"taxc-tccit", (Object[])new Object[0]), newValue, balanceamount));
            return;
        }
        model.setValue(SUM_FINANCIAL, (Object)sumFinancicalRegAmount);
    }

    private void checkAndUpdateSumIncludedtaxable(PropertyChangedArgs args) {
        IDataModel model = this.getModel();
        ChangeData[] changeSet = args.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        BigDecimal sumIncludedTaxable = this.calcSumAmount(BALANCE_REGISTER, BALANCE_REG_AMOUNT, e -> this.getEntry((String)e));
        BigDecimal balanceamount = (BigDecimal)model.getValue(BALANCE_AMOUNT);
        if (this.compareAmount().booleanValue()) {
            this.rollbackPropertyChange(args);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8ba1\u5165\u5e94\u7a0e\u6536\u5165\u767b\u8bb0\u91d1\u989d\u3010%1$s\u3011\u4e0d\u5f97\u8d85\u8fc7\u7ed3\u4f59\u53ef\u7528\u91d1\u989d\u3010%2$s\u3011", (String)"ZeroRatingInOutPlugin_6", (String)"taxc-tccit", (Object[])new Object[0]), newValue, balanceamount));
            return;
        }
        model.setValue(SUM_INCLUDED_TAXABLE, (Object)sumIncludedTaxable);
    }

    private BigDecimal calcSumAmount(String entryName, String amountName, Function<String, DynamicObjectCollection> entryFun) {
        return entryFun.apply(entryName).stream().map(s -> s.getBigDecimal(amountName)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private void rollbackPropertyChange(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        Object oldValue = changeSet[0].getOldValue();
        this.getModel().setValue(name, oldValue, rowIndex);
    }

    private void updateSumRegIncome() {
        IDataModel model = this.getModel();
        model.setValue(SUM_REGISTER_INCOME, (Object)this.calcSumAmount(IN_INCOME_REG, INCOME_REG_AMOUNT, e -> this.getEntry((String)e)));
    }

    private void updateSumRegPay() {
        IDataModel model = this.getModel();
        model.setValue(SUM_REGISTERPAY, (Object)this.calcSumAmount(PAY_REGISTER, PAY_REG_AMOUNT, e -> this.getEntry((String)e)));
        this.updateBalanceAmount();
    }

    private void updateSumfinancial() {
        IDataModel model = this.getModel();
        model.setValue(SUM_FINANCIAL, (Object)this.calcSumAmount(FINANCIAL_REGISTER, FINANCIAL_REG_AMOUNT, e -> this.getEntry((String)e)));
        this.updateBalanceAmount();
    }

    private void updateSumIncludedtaxable() {
        IDataModel model = this.getModel();
        model.setValue(SUM_INCLUDED_TAXABLE, (Object)this.calcSumAmount(BALANCE_REGISTER, BALANCE_REG_AMOUNT, e -> this.getEntry((String)e)));
        this.updateBalanceAmount();
    }

    private void updateBalanceAmount() {
        IDataModel model = this.getModel();
        model.setValue(BALANCE_AMOUNT, (Object)this.calcBalanceAmount());
    }

    private BigDecimal calcBalanceAmount() {
        IDataModel model = this.getModel();
        BigDecimal zeroRatingAmount = (BigDecimal)model.getValue(ZERO_RATING_AMOUNT);
        BigDecimal sumregisterpay = (BigDecimal)model.getValue(SUM_REGISTERPAY);
        BigDecimal sumfinancial = (BigDecimal)model.getValue(SUM_FINANCIAL);
        BigDecimal sumincludedtaxable = (BigDecimal)model.getValue(SUM_INCLUDED_TAXABLE);
        BigDecimal subtract = zeroRatingAmount.subtract(sumregisterpay).subtract(sumfinancial).subtract(sumincludedtaxable);
        return subtract;
    }

    private Boolean compareAmount() {
        IDataModel model = this.getModel();
        BigDecimal zeroRatingAmount = (BigDecimal)model.getValue(ZERO_RATING_AMOUNT);
        BigDecimal sumPayRegAmount = this.calcSumAmount(PAY_REGISTER, PAY_REG_AMOUNT, e -> this.getEntry((String)e));
        BigDecimal financialRegAmount = this.calcSumAmount(FINANCIAL_REGISTER, FINANCIAL_REG_AMOUNT, e -> this.getEntry((String)e));
        BigDecimal sumIncludedTaxable = this.calcSumAmount(BALANCE_REGISTER, BALANCE_REG_AMOUNT, e -> this.getEntry((String)e));
        return zeroRatingAmount.subtract(sumPayRegAmount).subtract(financialRegAmount).subtract(sumIncludedTaxable).compareTo(BigDecimal.ZERO) < 0;
    }

    private Boolean checkBizDate(PropertyChangedArgs args) {
        ChangeData[] changeSet = args.getChangeSet();
        Date inputDate = (Date)changeSet[0].getNewValue();
        IDataModel model = this.getModel();
        Date incomeDate = (Date)model.getValue(INCOMEDATE);
        if (incomeDate == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u6536\u5165\u65e5\u671f", (String)"ZeroRatingInOutPlugin_7", (String)"taxc-tccit", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)incomeDate);
        Date fiveYearLater = DateUtils.addYear((Date)lastDateOfYear, (int)5);
        if (inputDate == null || !DateUtils.isEffectiveDate((Date)inputDate, (Date)incomeDate, (Date)fiveYearLater)) {
            this.getModel().setValue(args.getProperty().getName(), (Object)incomeDate, changeSet[0].getRowIndex());
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u5e94\u5728\u6536\u5165\u65e5\u671f\u4e94\u5e74\u5185\uff0c\u8bf7\u4fee\u6539", (String)"ZeroRatingInOutPlugin_8", (String)"taxc-tccit", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private DynamicObject initDynamicObject(Integer year) {
        DynamicObject middle = BusinessDataServiceHelper.newDynamicObject((String)"tccit_zero_rating_middle");
        middle.set("orgid", (Object)((DynamicObject)this.getModel().getValue("org")).getLong("id"));
        middle.set("bizno", this.getModel().getValue("billno"));
        middle.set(INCOMEDATE, this.getModel().getValue(INCOMEDATE));
        middle.set("type", this.getModel().getValue("type"));
        middle.set(FISCAL_AMOUNT, this.getModel().getValue(FISCAL_AMOUNT));
        middle.set(ZERO_RATING_AMOUNT, this.getModel().getValue(ZERO_RATING_AMOUNT));
        middle.set("year", (Object)year);
        return middle;
    }

    private DynamicObjectCollection getEntry(String entryName) {
        return this.getModel().getEntryEntity(entryName);
    }

    private /* synthetic */ DynamicObjectCollection lambda$afterDoOperation$1(String e) {
        return this.getEntry(e);
    }

    private /* synthetic */ DynamicObject lambda$afterDoOperation$0(Integer year) {
        return this.initDynamicObject(year);
    }
}

