/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook.assetloss;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxclicense.TaxcLicenseCheckDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.taxbook.assetloss.AssetLossTaskService;
import kd.taxc.tccit.formplugin.taxbook.AssetLossPreTaxList;

public class AssetLossSyncDataPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String TAXORG = "taxorg";
    private static final String PERIOD = "period";
    private static final String DEPREUSE = "depreuse";
    private static final String BTNOK = "btnok";
    private AssetLossTaskService assetLossTaskService = new AssetLossTaskService();

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
        BasedataEdit org = (BasedataEdit)this.getView().getControl(TAXORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        long userId = RequestContext.get().getCurrUserId();
        List enableOrgs = (List)TaxcCombineDataServiceHelper.queryTaxcOrgIdsByIsTaxpayerWithPerm((Long)userId, (String)"tccit", (String)"tccit_asset_loss_pre_tax", (String)"1JBQ2T90EV46").getData();
        Map licenseMap = (Map)TaxcLicenseCheckDataServiceHelper.checkBatch((List)enableOrgs, (String)"tccit").getData();
        Map categoryMap = (Map)TaxcMainDataServiceHelper.isTaxcMainCategoryEnableByOrgIds((List)enableOrgs).getData();
        ArrayList<Long> orgs = new ArrayList<Long>();
        for (Map.Entry entry : licenseMap.entrySet()) {
            Long orgId = (Long)entry.getKey();
            if (!Boolean.FALSE.equals(entry.getValue()) || !EmptyCheckUtils.isNotEmpty(categoryMap.get(orgId)) || !Boolean.TRUE.equals(((Map)categoryMap.get(orgId)).get("qysds"))) continue;
            orgs.add(orgId);
        }
        QFilter idsFilter = new QFilter("id", "in", orgs);
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        formShowParameter.getListFilterParameter().setFilter(idsFilter);
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (source.getKey().equals(BTNOK)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObject taxorg = dataEntity.getDynamicObject(TAXORG);
            Date period = dataEntity.getDate(PERIOD);
            DynamicObject depreuse = dataEntity.getDynamicObject(DEPREUSE);
            Long accountOrgId = (Long)OrgRelationDataServiceHelper.getDefaultAccountingOrgIdByTaxcOrgId((Long)taxorg.getLong("id")).getData();
            if (accountOrgId != null && accountOrgId != 0L) {
                try {
                    this.assetLossTaskService.checkOnlyOneTaskRun(taxorg.getLong("id"), period);
                    this.dispatch(taxorg, period, depreuse);
                    String operateName = ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e", (String)"AssetLossSyncDataPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]);
                    String operateDescription = String.format(ResManager.loadKDString((String)"\u540c\u6b65\u3010%1$s\u3011\u4f1a\u8ba1\u671f\u95f4\u3001\u3010%2$s\u3011\u6298\u65e7\u7528\u9014\u7684\u56fa\u5b9a\u8d44\u4ea7\u6e05\u7406\u5355", (String)"AssetLossSyncDataPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]), DateUtils.formatMonth((Date)period), depreuse.getString("name"));
                    OperatorDialogUtils.operateDialog((String)"qysds", (String)"tccit_asset_loss_syncdata", (String)operateName, (String)operateDescription, (Long)taxorg.getLong("id"));
                    this.getView().close();
                }
                catch (Exception e) {
                    this.getView().showTipNotification(e.getMessage());
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7a0e\u52a1\u7ec4\u7ec7\u5bf9\u5e94\u7684\u6838\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u53bb\u4e1a\u52a1\u5355\u5143\u534f\u4f5c\u4e2d\u7ef4\u62a4\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"AssetLossSyncDataPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
            }
        }
    }

    private void dispatch(DynamicObject org, Date period, DynamicObject depreuse) {
        String jobName = this.assetLossTaskService.getJobName(org.getLong("id"), period);
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("tccit");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setName(jobName);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.taxc.tccit.business.taxbook.assetloss.AssetLossTask");
        jobInfo.setRunByLang(RequestContext.get().getLang());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("orgId", org.getString("id"));
        params.put("orgName", org.getString("name"));
        params.put(PERIOD, DateUtils.format((Date)period));
        params.put("depreuseid", depreuse.getString("id"));
        params.put("depreusenumber", depreuse.getString("number"));
        params.put("depreusename", depreuse.getString("name"));
        params.put("jobname", jobName);
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack(AssetLossPreTaxList.class.getName(), "taskcloseback");
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u8d44\u4ea7\u635f\u5931\u7a0e\u524d\u6263\u9664\u53f0\u8d26\u751f\u6210\u4efb\u52a1", (String)"AssetLossSyncDataPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setClickClassName("kd.taxc.tccit.business.taxbook.assetloss.AssetLossTaskClick");
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView().getParentView());
    }
}

