/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook.contribute;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;
import org.apache.commons.collections.CollectionUtils;

public class ContributePayFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("contributetype");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("org");
        orgF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        List<Long> ids;
        String name = evt.getProperty().getName();
        if ("contributetype".equals(name)) {
            Object businessdate = this.getModel().getValue("businessdate");
            if (Objects.isNull(businessdate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u65e5\u671f", (String)"ContributePayFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
            }
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter listFilter = new QFilter("number", "in", (Object)new String[]{"3010401", "3010403", "301040201", "301040202", "301040203", "301040204", "301040205"});
            listFilter.and(new QFilter("start", "<=", businessdate));
            listFilter.and(new QFilter("end", ">=", businessdate).or(new QFilter("end", "is null", null)));
            listShowParameter.getListFilterParameter().setFilter(listFilter);
        }
        if ("org".equals(name) && CollectionUtils.isNotEmpty(ids = this.getEnableOrgIds())) {
            QFilter qFilter = new QFilter("id", "in", ids);
            evt.addCustomQFilter(qFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        Object org = this.getModel().getValue("org");
        if ("save".equals(operateKey) && Objects.nonNull(org)) {
            long orgid = ((DynamicObject)org).getLong("id");
            List<Long> enableOrgIds = this.getEnableOrgIds();
            if (!enableOrgIds.contains(orgid)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u53ef\u7528\u6216\u672a\u5ba1\u6838", (String)"ContributePayFormPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        long orgid;
        TaxResult isEnable;
        Object org = this.getModel().getValue("org");
        String operKey = (String)this.getView().getFormShowParameter().getCustomParams().get("MUTEX_OPER_KEY");
        if (Objects.nonNull(org) && !"modify".equals(operKey) && !((Boolean)(isEnable = TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)(orgid = ((DynamicObject)org).getLong("id")))).getData()).booleanValue()) {
            this.getModel().setValue("org", (Object)0L);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if ("zhangzaiamount".equals(name)) {
            Object newValue = changeSet[0].getNewValue();
            BigDecimal actualpayamount = (BigDecimal)this.getModel().getValue("actualpayamount");
            if (BigDecimal.ZERO.compareTo(actualpayamount) == 0) {
                this.getModel().setValue("actualpayamount", newValue);
            }
        }
        if ("businessdate".equals(name)) {
            this.getModel().setValue("contributetype", (Object)"");
        }
    }

    private List<Long> getEnableOrgIds() {
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
        List ids = col.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        TaxResult listTaxResult = TaxcMainDataServiceHelper.queryTaxcMainOrgIdByOrgIds(ids);
        return (List)listTaxResult.getData();
    }
}

