/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook.contribute;

import com.alibaba.fastjson.JSONObject;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;

public class ContributePayImportPlugin
extends BatchImportPlugin {
    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            ImportBillData data = it.next();
            StringBuilder message = this.validBillData(data);
            if (!StringUtils.isNotBlank((CharSequence)message.toString())) continue;
            logger.log(Integer.valueOf(data.getStartIndex()), message.toString()).fail();
            it.remove();
        }
        return super.save(rowdatas, logger);
    }

    private StringBuilder validBillData(ImportBillData data) {
        StringBuilder message = new StringBuilder();
        JSONObject importData = data.getData();
        JSONObject orgJsonObject = importData.getJSONObject("org");
        if (Objects.isNull(orgJsonObject)) {
            return message;
        }
        String orgNumber = orgJsonObject.getString("number");
        TaxResult isEnable = TaxcMainDataServiceHelper.isTaxcMainByOrgNum((String)orgNumber);
        if (!isEnable.isSuccess() || !((Boolean)isEnable.getData()).booleanValue()) {
            message.append(isEnable.getMessage());
        }
        return message;
    }
}

