/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook.engine;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleEnginEntityTypeEnum;
import kd.taxc.bdtaxr.common.dto.RuleEngineDto;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.rule.RuleService;
import kd.taxc.tccit.common.enums.RuleTypeEnum;

public class BranchShareEngine
implements IEngine {
    private static final String ADJUST_DETAIL = "tccit_adjust_detail";
    private static final String BRANCH_SHARE_DETAIL = "tccit_branch_share_detail";
    public static final List<String> ITEMNUMBERLIST = Arrays.asList("2021-SWTZ-ZFJGSYS-0001", "2021-SWTZ-ZFJGSYS-0002", "2021-SWTZ-ZFJGSYS-0003", "2021-SWTZ-ZFJGSYS-0001_", "2021-SWTZ-ZFJGSYS-0002_", "2021-SWTZ-ZFJGSYS-0003_");

    public void deleteData(EngineModel model) {
        Long orgId = Long.parseLong(model.getOrgId());
        Object taxorgids = model.getCustom().get("taxorgids");
        Object isHeadOrg = model.getCustom().get("isHeadOrg");
        Object isIndependentOrg = model.getCustom().get("isIndependentOrg");
        if (taxorgids != null) {
            List taxorgids1 = (List)taxorgids;
            QFilter q1 = new QFilter("taxorg", "in", (Object)taxorgids1);
            if (Boolean.FALSE.equals(isHeadOrg) && Boolean.FALSE.equals(isIndependentOrg)) {
                q1 = q1.or(new QFilter("org", "=", (Object)orgId));
            }
            Date startDate = DateUtils.stringToDate((String)model.getStartDate());
            QFilter q2 = new QFilter("skssqq", ">=", (Object)startDate);
            Date endDate = DateUtils.stringToDate((String)model.getEndDate());
            QFilter q3 = new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast((Date)endDate));
            DeleteServiceHelper.delete((String)BRANCH_SHARE_DETAIL, (QFilter[])new QFilter[]{q1, q2, q3});
            QFilter itemnumberFilter = new QFilter("itemnumber", "in", ITEMNUMBERLIST);
            DeleteServiceHelper.delete((String)ADJUST_DETAIL, (QFilter[])new QFilter[]{q1, q2, q3, itemnumberFilter});
            DeleteServiceHelper.delete((String)"tccit_draft_edit", (QFilter[])new QFilter[]{q1, q2, q3});
            if (Boolean.FALSE.equals(isHeadOrg)) {
                q1 = new QFilter("org", "=", (Object)orgId).and("taxorg", "=", (Object)0L);
                DeleteServiceHelper.delete((String)ADJUST_DETAIL, (QFilter[])new QFilter[]{q1, q2, q3, itemnumberFilter});
                DeleteServiceHelper.delete((String)"tccit_draft_edit", (QFilter[])new QFilter[]{q1, q2, q3, itemnumberFilter});
            }
            if (Boolean.TRUE.equals(isHeadOrg) || Boolean.TRUE.equals(isIndependentOrg)) {
                q1 = new QFilter("taxorg", "in", (Object)taxorgids1).or("org", "in", (Object)taxorgids1);
                DeleteServiceHelper.delete((String)BRANCH_SHARE_DETAIL, (QFilter[])new QFilter[]{q1, q2, q3});
            }
        }
    }

    public void runEngine(EngineModel model) {
        String orgId = model.getOrgId();
        Long taxorgid = (Long)model.getCustom().get("taxorgid");
        List<DynamicObject> allLRuleList = RuleService.getSharingAndOrgRules(taxorgid, RuleTypeEnum.STANDBOOK, null).get((Object)RuleTypeEnum.STANDBOOK);
        long orgid = Long.parseLong(orgId);
        for (DynamicObject rule : allLRuleList) {
            DynamicObject standingbooks = rule.getDynamicObject("standingbooks");
            if (standingbooks == null) continue;
            Date startdate = DateUtils.stringToDate((String)model.getStartDate());
            Date enddate = DateUtils.stringToDate((String)model.getEndDate());
            List<DynamicObject> detailList = this.getRuleEngineData(rule, orgid, taxorgid, "", startdate, enddate, "income");
            detailList.addAll(this.getRuleEngineData(rule, orgid, taxorgid, "1", startdate, enddate, "salary"));
            detailList.addAll(this.getRuleEngineData(rule, orgid, taxorgid, "2", startdate, enddate, "asset"));
            SaveServiceHelper.save((DynamicObject[])detailList.toArray(new DynamicObject[0]));
        }
    }

    private List<DynamicObject> getRuleEngineData(DynamicObject rule, Long orgid, Long taxorgid, String suffix, Date startdate, Date enddate, String entryType) {
        String serialno = UUID.randomUUID().toString();
        DynamicObjectCollection entryentity = rule.getDynamicObjectCollection("entryentity" + suffix);
        if (StringUtils.isNotBlank((CharSequence)suffix)) {
            DynamicObjectCollection ee = rule.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection collection = new DynamicObjectCollection(ee.getDynamicObjectType(), (Object)rule);
            for (DynamicObject entry : entryentity) {
                DynamicObject dyo = collection.addNew();
                dyo.set("bizname", entry.get("bizname" + suffix));
                dyo.set("table", entry.get("table" + suffix));
                dyo.set("amountfield", entry.get("amountfield" + suffix));
                dyo.set("absolute", entry.get("absolute" + suffix));
                dyo.set("datatype", entry.get("datatype" + suffix));
                dyo.set("datadirection", entry.get("datadirection" + suffix));
                dyo.set("filtercondition", entry.get("filtercondition" + suffix));
                dyo.set("conditionjson", entry.get("conditionjson" + suffix));
                dyo.set("advancedconf", entry.get("advancedconf" + suffix));
                dyo.set("advancedconfjson", entry.get("advancedconfjson" + suffix));
            }
            entryentity = collection;
        }
        RuleEngineDto ruleEngineDto = new RuleEngineDto(taxorgid, orgid, startdate, enddate, BRANCH_SHARE_DETAIL, Collections.EMPTY_MAP, entryentity);
        ruleEngineDto.setTaxaccountserialno(serialno);
        ruleEngineDto.setRuleEnginEntityType(RuleEnginEntityTypeEnum.TCCIT_YJ_PROFITS_ACCDET.getEntityType());
        ruleEngineDto.setTaxCategoryId(DeclareTaxType.QYSDS.getBaseTaxId());
        List detailList = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"RuleEnginService", (String)"getRuleEnginData", (Object[])new Object[]{ruleEngineDto});
        for (DynamicObject detail : detailList) {
            detail.set("entrytype", (Object)entryType);
        }
        return detailList;
    }
}

