/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook.taxdiff;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class TaxAccDiffEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final Map<String, String> fieldsMapping = new HashMap<String, String>();

    public void preOpenForm(PreOpenFormEventArgs e) {
        DynamicObject diff;
        BillShowParameter showParameter = (BillShowParameter)e.getFormShowParameter().getShowParameter();
        Object pkId = showParameter.getPkId();
        if (pkId != null && OperationStatus.ADDNEW != showParameter.getStatus() && (diff = QueryServiceHelper.queryOne((String)"tccit_tax_acce_diff", (String)"source", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)})) != null && Objects.equals("system", diff.getString("source"))) {
            showParameter.setStatus(OperationStatus.VIEW);
        }
        super.preOpenForm(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit assetdata = (BasedataEdit)this.getControl("assetdata");
        assetdata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if ("assetdata".equals(name)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7", (String)"TaxAccDiffEdit_0", (String)"taxc-tccit", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter("taxorg", "=", (Object)org.getLong("id")));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("assetdata".equals(name)) {
            DynamicObject assetdata = (DynamicObject)e.getChangeSet()[0].getNewValue();
            for (Map.Entry<String, String> entry : fieldsMapping.entrySet()) {
                Object value = assetdata != null ? assetdata.get(entry.getValue()) : null;
                this.getModel().setValue(entry.getKey(), value);
            }
        }
    }

    static {
        fieldsMapping.put("assetsnumber", "assetcode");
        fieldsMapping.put("assetsname", "assetname");
        fieldsMapping.put("zctype", "assetclass");
        fieldsMapping.put("postingdate", "startdate");
        fieldsMapping.put("assetuse", "assetuse");
        fieldsMapping.put("rdaddition", "rdaddition");
        fieldsMapping.put("assetsvalue", "assetsvalue");
        fieldsMapping.put("assetstatus", "assetstatus");
        fieldsMapping.put("cleaningdate", "cleaningdate");
        fieldsMapping.put("initval", "initval");
    }
}

