/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook.taxdiff;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class TaxAccDiffImportPlugin
extends BatchImportPlugin {
    private static final String FORMAT = "%s_%s";

    protected boolean isForceBatch() {
        return true;
    }

    public String getDefaultKeyFields() {
        return "org,assetsnumber,accountingperiod";
    }

    public List<String> getDefaultLockUIs() {
        return Collections.singletonList("keyfields");
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        Iterator<ImportBillData> it = billdatas.iterator();
        while (it.hasNext()) {
            ImportBillData billdata = it.next();
            if (billdata.getData().containsKey((Object)"accountingperiod")) {
                billdata.getData().getDate("accountingperiod");
                continue;
            }
            String msg = String.format(ResManager.loadKDString((String)"\u4f1a\u8ba1\u671f\u95f4\u586b\u5199\u6709\u8bef\uff1a%s", (String)"TaxAccDiffImportPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]), billdata.getData().getString("accountingperiod"));
            logger.log(Integer.valueOf(billdata.getStartIndex()), msg);
            it.remove();
            logger.fail();
            logger.signTotalRow(billdata.getEndIndex() - billdata.getStartIndex() + 1);
        }
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        List orgNumberList = rowdatas.stream().map(d -> d.getData().getJSONObject("org").getString("number")).collect(Collectors.toList());
        List assetcodeList = rowdatas.stream().map(d -> d.getData().getJSONObject("assetdata").getString("assetcode")).collect(Collectors.toList());
        QFilter q1 = new QFilter("taxorg.number", "in", orgNumberList);
        QFilter q2 = new QFilter("assetcode", "in", assetcodeList);
        DynamicObjectCollection assetData = QueryServiceHelper.query((String)"tdm_asset_data", (String)"id,taxorg.number,assetcode", (QFilter[])new QFilter[]{q1, q2});
        Map<String, List<DynamicObject>> assetcodeMap = assetData.stream().collect(Collectors.groupingBy(d -> d.getString("taxorg.number") + "_" + d.getString("assetcode")));
        for (ImportBillData rowdata : rowdatas) {
            JSONObject assetdata;
            JSONObject data = rowdata.getData();
            Date accountingperiod = data.getDate("accountingperiod");
            data.put("accountingperiod", (Object)DateUtils.getFirstDateOfMonth((Date)accountingperiod));
            String orgNumber = data.getJSONObject("org").getString("number");
            String assetcode = data.getJSONObject("assetdata").getString("assetcode");
            data.put("assetsnumber", (Object)assetcode);
            data.put("source", (Object)"import");
            List<DynamicObject> objects = assetcodeMap.get(String.format(FORMAT, orgNumber, assetcode));
            if (!EmptyCheckUtils.isNotEmpty(objects) || (assetdata = data.getJSONObject("assetdata")) == null) continue;
            assetdata.put("importprop", (Object)"id");
            assetdata.put("id", (Object)objects.get(0).getLong("id"));
        }
        return super.save(rowdatas, logger);
    }
}

