/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.taxbook.taxdiff;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.ServiceFactory;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.tccit.business.task.SyncDataService;

public class TaxAccSyncDataPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        MulBasedataEdit org = (MulBasedataEdit)this.getView().getControl("orgs");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("orgs");
        Date date = (Date)this.getModel().getValue("date");
        SyncDataService service = new SyncDataService();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u751f\u6210\u9884\u7f34\u7a0e\u4f1a\u6298\u65e7\u644a\u9500\u5dee\u5f02\u53f0\u8d26\u6570\u636e\uff0c\u8bf7\u7a0d\u5019", (String)"TaxAccSyncDataPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
        List<Long> orgids = orgs.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toList());
        service.syncData(orgids, date);
        this.getView().returnDataToParent((Object)"success");
        this.getView().close();
        AppLogInfo appLogInfo = new AppLogInfo();
        appLogInfo.setBizAppID("/Z0U6BXKR4Y+");
        appLogInfo.setBizObjID("tccit_tax_acce_dialog");
        appLogInfo.setOpName(ResManager.loadKDString((String)"\u786e\u5b9a", (String)"TaxAccSyncDataPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
        appLogInfo.setOpDescription(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7id\u4e3a%1$s,\u65e5\u671f\u4e3a%2$s\u5df2\u751f\u6210\u9884\u7f34\u7a0e\u4f1a\u6298\u65e7\u644a\u9500\u5dee\u5f02\u53f0\u8d26\u6570\u636e", (String)"TaxAccSyncDataPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]), orgids, date));
        ILogService ilogservice = (ILogService)ServiceFactory.getService(ILogService.class);
        ilogservice.addLog(appLogInfo);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        HasPermOrgResult permOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView().getParentView());
        if (EmptyCheckUtils.isNotEmpty((Object)permOrgResult) && !permOrgResult.hasAllOrgPerm() && EmptyCheckUtils.isNotEmpty((Object)permOrgResult.getHasPermOrgs())) {
            List orgList = permOrgResult.getHasPermOrgs();
            QFilter idsFilter = new QFilter("id", "in", (Object)orgList);
            ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(idsFilter);
        }
    }
}

