/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class BranchShareBillUpgradePlugin
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        result.setLog(ResManager.loadKDString((String)this.update(), (String)"BranchShareBillUpgradePlugin_0", (String)"BranchShareBillUpgradePlugin_0", (Object[])new Object[0]));
        return result;
    }

    private String update() {
        try {
            String selectSql = "select fid,fsharerate,finitsharerate from t_tccit_branch_share WHERE (fnewsharerate is null and fnewinitsharerate is null) or (fnewsharerate = 0 and fnewinitsharerate = 0);";
            String updateSql = "UPDATE t_tccit_branch_share set fnewsharerate = ?, fnewinitsharerate = ? WHERE fid = ? and ((fnewsharerate is null and fnewinitsharerate is null) or (fnewsharerate = 0 and fnewinitsharerate = 0));";
            List tcretEntrys = DBUtils.query((String)"taxc", (String)selectSql);
            if (!CollectionUtils.isEmpty((Collection)tcretEntrys)) {
                ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
                for (Map row : tcretEntrys) {
                    Object fid = row.get("FID");
                    Object fsharerate = row.get("FSHARERATE");
                    BigDecimal fnewsharerate = fsharerate != null && StringUtil.isNotBlank((CharSequence)String.valueOf(fsharerate)) ? new BigDecimal(String.valueOf(fsharerate)) : BigDecimal.ZERO;
                    Object finitsharerate = row.get("FINITSHARERATE");
                    BigDecimal fnewinitsharerate = finitsharerate != null && StringUtil.isNotBlank((CharSequence)String.valueOf(finitsharerate)) ? new BigDecimal(String.valueOf(finitsharerate)) : BigDecimal.ZERO;
                    paramList.add(new Object[]{fnewsharerate, fnewinitsharerate, fid});
                }
                if (EmptyCheckUtils.isNotEmpty(paramList)) {
                    DBUtils.executeBatch((String)"taxc", (String)updateSql, paramList);
                }
            }
            return ResManager.loadKDString((String)"\u4e09\u56e0\u7d20\u53f0\u8d26\u6bd4\u4f8b\u5b57\u6bb5\u6570\u636e\u540c\u6b65\u6210\u529f", (String)"BranchShareBillUpgradePlugin_1", (String)"taxc-tccit", (Object[])new Object[0]);
        }
        catch (Exception e) {
            return e.getLocalizedMessage();
        }
    }
}

