/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.upgrade;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.CodeEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class YjAssetsUpgradePlugin
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(YjAssetsUpgradePlugin.class);
    private static final String LOGO_INFO = "upgrade data success!";
    private static final String ENTITY = "tccit_assert_acce_total";
    private static final String DEPRECIATION_DETAIL_ENTITY = "tccit_depreciation_detail";
    private static final String A200000_SBB_ENTITY = "tccit_qysds_ext_dyn3";
    private static final String A201020_SBB_ENTITY = "tccit_qysds_gdzczjyhmx";
    private static final String ADJUST_DETAIL = "tccit_adjust_detail";
    private static final String A201020_DYN = "tccit_qysds_a201020_dyn";
    private static final String A201020_DYN1 = "tccit_qysds_a201020_dyn1";
    private static final String A201020_DYN2 = "tccit_qysds_a201020_dyn2";
    private static final String DRAFT_TYPE = "1";
    private static final String A200000_SBB_TYPE = "2";
    private static final String A201020_SBB_TYPE = "3";
    private static final String A202000_SBB_TYPE = "4";
    private static final String[] ENTRYTYPES = new String[]{"depreciate", "origin", "normal", "quick"};
    private static final Map<String, String> DATA_MAPPER = new LinkedHashMap<String, String>();
    private static final Map<String, String> EWBLXH_MAP = new HashMap<String, String>(16);
    private static Map<String, Long> YEAR_ITEMS_MAP = new HashMap<String, Long>(16);
    private static Map<String, Long> DISCOUNT_ITEMS_MAP = new HashMap<String, Long>(16);

    public void afterCreateNewData(EventObject e) {
        YEAR_ITEMS_MAP = YjAssetsUpgradePlugin.getYearItem();
        DISCOUNT_ITEMS_MAP = YjAssetsUpgradePlugin.getDiscountItem();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("ksqltext");
        if ("updatetype".equals(name)) {
            codeSQLshow.setText("");
        }
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String updatetype = (String)this.getModel().getValue("updatetype");
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = LOGO_INFO;
        String info = LOGO_INFO;
        this.printLog("Upgrade data start!");
        try {
            if (StringUtil.isNotBlank((CharSequence)updatetype)) {
                this.upgradeData(updatetype);
            } else {
                success = false;
                info = log = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u5347\u7ea7\u7c7b\u578b", (String)"YjAssetsUpgradePlugin_0", (String)"taxc-tccit", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            success = false;
            info = log = e.getMessage();
        }
        this.printLog("Upgrade data finish!");
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void upgradeData(String updatetype) {
        if (DRAFT_TYPE.equals(updatetype)) {
            this.updateDraft();
        } else if (A200000_SBB_TYPE.equals(updatetype)) {
            this.updateA200000Sbb();
        } else if (A201020_SBB_TYPE.equals(updatetype)) {
            this.updateA201020Sbb();
        } else if (A202000_SBB_TYPE.equals(updatetype)) {
            this.updateA202000Sbb();
        }
    }

    private void updateA200000Sbb() {
        DynamicObject[] sbbDatas = BusinessDataServiceHelper.load((String)A200000_SBB_ENTITY, (String)"item,itemname", (QFilter[])new QFilter[]{new QFilter("sbbid", "is not null", null).and(new QFilter("itemname", "is not null", null))});
        if (sbbDatas != null && sbbDatas.length > 0) {
            for (DynamicObject sbbData : sbbDatas) {
                sbbData.set("item", (Object)DISCOUNT_ITEMS_MAP.getOrDefault(sbbData.getString("itemname").trim(), 0L));
            }
            SaveServiceHelper.save((DynamicObject[])sbbDatas);
        }
    }

    private void updateA201020Sbb() {
        this.printLog("Upgrade sbb start!");
        String selectProperties = "sbbid,ewblxh,ewblname,zcyz,zzzjje,azssybgdjsdzjje,xsjszjyhjsdzjje,nstjje,xsjszjyhje";
        DynamicObject[] sbbDatas = BusinessDataServiceHelper.load((String)A201020_SBB_ENTITY, (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("ewblxh", "in", (Object)Lists.newArrayList((Object[])new Serializable[]{DRAFT_TYPE, A200000_SBB_TYPE, A201020_SBB_TYPE, A202000_SBB_TYPE, "5", "6", "7", Character.valueOf('8'), "9", "10", "11"}))});
        if (sbbDatas != null && sbbDatas.length > 0) {
            List objectList = Arrays.stream(sbbDatas).filter(s -> StringUtils.isNotEmpty((CharSequence)s.getString("sbbid")) && !"0".equals(s.getString("sbbid"))).collect(Collectors.toList());
            Map<String, List<DynamicObject>> listMap = objectList.stream().collect(Collectors.groupingBy(s -> s.getString("sbbid")));
            this.printLog("sbb data size:" + listMap.size());
            listMap.forEach((k, v) -> {
                this.clearDynData((String)k);
                this.addA201020Dyn((String)k, (List<DynamicObject>)v);
                this.addA201020Dyn1((String)k, (List<DynamicObject>)v);
                this.addA201020Dyn2((String)k, (List<DynamicObject>)v);
                this.printLog("update data sbbid===>" + k);
            });
        }
        this.printLog("Upgrade sbb end!");
    }

    private void clearDynData(String sbbid) {
        QFilter[] sbbidFilter = new QFilter[]{new QFilter("sbbid", "=", (Object)sbbid)};
        DeleteServiceHelper.delete((String)A201020_DYN, (QFilter[])sbbidFilter);
        DeleteServiceHelper.delete((String)A201020_DYN1, (QFilter[])sbbidFilter);
        DeleteServiceHelper.delete((String)A201020_DYN2, (QFilter[])sbbidFilter);
    }

    private void updateA202000Sbb() {
    }

    private void addA201020Dyn(String sbbid, List<DynamicObject> datas) {
        ArrayList<DynamicObject> sum = new ArrayList<DynamicObject>(16);
        List details = datas.stream().filter(s -> EWBLXH_MAP.containsKey(s.getString("ewblxh"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(details)) {
            return;
        }
        for (DynamicObject detail : details) {
            DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)A201020_DYN);
            dyn.set("sbbid", (Object)sbbid);
            dyn.set("ewblxh", (Object)EWBLXH_MAP.get(detail.getString("ewblxh")));
            dyn.set("zcyz", detail.get("zcyz"));
            dyn.set("zzzjje", detail.get("zzzjje"));
            dyn.set("azssybgdjsdzjje", detail.get("azssybgdjsdzjje"));
            dyn.set("xsjszjyhjsdzjje", detail.get("xsjszjyhjsdzjje"));
            dyn.set("xsjszjyhje", detail.get("xsjszjyhje"));
            dyn.set("nstjje", detail.get("nstjje"));
            sum.add(dyn);
        }
        if (!CollectionUtils.isEmpty(sum)) {
            SaveServiceHelper.save((DynamicObject[])sum.toArray(new DynamicObject[0]));
        }
    }

    private void addA201020Dyn1(String sbbid, List<DynamicObject> datas) {
        ArrayList<DynamicObject> sum = new ArrayList<DynamicObject>(16);
        List details = datas.stream().filter(s -> Lists.newArrayList((Object[])new String[]{A200000_SBB_TYPE, A201020_SBB_TYPE, "6", "7"}).contains(s.getString("ewblxh"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(details)) {
            return;
        }
        int index = 1;
        for (DynamicObject detail : details) {
            DynamicObject dyn1 = BusinessDataServiceHelper.newDynamicObject((String)A201020_DYN1);
            dyn1.set("sbbid", (Object)sbbid);
            dyn1.set("ewblxh", (Object)String.valueOf(index));
            dyn1.set("rownumber", (Object)("1." + index));
            dyn1.set("item", (Object)YEAR_ITEMS_MAP.getOrDefault(detail.getString("ewblname").trim(), 0L));
            dyn1.set("zcyz", detail.get("zcyz"));
            dyn1.set("zzzjje", detail.get("zzzjje"));
            dyn1.set("azssybgdjsdzjje", detail.get("azssybgdjsdzjje"));
            dyn1.set("xsjszjyhjsdzjje", detail.get("xsjszjyhjsdzjje"));
            dyn1.set("xsjszjyhje", detail.get("xsjszjyhje"));
            dyn1.set("nstjje", detail.get("nstjje"));
            sum.add(dyn1);
            ++index;
        }
        if (!CollectionUtils.isEmpty(sum)) {
            SaveServiceHelper.save((DynamicObject[])sum.toArray(new DynamicObject[0]));
        }
    }

    private void addA201020Dyn2(String sbbid, List<DynamicObject> datas) {
        ArrayList<DynamicObject> sum = new ArrayList<DynamicObject>(16);
        List details = datas.stream().filter(s -> Lists.newArrayList((Object[])new String[]{"8", "9", "10", "11"}).contains(s.getString("ewblxh"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(details)) {
            return;
        }
        int index = 1;
        for (DynamicObject detail : details) {
            DynamicObject dyn2 = BusinessDataServiceHelper.newDynamicObject((String)A201020_DYN2);
            dyn2.set("sbbid", (Object)sbbid);
            dyn2.set("ewblxh", (Object)String.valueOf(index));
            dyn2.set("rownumber", (Object)("2." + index));
            dyn2.set("item", (Object)YEAR_ITEMS_MAP.getOrDefault(detail.getString("ewblname").trim(), 0L));
            dyn2.set("zcyz", detail.get("zcyz"));
            dyn2.set("zzzjje", detail.get("zzzjje"));
            dyn2.set("azssybgdjsdzjje", detail.get("azssybgdjsdzjje"));
            dyn2.set("xsjszjyhjsdzjje", detail.get("xsjszjyhjsdzjje"));
            dyn2.set("xsjszjyhje", detail.get("xsjszjyhje"));
            dyn2.set("nstjje", detail.get("nstjje"));
            sum.add(dyn2);
            ++index;
        }
        if (!CollectionUtils.isEmpty(sum)) {
            SaveServiceHelper.save((DynamicObject[])sum.toArray(new DynamicObject[0]));
        }
    }

    private void updateDraft() {
        this.printLog("Upgrade draft start!");
        this.printLog("=======================================the first part=======================================");
        DynamicObject[] detailDatas = BusinessDataServiceHelper.load((String)DEPRECIATION_DETAIL_ENTITY, (String)"ruleid,itemnumber", (QFilter[])new QFilter[]{new QFilter("entrytype", "in", (Object)ENTRYTYPES).and(new QFilter("itemnumber", "not like", (Object)"JSZJ%"))});
        if (detailDatas != null && detailDatas.length > 0) {
            Arrays.stream(detailDatas).forEach(s -> {
                String newNumber = Optional.ofNullable(s.getDynamicObject("ruleid")).map(r -> Optional.ofNullable(r.getDynamicObject("depreciatetype")).map(d -> d.getString("number")).orElseGet(() -> this.getMappingNumber(s.getString("itemnumber")))).orElseGet(() -> this.getMappingNumber(s.getString("itemnumber")));
                this.printLog("itemnumber\uff1a" + s.getString("itemnumber") + "===> newNumber\uff1a" + newNumber);
                s.set("itemnumber", (Object)newNumber);
            });
            SaveServiceHelper.save((DynamicObject[])detailDatas);
        }
        this.printLog("=======================================the second part=======================================");
        DynamicObject[] draftDatas = BusinessDataServiceHelper.load((String)ENTITY, (String)"rule,ewblxh,ewblname", (QFilter[])new QFilter[]{new QFilter("ewblxh", "not like", (Object)"JSZJ%")});
        if (draftDatas != null && draftDatas.length > 0) {
            Arrays.stream(draftDatas).forEach(s -> {
                String newEwblxh = Optional.ofNullable(s.getDynamicObject("rule")).map(r -> Optional.ofNullable(r.getDynamicObject("depreciatetype")).map(d -> d.getString("number")).orElseGet(() -> this.getMappingNumber(s.getString("ewblxh")))).orElseGet(() -> this.getMappingNumber(s.getString("ewblxh")));
                this.printLog("ewblxh\uff1a" + s.getString("ewblxh") + "===> newEwblxh\uff1a" + newEwblxh);
                s.set("ewblxh", (Object)newEwblxh);
            });
            SaveServiceHelper.save((DynamicObject[])draftDatas);
        }
        this.printLog("=======================================the third part=======================================");
        DynamicObject[] adjustDetails = BusinessDataServiceHelper.load((String)ADJUST_DETAIL, (String)"ruleid,itemnumber", (QFilter[])new QFilter[]{new QFilter("entrytype", "in", (Object)ENTRYTYPES).and(new QFilter("itemnumber", "not like", (Object)"JSZJ%"))});
        if (adjustDetails != null && adjustDetails.length > 0) {
            Arrays.stream(adjustDetails).forEach(s -> {
                String itemnumber = s.getString("itemnumber");
                if (itemnumber.endsWith("_")) {
                    String mappingNumber = Optional.ofNullable(BusinessDataServiceHelper.loadSingle((Object)s.get("ruleid"), (String)"tccit_depreciate_rule")).map(r -> Optional.ofNullable(r.getDynamicObject("depreciatetype")).map(d -> d.getString("number") + "_").orElseGet(() -> this.getMappingNumber(itemnumber))).orElseGet(() -> this.getMappingNumber(itemnumber));
                    this.printLog("itemnumber\uff1a" + s.getString("itemnumber") + "===> newNumber\uff1a" + mappingNumber);
                    s.set("itemnumber", (Object)mappingNumber);
                } else {
                    String newNumber = Optional.ofNullable(BusinessDataServiceHelper.loadSingle((Object)s.get("ruleid"), (String)"tccit_depreciate_rule")).map(r -> Optional.ofNullable(r.getDynamicObject("depreciatetype")).map(d -> d.getString("number")).orElseGet(() -> this.getMappingNumber(itemnumber))).orElseGet(() -> this.getMappingNumber(itemnumber));
                    this.printLog("itemnumber\uff1a" + s.getString("itemnumber") + "===> newNumber\uff1a" + newNumber);
                    s.set("itemnumber", (Object)newNumber);
                }
            });
            SaveServiceHelper.save((DynamicObject[])adjustDetails);
        }
        this.printLog("Upgrade draft end!");
    }

    private String getMappingNumber(String itemNumber) {
        if (!DATA_MAPPER.containsKey(itemNumber)) {
            if (itemNumber.endsWith("_")) {
                return this.getMappingNumber(itemNumber.replace("_", "")) + "_";
            }
            this.printLog("number not exists!" + itemNumber);
            return itemNumber;
        }
        return DATA_MAPPER.get(itemNumber);
    }

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    private String getNow() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss");
        LocalDateTime localDateTime = LocalDateTime.now();
        return localDateTime.format(formatter);
    }

    private void printLog(String message) {
        this.addLog(INFO, this.getNow() + ":\t" + message);
    }

    private static Map<String, Long> getYearItem() {
        QFilter q1 = new QFilter("template", "=", (Object)"qysdsyj");
        QFilter q2 = new QFilter("type", "=", (Object)"acce");
        DynamicObject[] yearitemsTrees = BusinessDataServiceHelper.load((String)"tpo_yearitems_tree", (String)"id,name,number", (QFilter[])new QFilter[]{q1, q2});
        if (yearitemsTrees != null && yearitemsTrees.length > 0) {
            return Arrays.stream(yearitemsTrees).collect(Collectors.toMap(k -> k.getString("name"), v -> v.getLong("id"), (k1, k2) -> k1));
        }
        return new HashMap<String, Long>(16);
    }

    private static Map<String, Long> getDiscountItem() {
        QFilter q1 = new QFilter("template", "=", (Object)"qysdsyj");
        QFilter q2 = new QFilter("type", "=", (Object)"yhxm");
        DynamicObject[] discountTrees = BusinessDataServiceHelper.load((String)"tpo_discount_tree", (String)"id,name,number", (QFilter[])new QFilter[]{q1, q2});
        if (discountTrees != null & discountTrees.length > 0) {
            return Arrays.stream(discountTrees).collect(Collectors.toMap(s -> s.getString("name"), s -> s.getLong("id"), (k1, k2) -> k1));
        }
        return new HashMap<String, Long>(16);
    }

    static {
        DATA_MAPPER.put("101", "JSZJ0010");
        DATA_MAPPER.put("102", "JSZJ0020");
        DATA_MAPPER.put("103", "JSZJ0030");
        DATA_MAPPER.put("104", "JSZJ0040");
        DATA_MAPPER.put("201", "JSZJ1010");
        DATA_MAPPER.put("202", "JSZJ1020");
        DATA_MAPPER.put("203", "JSZJ1030");
        DATA_MAPPER.put("204", "JSZJ1040");
        EWBLXH_MAP.put(DRAFT_TYPE, DRAFT_TYPE);
        EWBLXH_MAP.put(A202000_SBB_TYPE, A200000_SBB_TYPE);
        EWBLXH_MAP.put("5", A201020_SBB_TYPE);
    }
}

