/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.upgrade;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.CodeEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class YjProfitsUpgradePlugin
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(YjProfitsUpgradePlugin.class);
    private static final String LOGO_INFO = "upgrade data success!";
    private static final String ENTITY_SUMMARY = "tccit_profit_summary";
    private static final String RULE_ENTITY = "tccit_profits_rule";
    private static final String PROFITS_DETAIL_ENTITY = "tccit_yj_profits_accdet";
    private static final String ASSETS_DETAIL_ENTITY = "tccit_yj_assets_accdet";
    private static final List<String> PROFITS_NUMBER = Arrays.asList("011", "012", "013");
    private static final List<String> ZCFZ_NUMBER = Arrays.asList("021", "022");
    private static final Map<String, String> MAP = new LinkedHashMap<String, String>();
    private static final String profitsType = "1";
    private static final String zcfzType = "2";

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("ksqltext");
        if (name.equals("updatetype")) {
            codeSQLshow.setText("");
        }
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String updatetype = (String)this.getModel().getValue("updatetype");
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = LOGO_INFO;
        String info = LOGO_INFO;
        this.addLog(INFO, "Upgrade data start:" + this.getNow());
        try {
            if (StringUtil.isNotBlank((CharSequence)updatetype)) {
                this.upgradeData(updatetype);
            } else {
                success = false;
                info = log = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u5347\u7ea7\u7c7b\u578b", (String)"YjProfitsUpgradePlugin_0", (String)"taxc-tccit", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            success = false;
            info = log = e.getMessage();
        }
        this.addLog(INFO, "Upgrade data finish:" + this.getNow());
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void upgradeData(String updatetype) {
        DynamicObject[] dynamicObjects = new DynamicObject[]{};
        if (profitsType.equals(updatetype)) {
            dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_SUMMARY, (String)"id,org,skssqq,skssqz,type,bqfse,bqlje,sqfse,sqlje", (QFilter[])new QFilter[0], (String)"type");
        } else if (zcfzType.equals(updatetype)) {
            dynamicObjects = BusinessDataServiceHelper.load((String)"tccit_seasonal_policy", (String)"id,orgid,startdate,enddate,sosassets,eosassets", (QFilter[])new QFilter[0]);
        }
        List<Object> orgIds = new ArrayList();
        if (dynamicObjects.length > 0) {
            orgIds = Arrays.stream(dynamicObjects).map(s -> {
                if (profitsType.equals(updatetype)) {
                    return s.getDynamicObject("org").getLong("id");
                }
                if (zcfzType.equals(updatetype)) {
                    return s.getDynamicObject("orgid").getLong("id");
                }
                return 0L;
            }).distinct().collect(Collectors.toList());
        }
        this.addLog(INFO, "org size:" + orgIds.size());
        for (Long l : orgIds) {
            if (this.checkRule(l, updatetype)) continue;
            this.addRule(l, updatetype);
        }
        this.addRuleDetail(dynamicObjects, updatetype);
        if (profitsType.equals(updatetype)) {
            this.addLog(INFO, "update data over!:" + orgIds.size() * 3);
        } else {
            this.addSummary(dynamicObjects);
            this.addLog(INFO, "update data over!:" + orgIds.size() * 2);
        }
    }

    private void addSummary(DynamicObject[] dynamicObjects) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
        ArrayList types = Lists.newArrayList((Object[])new String[]{"021", "022"});
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (this.isExistSummary(dynamicObject)) {
                this.addLog(INFO, String.format("summary detail exists,skip it!!!:\u3010org:%s\uff0cstartdate:%s\uff0cenddate:%s\u3011", dynamicObject.getDynamicObject("orgid").getString("name"), DateUtils.format((Date)dynamicObject.getDate("startdate")), DateUtils.format((Date)dynamicObject.getDate("enddate"))));
                continue;
            }
            for (String type : types) {
                DynamicObject summary = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tccit_yj_assets_summary"));
                summary.set("org", (Object)dynamicObject.getDynamicObject("orgid").getLong("id"));
                summary.set("type", (Object)type);
                summary.set("skssqq", (Object)dynamicObject.getDate("startdate"));
                summary.set("skssqz", (Object)dynamicObject.getDate("enddate"));
                BigDecimal amount = type.equals("021") ? dynamicObject.getBigDecimal("sosassets") : dynamicObject.getBigDecimal("eosassets");
                summary.set("bqamount", (Object)amount);
                summary.set("bjamount", (Object)amount);
                list.add(summary);
            }
        }
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
    }

    private boolean isExistSummary(DynamicObject dynamicObject) {
        QFilter q1 = new QFilter("org", "=", (Object)dynamicObject.getDynamicObject("orgid").getLong("id"));
        QFilter q2 = new QFilter("skssqq", "=", (Object)dynamicObject.getDate("startdate"));
        QFilter q3 = new QFilter("skssqz", "=", (Object)dynamicObject.getDate("enddate"));
        return QueryServiceHelper.exists((String)"tccit_yj_assets_summary", (QFilter[])new QFilter[]{q1, q2, q3});
    }

    private void addRuleDetail(DynamicObject[] dynamicObjects, String updatetype) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            String orgPro = profitsType.equals(updatetype) ? "org" : "orgid";
            long orgId = dynamicObject.getDynamicObject(orgPro).getLong("id");
            ArrayList types = profitsType.equals(updatetype) ? Lists.newArrayList((Object[])new String[]{dynamicObject.getString("type")}) : Lists.newArrayList((Object[])new String[]{"021", "022"});
            for (String type : types) {
                String entityName;
                DynamicObject rule = this.getRule(orgId, type, updatetype);
                if (rule == null) continue;
                String number = rule.getDynamicObject("item").getString("number");
                Date skssqq = profitsType.equals(updatetype) ? dynamicObject.getDate("skssqq") : dynamicObject.getDate("startdate");
                Date skssqz = profitsType.equals(updatetype) ? dynamicObject.getDate("skssqz") : dynamicObject.getDate("enddate");
                String string = entityName = profitsType.equals(updatetype) ? PROFITS_DETAIL_ENTITY : ASSETS_DETAIL_ENTITY;
                if (this.existsDetail(entityName, orgId, number, skssqq, skssqz)) {
                    this.addLog(INFO, String.format("rule detail exists,skip it!!!:\u3010org:%s\uff0cstartdate:%s\uff0cenddate:%s\uff0cname:%s\u3011", dynamicObject.getDynamicObject(orgPro).getString("name"), DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz), rule.getString("name")));
                    continue;
                }
                DynamicObject detailEntity = profitsType.equals(updatetype) ? BusinessDataServiceHelper.newDynamicObject((String)PROFITS_DETAIL_ENTITY) : BusinessDataServiceHelper.newDynamicObject((String)ASSETS_DETAIL_ENTITY);
                detailEntity.set("taxaccountserialno", (Object)UUID.randomUUID().toString());
                detailEntity.set("org", (Object)orgId);
                detailEntity.set("taxorg", (Object)orgId);
                detailEntity.set("bizname", (Object)rule.getString("name"));
                DynamicObject setting = (DynamicObject)rule.getDynamicObjectCollection("entryentity").get(0);
                detailEntity.set("table", (Object)setting.getDynamicObject("table").getLong("id"));
                detailEntity.set("amountfield", (Object)setting.getDynamicObject("amountfield").getLong("id"));
                detailEntity.set("datatype", setting.get("datatype"));
                detailEntity.set("datadirection", setting.get("datadirection"));
                if (profitsType.equals(updatetype)) {
                    detailEntity.set("skssqq", dynamicObject.get("skssqq"));
                    detailEntity.set("skssqz", dynamicObject.get("skssqz"));
                    detailEntity.set("amount", (Object)dynamicObject.getBigDecimal("bqfse"));
                    detailEntity.set("fetchamount", (Object)dynamicObject.getBigDecimal("bqfse"));
                    detailEntity.set("entrytype", (Object)"profits");
                } else {
                    detailEntity.set("skssqq", dynamicObject.get("startdate"));
                    detailEntity.set("skssqz", dynamicObject.get("enddate"));
                    String ruleNumber = rule.getDynamicObject("item").getString("number");
                    BigDecimal amount = ruleNumber.equals("021") ? dynamicObject.getBigDecimal("sosassets") : dynamicObject.getBigDecimal("eosassets");
                    detailEntity.set("amount", (Object)amount.multiply(new BigDecimal("10000")));
                    detailEntity.set("fetchamount", (Object)amount.multiply(new BigDecimal("10000")));
                    detailEntity.set("entrytype", (Object)"yjassets");
                }
                detailEntity.set("filtercondition", setting.get("filtercondition"));
                detailEntity.set("ruleid", (Object)rule.getLong("id"));
                detailEntity.set("itemnumber", (Object)rule.getDynamicObject("item").getString("number"));
                detailEntity.set("absolute", setting.get("absolute"));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{detailEntity});
                this.addLog(INFO, String.format("create rule detail:\u3010org:%s\uff0cstartdate:%s\uff0cenddate:%s\uff0cname:%s\u3011", dynamicObject.getDynamicObject(orgPro).getString("name"), DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz), rule.getString("name")));
            }
        }
    }

    private boolean existsDetail(String entityName, long orgId, String type, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)skssqq);
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)skssqz);
        QFilter itemnumberFilter = new QFilter("itemnumber", "=", (Object)type);
        DynamicObjectCollection ids = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter, itemnumberFilter});
        return ids != null && ids.size() > 0;
    }

    private DynamicObject getRule(long orgId, String type, String updatetype) {
        String itemType = profitsType.equals(updatetype) ? MAP.get(type) : type;
        return BusinessDataServiceHelper.loadSingleFromCache((String)RULE_ENTITY, (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("item.number", "=", (Object)itemType)});
    }

    private boolean checkRule(Long orgId, String updatetype) {
        List names;
        QFilter nameFilter;
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        List<String> itemNumbers = profitsType.equals(updatetype) ? PROFITS_NUMBER : ZCFZ_NUMBER;
        QFilter itemFilter = new QFilter("item.number", "in", itemNumbers);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)RULE_ENTITY, (String)"id", (QFilter[])new QFilter[]{orgFilter, itemFilter, nameFilter = new QFilter("name", "in", names = itemNumbers.stream().map(s -> YjProfitsUpgradeEnum.getYjProfitsUpgradeEnum(s).name.loadKDString()).collect(Collectors.toList()))});
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            DynamicObject[] loads;
            for (DynamicObject rule : loads = BusinessDataServiceHelper.load((Object[])dynamicObjects.stream().map(s -> s.get("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)RULE_ENTITY))) {
                String number = rule.getDynamicObject("item").getString("number");
                DynamicObjectCollection entryentity = rule.getDynamicObjectCollection("entryentity");
                for (DynamicObject setting : entryentity) {
                    YjProfitsUpgradeEnum upgradeEnum = YjProfitsUpgradeEnum.getYjProfitsUpgradeEnum(number);
                    if (upgradeEnum == null) continue;
                    setting.set("filtercondition", (Object)upgradeEnum.filter.loadKDString());
                    setting.set("conditionjson", (Object)upgradeEnum.json);
                }
            }
            SaveServiceHelper.save((DynamicObject[])loads);
            return true;
        }
        return false;
    }

    private void addRule(Long orgId, String updatetype) {
        ArrayList<DynamicObject> saveDatas = new ArrayList<DynamicObject>(3);
        List<String> numbers = profitsType.equals(updatetype) ? PROFITS_NUMBER : ZCFZ_NUMBER;
        for (String type : numbers) {
            YjProfitsUpgradeEnum upgradeEnum = YjProfitsUpgradeEnum.getYjProfitsUpgradeEnum(type);
            if (upgradeEnum == null) continue;
            DynamicObject rule = BusinessDataServiceHelper.newDynamicObject((String)RULE_ENTITY);
            String readNumber = CodeRuleServiceHelper.getNumber((String)RULE_ENTITY, (DynamicObject)rule, (String)String.valueOf(orgId));
            rule.set("number", (Object)readNumber);
            rule.set("org", (Object)orgId);
            rule.set("enable", (Object)Character.valueOf('1'));
            rule.set("ruletype", (Object)"private");
            rule.set("name", (Object)upgradeEnum.name.loadKDString());
            rule.set("item", (Object)upgradeEnum.item);
            DynamicObjectCollection entryentity = rule.getDynamicObjectCollection("entryentity");
            DynamicObject setting = entryentity.addNew();
            setting.set("bizname", (Object)upgradeEnum.name.loadKDString());
            if (profitsType.equals(updatetype)) {
                setting.set("table", (Object)upgradeEnum.table);
                setting.set("amountfield", (Object)upgradeEnum.amountfield);
            } else {
                setting.set("table", (Object)upgradeEnum.table);
                setting.set("amountfield", (Object)upgradeEnum.amountfield);
                if ("021".equals(upgradeEnum.number)) {
                    setting.set("advancedconf", (Object)ResManager.loadKDString((String)"\u4e0a\u671f\u671f\u672b\u6570", (String)"YjProfitsUpgradePlugin_1", (String)"taxc-tccit", (Object[])new Object[0]));
                    setting.set("advancedconfjson", (Object)"sqqms");
                } else if ("022".equals(upgradeEnum.number)) {
                    setting.set("advancedconf", (Object)ResManager.loadKDString((String)"\u622a\u81f3\u671f\u672b\u6570", (String)"YjProfitsUpgradePlugin_2", (String)"taxc-tccit", (Object[])new Object[0]));
                    setting.set("advancedconfjson", (Object)"jzqms");
                }
            }
            setting.set("absolute", (Object)Boolean.FALSE);
            setting.set("datatype", (Object)"zjqs");
            setting.set("datadirection", (Object)"positive");
            setting.set("filtercondition", (Object)upgradeEnum.filter.loadKDString());
            setting.set("conditionjson", (Object)upgradeEnum.json);
            saveDatas.add(rule);
            this.addLog(INFO, "create rule number:" + rule.getString("number"));
        }
        SaveServiceHelper.save((DynamicObject[])saveDatas.toArray(new DynamicObject[0]));
    }

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    private String getNow() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss");
        LocalDateTime localDateTime = LocalDateTime.now();
        return localDateTime.format(formatter);
    }

    static {
        MAP.put("income", "011");
        MAP.put("jcost", "012");
        MAP.put("profit", "013");
    }

    private static enum YjProfitsUpgradeEnum {
        p_011("011", new MultiLangEnumBridge("\u8425\u4e1a\u6536\u5165", "YjProfitsUpgradePlugin_3", "taxc-tccit"), 1265068381174759424L, 886814324742447104L, 1265769269262621702L, new MultiLangEnumBridge("\u62a5\u8868\u9879\u76ee\u540d\u79f0 \u7b49\u4e8e \u8425\u4e1a\u6536\u5165", "YjProfitsUpgradePlugin_8", "taxc-tccit"), "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"BaseDataIds\":[{\"_Type_\":\"FilterValue\",\"Value\":\"1\",\"Id\":\"2/IQPFL=Z4T7\"}],\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\u8425\u4e1a\u6536\u5165\",\"Id\":\"2/IQPFL7AOKY\"}],\"CompareType\":\"67\",\"Id\":\"2/IQPFKGAE1L\",\"Logic\":\"0\",\"FieldName\":\"reportitem.name\"}]}"),
        p_012("012", new MultiLangEnumBridge("\u8425\u4e1a\u6210\u672c", "YjProfitsUpgradePlugin_4", "taxc-tccit"), 1265068381174759425L, 886814324742447104L, 1265769269262621702L, new MultiLangEnumBridge("\u62a5\u8868\u9879\u76ee\u540d\u79f0 \u7b49\u4e8e \u51cf\uff1a\u8425\u4e1a\u6210\u672c", "YjProfitsUpgradePlugin_9", "taxc-tccit"), "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"BaseDataIds\":[{\"_Type_\":\"FilterValue\",\"Value\":\"2\",\"Id\":\"2/IR+ESGP//N\"}],\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\u51cf\uff1a\u8425\u4e1a\u6210\u672c\",\"Id\":\"2/IR+ESGP10D\"}],\"CompareType\":\"67\",\"Id\":\"2/IR+ESGP//M\",\"Logic\":\"0\",\"FieldName\":\"reportitem.name\"}]}"),
        p_013("013", new MultiLangEnumBridge("\u5229\u6da6\u603b\u989d", "YjProfitsUpgradePlugin_5", "taxc-tccit"), 1265068381174759426L, 886814324742447104L, 1265769269262621702L, new MultiLangEnumBridge("\u62a5\u8868\u9879\u76ee\u540d\u79f0 \u7b49\u4e8e \u5229\u6da6\u603b\u989d\uff08\u4e8f\u635f\u603b\u989d\u4ee5\u201c-\u201d\u53f7\u586b\u5217\uff09", "YjProfitsUpgradePlugin_10", "taxc-tccit"), "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"BaseDataIds\":[{\"_Type_\":\"FilterValue\",\"Value\":\"23\",\"Id\":\"2/IR2D/LCJUV\"}],\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\u5229\u6da6\u603b\u989d\uff08\u4e8f\u635f\u603b\u989d\u4ee5\u201c-\u201d\u53f7\u586b\u5217\uff09\",\"Id\":\"2/IR2D/LCHU1\"}],\"CompareType\":\"67\",\"Id\":\"2/IR2D/LCJUU\",\"Logic\":\"0\",\"FieldName\":\"reportitem.name\"}]}"),
        z_021("021", new MultiLangEnumBridge("\u671f\u521d\u8d44\u4ea7", "YjProfitsUpgradePlugin_6", "taxc-tccit"), 1331828708369286144L, 886815693662609408L, 886815693662631947L, new MultiLangEnumBridge("\u62a5\u8868\u9879\u76ee\u540d\u79f0 \u7b49\u4e8e \u8d44\u4ea7\u603b\u8ba1", "YjProfitsUpgradePlugin_11", "taxc-tccit"), "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"BaseDataIds\":[{\"_Type_\":\"FilterValue\",\"Value\":\"41\",\"Id\":\"260KFP=QG6DT\"}],\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\u8d44\u4ea7\u603b\u8ba1\",\"Id\":\"260KFP=QEFDW\"}],\"CompareType\":\"67\",\"Id\":\"260KFP=QG6DS\",\"Logic\":\"0\",\"FieldName\":\"reportitem.name\"}]}"),
        z_022("022", new MultiLangEnumBridge("\u671f\u672b\u8d44\u4ea7", "YjProfitsUpgradePlugin_7", "taxc-tccit"), 1331828708369286145L, 886815693662609408L, 886815693662631947L, new MultiLangEnumBridge("\u62a5\u8868\u9879\u76ee\u540d\u79f0 \u7b49\u4e8e \u8d44\u4ea7\u603b\u8ba1", "YjProfitsUpgradePlugin_12", "taxc-tccit"), "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"BaseDataIds\":[{\"_Type_\":\"FilterValue\",\"Value\":\"41\",\"Id\":\"260KFP=QG6DT\"}],\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":\"\u8d44\u4ea7\u603b\u8ba1\",\"Id\":\"260KFP=QEFDW\"}],\"CompareType\":\"67\",\"Id\":\"260KFP=QG6DS\",\"Logic\":\"0\",\"FieldName\":\"reportitem.name\"}]}");

        private String number;
        private MultiLangEnumBridge name;
        private Long item;
        private Long table;
        private Long amountfield;
        private MultiLangEnumBridge filter;
        private String json;

        private YjProfitsUpgradeEnum(String number, MultiLangEnumBridge name, Long item, Long table, Long amountfield, MultiLangEnumBridge filter, String json) {
            this.number = number;
            this.name = name;
            this.item = item;
            this.table = table;
            this.amountfield = amountfield;
            this.filter = filter;
            this.json = json;
        }

        public static YjProfitsUpgradeEnum getYjProfitsUpgradeEnum(String number) {
            for (YjProfitsUpgradeEnum value : YjProfitsUpgradeEnum.values()) {
                if (!value.number.equals(number)) continue;
                return value;
            }
            return null;
        }
    }
}

