/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.year.dg.lrqr;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.rule.RuleService;
import kd.taxc.tccit.common.enums.RuleTypeEnum;
import kd.taxc.tccit.formplugin.account.ProfitCostTZFormPlugin;
import kd.taxc.tccit.formplugin.account.ProfitFeesTZFormPlugin;
import kd.taxc.tccit.formplugin.account.ProfitIncomeCostCommFormPlugin;
import kd.taxc.tccit.formplugin.account.ProfitIncomeTZFormPlugin;
import kd.taxc.tccit.formplugin.year.dg.lrqr.A101020_DGFormPlugin;
import kd.taxc.tccit.formplugin.year.dg.lrqr.A102020_DGFormPlugin;
import kd.taxc.tccit.formplugin.year.dg.lrqr.A103000_DGFormPlugin;

public class A100000_1_DGFormPlugin
extends ProfitIncomeCostCommFormPlugin
implements Observer {
    public static final String SUMMARY_ENTRY_NAME = "tccit_dg_a100000_1_sum";
    public static final String RULE_DETAIL_ENTRY_NAME = "tccit_dg_a100000_1_det";
    private final List<String> itemTypes = Lists.newArrayList((Object[])new String[]{"001", "001_01", "106", "001_03", "001_04", "001_05", "107", "108", "109", "002", "002_01", "002_02", "003"});
    private final Map<String, String> CALC_RELATION = new HashMap<String, String>(){
        {
            this.put("002", "{Q[001]}-{Q[001_01]}-{Q[106]}-{Q[001_03]}-{Q[001_04]}-{Q[001_05]}-{Q[107]}+{Q[108]}+{Q[109]}");
            this.put("003", "{Q[002]}+{Q[002_01]}-{Q[002_02]}");
        }
    };

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams, this.itemTypes, SUMMARY_ENTRY_NAME, RULE_DETAIL_ENTRY_NAME);
        }
        this.initData(SUMMARY_ENTRY_NAME, this.itemTypes);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent evt) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("entryname", RULE_DETAIL_ENTRY_NAME);
        customParams.put("entrytype", this.getEntrytype(customParams));
        String key = ((Control)evt.getSource()).getKey();
        EntryGrid itemsEntity = (EntryGrid)this.getControl(key);
        String itemtype = String.valueOf(itemsEntity.getModel().getValue("itemtype"));
        String originalamount = cacheLevel1Map.getOrDefault("originalamount_" + itemtype, "0");
        BigDecimal amount = new BigDecimal(StringUtil.isEmpty((CharSequence)originalamount) ? "0" : originalamount).setScale(2, 4);
        customParams.put("originalamount_" + itemtype, amount);
        customParams.put("isExists110Rules", this.isExistsRules(customParams));
        super.hyperLinkClick(evt);
    }

    @Override
    public String getCalExpression(String rowType, Map<String, Object> customParams) {
        if ("002".equals(rowType)) {
            return !this.isExistsRules(customParams) ? this.CALC_RELATION.get(rowType) : null;
        }
        return this.CALC_RELATION.get(rowType);
    }

    public boolean isExistsRules(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        List<DynamicObject> allLRuleList = RuleService.getSharingAndOrgRules(orgid, RuleTypeEnum.REMINCOME, null).get((Object)RuleTypeEnum.REMINCOME);
        return !CollectionUtils.isEmpty(allLRuleList) && allLRuleList.stream().anyMatch(s -> "110".equals(s.getDynamicObject("item").getString("number")));
    }

    @Override
    protected DynamicObjectCollection getSDTZOriginalAmount(Map<String, Object> customParams, String itemnumber, String entrytype) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        Object orgid = customParams.get("orgid");
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        qFilters.add(new QFilter("org", "=", (Object)Long.parseLong((String)orgid)));
        qFilters.add(new QFilter("skssqq", "=", (Object)skssqq));
        qFilters.add(new QFilter("skssqz", "=", (Object)skssqz));
        if ("002".equals(itemnumber)) {
            qFilters.add(new QFilter("itemnumber", "in", (Object)Lists.newArrayList((Object[])new String[]{"110", "002", "110_", "002_"})));
        } else {
            qFilters.add(new QFilter("itemnumber", "=", (Object)itemnumber).or(new QFilter("itemnumber", "=", (Object)(itemnumber + "_"))));
        }
        qFilters.add(new QFilter("entrytype", "=", (Object)entrytype));
        return QueryServiceHelper.query((String)"tccit_adjust_detail", (String)"id,amount,totalamount,adjustamount", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
    }

    @Override
    public Set<String> getTitles() {
        return Sets.newHashSet((Object[])new String[]{"001", "001_01", "001_03", "001_04", "001_05", "002_01", "002_02", "003"});
    }

    @Override
    public boolean checkCalData(Map<String, Object> customParams) {
        return true;
    }

    @Override
    protected BigDecimal getAmount(Map<String, Object> customParams, String columnType, String rowType, String ruleDetailEntryName) {
        if ("001".equals(rowType)) {
            BigDecimal a1 = this.queryDgAmount(customParams, "tccit_profit_income_sum", "amount", Collections.singletonList(1));
            BigDecimal a2 = this.queryDgAmount(customParams, "tccit_dg_a101020_sum", "amount", Collections.singletonList(1));
            BigDecimal a3 = this.queryDgAmount(customParams, "tccit_dg_a103000_sum", "amount", Arrays.asList(2, 3, 4, 5, 6, 11, 12, 13, 14, 15));
            BigDecimal originalamount = BigDecimalUtil.addObjects((Object[])new Object[]{a1, a2, a3});
            BigDecimal adjustamount = this.getAdjustAmount(customParams, rowType, originalamount);
            return BigDecimalUtil.addObjects((Object[])new Object[]{originalamount, adjustamount});
        }
        if ("001_01".equals(rowType)) {
            BigDecimal a1 = this.queryDgAmount(customParams, "tccit_profit_cost_summary", "amount", Collections.singletonList(1));
            BigDecimal a2 = this.queryDgAmount(customParams, "tccit_dg_a102020_sum", "amount", Collections.singletonList(1));
            BigDecimal a3 = this.queryDgAmount(customParams, "tccit_dg_a103000_sum", "amount", Arrays.asList(19, 20, 21, 22, 25, 26, 27));
            BigDecimal originalamount = BigDecimalUtil.addObjects((Object[])new Object[]{a1, a2, a3});
            BigDecimal adjustamount = this.getAdjustAmount(customParams, rowType, originalamount);
            return BigDecimalUtil.addObjects((Object[])new Object[]{originalamount, adjustamount});
        }
        if ("001_03".equals(rowType)) {
            BigDecimal a1;
            BigDecimal originalamount = a1 = this.queryDgAmount(customParams, "tccit_profit_fees_summary", "sellcost", Collections.singletonList(26));
            BigDecimal adjustamount = this.getAdjustAmount(customParams, rowType, originalamount);
            return BigDecimalUtil.addObjects((Object[])new Object[]{originalamount, adjustamount});
        }
        if ("001_04".equals(rowType)) {
            BigDecimal a1;
            BigDecimal originalamount = a1 = this.queryDgAmount(customParams, "tccit_profit_fees_summary", "managecost", Collections.singletonList(26));
            BigDecimal adjustamount = this.getAdjustAmount(customParams, rowType, originalamount);
            return BigDecimalUtil.addObjects((Object[])new Object[]{originalamount, adjustamount});
        }
        if ("001_05".equals(rowType)) {
            BigDecimal a1;
            BigDecimal originalamount = a1 = this.queryDgAmount(customParams, "tccit_profit_fees_summary", "financecost", Collections.singletonList(26));
            BigDecimal adjustamount = this.getAdjustAmount(customParams, rowType, originalamount);
            return BigDecimalUtil.addObjects((Object[])new Object[]{originalamount, adjustamount});
        }
        if ("002_01".equals(rowType)) {
            BigDecimal a1 = this.queryDgAmount(customParams, "tccit_profit_income_sum", "amount", Collections.singletonList(16));
            BigDecimal a2 = this.queryDgAmount(customParams, "tccit_dg_a101020_sum", "amount", Collections.singletonList(35));
            BigDecimal a3 = this.queryDgAmount(customParams, "tccit_dg_a103000_sum", "amount", Arrays.asList(9, 17));
            BigDecimal originalamount = BigDecimalUtil.addObjects((Object[])new Object[]{a1, a2, a3});
            BigDecimal adjustamount = this.getAdjustAmount(customParams, rowType, originalamount);
            return BigDecimalUtil.addObjects((Object[])new Object[]{originalamount, adjustamount});
        }
        if ("002_02".equals(rowType)) {
            BigDecimal a1 = this.queryDgAmount(customParams, "tccit_profit_cost_summary", "amount", Collections.singletonList(16));
            BigDecimal a2 = this.queryDgAmount(customParams, "tccit_dg_a102020_sum", "amount", Collections.singletonList(33));
            BigDecimal a3 = this.queryDgAmount(customParams, "tccit_dg_a103000_sum", "amount", Arrays.asList(23, 28));
            BigDecimal originalamount = BigDecimalUtil.addObjects((Object[])new Object[]{a1, a2, a3});
            BigDecimal adjustamount = this.getAdjustAmount(customParams, rowType, originalamount);
            return BigDecimalUtil.addObjects((Object[])new Object[]{originalamount, adjustamount});
        }
        return super.getAmount(customParams, columnType, rowType, ruleDetailEntryName);
    }

    private BigDecimal getAdjustAmount(Map<String, Object> customParams, String rowType, BigDecimal originalamount) {
        cacheLevel1Map.put("originalamount_" + rowType, originalamount.toString());
        DynamicObjectCollection results = this.getSDTZOriginalAmount(customParams, rowType, this.getEntrytype(customParams));
        return CollectionUtils.isEmpty((Collection)results) ? BigDecimal.ZERO : ((DynamicObject)results.get(0)).getBigDecimal("adjustamount");
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams, this.itemTypes, SUMMARY_ENTRY_NAME, RULE_DETAIL_ENTRY_NAME);
    }

    private BigDecimal queryDgAmount(Map<String, Object> customParams, String entityentity, String field, List<Integer> itemno) {
        String orgid = (String)customParams.get("orgid");
        QFilter q1 = new QFilter("orgid", "=", (Object)Long.parseLong(orgid));
        String skssqq = (String)customParams.get("skssqq");
        QFilter q2 = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)skssqq));
        String skssqz = (String)customParams.get("skssqz");
        QFilter q3 = new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)skssqz));
        QFilter q4 = new QFilter("itemno", "in", itemno);
        BigDecimal total = BigDecimal.ZERO;
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entityentity, (String)field, (QFilter[])new QFilter[]{q1, q2, q3, q4});
        for (DynamicObject dynamicObject : dynamicObjects) {
            BigDecimal bigDecimal = dynamicObject.getBigDecimal(field);
            total = BigDecimalUtil.addObject((Object)total, (Object)bigDecimal);
        }
        return total;
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz, this.itemTypes, SUMMARY_ENTRY_NAME);
    }

    @Override
    public String getEntrytype(Map<String, Object> customParams) {
        return "profits-ack";
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{"amount"});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        boolean existsRules = this.isExistsRules(customParams);
        String itemtype = row.getString("itemtype");
        customParams.put("entryname", RULE_DETAIL_ENTRY_NAME);
        customParams.put("entrytype", this.getEntrytype(customParams));
        customParams.put("columnType", column);
        customParams.put("itemnumber", itemtype.equals("002") ? (existsRules ? "110" : "002") : itemtype);
        customParams.put("isExists110Rules", existsRules);
        return customParams;
    }

    @Override
    public Map<String, List<String>> getNodeDependentOn() {
        return new HashMap(){
            {
                this.put(A100000_1_DGFormPlugin.class.getSimpleName(), Lists.newArrayList((Object[])new String[]{ProfitIncomeTZFormPlugin.class.getSimpleName(), A101020_DGFormPlugin.class.getSimpleName(), ProfitCostTZFormPlugin.class.getSimpleName(), A102020_DGFormPlugin.class.getSimpleName(), A103000_DGFormPlugin.class.getSimpleName(), ProfitFeesTZFormPlugin.class.getSimpleName()}));
            }
        };
    }
}

