/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.year.dg.lrqr;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.org.OrgWithFinanceService;
import kd.taxc.tccit.formplugin.account.ProfitIncomeCostCommFormPlugin;

public class A101020_DGFormPlugin
extends ProfitIncomeCostCommFormPlugin
implements Observer {
    public static final String SUMMARY_ENTRY_NAME = "tccit_dg_a101020_sum";
    public static final String RULE_DETAIL_ENTRY_NAME = "tccit_dg_a101020_det";
    private final List<String> itemTypes = Lists.newArrayList((Object[])new String[]{"001", "001_01", "001_01_01", "1030101", "1030102", "1030103", "1030104", "1030105", "1030106", "001_01_02", "1030107", "1030108", "1030109", "1030110", "1030111", "1030112", "1030113", "001_02", "001_02_1", "1030114", "1030115", "1030116", "1030117", "1030118", "1030119", "1030120", "001_03", "1030121", "1030122", "1030123", "1030124", "1030125", "1030126", "1030127", "002", "1030201", "1030202", "1030203", "1030204", "1030205", "1030206", "1030207"});
    private final Map<String, String> CALC_RELATION = new HashMap<String, String>(){
        {
            this.put("001", "{Q[001_01]}+{Q[001_02]}+{Q[001_03]}+{Q[1030125]}+{Q[1030126]}+{Q[1030127]}");
            this.put("001_01", "{Q[001_01_01]}+{Q[001_01_02]}");
            this.put("001_01_01", "{Q[1030101]}+{Q[1030102]}+{Q[1030103]}+{Q[1030104]}+{Q[1030105]}+{Q[1030106]}");
            this.put("001_01_02", "{Q[1030107]}+{Q[1030108]}+{Q[1030109]}+{Q[1030110]}+{Q[1030111]}+{Q[1030112]}+{Q[1030113]}");
            this.put("001_02", "{Q[001_02_1]}+{Q[1030120]}");
            this.put("001_02_1", "{Q[1030114]}+{Q[1030115]}+{Q[1030116]}+{Q[1030117]}+{Q[1030118]}+{Q[1030119]}");
            this.put("001_03", "{Q[1030121]}-{Q[1030123]}-{Q[1030124]}");
            this.put("002", "{Q[1030201]}+{Q[1030202]}+{Q[1030203]}+{Q[1030204]}+{Q[1030205]}+{Q[1030206]}+{Q[1030207]}");
        }
    };

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams, this.itemTypes, SUMMARY_ENTRY_NAME, RULE_DETAIL_ENTRY_NAME);
        }
        this.initData(SUMMARY_ENTRY_NAME, this.itemTypes);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent evt) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("entryname", RULE_DETAIL_ENTRY_NAME);
        customParams.put("entrytype", this.getEntrytype(customParams));
        super.hyperLinkClick(evt);
    }

    @Override
    public String getCalExpression(String rowType, Map<String, Object> customParams) {
        return this.CALC_RELATION.get(rowType);
    }

    @Override
    public Set<String> getTitles() {
        return this.CALC_RELATION.keySet();
    }

    @Override
    public boolean checkCalData(Map<String, Object> customParams) {
        DynamicObject policy = (DynamicObject)customParams.get("policy");
        if (policy == null) {
            return true;
        }
        return OrgWithFinanceService.isFinance(policy);
    }

    @Override
    public String getEntrytype(Map<String, Object> customParams) {
        return "finance-income";
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams, this.itemTypes, SUMMARY_ENTRY_NAME, RULE_DETAIL_ENTRY_NAME);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz, this.itemTypes, SUMMARY_ENTRY_NAME);
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{"amount"});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String itemtype = row.getString("itemtype");
        customParams.put("entryname", RULE_DETAIL_ENTRY_NAME);
        customParams.put("entrytype", this.getEntrytype(customParams));
        customParams.put("columnType", column);
        customParams.put("itemnumber", itemtype);
        return customParams;
    }
}

