/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.year.dg.lrqr;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.org.OrgWithFinanceService;
import kd.taxc.tccit.formplugin.account.ProfitIncomeCostCommFormPlugin;

public class A102020_DGFormPlugin
extends ProfitIncomeCostCommFormPlugin
implements Observer {
    public static final String SUMMARY_ENTRY_NAME = "tccit_dg_a102020_sum";
    public static final String RULE_DETAIL_ENTRY_NAME = "tccit_dg_a102020_det";
    private final List<String> itemTypes = Lists.newArrayList((Object[])new String[]{"001", "001_01", "001_01_01", "1040101", "1040102", "1040103", "1040104", "1040105", "1040106", "1040107", "001_01_02", "1040108", "1040109", "1040110", "001_02", "1040111", "1040112", "1040113", "1040114", "1040115", "1040116", "1040117", "1040118", "1040119", "001_03", "001_03_01", "1040120", "1040121", "1040122", "1040123", "1040124", "1040125", "002", "1040201", "1040202", "1040203", "1040204", "1040205", "1040206"});
    private static final Map<String, String> CALC_RELATION = new HashMap<String, String>(){
        {
            this.put("001", "{Q[001_01]}+{Q[001_02]}+{Q[1040124]}+{Q[1040125]}");
            this.put("001_01", "{Q[001_01_01]}+{Q[001_01_02]}");
            this.put("001_01_01", "{Q[1040101]}+{Q[1040102]}+{Q[1040103]}+{Q[1040104]}+{Q[1040105]}+{Q[1040106]}+{Q[1040107]}");
            this.put("001_01_02", "{Q[1040108]}+{Q[1040109]}+{Q[1040110]}");
            this.put("001_02", "{Q[1040111]}+{Q[1040112]}-{Q[1040113]}+{Q[1040114]}-{Q[1040115]}+{Q[1040116]}+{Q[1040117]}-{Q[1040118]}+{Q[1040119]}");
            this.put("001_03", "{Q[001_03_01]}+{Q[1040123]}");
            this.put("001_03_01", "{Q[1040120]}+{Q[1040121]}+{Q[1040122]}");
            this.put("002", "{Q[1040201]}+{Q[1040202]}+{Q[1040203]}+{Q[1040204]}+{Q[1040205]}+{Q[1040206]}");
        }
    };

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams, this.itemTypes, SUMMARY_ENTRY_NAME, RULE_DETAIL_ENTRY_NAME);
        }
        this.initData(SUMMARY_ENTRY_NAME, this.itemTypes);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent evt) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("entryname", RULE_DETAIL_ENTRY_NAME);
        customParams.put("entrytype", this.getEntrytype(customParams));
        super.hyperLinkClick(evt);
    }

    @Override
    public String getCalExpression(String rowType, Map<String, Object> customParams) {
        return CALC_RELATION.get(rowType);
    }

    @Override
    public Set<String> getTitles() {
        return CALC_RELATION.keySet();
    }

    @Override
    public boolean checkCalData(Map<String, Object> customParams) {
        DynamicObject policy = (DynamicObject)customParams.get("policy");
        if (policy == null) {
            return true;
        }
        return OrgWithFinanceService.isFinance(policy);
    }

    @Override
    public String getEntrytype(Map<String, Object> customParams) {
        return "finance-cost";
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams, this.itemTypes, SUMMARY_ENTRY_NAME, RULE_DETAIL_ENTRY_NAME);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz, this.itemTypes, SUMMARY_ENTRY_NAME);
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return Sets.newHashSet((Object[])new String[]{"amount"});
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String itemtype = row.getString("itemtype");
        customParams.put("entryname", RULE_DETAIL_ENTRY_NAME);
        customParams.put("entrytype", this.getEntrytype(customParams));
        customParams.put("columnType", column);
        customParams.put("itemnumber", itemtype);
        return customParams;
    }
}

