/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.year.dg.lrqr;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.org.OrgWithFinanceService;
import kd.taxc.tccit.formplugin.account.ProfitIncomeCostCommFormPlugin;

public class A103000_DGFormPlugin
extends ProfitIncomeCostCommFormPlugin
implements Observer {
    public static final String SUMMARY_ENTRY_NAME = "tccit_dg_a103000_sum";
    public static final String RULE_DETAIL_ENTRY_NAME = "tccit_dg_a103000_det";
    private final List<String> itemTypes = Lists.newArrayList((Object[])new String[]{"001", "1050101", "1050102", "1050103", "1050104", "1050105", "001_01", "1050106", "1050107", "002", "1050301", "1050302", "1050303", "1050304", "1050305", "1050306", "1050307", "003", "1050201", "1050202", "1050203", "1050204", "1050205", "004", "1050401", "1050402", "1050403", "1050404"});
    private final Map<String, String> CALC_RELATION = new HashMap<String, String>(){
        {
            this.put("001", "{Q[001_01]}+{Q[1050101]}+{Q[1050102]}+{Q[1050103]}+{Q[1050104]}+{Q[1050105]}");
            this.put("001_01", "{Q[1050106]}+{Q[1050107]}");
            this.put("002", "{Q[1050301]}+{Q[1050302]}+{Q[1050303]}+{Q[1050304]}+{Q[1050305]}+{Q[1050306]}+{Q[1050307]}");
            this.put("003", "{Q[1050201]}+{Q[1050202]}+{Q[1050203]}+{Q[1050204]}+{Q[1050205]}");
            this.put("004", "{Q[1050401]}+{Q[1050402]}+{Q[1050403]}+{Q[1050404]}");
        }
    };

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams, this.itemTypes, SUMMARY_ENTRY_NAME, RULE_DETAIL_ENTRY_NAME);
        }
        this.initData(SUMMARY_ENTRY_NAME, this.itemTypes);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent evt) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("entryname", RULE_DETAIL_ENTRY_NAME);
        customParams.put("entrytype", this.getEntrytype(customParams));
        super.hyperLinkClick(evt);
    }

    @Override
    public String getCalExpression(String rowType, Map<String, Object> customParams) {
        return this.CALC_RELATION.get(rowType);
    }

    @Override
    public Set<String> getTitles() {
        return this.CALC_RELATION.keySet();
    }

    @Override
    public boolean checkCalData(Map<String, Object> customParams) {
        DynamicObject policy = (DynamicObject)customParams.get("policy");
        if (policy == null) {
            return true;
        }
        return OrgWithFinanceService.isSydw(policy);
    }

    @Override
    public String getEntrytype(Map<String, Object> customParams) {
        return "gov-non";
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams, this.itemTypes, SUMMARY_ENTRY_NAME, RULE_DETAIL_ENTRY_NAME);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz, this.itemTypes, SUMMARY_ENTRY_NAME);
    }
}

