/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.year.dg.sdtz;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tccit.business.calc.Observer;
import kd.taxc.tccit.business.rule.RuleService;
import kd.taxc.tccit.common.enums.DynamicYearRuleEnum;
import kd.taxc.tccit.common.enums.RuleTypeEnum;
import kd.taxc.tccit.common.utils.DataFormat;
import kd.taxc.tccit.formplugin.account.AbstractEngine;

public class B105093_DGFormPlugin
extends AbstractEngine
implements Observer,
HyperLinkClickListener {
    public static final String SUMMARY_MLE_ENTRY_NAME = "tccit_dg_b105093mle_sum";
    public static final String SUMMARY_NSTZ_ENTRY_NAME = "tccit_dg_b105093nstz_sum";
    public static final String RULE_DETAIL_ENTRY_NAME = "tccit_dg_b105093_det";
    public static final String TCCIT_DETAIL_TZ_DIALOG = "tccit_detail_tz_dialog";
    public static final String ITEM_NO = "itemno";
    public static final String ITEM_TYPE = "itemtype";
    public static final String ITEM_NAME = "itemname";
    public static final String RULE_ID = "ruleid";
    public static final String SRJE = "srje";
    public static final String MLL = "mll";
    public static final String YJMLE = "yjmle";
    public static final String ITEM_NUMBER_XSWWGCPSR = "8010501";
    public static final String ITEM_NUMBER_SJFSDSJ = "8010502";
    private final List<String> entrytypes = Lists.newArrayList((Object[])new String[]{DynamicYearRuleEnum.XSWSGCPSR.getProjecttype(), DynamicYearRuleEnum.XSWSGCPZWGCPQRXSSR.getProjecttype()});
    private final List<String> itemTypes = Lists.newArrayList((Object[])new String[]{"001", "001_01", "001_02", "001_03", "002", "002_01", "002_02", "002_03", "003"});

    public void initialize() {
        super.initialize();
        EntryGrid mleentity = (EntryGrid)this.getControl("mleentity");
        EntryGrid mleentity1 = (EntryGrid)this.getControl("mleentity1");
        mleentity.addPackageDataListener(packageDataEvent -> {
            DynamicObject rowData = packageDataEvent.getRowData();
            if (rowData.getBoolean("fetchok")) {
                packageDataEvent.getNoLinkKey().add(MLL);
            } else {
                packageDataEvent.getNoLinkKey().add(YJMLE);
            }
        });
        mleentity1.addPackageDataListener(packageDataEvent -> {
            DynamicObject rowData = packageDataEvent.getRowData();
            if (rowData.getBoolean("fetchok1")) {
                packageDataEvent.getNoLinkKey().add("mll1");
            } else {
                packageDataEvent.getNoLinkKey().add("yjmle1");
            }
        });
    }

    public void registerListener(EventObject e) {
        EntryGrid mleentity = (EntryGrid)this.getControl("mleentity");
        mleentity.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid mleentity1 = (EntryGrid)this.getControl("mleentity1");
        mleentity1.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid nstzentity = (EntryGrid)this.getControl("nstzentity");
        nstzentity.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (this.canReCalc(customParams).booleanValue()) {
            this.calc(customParams);
        }
        this.initData();
    }

    public void initData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        this.initNstzData(orgFilter, dateFilter);
        this.initMleData(orgFilter, dateFilter);
    }

    private void initNstzData(QFilter orgFilter, QFilter dateFilter) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)SUMMARY_NSTZ_ENTRY_NAME, (String)"itemno,itemtype,amount", (QFilter[])new QFilter[]{orgFilter, dateFilter}, (String)ITEM_TYPE);
        if (query == null || query.size() == 0) {
            return;
        }
        this.getModel().beginInit();
        this.getModel().deleteEntryData("nstzentity");
        this.getModel().batchCreateNewEntryRow("nstzentity", query.size());
        int rowIndex = 0;
        for (int i = 0; i < query.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)query.get(i);
            String itemnumber = dynamicObject.getString(ITEM_TYPE);
            this.getModel().setValue("itemnumber", (Object)itemnumber, rowIndex);
            this.getModel().setValue("amount", (Object)this.formatData(dynamicObject, "amount", itemnumber), rowIndex);
            ++rowIndex;
        }
        this.getModel().endInit();
        this.getView().updateView("nstzentity");
    }

    private void initMleData(QFilter orgFilter, QFilter dateFilter) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)SUMMARY_MLE_ENTRY_NAME, (String)"itemno,itemtype,itemname,ruleid,srje,mll,yjmle,fetchok", (QFilter[])new QFilter[]{orgFilter, dateFilter});
        if (query == null || query.size() == 0) {
            return;
        }
        Map<String, List<DynamicObject>> map = query.stream().collect(Collectors.groupingBy(o -> o.getString(ITEM_TYPE)));
        for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
            String itemnumber = entry.getKey();
            String suffix = "";
            if (DynamicYearRuleEnum.XSWSGCPZWGCPQRXSSR.getProjecttype().equals(itemnumber)) {
                suffix = "1";
            }
            List<DynamicObject> list = entry.getValue();
            IDataModel model = this.getModel();
            model.beginInit();
            model.deleteEntryData("mleentity" + suffix);
            model.batchCreateNewEntryRow("mleentity" + suffix, list.size());
            int rowIndex = 0;
            for (int i = 0; i < list.size(); ++i) {
                DynamicObject dynamicObject = list.get(i);
                model.setValue("number" + suffix, (Object)dynamicObject.getString(ITEM_TYPE), rowIndex);
                model.setValue(ITEM_NAME + suffix, (Object)dynamicObject.getString(ITEM_NAME), rowIndex);
                String ruleid = dynamicObject.getString(RULE_ID);
                model.setValue(RULE_ID + suffix, (Object)ruleid, rowIndex);
                model.setValue(SRJE + suffix, dynamicObject.get(SRJE), rowIndex);
                model.setValue(MLL + suffix, dynamicObject.get(MLL), rowIndex);
                model.setValue(YJMLE + suffix, dynamicObject.get(YJMLE), rowIndex);
                model.setValue("fetchok" + suffix, dynamicObject.get("fetchok"), rowIndex);
                ++rowIndex;
            }
            model.endInit();
            this.getView().updateView("mleentity" + suffix);
        }
    }

    public void calc(Map<String, Object> customParams) {
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
        String adjustRate = (String)customParams.get("adjustRate");
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
        Object policy = customParams.get("policy");
        if (policy != null && !((DynamicObject)policy).getBoolean("income4")) {
            return;
        }
        DynamicObjectCollection sum = new DynamicObjectCollection();
        List orglist = (List)customParams.get("orglist");
        List<Object> sellRuleList = RuleService.getSharingAndOrgRules(orglist.stream().map(Long::parseLong).collect(Collectors.toList()), RuleTypeEnum.TSSX);
        sellRuleList = sellRuleList.stream().filter(s -> s.getDynamicObject("item") != null && ITEM_NUMBER_XSWWGCPSR.equals(s.getDynamicObject("item").getString("number"))).collect(Collectors.toList());
        int index = 1;
        for (String entrytype : this.entrytypes) {
            for (DynamicObject dynamicObject : sellRuleList) {
                DynamicObject dynamicObject2 = BusinessDataServiceHelper.newDynamicObject((String)SUMMARY_MLE_ENTRY_NAME);
                dynamicObject2.set(ITEM_NO, (Object)index++);
                dynamicObject2.set(ITEM_TYPE, (Object)entrytype);
                dynamicObject2.set(ITEM_NAME, (Object)dynamicObject.getString("name"));
                dynamicObject2.set(RULE_ID, (Object)dynamicObject.getString("id"));
                BigDecimal srje = this.calcAmount(dynamicObject.getString("id"), null, entrytype, customParams, RULE_DETAIL_ENTRY_NAME);
                dynamicObject2.set(SRJE, (Object)srje);
                BigDecimal mll = this.calcAmount(dynamicObject.getString("id"), null, entrytype + "_mll", customParams, RULE_DETAIL_ENTRY_NAME);
                dynamicObject2.set(MLL, (Object)mll);
                BigDecimal onylAmount = this.getCellAmountOnlyDetail(customParams, YJMLE, entrytype.equals("xswsgcpsr") ? "xswwgcpyjmle" : "zhdxswwgcpyjmle", null, null, dynamicObject.getLong("id"), RULE_DETAIL_ENTRY_NAME);
                BigDecimal yjmle = this.calcAmount(dynamicObject.getString("id"), null, entrytype.equals("xswsgcpsr") ? "xswwgcpyjmle" : "zhdxswwgcpyjmle", customParams, RULE_DETAIL_ENTRY_NAME);
                boolean fetchok = onylAmount.compareTo(BigDecimal.ZERO) != 0;
                dynamicObject2.set(YJMLE, (Object)(fetchok ? yjmle : BigDecimalUtil.multiplyObject((Object)srje, (Object)mll, (int)2)));
                dynamicObject2.set("fetchok", (Object)fetchok);
                dynamicObject2.set("orgid", (Object)orgid);
                dynamicObject2.set("skssqq", (Object)skssqq);
                dynamicObject2.set("skssqz", (Object)skssqz);
                sum.add((Object)dynamicObject2);
            }
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])sum.toArray((Object[])new DynamicObject[0])));
        HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>();
        BigDecimal amount_001_01 = this.getTotalAmount(sum, DynamicYearRuleEnum.XSWSGCPSR.getProjecttype(), SRJE);
        amountMap.put("amount_001_01", amount_001_01);
        BigDecimal amount_001_02 = this.getTotalAmount(sum, DynamicYearRuleEnum.XSWSGCPSR.getProjecttype(), YJMLE);
        amountMap.put("amount_001_02", amount_001_02);
        BigDecimal bigDecimal = this.calcAmount(null, ITEM_NUMBER_SJFSDSJ, DynamicYearRuleEnum.SJFSDYYSJJFJTDZZS.getProjecttype(), customParams, RULE_DETAIL_ENTRY_NAME);
        amountMap.put("amount_001_03", bigDecimal);
        BigDecimal amount_002_01 = this.getTotalAmount(sum, DynamicYearRuleEnum.XSWSGCPZWGCPQRXSSR.getProjecttype(), SRJE);
        amountMap.put("amount_002_01", amount_002_01);
        BigDecimal amount_002_02 = this.getTotalAmount(sum, DynamicYearRuleEnum.XSWSGCPZWGCPQRXSSR.getProjecttype(), YJMLE);
        amountMap.put("amount_002_02", amount_002_02);
        BigDecimal amount_002_03 = this.calcAmount(null, ITEM_NUMBER_SJFSDSJ, DynamicYearRuleEnum.ZHSJFSDYYSJJFJTDZZS.getProjecttype(), customParams, RULE_DETAIL_ENTRY_NAME);
        amountMap.put("amount_002_03", amount_002_03);
        BigDecimal amount_001 = BigDecimalUtil.subtractObject((Object)amount_001_02, (Object)bigDecimal);
        amountMap.put("amount_001", amount_001);
        BigDecimal amount_002 = BigDecimalUtil.subtractObject((Object)amount_002_02, (Object)amount_002_03);
        amountMap.put("amount_002", amount_002);
        BigDecimal amount_003 = BigDecimalUtil.subtractObject((Object)amount_001, (Object)amount_002);
        amountMap.put("amount_003", amount_003);
        int nstzIndex = 1;
        ArrayList<DynamicObject> nstzList = new ArrayList<DynamicObject>(32);
        for (String itemType : this.itemTypes) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)SUMMARY_NSTZ_ENTRY_NAME);
            dynamicObject.set(ITEM_NO, (Object)nstzIndex++);
            dynamicObject.set(ITEM_TYPE, (Object)itemType);
            dynamicObject.set("amount", amountMap.get("amount_" + itemType));
            dynamicObject.set("orgid", (Object)orgid);
            dynamicObject.set("skssqq", (Object)skssqq);
            dynamicObject.set("skssqz", (Object)skssqz);
            nstzList.add(dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])nstzList.toArray(new DynamicObject[0]));
    }

    private BigDecimal getTotalAmount(DynamicObjectCollection sum, String entrytype, String amountField) {
        Map<String, List<DynamicObject>> map = sum.stream().collect(Collectors.groupingBy(e -> e.getString(ITEM_TYPE)));
        List<DynamicObject> objects = map.get(entrytype);
        BigDecimal total = BigDecimal.ZERO;
        if (objects != null && !objects.isEmpty()) {
            for (DynamicObject object : objects) {
                total = BigDecimalUtil.addObject((Object)total, (Object)object.getBigDecimal(amountField));
            }
        }
        return total;
    }

    private BigDecimal calcAmount(String ruleid, String itemnumber, String entrytype, Map<String, Object> customParams, String ruleDetailEntryName) {
        BigDecimal amount = this.getAmount(ruleid, itemnumber, customParams, entrytype, ruleDetailEntryName);
        return amount;
    }

    private BigDecimal getAmount(String ruleid, String itemnumber, Map<String, Object> customParams, String entrytype, String ruleDetailEntryName) {
        return this.getCellAmount(customParams, null, entrytype, null, itemnumber, ruleid != null ? Long.valueOf(ruleid) : null, ruleDetailEntryName);
    }

    private String formatData(DynamicObject dynamicObject, String columnType, String itemnumber) {
        StringBuilder link = new StringBuilder("<nolink>");
        BigDecimal amount = dynamicObject.getBigDecimal(columnType).setScale(2, 4);
        if (!"001_03".equals(itemnumber) && !"002_03".equals(itemnumber)) {
            return link.append(DataFormat.formatMicrometer(amount.toString())).toString();
        }
        return DataFormat.formatMicrometer(amount.toString());
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        int rowIndex = evt.getRowIndex();
        Map<String, Object> customParams = this.getStringObjectMap(fieldName, rowIndex);
        customParams.put("columnType", fieldName);
        customParams.put("entryname", RULE_DETAIL_ENTRY_NAME);
        this.showForm(customParams, TCCIT_DETAIL_TZ_DIALOG);
    }

    private Map<String, Object> getStringObjectMap(String fieldName, int rowIndex) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (SRJE.equals(fieldName)) {
            customParams.put("entrytype", DynamicYearRuleEnum.XSWSGCPSR.getProjecttype());
            customParams.put("itemnumber", this.getModel().getValue(RULE_ID, rowIndex));
            customParams.put(RULE_ID, this.getModel().getValue(RULE_ID, rowIndex));
        } else if ("srje1".equals(fieldName)) {
            customParams.put("entrytype", DynamicYearRuleEnum.XSWSGCPZWGCPQRXSSR.getProjecttype());
            customParams.put("itemnumber", this.getModel().getValue("ruleid1", rowIndex));
            customParams.put(RULE_ID, this.getModel().getValue("ruleid1", rowIndex));
        } else if (YJMLE.equals(fieldName)) {
            customParams.put("entrytype", DynamicYearRuleEnum.XSWWGCPYJMLE.getProjecttype());
            customParams.put("itemnumber", this.getModel().getValue(RULE_ID, rowIndex));
            customParams.put(RULE_ID, this.getModel().getValue(RULE_ID, rowIndex));
        } else if ("yjmle1".equals(fieldName)) {
            customParams.put("entrytype", DynamicYearRuleEnum.ZHDXSWWGCPYJMLE.getProjecttype());
            customParams.put("itemnumber", this.getModel().getValue(RULE_ID, rowIndex));
            customParams.put(RULE_ID, this.getModel().getValue("ruleid1", rowIndex));
        } else if ("amount".equals(fieldName)) {
            Object itemnumber = this.getModel().getValue("itemnumber", rowIndex);
            if ("001_03".equals(itemnumber)) {
                customParams.put("entrytype", DynamicYearRuleEnum.SJFSDYYSJJFJTDZZS.getProjecttype());
            } else if ("002_03".equals(itemnumber)) {
                customParams.put("entrytype", DynamicYearRuleEnum.ZHSJFSDYYSJJFJTDZZS.getProjecttype());
            }
            customParams.put("itemnumber", ITEM_NUMBER_SJFSDSJ);
        } else if (MLL.equals(fieldName)) {
            customParams.put("entrytype", DynamicYearRuleEnum.XSWSGCPSR.getProjecttype() + "_mll");
            customParams.put("itemnumber", ITEM_NUMBER_XSWWGCPSR);
            customParams.put(RULE_ID, this.getModel().getValue(RULE_ID, rowIndex));
        } else if ("mll1".equals(fieldName)) {
            customParams.put("entrytype", DynamicYearRuleEnum.XSWSGCPZWGCPQRXSSR.getProjecttype() + "_mll");
            customParams.put("itemnumber", ITEM_NUMBER_XSWWGCPSR);
            customParams.put(RULE_ID, this.getModel().getValue("ruleid1", rowIndex));
        }
        return customParams;
    }

    private void showForm(Map<String, Object> customParams, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    @Override
    public void calcSummery(Map<String, Object> customParams) {
        this.calc(customParams);
    }

    public void deleteData(EngineModel model) {
        Long orgid = Long.parseLong(model.getOrgId());
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        this.clearCurrentPeriod(orgid, skssqq, skssqz);
    }

    protected void clearCurrentPeriod(Long orgid, Date skssqq, Date skssqz) {
        QFilter orgFilter = new QFilter("orgid", "=", (Object)orgid);
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        DeleteServiceHelper.delete((String)SUMMARY_NSTZ_ENTRY_NAME, (QFilter[])new QFilter[]{orgFilter, dateFilter});
        DeleteServiceHelper.delete((String)SUMMARY_MLE_ENTRY_NAME, (QFilter[])new QFilter[]{orgFilter, dateFilter});
    }

    @Override
    public String getEntryName() {
        return "nstzentity,mleentity,mleentity1";
    }

    @Override
    public Set<String> linkAmountCellNames(String entryName) {
        return "nstzentity".equals(entryName) ? Sets.newHashSet((Object[])new String[]{"amount"}) : ("mleentity".equals(entryName) ? Sets.newHashSet((Object[])new String[]{SRJE, MLL, YJMLE}) : Sets.newHashSet((Object[])new String[]{"srje1", "mll1", "yjmle1"}));
    }

    @Override
    public Map<String, Object> createParams(DynamicObject row, String column) {
        Map<String, Object> customParams = this.getStringObjectMap(column, row.getInt("seq") - 1);
        customParams.put("entryname", RULE_DETAIL_ENTRY_NAME);
        customParams.put("columnType", column);
        return customParams;
    }
}

