/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.year.rule;

import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.draft.TaxMainInfoService;
import kd.taxc.tccit.business.rule.CustomDataSourceService;
import kd.taxc.tccit.common.enums.DynamicYearRuleEnum;
import kd.taxc.tccit.common.enums.RuleTipEnum;
import kd.taxc.tccit.common.utils.DynamicRuleTypeConstantUtils;

public class DynamicTccitRuleEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
BasedataFuzzySearchListener {
    private static final String ENTITY_KEY = "entryentity";
    private static final String META_ENTITY_PREFIX = "entryentity";
    private static final String FLEX_PANEL_PREFIX = "advconap";
    public static final String RULE_TYPE_DSALE = "dsale";
    public static final String RULE_TYPE = "type";
    public static final String SPACE_STRING = " ";
    private static String[] FIELDS_NONULL = new String[]{"bizname", "table", "amountfield", "datadirection", "absolute", "datatype"};
    private static Set<String> DYNAMIC_TYPES = Sets.newHashSet((Object[])new String[]{"ajust", "dsale", "zcajust", "srajust", "tssx", "other", "period", "income", "ssyh"});
    private static Set<String> project1 = Sets.newHashSet((Object[])new String[]{"701030401", "701030402", "701030501", "701030502", "701030503", "701030701", "701030702", "7010312"});
    private static Set<String> project2 = Sets.newHashSet((Object[])new String[]{"701030301", "701030302", "701030601", "701030602"});
    private static Set<DynamicYearRuleEnum> ASSETS_ENTRY_NAME = Sets.newHashSet((Object[])new DynamicYearRuleEnum[]{DynamicYearRuleEnum.ASSETSORIGINALRULE, DynamicYearRuleEnum.ASSETSSUMDEPRECIATERULE, DynamicYearRuleEnum.ASSETSABNORMALINCOMERULE});

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit item = (BasedataEdit)this.getControl("item");
        item.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit baseDataEdit = (BasedataEdit)this.getControl("item");
        baseDataEdit.addBasedataFuzzySearchListener((BasedataFuzzySearchListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get("orgid");
        this.getModel().setValue("org", orgid);
        Object ruletype = customParams.get("ruletype");
        this.getModel().setValue("ruletype", ruletype);
        Object type = customParams.get(RULE_TYPE);
        this.getModel().setValue(RULE_TYPE, type);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue("org", this.getView().getFormShowParameter().getCustomParams().get("orgid"));
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if ("item".equals(name)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"DynamicTccitRuleEditPlugin_9", (String)"taxc-tccit", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            long orgid = org.getLong("id");
            DynamicObject taxMain = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgid).getData();
            if (taxMain == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6ca1\u6709\u914d\u7f6e\u2018\u767b\u8bb0\u6ce8\u518c\u7c7b\u578b\u2019\uff0c\u8bf7\u524d\u5f80\u7a0e\u52a1\u4fe1\u606f\u9875\u9762\u914d\u7f6e\u76f8\u5173\u4fe1\u606f\u3002", (String)"DynamicTccitRuleEditPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            Object type = this.getModel().getValue(RULE_TYPE);
            Object costtype = this.getModel().getValue("costtype");
            formShowParameter.getListFilterParameter().setFilter(new QFilter(RULE_TYPE, "=", (Object)String.valueOf(this.getModel().getValue(RULE_TYPE))));
            formShowParameter.setCustomParam("orgid", (Object)orgid);
            formShowParameter.setCustomParam(RULE_TYPE, type);
            formShowParameter.setCustomParam("costtype", costtype);
            formShowParameter.setCustomParam("template", (Object)"qysdsnb");
            formShowParameter.setCaption(new LocaleString(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee\u8868", (String)"DynamicTccitRuleEditPlugin_1", (String)"taxc-tccit", (Object[])new Object[0])).getLocaleValue());
        }
    }

    public void afterBindData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"ruletip1", "ruletip2", "ruletip3", "ruletip4", "ruletip5", "ruletip6", "ruletip7"});
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.EDIT)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"org"});
        }
        if (this.isOpenDynamicEntry(this.getModel().getValue("item"))) {
            this.initEntry();
        } else {
            this.showInitEntry();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("costtype".equals(name)) {
            this.getModel().setValue("item", null);
        } else if ("item".equals(name)) {
            if (DYNAMIC_TYPES.contains(String.valueOf(this.getModel().getValue(RULE_TYPE)))) {
                ChangeData[] changeSet = e.getChangeSet();
                Object newValue = changeSet[0].getNewValue();
                Object oldValue = changeSet[0].getOldValue();
                boolean oldType = this.isOpenDynamicEntry(oldValue);
                boolean newType = this.isOpenDynamicEntry(newValue);
                String oldItem = String.valueOf(oldValue == null ? "" : ((DynamicObject)oldValue).get("number"));
                String itemnName = String.valueOf(newValue == null ? "" : ((DynamicObject)newValue).get("number"));
                if (oldType) {
                    this.clearOldEntry(oldItem);
                    if (newType) {
                        this.showEntryByItemType(itemnName);
                    } else {
                        this.showInitEntry();
                    }
                } else if (newType) {
                    this.showEntryByItemType(itemnName);
                }
                this.getView().updateView();
                this.getModel().setDataChanged(false);
                this.notifyDksszbjMsg(changeSet);
            }
        } else {
            super.propertyChanged(e);
        }
    }

    private void notifyDksszbjMsg(ChangeData[] changeSet) {
        Object newValue;
        if (StringUtil.equals((CharSequence)String.valueOf(this.getModel().getValue(RULE_TYPE)), (CharSequence)"tssx") && (newValue = changeSet[0].getNewValue()) != null) {
            String itemnumber = ((DynamicObject)newValue).getString("number");
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)org.getLong("id"));
            if (result.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
                String codeNumber;
                DynamicObject taxMain = (DynamicObject)result.getData();
                if (itemnumber.startsWith("8010201") && EmptyCheckUtils.isNotEmpty((Object)taxMain) && !(codeNumber = taxMain.getString("codeandname.number")).startsWith("662") && !codeNumber.startsWith("663")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5f53\u524d\u7ec4\u7ec7\u662f\u5426\u6d89\u53ca\u5df2\u9009\u7684\u7eb3\u7a0e\u8c03\u6574\u9879\u76ee", (String)"DynamicTccitRuleEditPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]));
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Save && this.isOpenDynamicEntry(this.getModel().getValue("item"))) {
            Object item = this.getModel().getValue("item");
            String itemName = String.valueOf(item == null ? "" : ((DynamicObject)item).get("number"));
            String msg = this.validDataOfMustInput(itemName);
            if (StringUtil.isNotBlank((CharSequence)msg)) {
                args.setCancel(true);
                this.getView().showTipNotification(msg);
                return;
            }
            this.collectData(itemName, args);
        }
        if (!RULE_TYPE_DSALE.equals(String.valueOf(this.getModel().getValue(RULE_TYPE)))) {
            this.getModel().setValue("spap", (Object)"out");
        }
    }

    private String validDataOfMustInput(String itemName) {
        StringBuilder msg = new StringBuilder();
        List<DynamicYearRuleEnum> ruleTypes = DynamicRuleTypeConstantUtils.getRuleTypes(String.valueOf(this.getModel().getValue(RULE_TYPE)), itemName);
        for (DynamicYearRuleEnum ruleEnum : ruleTypes) {
            String suffix = ruleEnum.getMetadatasuffix();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity" + suffix);
            if (entryEntity.size() == 0) continue;
            for (DynamicObject object : entryEntity) {
                DynamicObject table = (DynamicObject)object.get("table" + suffix);
                if (table == null) continue;
                String conditionjson = object.getString("conditionjson" + suffix);
                if (!CustomDataSourceService.isRdesdGxqyyhmx(table.getLong("id")) && !CustomDataSourceService.isRdesdyhmx(table.getLong("id")) || !StringUtil.isBlank((CharSequence)conditionjson)) continue;
                String bizNameTips = ResManager.loadKDString((String)"\u4e1a\u52a1\u540d\u79f0\uff1a", (String)"DynamicTccitRuleEditPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]);
                String tableTips = ResManager.loadKDString((String)"\u6570\u636e\u6e90\uff1a", (String)"DynamicTccitRuleEditPlugin_4", (String)"taxc-tccit", (Object[])new Object[0]);
                String needTips = ResManager.loadKDString((String)"\u9700\u8981\u6307\u5b9a\u8fc7\u6ee4\u6761\u4ef6", (String)"DynamicTccitRuleEditPlugin_5", (String)"taxc-tccit", (Object[])new Object[0]);
                msg.append(bizNameTips).append("\u3010").append(object.getString("bizname" + suffix)).append("\u3011").append(tableTips).append("\u3010").append(table.getString("bizname")).append("\u3011").append(needTips).append("\t\n");
            }
        }
        return msg.toString();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("save".equals(afterDoOperationEventArgs.getOperateKey()) && this.isOpenDynamicEntry(this.getModel().getValue("item"))) {
            this.splitEntryData();
        }
    }

    private void initEntry() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (DYNAMIC_TYPES.contains(String.valueOf(this.getModel().getValue(RULE_TYPE)))) {
            Object item = this.getModel().getValue("item");
            String name = String.valueOf(item == null ? "" : ((DynamicObject)item).get("number"));
            this.showEntryByItemType(name);
            Object id = this.getModel().getValue("id");
            if (id != null && (Long)id != 0L || customParams.getOrDefault("iscopy", Boolean.FALSE).booleanValue()) {
                this.splitEntryData();
            }
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_PANEL_PREFIX});
            this.getView().setVisible(Boolean.FALSE, DynamicRuleTypeConstantUtils.getDynamicEntryPanel());
        }
    }

    private void splitEntryData() {
        Object item = this.getModel().getValue("item");
        String itemName = String.valueOf(item == null ? "" : ((DynamicObject)item).get("number"));
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("entryentity");
        LinkedHashMap collectGroup = dynamicObjectCollection.stream().sorted(Comparator.comparing(a -> a.getInt("seq"))).collect(Collectors.groupingBy(b -> b.getString("projecttype"), LinkedHashMap::new, Collectors.toList()));
        List<DynamicYearRuleEnum> ruleTypes = DynamicRuleTypeConstantUtils.getRuleTypes(String.valueOf(this.getModel().getValue(RULE_TYPE)), itemName);
        if (ruleTypes != null) {
            for (DynamicYearRuleEnum ruleType : ruleTypes) {
                String suffix = ruleType.getMetadatasuffix();
                String projectType = ruleType.getProjecttype();
                List sourceObjects = (List)collectGroup.get(projectType);
                if (sourceObjects == null || sourceObjects.size() <= 0) continue;
                this.getModel().deleteEntryData("entryentity" + suffix);
                DynamicObjectCollection targetEntitys = this.getModel().getEntryEntity("entryentity" + suffix);
                int count = 1;
                for (DynamicObject sourceObject : sourceObjects) {
                    DynamicObject target = targetEntitys.addNew();
                    target.set("id", sourceObject.get("id"));
                    target.set("seq", (Object)count);
                    target.set("bizname" + suffix, sourceObject.get("bizname"));
                    target.set("projecttype" + suffix, (Object)projectType);
                    target.set("table" + suffix, sourceObject.get("table"));
                    target.set("amountfield" + suffix, sourceObject.get("amountfield"));
                    target.set("absolute" + suffix, sourceObject.get("absolute"));
                    target.set("datatype" + suffix, sourceObject.get("datatype"));
                    target.set("datadirection" + suffix, sourceObject.get("datadirection"));
                    target.set("filtercondition" + suffix, sourceObject.get("filtercondition"));
                    target.set("conditionjson" + suffix, sourceObject.get("conditionjson"));
                    target.set("advancedconf" + suffix, sourceObject.get("advancedconf"));
                    target.set("advancedconfjson" + suffix, sourceObject.get("advancedconfjson"));
                    target.set("vatrate" + suffix, sourceObject.get("vatrate"));
                    target.set("exratejson" + suffix, sourceObject.get("exratejson"));
                    ++count;
                }
                this.getView().updateView("entryentity" + suffix);
            }
            this.getModel().deleteEntryData("entryentity");
            this.getView().updateView("entryentity");
            this.getModel().setDataChanged(false);
        }
    }

    private void collectData(String item, BeforeDoOperationEventArgs args) {
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        List<DynamicYearRuleEnum> ruleTypes = DynamicRuleTypeConstantUtils.getRuleTypes(String.valueOf(this.getModel().getValue(RULE_TYPE)), item);
        for (DynamicYearRuleEnum ruleEnum : ruleTypes) {
            String suffix = ruleEnum.getMetadatasuffix();
            DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity" + suffix);
            if (entryEntity.size() == 0) continue;
            String projectType = ruleEnum.getProjecttype();
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject pageEntityObject = (DynamicObject)entryEntity.get(i);
                if (!this.hasNullFields(pageEntityObject, suffix).booleanValue()) {
                    int newEntryRow = model.createNewEntryRow("entryentity");
                    DynamicObject ruleObject = model.getEntryRowEntity("entryentity", newEntryRow);
                    ruleObject.set("id", pageEntityObject.get("id"));
                    ruleObject.set("bizname", pageEntityObject.get("bizname" + suffix));
                    ruleObject.set("projecttype", (Object)projectType);
                    ruleObject.set("table", pageEntityObject.get("table" + suffix));
                    ruleObject.set("amountfield", pageEntityObject.get("amountfield" + suffix));
                    ruleObject.set("absolute", pageEntityObject.get("absolute" + suffix));
                    ruleObject.set("datatype", pageEntityObject.get("datatype" + suffix));
                    ruleObject.set("datadirection", pageEntityObject.get("datadirection" + suffix));
                    ruleObject.set("filtercondition", this.emptyStr(pageEntityObject.getString("filtercondition" + suffix)));
                    ruleObject.set("conditionjson", this.emptyStr(pageEntityObject.getString("conditionjson" + suffix)));
                    ruleObject.set("advancedconf", this.emptyStr(pageEntityObject.getString("advancedconf" + suffix)));
                    ruleObject.set("advancedconfjson", this.emptyStr(pageEntityObject.getString("advancedconfjson" + suffix)));
                    ruleObject.set("vatrate", this.emptyStr(pageEntityObject.getString("vatrate" + suffix)));
                    ruleObject.set("exratejson", this.emptyStr(pageEntityObject.getString("exratejson" + suffix)));
                    continue;
                }
                args.setCancel(true);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u8bf7\u6309\u8981\u6c42\u586b\u5199\u53d6\u6570\u89c4\u5219\u914d\u7f6e", (String)"DynamicTccitRuleEditPlugin_8", (String)"taxc-tccit", (Object[])new Object[0]), this.getModel().getValue("number")));
            }
        }
    }

    private Object emptyStr(String cs) {
        if (StringUtil.isEmpty((CharSequence)cs)) {
            return SPACE_STRING;
        }
        return cs;
    }

    private void clearOldEntry(String oldItem) {
        List<DynamicYearRuleEnum> ruleTypes = DynamicRuleTypeConstantUtils.getRuleTypes(String.valueOf(this.getModel().getValue(RULE_TYPE)), oldItem);
        if (ruleTypes != null) {
            for (DynamicYearRuleEnum ruleEnum : ruleTypes) {
                String suffix = ruleEnum.getMetadatasuffix();
                this.getModel().deleteEntryData("entryentity" + suffix);
                int newEntryRow = this.getModel().createNewEntryRow("entryentity" + suffix);
                this.getModel().getEntryRowEntity("entryentity" + suffix, newEntryRow);
                this.getView().updateView("entryentity" + suffix);
            }
        }
    }

    private void showEntryByItemType(String item) {
        String orgid = Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(s -> s.getString("id")).orElseGet(() -> "0");
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_PANEL_PREFIX});
        this.getView().setVisible(Boolean.FALSE, DynamicRuleTypeConstantUtils.getDynamicEntryPanel());
        List<DynamicYearRuleEnum> projectTypes = DynamicRuleTypeConstantUtils.getRuleTypes(String.valueOf(this.getModel().getValue(RULE_TYPE)), item);
        if (projectTypes != null) {
            String[] panels = projectTypes.stream().map(v -> FLEX_PANEL_PREFIX + v.getMetadatasuffix()).collect(Collectors.toList()).toArray(new String[0]);
            if (panels != null) {
                this.getView().setVisible(Boolean.TRUE, panels);
            }
            for (DynamicYearRuleEnum ruleEnum : projectTypes) {
                HashMap<String, LocaleString> map = new HashMap<String, LocaleString>();
                map.put("text", new LocaleString(ResManager.loadKDString((String)ruleEnum.getTitledefault(), (String)ruleEnum.getTitlekey(), (String)"taxc-tccit", (Object[])new Object[0])));
                this.getView().updateControlMetadata(FLEX_PANEL_PREFIX + ruleEnum.getMetadatasuffix(), map);
                if (ruleEnum.getTipKey() == null) continue;
                this.addTips(item, orgid, ruleEnum);
            }
        }
    }

    private void addTips(String item, String orgid, DynamicYearRuleEnum ruleEnum) {
        Boolean flag = project1.contains(item) ? this.createTip(ruleEnum.getTipKey(), RuleTipEnum.TIP6) : (project2.contains(item) ? this.createTip(ruleEnum.getTipKey(), RuleTipEnum.TIP7) : ("DynamicTccitRuleEditPlugin_7".equals(item) && ASSETS_ENTRY_NAME.contains((Object)ruleEnum) ? (TaxMainInfoService.codes.contains(TaxMainInfoService.getCode(orgid)) ? this.createTip(ruleEnum.getTipKey(), RuleTipEnum.TIP6) : this.createTip(ruleEnum.getTipKey(), RuleTipEnum.TIP7)) : this.createTip(ruleEnum.getTipKey(), RuleTipEnum.get(ruleEnum.getProjecttype()))));
        if (flag.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{ruleEnum.getTipKey()});
        }
    }

    Boolean createTip(String key, RuleTipEnum tip) {
        if (tip == null) {
            return Boolean.FALSE;
        }
        Label text = (Label)this.getControl(key);
        Tips tips = new Tips();
        tips.setTitle(new LocaleString(tip.getTitle()));
        tips.setContent(new LocaleString(tip.getContent()));
        tips.setType("text");
        text.addTips(tips);
        return Boolean.TRUE;
    }

    private boolean isOpenDynamicEntry(Object item) {
        String name = String.valueOf(item == null ? "" : ((DynamicObject)item).get("number"));
        return DynamicRuleTypeConstantUtils.getRuleTypes(String.valueOf(this.getModel().getValue(RULE_TYPE)), name) != null;
    }

    private void showInitEntry() {
        if (RULE_TYPE_DSALE.equals(String.valueOf(this.getModel().getValue(RULE_TYPE)))) {
            this.showEntryByItemType("dsale_default");
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_PANEL_PREFIX});
            this.getView().setVisible(Boolean.FALSE, DynamicRuleTypeConstantUtils.getDynamicEntryPanel());
        }
    }

    private Boolean hasNullFields(DynamicObject rule, String suffix) {
        for (String s : FIELDS_NONULL) {
            if (rule.get(s + suffix) != null) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void handleData(BasedataFuzzySearchEvent basedataFuzzySearchEvent) {
        basedataFuzzySearchEvent.getQueryData().clear();
    }
}

