/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.year.rule;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.db.DynamicObjectUtils;
import kd.taxc.bdtaxr.common.enums.DataType;
import kd.taxc.bdtaxr.common.taxdeclare.dto.AdvanceConfDto;
import kd.taxc.bdtaxr.common.taxdeclare.ruleconfig.RuleTemplateService;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.rule.CustomDataSourceService;
import kd.taxc.tccit.common.enums.DynamicYearRuleEnum;
import kd.taxc.tccit.common.enums.RuleAmountFieldEnum;
import kd.taxc.tccit.common.utils.DynamicRuleTypeConstantUtils;
import kd.taxc.tccit.common.utils.RuleItemUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RuleTemplateFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String KEY_FILTERCONDITION = "filtercondition";
    private static final String KEY_CONDITIONJSON = "conditionjson";
    private static final String ENTRY_ENTITY_KEY = "entryentity";
    private static final Map<String, String> formToBillMap = new LinkedHashMap<String, String>();
    private static final Map<String, String[]> billEntitySuffix = new LinkedHashMap<String, String[]>();
    private static final String[] DISABLEBUTTON = new String[]{"name", "item", "entryentity"};
    private static final String[] INVISABLEBUTTON = new String[]{"bar_disable", "bar_save"};
    private static final String PROFIT_ITEM_CODE = "110";
    private static final String CJQRCZ = "cjqrcz";
    private static final String SWQRCZ = "swqrcz";

    public void initialize() {
        String parentform = this.getView().getFormShowParameter().getParentFormId();
        if (null != parentform && "tccit_n_rule_query".equals(parentform)) {
            this.getView().setEnable(Boolean.valueOf(false), DISABLEBUTTON);
            this.getView().setVisible(Boolean.valueOf(false), INVISABLEBUTTON);
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit item = (BasedataEdit)this.getControl("item");
        item.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        String[] entitys = this.getBillEntitys();
        if (entitys != null) {
            for (String entitySuffix : entitys) {
                BasedataEdit amountfield = (BasedataEdit)this.getControl("amountfield" + entitySuffix);
                amountfield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
                BasedataEdit tablefield = (BasedataEdit)this.getControl("table" + entitySuffix);
                tablefield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
        }
    }

    private String[] getBillEntitys() {
        String currentPage = this.getModel().getDataEntityType().getName();
        String entityName = formToBillMap.get(currentPage);
        return billEntitySuffix.get(entityName);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get("orgid");
        this.getModel().setValue("org", orgid);
        if ("ssyh".equals(customParams.get("type"))) {
            this.getModel().setValue("itemtype", (Object)"tpo_discount_tree");
        } else {
            this.getModel().setValue("itemtype", (Object)"tpo_yearitems_tree");
        }
        Object ruletype = customParams.get("ruletype");
        if (null == ruletype) {
            this.getModel().setValue("ruletype", (Object)"private");
        } else {
            this.getModel().setValue("ruletype", ruletype);
        }
        this.initBtnStatus(customParams);
    }

    public void loadData(LoadDataEventArgs e) {
        super.loadData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String ruledetail = customParams.getOrDefault("ruledetail", "");
        if (StringUtils.isNotBlank((CharSequence)ruledetail)) {
            Boolean iscopy;
            String formId = ((BillModel)e.getSource()).getDataEntityType().getName();
            DynamicObject obj = DynamicObjectUtils.serializeToDataEntity((String)ruledetail, (String)formId);
            String operateSource = customParams.getOrDefault("operateSource", "");
            if ("tpo_rule".equals(operateSource) && (iscopy = customParams.getOrDefault("iscopy", Boolean.FALSE)).booleanValue()) {
                String number = CodeRuleServiceHelper.getNumber((String)formId, (DynamicObject)obj, (String)obj.getString("org.id"));
                obj.set("number", (Object)number);
                obj.set("ruletype", (Object)"private");
            }
            e.setDataEntity(obj);
        }
        this.initBtnStatus(customParams);
    }

    private void initBtnStatus(Map<String, Object> customParams) {
        String operation = (String)customParams.get("operateType");
        String ruledetail = (String)customParams.getOrDefault("ruledetail", "");
        if ("addSysRule".equals(operation)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            if ("addSysRule".equals(operation)) {
                try {
                    this.getModel().setValue("ruletype", (Object)"private");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!"addSysRule".equals(operation) && StringUtils.isNotBlank((CharSequence)ruledetail)) {
            Boolean iscopy = (Boolean)customParams.getOrDefault("iscopy", Boolean.FALSE);
            if (iscopy.booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_disable", "saverule"});
            }
        }
        if (!"addSysRule".equals(operation) && StringUtils.isBlank((CharSequence)ruledetail)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"saverule"});
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"saverule"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing) {
            String key;
            String entitySuffix = key = ((Donothing)args.getSource()).getOperateKey();
            if (!key.startsWith("setting") && !key.startsWith("setadvancedconf")) {
                return;
            }
            if (key.startsWith("setting")) {
                entitySuffix = entitySuffix.replace("setting", "");
            }
            if (key.startsWith("setadvancedconf")) {
                entitySuffix = entitySuffix.replace("setadvancedconf", "");
            }
            EntryGrid entryentity = (EntryGrid)this.getControl(ENTRY_ENTITY_KEY + entitySuffix);
            int focusRow = entryentity.getEntryState().getFocusRow();
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table" + entitySuffix, focusRow);
            if (tabletype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"RuleTemplateFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (key.startsWith("setting")) {
                String itemNumber;
                RuleAmountFieldEnum ruleAmountFieldEnum;
                String ischild = tabletype.getString("ischild");
                String entityNumber = tabletype.getString("name");
                if ("false".equals(ischild) && StringUtil.isNotBlank((CharSequence)tabletype.getString("subname"))) {
                    entityNumber = tabletype.getString("subname");
                }
                String type = String.valueOf(this.getModel().getValue("type"));
                String number = this.getModel().getValue("item") != null ? ((DynamicObject)this.getModel().getValue("item")).getString("number") : "";
                int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY_KEY + entitySuffix);
                String projecttype = "";
                if (StringUtil.isNotEmpty((CharSequence)entitySuffix)) {
                    List<DynamicYearRuleEnum> ruleTypes = DynamicRuleTypeConstantUtils.getRuleTypes(type, number);
                    if (CollectionUtils.isNotEmpty(ruleTypes)) {
                        String entitySuffix1 = entitySuffix;
                        projecttype = ruleTypes.stream().filter(s -> s.getMetadatasuffix().equals(entitySuffix1)).findFirst().get().getProjecttype();
                    }
                } else {
                    projecttype = (String)this.getModel().getValue("projecttype" + entitySuffix, rowIndex);
                }
                String ruleCode = RuleItemUtils.getRuleCode(type, number, projecttype);
                DynamicObject item = (DynamicObject)this.getModel().getValue("item");
                String filterName = "";
                if (item != null && (ruleAmountFieldEnum = RuleAmountFieldEnum.byItemNumberAndEntry(itemNumber = item.getString("number"), entityNumber)) != null) {
                    filterName = ruleAmountFieldEnum.getFilterName();
                }
                this.openSettingPage(focusRow, tabletype.getLong("id"), entityNumber, ENTRY_ENTITY_KEY + entitySuffix, KEY_CONDITIONJSON + entitySuffix, "setting" + entitySuffix, entitySuffix, ruleCode, filterName);
            }
            if (key.startsWith("setadvancedconf")) {
                DynamicObject amountfield = (DynamicObject)this.getModel().getValue("amountfield" + entitySuffix, focusRow);
                long tableEntityId = tabletype.getLong("id");
                String advancedconfjson = (String)this.getModel().getValue("advancedconfjson" + entitySuffix, focusRow);
                String datatype = (String)this.getModel().getValue("datatype" + entitySuffix, focusRow);
                BigDecimal vatrate = (BigDecimal)this.getModel().getValue("vatrate" + entitySuffix, focusRow);
                AdvanceConfDto advanceConfDto = new AdvanceConfDto(advancedconfjson, datatype, vatrate);
                String exratejson = (String)this.getModel().getValue("exratejson" + entitySuffix, focusRow);
                advanceConfDto.setConvertExrateJson(exratejson);
                RuleTemplateService.operationConfigClick((AdvanceConfDto)advanceConfDto, (BeforeDoOperationEventArgs)args, (EntryGrid)entryentity, (DynamicObject)amountfield, (Long)tableEntityId, (IFormView)this.getView(), (int)focusRow, (String)(ENTRY_ENTITY_KEY + entitySuffix), (IFormPlugin)this);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (operateKey.equals("saverule")) {
            DynamicObject ruleObject = this.getModel().getDataEntity(true);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            RuleTemplateService.saveRule((DynamicObject)ruleObject, (Map)customParams);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"YearBranchPolicyEdit_0", (String)"taxc-tccit", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        int currentRowIndex;
        Map filterData;
        String entitySuffix;
        String key;
        super.closedCallBack(evt);
        if (evt.getActionId().startsWith("setting")) {
            key = evt.getActionId();
            entitySuffix = key.replace("setting", "");
            filterData = (Map)evt.getReturnData();
            if (filterData != null) {
                currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY_KEY + entitySuffix);
                this.getModel().setValue(KEY_FILTERCONDITION + entitySuffix, filterData.get("filterdescription"), currentRowIndex);
                this.getModel().setValue(KEY_CONDITIONJSON + entitySuffix, filterData.get("filtervalue"), currentRowIndex);
            }
        }
        if (evt.getActionId().startsWith("setadvancedconf")) {
            key = evt.getActionId();
            entitySuffix = key.replace("setadvancedconf", "");
            filterData = (Map)evt.getReturnData();
            if (filterData != null) {
                currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY_KEY + entitySuffix);
                this.getModel().setValue("advancedconf" + entitySuffix, filterData.get("advancedconf"), currentRowIndex);
                this.getModel().setValue("advancedconfjson" + entitySuffix, filterData.get("advancedconfjson"), currentRowIndex);
                this.getModel().setValue("vatrate" + entitySuffix, filterData.get("vatrate"), currentRowIndex);
                this.getModel().setValue("exratejson" + entitySuffix, filterData.get("convert_rate_json"), currentRowIndex);
            }
        }
    }

    protected void openSettingPage(int rowIndex, long entityId, String entityNumber, String entityfield, String conditionjson, String actionId, String entitySuffix, String ruleCode, String filterName) {
        String ruleType;
        DynamicObject selectedRow = this.getModel().getEntryRowEntity(entityfield, rowIndex);
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("bdtaxr_filtercondition");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.setCustomParam("entityId", (Object)entityId);
        formshowParameter.setCustomParam("entityNumber", (Object)entityNumber);
        formshowParameter.setCustomParam("filterJson", selectedRow.get(conditionjson));
        formshowParameter.setCustomParam("description", selectedRow.get(KEY_FILTERCONDITION + entitySuffix));
        formshowParameter.setCustomParam("ruleCode", (Object)ruleCode);
        if (StringUtil.isNotEmpty((CharSequence)filterName)) {
            formshowParameter.setCustomParam("filterName", (Object)filterName);
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String string = ruleType = this.getModel().getDataEntityType().getProperties().containsKey((Object)"ruletype") ? (String)this.getModel().getValue("ruletype") : (String)this.getView().getFormShowParameter().getCustomParams().get("ruletype");
        if (null != ruleType) {
            formshowParameter.setCustomParam("ruletype", (Object)ruleType);
        }
        if (org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"RuleTemplateFormPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        formshowParameter.setCustomParam("orgid", (Object)org.getString("id"));
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        if (evt.getProperty().getName().startsWith("amountfield")) {
            DynamicObject taxation;
            key = evt.getProperty().getName();
            String suffix = key.replace("amountfield", "");
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY_KEY + suffix);
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table" + suffix, rowIndex);
            if (tabletype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"RuleTemplateFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter id = new QFilter("tableid", "=", tabletype.get("id"));
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(id);
            String currentPage = this.getModel().getDataEntityType().getName();
            String entityName = formToBillMap.get(currentPage);
            if (RuleTypeEnum.REDUCE.getEntry().equals(entityName) && "tdm_balance_new".equals(tabletype.get("name"))) {
                QFilter fieldFilter = new QFilter("fieldname", "=", (Object)"debitlocalcurrency").or(new QFilter("fieldname", "=", (Object)"creditlocalcurrency"));
                formShowParameter.getListFilterParameter().setFilter(fieldFilter);
            }
            if (RuleTypeEnum.INCOME.getEntry().equals(entityName) && null != (taxation = (DynamicObject)this.getModel().getValue("taxation")) && taxation.getString("number").equals("MS") && "tdm_balance_new".equals(tabletype.get("name"))) {
                QFilter fieldFilter = new QFilter("fieldname", "=", (Object)"debitlocalcurrency").or(new QFilter("fieldname", "=", (Object)"creditlocalcurrency"));
                formShowParameter.getListFilterParameter().setFilter(fieldFilter);
            }
            String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
            String entryName = tabletype.get("name").toString();
            DynamicObject item = (DynamicObject)this.getModel().getValue("item");
            if (item != null) {
                String itemNumber = item.getString("number");
                RuleAmountFieldEnum ruleAmountFieldEnum = RuleAmountFieldEnum.byItemNumberAndEntry(itemNumber, entryName);
                if (ruleAmountFieldEnum != null) {
                    QFilter fieldFilter = new QFilter("fieldname", "in", ruleAmountFieldEnum.getAmountFieldList());
                    formShowParameter.getListFilterParameter().setFilter(fieldFilter);
                } else if ("srajust".equals(type) && "tccit_invest_dispose".equals(entryName)) {
                    QFilter fieldFilter = new QFilter("fieldname", "in", (Object)Lists.newArrayList((Object[])new String[]{"czzczmjz", "czsyzjjrbnsyje", "zcczsr", "jsjc", "ssje", "tsxswclssje"}));
                    formShowParameter.getListFilterParameter().setFilter(fieldFilter);
                } else if ("zcajust".equals(type) && "tccit_invest_dispose".equals(entryName)) {
                    QFilter fieldFilter = new QFilter("fieldname", "in", (Object)Lists.newArrayList((Object[])new String[]{"czzczmjz", "czsyzjjrbnsyje", "czsszbjhxje", "zcczsr", "pcsr", "jsjc", "ssje"}));
                    formShowParameter.getListFilterParameter().setFilter(fieldFilter);
                }
            }
        }
        if (evt.getProperty().getName().startsWith("table")) {
            key = evt.getProperty().getName();
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null) {
                formShowParameter.setUseOrgId(org.getLong("id"));
            }
            String type = String.valueOf(this.getModel().getValue("type"));
            String number = this.getModel().getValue("item") != null ? ((DynamicObject)this.getModel().getValue("item")).getString("number") : "";
            String suffix = key.replace("table", "");
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY_KEY + suffix);
            String projecttype = "";
            if (StringUtil.isNotEmpty((CharSequence)suffix)) {
                List<DynamicYearRuleEnum> ruleTypes = DynamicRuleTypeConstantUtils.getRuleTypes(type, number);
                if (CollectionUtils.isNotEmpty(ruleTypes)) {
                    projecttype = ruleTypes.stream().filter(s -> s.getMetadatasuffix().equals(suffix)).findFirst().get().getProjecttype();
                }
            } else {
                projecttype = (String)this.getModel().getValue("projecttype" + suffix, rowIndex);
            }
            String ruleCode = RuleItemUtils.getRuleCode(type, number, projecttype);
            QFilter filter = new QFilter("basedataid.billno", "=", (Object)ruleCode);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_datasource_pkrules", (String)"id", (QFilter[])new QFilter[]{filter});
            List<Long> excludeDataSouce = this.excludeDataSouce(ruleCode, projecttype, number);
            collection.removeIf(s -> excludeDataSouce.contains(s.getLong("id")));
            formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", collection.stream().map(e -> e.getLong("id")).collect(Collectors.toList())));
        }
        if ("item".equals(evt.getProperty().getName())) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            Date now = new Date();
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("isleaf", "=", (Object)"1"));
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("template", "=", (Object)"qysdsnb"));
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("start", "<=", (Object)now));
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("end", ">=", (Object)now).or(new QFilter("end", "is null", null)));
            if ("ssyh".equals(this.getModel().getValue("type"))) {
                formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("type", "=", (Object)"ssyh"));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String eventName = e.getProperty().getName();
        if (eventName.startsWith("table")) {
            ChangeData[] changeSet = e.getChangeSet();
            Object newValue = changeSet[0].getNewValue();
            Object oldValue = changeSet[0].getOldValue();
            String suffix = eventName.replace("table", "");
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY_KEY + suffix);
            this.getModel().setValue("amountfield" + suffix, null, rowIndex);
            Long id = Optional.ofNullable((DynamicObject)newValue).map(s -> s.getLong("id")).orElseGet(() -> 0L);
            if (CustomDataSourceService.isRdesdGxqyyhmx(id)) {
                this.getModel().setValue("amountfield" + suffix, (Object)CustomDataSourceService.getAmountFieldOfValueWithId(id, "value"), rowIndex);
                this.getModel().setValue(KEY_FILTERCONDITION + suffix, null, rowIndex);
                this.getModel().setValue(KEY_CONDITIONJSON + suffix, null, rowIndex);
            } else if (CustomDataSourceService.isRdesdyhmx(id)) {
                String type = String.valueOf(this.getModel().getValue("type"));
                String number = this.getModel().getValue("item") != null ? ((DynamicObject)this.getModel().getValue("item")).getString("number") : "";
                DynamicYearRuleEnum yearRuleEnum = this.getYearRuleEnum(suffix, type, number);
                this.getModel().setValue("amountfield" + suffix, (Object)CustomDataSourceService.getAmountFieldOfValueWithId(id, "value"), rowIndex);
                if (yearRuleEnum != null && yearRuleEnum.getMapperValue() != null) {
                    String defaultFilterJson = this.getDefaultFilterJson(yearRuleEnum.getMapperValue(), "yhmxb_je");
                    String defaultFilterCondition = this.getFiltercondition(yearRuleEnum.getMapperValue(), "yhmxb_je");
                    this.getModel().setValue(KEY_FILTERCONDITION + suffix, (Object)defaultFilterCondition, rowIndex);
                    this.getModel().setValue(KEY_CONDITIONJSON + suffix, (Object)defaultFilterJson, rowIndex);
                } else {
                    this.getModel().setValue(KEY_FILTERCONDITION + suffix, null, rowIndex);
                    this.getModel().setValue(KEY_CONDITIONJSON + suffix, null, rowIndex);
                }
            } else if (CustomDataSourceService.isXswwg(id) || CustomDataSourceService.iszhdXswwg(id)) {
                String number = this.getModel().getValue("item") != null ? ((DynamicObject)this.getModel().getValue("item")).getString("number") : "";
                this.getModel().setValue("amountfield" + suffix, (Object)CustomDataSourceService.getAmountFieldOfValueWithId(id, CustomDataSourceService.getDatasourceOfDefaultFieldMapping(number).get(eventName)), rowIndex);
                this.getModel().setValue(KEY_FILTERCONDITION + suffix, null, rowIndex);
                this.getModel().setValue(KEY_CONDITIONJSON + suffix, null, rowIndex);
            } else {
                this.getModel().setValue(KEY_FILTERCONDITION + suffix, null, rowIndex);
                this.getModel().setValue(KEY_CONDITIONJSON + suffix, null, rowIndex);
            }
            this.getModel().setValue("absolute" + suffix, (Object)Boolean.FALSE, rowIndex);
        } else if (eventName.startsWith("amountfield")) {
            String suffix = eventName.replace("amountfield", "");
            DynamicObject changeAmount = (DynamicObject)e.getChangeSet()[0].getNewValue();
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY_KEY + suffix);
            if (changeAmount == null) {
                return;
            }
            String amountValue = changeAmount.getString("fieldname");
            String table = changeAmount.getString("fieldsubname");
            BiPredicate<String, String> tdmBalance = RuleTemplateFormPlugin.predicate("tdm_balance_new", Lists.newArrayList((Object[])new String[]{"closinglocalcurrency", "openinglocalcurrency"}));
            BiPredicate<String, String> glBalance = RuleTemplateFormPlugin.predicate("gl_balance", Lists.newArrayList((Object[])new String[]{"beginlocal", "endlocal"}));
            if (tdmBalance.test(table, amountValue) || glBalance.test(table, amountValue)) {
                this.getModel().setValue("absolute" + suffix, (Object)Boolean.TRUE, rowIndex);
            } else {
                this.getModel().setValue("absolute" + suffix, (Object)Boolean.FALSE, rowIndex);
            }
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table" + suffix, rowIndex);
            DynamicObject amountfield = (DynamicObject)this.getModel().getValue("amountfield" + suffix, rowIndex);
            RuleTemplateService.setAdvanceConfDefaultValue((IDataModel)this.getModel(), (int)rowIndex, (DynamicObject)tabletype, (DynamicObject)amountfield, (String)("advancedconf" + suffix), (String)("advancedconfjson" + suffix));
        } else if ("item".equals(eventName)) {
            this.buildComboItems();
            ChangeData changeData = e.getChangeSet()[0];
            DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
            if (oldValue != null && oldValue.getString("number").equals("8010501")) {
                String[] suffixs;
                for (String suffix : suffixs = billEntitySuffix.get("tccit_year_rule")) {
                    int rowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY_KEY + suffix);
                    for (int i = 0; i < rowCount; ++i) {
                        this.getModel().setValue("datatype" + suffix, (Object)DataType.ZJQS.getCode(), i);
                    }
                }
            }
        } else if (eventName.startsWith("datatype")) {
            String suffix = eventName.replace("datatype", "");
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY_KEY + suffix);
            BigDecimal vatrate = BigDecimal.ZERO;
            String datatype = (String)e.getChangeSet()[0].getNewValue();
            if (!datatype.equals("jsflqs") && !datatype.equals("cysldsqs")) {
                this.getModel().setValue("vatrate" + suffix, (Object)vatrate, rowIndex);
            }
        }
    }

    private DynamicYearRuleEnum getYearRuleEnum(String suffix, String type, String number) {
        List<DynamicYearRuleEnum> ruleTypes;
        if (StringUtil.isNotEmpty((CharSequence)suffix) && CollectionUtils.isNotEmpty(ruleTypes = DynamicRuleTypeConstantUtils.getRuleTypes(type, number))) {
            return ruleTypes.stream().filter(s -> s.getMetadatasuffix().equals(suffix)).findFirst().get();
        }
        return null;
    }

    private String getDefaultFilterJson(String rowNumber, String columnNumber) {
        FilterCondition filterCondition = new FilterCondition();
        ArrayList<SimpleFilterRow> filteList = new ArrayList<SimpleFilterRow>(2);
        FilterValue rowFilterValue = new FilterValue();
        rowFilterValue.setValue((Object)rowNumber);
        FilterValue colFilterValue = new FilterValue();
        colFilterValue.setValue((Object)columnNumber);
        filteList.add(new SimpleFilterRow("", "67", "row.number", "", "0", Collections.singletonList(rowFilterValue)));
        filteList.add(new SimpleFilterRow("", "67", "column.number", "", "0", Collections.singletonList(colFilterValue)));
        filterCondition.setFilterRow(filteList);
        String modelType = "DynamicFormModel";
        DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)modelType, (boolean)false));
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
        binder.setWriteInheritFlag(true);
        Map filterConditionMap = ser.serializeToMap((Object)filterCondition, null);
        String filterJson = SerializationUtils.toJsonString((Object)filterConditionMap);
        return filterJson;
    }

    public String getFiltercondition(String rowNumber, String columnNumber) {
        return String.format(ResManager.loadKDString((String)"\u884c\u7ef4.\u7f16\u7801 \u7b49\u4e8e %1$s \u5e76\u4e14 \u5217\u7ef4.\u7f16\u7801 \u7b49\u4e8e %2$s", (String)"RuleTemplateFormPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]), rowNumber, columnNumber);
    }

    public void afterBindData(EventObject e) {
        this.buildComboItems();
    }

    private void buildComboItems() {
        String[] suffixs;
        DynamicObject item = (DynamicObject)this.getModel().getValue("item");
        for (String suffix : suffixs = billEntitySuffix.get("tccit_year_rule")) {
            ComboEdit datatype = (ComboEdit)this.getControl("datatype" + suffix);
            if (item != null && "8010501".equals(item.getString("number"))) {
                datatype.setComboItems(DataType.buildDataType(Arrays.asList(DataType.ZJQS, DataType.JSFLQS, DataType.CYSLDSQS)));
                continue;
            }
            datatype.setComboItems(DataType.buildDataType(Collections.singletonList(DataType.ZJQS)));
        }
    }

    private static BiPredicate<String, String> predicate(String table, List<String> columns) {
        BiPredicate<String, String> predicate = (table1, amountValue1) -> table.equals(table1) && columns.contains(amountValue1);
        return predicate;
    }

    private List<Long> excludeDataSouce(String ruleCode, String projecttype, String number) {
        if ("RULE-CIT-HJ-SRTZ-TZZCCZSY".equals(ruleCode) && (CJQRCZ.equals(projecttype) || SWQRCZ.equals(projecttype))) {
            return CustomDataSourceService.query(new QFilter[]{new QFilter("entityname", "=", (Object)"tccit_new_invest_asset")});
        }
        if ("RULE-CIT-HJ-KCTZ-JZZC".equals(ruleCode)) {
            return CustomDataSourceService.query(new QFilter[]{new QFilter("entityname", "=", (Object)"tccit_gyxjz_acc")});
        }
        if ("RULE-CIT-HJ-TSSX-FDCTDYWNSTZ".equals(ruleCode) && ("8010501".equals(number) || "8010502".equals(number))) {
            boolean isxswwg = Lists.newArrayList((Object[])new String[]{DynamicYearRuleEnum.XSWSGCPSR.getProjecttype(), DynamicYearRuleEnum.XSWWGCPYJMLE.getProjecttype(), DynamicYearRuleEnum.SJFSDYYSJJFJTDZZS.getProjecttype()}).contains(projecttype);
            QFilter filter = isxswwg ? new QFilter("subname", "=", (Object)"entryentity1") : new QFilter("subname", "=", (Object)ENTRY_ENTITY_KEY);
            return CustomDataSourceService.query(new QFilter[]{filter});
        }
        if ("RULE-CIT-HJ-SRCB".equals(ruleCode) && !PROFIT_ITEM_CODE.equals(number)) {
            return CustomDataSourceService.query(new QFilter[]{new QFilter("subname", "=", (Object)"tdm_finance_hblrb")});
        }
        if ("RULE-CIT-HJ-KCTZ-YJSXF".equals(ruleCode) && "3010601".equals(number)) {
            return CustomDataSourceService.query(new QFilter[]{new QFilter("entityname", "=", (Object)"tccit_commissions_fees")});
        }
        return Lists.newArrayList();
    }

    static {
        formToBillMap.put("tccit_year_rule", "tccit_year_rule");
        billEntitySuffix.put("tccit_year_rule", new String[]{"", "1", "2", "3", "4", "5", "6", "7", "8", "9"});
    }
}

