/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.year.rule;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.tree.SearchUtil;

public class TccitRuleConfigPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TabSelectListener,
SearchEnterListener {
    private static Log logger = LogFactory.getLog(TccitRuleConfigPlugin.class);
    private static String TREE_ORG = "treeviewap";
    private static final String CURRENT_NODE = "CURRENT_NODE";
    private static final String CURRENT_TEMP_NODE = "CURRENT_TEMP_NODE";
    private static final String CURRENT_TAB = "CURRENT_TAB";
    private static final String SEARCH_TEXT = "searchtext";

    public void initialize() {
        TreeView tree = (TreeView)this.getView().getControl(TREE_ORG);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search searchap = (Search)this.getControl("searchap");
        searchap.addEnterListener((SearchEnterListener)this);
    }

    public void registerListener(EventObject e) {
        Search sl = (Search)this.getControl("entitysearchap");
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        TreeView treeView = (TreeView)this.getControl(TREE_ORG);
        sl.addEnterListener(event -> {
            if (event.getText() != null && !"".equals(event.getText())) {
                SearchUtil.searchMember((String)event.getText().toLowerCase().trim(), (boolean)false, (IFormView)view, (IPageCache)pageCache, (TreeView)treeView, (String)TREE_ORG);
            } else {
                this.getPageCache().put("_resultlist", null);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e", (String)"TccitRuleConfigPlugin_10", (String)"taxc-tccit", (Object[])new Object[0]));
            }
        });
        this.addItemClickListeners(new String[]{"toolbarap"});
        Tab tabap = (Tab)this.getControl("tabap");
        tabap.addTabSelectListener((TabSelectListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("refresh".equals(itemKey)) {
            this.refreshData();
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.refreshData();
    }

    private void refreshData() {
        TreeView treeView = (TreeView)this.getView().getControl(TREE_ORG);
        treeView.deleteAllNodes();
        IFormView view = this.getView();
        IPageCache cache = this.getPageCache();
        OrgUtils.buildOrgTree((IFormView)view, (TreeView)treeView, (IPageCache)cache);
        this.checkNode(treeView, cache);
    }

    private void loadrule(String type) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("type", type);
        customParams.put("ruletype", this.getView().getFormShowParameter().getCustomParam("ruletype"));
        customParams.put("orgid", this.getPageCache().get(CURRENT_NODE));
        customParams.put(SEARCH_TEXT, this.getPageCache().get(SEARCH_TEXT));
        PageShowCommon.showForm((String)type, (String)"tccit_year_rule_entry", (IFormView)this.getView(), customParams);
    }

    private void checkNode(TreeView treeView, IPageCache cache) {
        String status;
        Object orgid = this.getView().getFormShowParameter().getCustomParam("orgid");
        if (orgid != null) {
            TreeUtils.checkNode((IPageCache)cache, (TreeView)treeView, (String)String.valueOf(orgid));
            return;
        }
        if (cache.get(CURRENT_NODE) != null && "1".equals(status = OrgUtils.getOrgStatusById((String)cache.get(CURRENT_NODE))) && ((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)Long.valueOf(cache.get(CURRENT_NODE))).getData()).booleanValue()) {
            TreeUtils.checkNode((IPageCache)cache, (TreeView)treeView, (String)cache.get(CURRENT_NODE));
            return;
        }
        DynamicObject org = null;
        try {
            org = (DynamicObject)this.getView().getParentView().getModel().getValue("org");
        }
        catch (Exception ee) {
            org = null;
            logger.error("\u83b7\u53d6\u7ec4\u7ec7\u5f02\u5e38", (Throwable)ee);
        }
        if (org != null && "1".equals(org.getString("enable")) && ((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).getData()).booleanValue()) {
            TreeUtils.checkNode((IPageCache)cache, (TreeView)treeView, (String)org.getString("id"));
        } else {
            TreeUtils.checkFirstNode((IPageCache)cache, (TreeView)treeView);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("searchbefore".equals(key) || "searchnext".equals(key)) {
            String[] btns = new String[]{"searchbefore", "searchnext"};
            SearchUtil.getLeftOrRight((IPageCache)this.getPageCache(), (IFormView)this.getView(), (String)key, (TreeView)((TreeView)this.getControl(TREE_ORG)), (String[])btns, (String)TREE_ORG);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        IPageCache pageCache = this.getPageCache();
        String current = this.getPageCache().get(CURRENT_NODE);
        TreeView treeView = (TreeView)this.getControl(TREE_ORG);
        TreeNode treeNode = TreeUtils.getTreeNode((IPageCache)pageCache, (TreeView)treeView, (String)nodeId);
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        if (!hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains(Long.parseLong(nodeId))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TccitRuleConfigPlugin_4", (String)"taxc-tccit", (Object[])new Object[0]), treeNode.getText()));
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
            pageCache.put(CURRENT_TEMP_NODE, nodeId);
            this.loadrule("income");
            return;
        }
        String status = OrgUtils.getOrgStatusById((String)nodeId);
        if (!"1".equals(status)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ec4\u7ec7\u5c1a\u672a\u542f\u7528\uff0c\u5982\u9700\u64cd\u4f5c,\u8bf7\u524d\u5f80\u7a0e\u52a1\u4e91-\u57fa\u7840\u8d44\u6599-\u7ec4\u7ec7\u5217\u8868\u8fdb\u884c\u542f\u7528\u3002", (String)"TccitRuleConfigPlugin_5", (String)"taxc-tccit", (Object[])new Object[0]), treeNode.getText()));
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
            this.loadrule("income");
            return;
        }
        if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)Long.valueOf(nodeId)).getData()).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"TccitRuleConfigPlugin_6", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        if (OrgCheckUtil.withoutLicenseCheck((IFormView)this.getView(), (String)nodeId, (String)"tccit", (String)"qysds")) {
            TreeUtils.checkNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
            pageCache.put(CURRENT_TEMP_NODE, nodeId);
            this.loadrule("income");
            return;
        }
        pageCache.remove(CURRENT_TEMP_NODE);
        pageCache.put(CURRENT_NODE, nodeId);
        String tab = pageCache.get(CURRENT_TAB);
        if (null != tab) {
            this.loadrule(tab);
        } else {
            this.loadrule("income");
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        if (this.getPageCache().get(tabKey) == null) {
            this.loadrule(tabKey);
            this.getPageCache().put(CURRENT_TAB, tabKey);
        }
    }

    public void search(SearchEnterEvent evt) {
        this.getPageCache().put(SEARCH_TEXT, evt.getText());
        this.refreshData();
    }
}

