/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.formplugin.year.rule;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.form.ClientViewProxy;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tccit.business.rule.RuleService;
import org.apache.commons.collections.CollectionUtils;

public class TccitRuleSubFormPlugin
extends AbstractFormPlugin {
    public static final String RULE_ENTITY = "tccit_year_rule";
    private static final String ORG_ID = "orgid";
    private static final String SEARCH_TEXT = "searchtext";
    private static final String TYPE = "type";
    private static final String RULE_TYPE = "ruletype";
    private static final Set<String> clickKeys = new LinkedHashSet<String>(Arrays.asList("add", "up", "down", "label", "image", "cardentryflexpanelap", "cardentryflexpanelap2", "cardflexpanelap", "cardflexpanelap1", "cardflexpanelap2", "cardflexpanelap3", "labelap_discounttype", "modifydate_lable", "enable_lable", "disable_lable"));

    public void registerListener(EventObject e) {
        this.addClickListeners(clickKeys.toArray(new String[0]));
    }

    public void afterCreateNewData(EventObject e) {
        this.refreshData();
    }

    private void setBackgroundAndImage(int row, String ruletype) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>(16);
        HashMap<String, HashMap<String, String>> pmap = new HashMap<String, HashMap<String, String>>(16);
        if ("private".equals(ruletype)) {
            propertiesMap.put("bc", "#FFF2E9");
            propertiesMap.put("src", "/icons/pc/label/swy_zy_61_61.png");
        } else {
            propertiesMap.put("bc", "#E7F0FF");
            propertiesMap.put("src", "/icons/pc/label/swy_fp_61_61.png");
        }
        pmap.put("flex", propertiesMap);
        pmap.put("image", propertiesMap);
        ClientViewProxy client = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        client.invokeControlMethod("entryentity", "setCustomProperties", new Object[]{row, pmap});
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        if (RULE_ENTITY.equals(event.getActionId())) {
            this.refreshData();
        }
    }

    private void refreshData() {
        this.getModel().deleteEntryData("entryentity");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String searchText = (String)customParams.get(SEARCH_TEXT);
        Object orgId = customParams.get(ORG_ID);
        DynamicObjectCollection rules = RuleService.getYearRule(searchText, orgId != null ? Long.parseLong((String)orgId) : 0L, (String)customParams.get(TYPE), (String)customParams.get(RULE_TYPE));
        if (CollectionUtils.isNotEmpty((Collection)rules)) {
            int[] rows;
            this.getModel().beginInit();
            for (int row : rows = this.getModel().batchCreateNewEntryRow("entryentity", rules.size())) {
                DynamicObject rule = (DynamicObject)rules.get(row);
                this.getModel().setValue("itemtype", (Object)("ssyh".equals(customParams.get(TYPE)) ? "tpo_discount_tree" : "tpo_yearitems_tree"), row);
                this.getModel().setValue("ruleid", rule.get("id"), row);
                this.getModel().setValue("name", (Object)rule.getString("name"), row);
                this.getModel().setValue(RULE_TYPE, rule.get(RULE_TYPE), row);
                this.getModel().setValue("item", rule.get("item"), row);
                this.getModel().setValue("modifydate", rule.get("modifytime"), row);
                this.getModel().setValue("enable", rule.get("enable"), row);
                this.setBackgroundAndImage(row, rule.getString(RULE_TYPE));
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (clickKeys.contains(key)) {
            EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryentity.getSelectRows();
            String type = (String)this.getView().getFormShowParameter().getCustomParam(TYPE);
            if (selectRows != null && selectRows.length > 0) {
                this.openRuleForm(this.getModel().getValue("ruleid", selectRows[0]), type);
            } else {
                this.openRuleForm(null, type);
            }
        }
    }

    private void openRuleForm(Object pkid, String type) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgId = (String)customParams.get(ORG_ID);
        if (StringUtil.isEmpty((CharSequence)orgId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u5de6\u8fb9\u7ec4\u7ec7\u6811\u4e0a\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"TccitRuleSubFormPlugin_0", (String)"taxc-tccit", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId(RULE_ENTITY);
        if (pkid == null) {
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setBillStatus(BillOperationStatus.ADDNEW);
        } else {
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setBillStatus(BillOperationStatus.EDIT);
            showParameter.setPkId(pkid);
        }
        String caption = this.getCaptionByType(type);
        showParameter.setCaption(caption);
        showParameter.setCustomParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, RULE_ENTITY);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private String getCaptionByType(String type) {
        String caption = "income".equals(type) ? ResManager.loadKDString((String)"\u6536\u5165\u6210\u672c\u89c4\u5219", (String)"TccitRuleSubFormPlugin_1", (String)"taxc-tccit", (Object[])new Object[0]) : ("period".equals(type) ? ResManager.loadKDString((String)"\u671f\u95f4\u8d39\u7528\u89c4\u5219", (String)"TccitRuleSubFormPlugin_2", (String)"taxc-tccit", (Object[])new Object[0]) : ("ajust".equals(type) ? ResManager.loadKDString((String)"\u6263\u9664\u8c03\u6574\u89c4\u5219", (String)"TccitRuleSubFormPlugin_3", (String)"taxc-tccit", (Object[])new Object[0]) : ("dsale".equals(type) ? ResManager.loadKDString((String)"\u89c6\u540c\u9500\u552e\u89c4\u5219", (String)"TccitRuleSubFormPlugin_4", (String)"taxc-tccit", (Object[])new Object[0]) : ("srajust".equals(type) ? ResManager.loadKDString((String)"\u6536\u5165\u8c03\u6574\u89c4\u5219", (String)"TccitRuleSubFormPlugin_5", (String)"taxc-tccit", (Object[])new Object[0]) : ("zcajust".equals(type) ? ResManager.loadKDString((String)"\u8d44\u4ea7\u8c03\u6574\u89c4\u5219", (String)"TccitRuleSubFormPlugin_6", (String)"taxc-tccit", (Object[])new Object[0]) : ("tssx".equals(type) ? ResManager.loadKDString((String)"\u7279\u6b8a\u4e8b\u9879\u8c03\u6574\u89c4\u5219", (String)"TccitRuleSubFormPlugin_7", (String)"taxc-tccit", (Object[])new Object[0]) : ("ssyh".equals(type) ? ResManager.loadKDString((String)"\u7a0e\u6536\u4f18\u60e0\u89c4\u5219", (String)"TccitRuleSubFormPlugin_8", (String)"taxc-tccit", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5176\u4ed6\u8c03\u6574\u89c4\u5219", (String)"TccitRuleSubFormPlugin_9", (String)"taxc-tccit", (Object[])new Object[0]))))))));
        return caption;
    }
}

