/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.opplugin.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.bean.BeanCopyUtils;
import kd.taxc.tccit.common.enums.RuleTypeNodeEnum;

public class RuleDataSynOp
extends AbstractOperationServicePlugIn {
    public static final String TCCIT_ALL_RULE_CONFIG = "tccit_all_rule_config";

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        if ("disable".equals(operationKey) || "enable".equals(operationKey)) {
            DynamicObject[] dataEntities = e.getDataEntities();
            List ruleIds = Stream.of(dataEntities).map(dataEntity -> dataEntity.getLong("id")).collect(Collectors.toList());
            DynamicObject[] sbxRuleArray = BusinessDataServiceHelper.load((Object[])ruleIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TCCIT_ALL_RULE_CONFIG));
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(10);
            for (DynamicObject rule : sbxRuleArray) {
                rule.set("enable", (Object)e.getDataEntities()[0].getString("enable"));
                updateList.add(rule);
            }
            SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
        if ("save".equals(operationKey)) {
            DynamicObject dataEntity2 = e.getDataEntities()[0];
            Object pkValue = dataEntity2.getPkValue();
            String formId = e.getDataEntities()[0].getDataEntityType().getName();
            Long groupId = "tccit_year_rule".equals(formId) ? RuleTypeNodeEnum.getGroupId(formId, dataEntity2.getString("type")) : RuleTypeNodeEnum.getGroupId(formId);
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCCIT_ALL_RULE_CONFIG);
            BeanCopyUtils.copyDynamicObjectWithoutEntity((DynamicObject)e.getDataEntities()[0], (DynamicObject)dynamicObject);
            if (RuleTypeNodeEnum.PROFITS.getFormId().equals(formId)) {
                dynamicObject.set("itemtype", (Object)"tpo_yearitems_tree");
            }
            if (RuleTypeNodeEnum.PREFERENTIAL.getFormId().equals(formId)) {
                dynamicObject.set("item", (Object)dataEntity2.getDynamicObject("itemchoicename").getLong("id"));
                dynamicObject.set("itemtype", (Object)"tpo_discount_tree");
            }
            if (RuleTypeNodeEnum.DEPRECIATION.getFormId().equals(formId)) {
                dynamicObject.set("item", (Object)dataEntity2.getDynamicObject("depreciatetype").getLong("id"));
                dynamicObject.set("itemtype", (Object)"tpo_yearitems_tree");
            }
            if (RuleTypeNodeEnum.YJOTHER.getFormId().equals(formId)) {
                dynamicObject.set("itemtype", (Object)"tpo_yearitems_tree");
            }
            if (RuleTypeNodeEnum.STANDINGBOOK.getFormId().equals(formId)) {
                dynamicObject.set("item", (Object)dataEntity2.getDynamicObject("standingbooks").getLong("id"));
                dynamicObject.set("itemtype", (Object)"tpo_standingbook_tree");
            }
            dynamicObject.set("group", (Object)groupId);
            dynamicObject.set("issystem", (Object)"0");
            if (QueryServiceHelper.exists((String)TCCIT_ALL_RULE_CONFIG, (Object)pkValue)) {
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
                return;
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String operationKey = this.getOperateKey();
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                ExtendedDataEntity dataEntity = dataEntities[0];
                if ("disable".equals(operationKey)) {
                    if (Arrays.asList("tccit_depreciate_rule", "tccit_other_rule", "tccit_preferential_item", "tccit_profits_rule").contains(this.entityKey)) {
                        if (RuleDataSynOp.this.noPerm("tccit_yj_rule_group", "47160c2b000000ac")) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u201c\u9884\u7f34\u7533\u62a5\u9879\u89c4\u5219\u914d\u7f6e\u201d\u7684\u201c\u7981\u7528\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RuleDataSynOp_4", (String)"taxc-tccit", (Object[])new Object[0]));
                        }
                    } else if ("tccit_year_rule".equals(this.entityKey)) {
                        if (RuleDataSynOp.this.noPerm("tccit_year_rule_group", "47160c2b000000ac")) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u201c\u5e74\u62a5\u7533\u62a5\u9879\u89c4\u5219\u914d\u7f6e\u201d\u7684\u201c\u7981\u7528\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RuleDataSynOp_5", (String)"taxc-tccit", (Object[])new Object[0]));
                        }
                    } else if ("tccit_standbook_rule_item".equals(this.entityKey) && RuleDataSynOp.this.noPerm("tccit_book_rule_group", "47160c2b000000ac")) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u201c\u53f0\u8d26\u9879\u76ee\u89c4\u5219\u914d\u7f6e\u201d\u7684\u201c\u7981\u7528\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RuleDataSynOp_6", (String)"taxc-tccit", (Object[])new Object[0]));
                    }
                } else if ("enable".equals(operationKey)) {
                    if (Arrays.asList("tccit_depreciate_rule", "tccit_other_rule", "tccit_preferential_item", "tccit_profits_rule").contains(this.entityKey)) {
                        if (RuleDataSynOp.this.noPerm("tccit_yj_rule_group", "4730fc5d000000ac")) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u201c\u9884\u7f34\u7533\u62a5\u9879\u89c4\u5219\u914d\u7f6e\u201d\u7684\u201c\u542f\u7528\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RuleDataSynOp_7", (String)"taxc-tccit", (Object[])new Object[0]));
                        }
                    } else if ("tccit_year_rule".equals(this.entityKey)) {
                        if (RuleDataSynOp.this.noPerm("tccit_year_rule_group", "4730fc5d000000ac")) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u201c\u5e74\u62a5\u7533\u62a5\u9879\u89c4\u5219\u914d\u7f6e\u201d\u7684\u201c\u542f\u7528\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RuleDataSynOp_8", (String)"taxc-tccit", (Object[])new Object[0]));
                        }
                    } else if ("tccit_standbook_rule_item".equals(this.entityKey) && RuleDataSynOp.this.noPerm("tccit_book_rule_group", "4730fc5d000000ac")) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u201c\u53f0\u8d26\u9879\u76ee\u89c4\u5219\u914d\u7f6e\u201d\u7684\u201c\u542f\u7528\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RuleDataSynOp_9", (String)"taxc-tccit", (Object[])new Object[0]));
                    }
                } else if ("save".equals(operationKey)) {
                    DynamicObject obj = dataEntity.getDataEntity();
                    String entityKey = this.getEntityKey();
                    if (Arrays.asList("tccit_depreciate_rule", "tccit_other_rule", "tccit_preferential_item", "tccit_profits_rule").contains(entityKey)) {
                        if (RuleDataSynOp.this.isNewRule(entityKey, obj)) {
                            return;
                        }
                        if (RuleDataSynOp.this.noPerm("tccit_yj_rule_group", "4715a0df000000ac")) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u201c\u9884\u7f34\u7533\u62a5\u9879\u89c4\u5219\u914d\u7f6e\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RuleDataSynOp_1", (String)"taxc-tccit", (Object[])new Object[0]));
                        }
                    } else if ("tccit_year_rule".equals(entityKey)) {
                        if (RuleDataSynOp.this.isNewRule(entityKey, obj)) {
                            return;
                        }
                        if (RuleDataSynOp.this.noPerm("tccit_year_rule_group", "4715a0df000000ac")) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u201c\u5e74\u62a5\u7533\u62a5\u9879\u89c4\u5219\u914d\u7f6e\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RuleDataSynOp_2", (String)"taxc-tccit", (Object[])new Object[0]));
                        }
                    } else if ("tccit_standbook_rule_item".equals(entityKey)) {
                        if (RuleDataSynOp.this.isNewRule(entityKey, obj)) {
                            return;
                        }
                        if (RuleDataSynOp.this.noPerm("tccit_book_rule_group", "4715a0df000000ac")) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u201c\u53f0\u8d26\u9879\u76ee\u89c4\u5219\u914d\u7f6e\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RuleDataSynOp_3", (String)"taxc-tccit", (Object[])new Object[0]));
                        }
                    }
                }
            }
        });
    }

    private boolean noPerm(String entity, String permItem) {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((String)"tccit", (String)entity, (String)permItem);
        return !hasPermOrgResult.hasAllOrgPerm() && (CollectionUtils.isEmpty((Collection)hasPermOrgResult.getHasPermOrgs()) || !CollectionUtils.isEmpty((Collection)hasPermOrgResult.getHasPermOrgs()) && !hasPermOrgResult.getHasPermOrgs().contains(RequestContext.get().getOrgId()));
    }

    private boolean isNewRule(String entityKey, DynamicObject obj) {
        return !QueryServiceHelper.exists((String)entityKey, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)obj.getString("number"))});
    }
}

