/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.opplugin.taxbook;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.collections.CollectionUtils;

public class GetReduceAccSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject entity = dataEntity.getDataEntity();
                    Date firstyear = entity.getDate("firstyear");
                    DynamicObjectCollection entryentity = entity.getDynamicObjectCollection("entryentity");
                    for (DynamicObject dynamicObject : entryentity) {
                        Date year = dynamicObject.getDate("year");
                        if (year == null || dynamicObject.get("nreducename") == null) {
                            return;
                        }
                        dynamicObject.set("year", (Object)DateUtils.getFirstDateOfYear((Date)year));
                    }
                    if (CollectionUtils.isNotEmpty((Collection)entryentity)) {
                        Set collect = entryentity.stream().filter(s -> s.getDynamicObject("nreducename") != null).map(s -> s.getDynamicObject("nreducename").getString("number")).collect(Collectors.toSet());
                        if (collect.contains("40401") || collect.contains("40402")) {
                            collect.remove("40401");
                            collect.remove("40402");
                            if (collect.size() > 0) {
                                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u9879\u76ee\u53f0\u8d26\u4e2d\u4e0d\u652f\u6301\u540c\u65f6\u7ef4\u62a4\u6280\u672f\u7c7b\u9879\u76ee\u548c\u975e\u6280\u672f\u7c7b\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u4f18\u60e0\u4e8b\u9879\u540d\u79f0", (String)"GetReduceAccSaveOp_0", (String)"taxc-tccit", (Object[])new Object[0]));
                                return;
                            }
                            for (int i = 0; i < entryentity.size(); ++i) {
                                for (int j = 0; j < entryentity.size(); ++j) {
                                    if (j <= i) continue;
                                    DynamicObject iObject = (DynamicObject)entryentity.get(i);
                                    Iterator jObject = (DynamicObject)entryentity.get(j);
                                    if (DateUtils.getYearOfDate((Date)iObject.getDate("year")) != DateUtils.getYearOfDate((Date)jObject.getDate("year")) || Objects.equals(iObject.getDynamicObject("nreducename").get("id"), jObject.getDynamicObject("nreducename").get("id"))) continue;
                                    this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s%2$s\u5e74\u540c\u65f6\u5b58\u5728\u201c\u4e00\u822c\u6280\u672f\u9879\u76ee\u201d\u548c\u201c\u4e2d\u5173\u6751\u56fd\u5bb6\u81ea\u4e3b\u521b\u65b0\u793a\u8303\u533a\u7279\u5b9a\u533a\u57df\u6280\u672f\u8f6c\u8ba9\u9879\u76ee\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"GetReduceAccSaveOp_1", (String)"taxc-tccit", (Object[])new Object[0]), entity.get("org.name"), DateUtils.getYearOfDate((Date)iObject.getDate("year"))));
                                    return;
                                }
                            }
                            QFilter orgFilter = new QFilter("org", "=", entity.get("org.id"));
                            for (DynamicObject dynamicObject : entryentity) {
                                QFilter numberFilter = 1064511039091315712L == dynamicObject.getDynamicObject("nreducename").getLong("id") ? new QFilter("entryentity.nreducename", "=", (Object)1119482547752284160L) : new QFilter("entryentity.nreducename", "=", (Object)1064511039091315712L);
                                QFilter yearFilter = new QFilter("entryentity.year", "=", (Object)dynamicObject.getDate("year"));
                                if (!QueryServiceHelper.exists((String)"tccit_getreduce_acc", (QFilter[])new QFilter[]{orgFilter, yearFilter, numberFilter})) continue;
                                this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s%2$s\u5e74\u540c\u65f6\u5b58\u5728\u201c\u4e00\u822c\u6280\u672f\u9879\u76ee\u201d\u548c\u201c\u4e2d\u5173\u6751\u56fd\u5bb6\u81ea\u4e3b\u521b\u65b0\u793a\u8303\u533a\u7279\u5b9a\u533a\u57df\u6280\u672f\u8f6c\u8ba9\u9879\u76ee\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"GetReduceAccSaveOp_1", (String)"taxc-tccit", (Object[])new Object[0]), entity.get("org.name"), DateUtils.getYearOfDate((Date)dynamicObject.getDate("year"))));
                                return;
                            }
                            entity.set("firstyear", (Object)DateUtils.stringToDate((String)"1999", (String)"yyyy"));
                            continue;
                        }
                        if (firstyear == null) {
                            return;
                        }
                        Map<Integer, List<DynamicObject>> yearMap = entryentity.stream().collect(Collectors.groupingBy(a -> DateUtils.getYearOfDate((Date)a.getDate("year"))));
                        for (Map.Entry<Integer, List<DynamicObject>> objectListEntry : yearMap.entrySet()) {
                            List<DynamicObject> value = objectListEntry.getValue();
                            long count = value.stream().map(s -> s.getDynamicObject("nreducename").getLong("id")).distinct().count();
                            if (count <= 1L) continue;
                            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s%2$s\u5e74\u5ea6%3$s\u53ea\u80fd\u9009\u62e9\u540c\u4e00\u4e2a\u7684\u201c\u4f18\u60e0\u4e8b\u9879\u540d\u79f0\u201d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GetReduceAccSaveOp_2", (String)"taxc-tccit", (Object[])new Object[0]), entity.getString("org.name"), objectListEntry.getKey(), entity.getString("projectname")));
                            return;
                        }
                        Date firstyearDateOfYear = DateUtils.getFirstDateOfYear((Date)firstyear);
                        entity.set("firstyear", (Object)firstyearDateOfYear);
                        continue;
                    }
                    if (firstyear == null) {
                        return;
                    }
                    Date firstyearDateOfYear = DateUtils.getFirstDateOfYear((Date)firstyear);
                    entity.set("firstyear", (Object)firstyearDateOfYear);
                }
            }
        });
    }
}

