/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.opplugin.taxbook;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class MbyqksAccSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    BigDecimal lossmoney;
                    DynamicObject entity = dataEntity.getDataEntity();
                    if (entity.getDate("happenyear") == null) {
                        return;
                    }
                    Date firstDateOfhappen = DateUtils.getFirstDateOfYear((Date)entity.getDate("happenyear"));
                    entity.set("happenyear", (Object)firstDateOfhappen);
                    entity.set("ksdqnd", (Object)DateUtils.getFirstDateOfYear((Date)entity.getDate("ksdqnd")));
                    if ("jnsd".equals(entity.getString("losstype"))) {
                        QFilter losstypeFilter = new QFilter("losstype", "=", (Object)"jnsd");
                        QFilter yearFilter = new QFilter("happenyear", "=", (Object)firstDateOfhappen);
                        QFilter orgFilter = new QFilter("org", "=", entity.getDynamicObject("org").get("id"));
                        QFilter idFilter = new QFilter("id", "is null", null);
                        if (entity.get("id") != null) {
                            idFilter = new QFilter("id", "!=", entity.get("id"));
                        }
                        if (QueryServiceHelper.exists((String)"tccit_mbyqks_acc", (QFilter[])new QFilter[]{losstypeFilter, yearFilter, orgFilter, idFilter})) {
                            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5e74\u5ea6\u5df2\u5b58\u5728\u5883\u5185\u6240\u5f97\u989d\u4e8f\u635f\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u91cd\u590d\u6570\u636e", (String)"MbyqksAccSaveOp_0", (String)"taxc-tccit", (Object[])new Object[0]), DateUtils.format((Date)firstDateOfhappen, (String)"yyyy")));
                            return;
                        }
                    }
                    DynamicObjectCollection entryentity = entity.getDynamicObjectCollection("entryentity");
                    for (int i = 0; i < entryentity.size(); ++i) {
                        if (((DynamicObject)entryentity.get(i)).getDate("mbnd") == null) continue;
                        ((DynamicObject)entryentity.get(i)).set("mbnd", (Object)DateUtils.getFirstDateOfYear((Date)((DynamicObject)entryentity.get(i)).getDate("mbnd")));
                    }
                    BigDecimal amount = entryentity.stream().map(s -> s.getBigDecimal("mbzcksje")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    entity.set("ljmbzcksje", (Object)amount);
                    if (entity.getBigDecimal("lossmoney") == null) {
                        return;
                    }
                    int intHappenYear = DateUtils.getYearOfDate((Date)firstDateOfhappen);
                    int intNowYear = DateUtils.getYearOfDate((Date)new Date());
                    boolean mbkslx = entryentity.stream().filter(m -> "flzc".equals(m.get("mbkslx"))).findAny().isPresent();
                    if ((intNowYear == intHappenYear || intNowYear - intHappenYear == 1) && "jnsd".equals(entity.getString("losstype")) && mbkslx || amount.compareTo(lossmoney = entity.getBigDecimal("lossmoney").abs()) <= 0) continue;
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f25\u8865\u3001\u8f6c\u51fa\u4e8f\u635f\u7d2f\u8ba1\u91d1\u989d\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u4e8f\u635f\u91d1\u989d", (String)"MbyqksAccSaveOp_1", (String)"taxc-tccit", (Object[])new Object[0]));
                    return;
                }
            }
        });
    }
}

