/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.opplugin.taxbook;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;

public class NewInvestAssetSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject entity = dataEntity.getDataEntity();
                    DynamicObjectCollection details = entity.getDynamicObjectCollection("tccit_new_invest_detail");
                    BigDecimal tzblSum = details.stream().map(d -> d.getBigDecimal("tzbl")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    if (BigDecimal.ONE.compareTo(tzblSum) >= 0) continue;
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u6295\u8d44\u6bd4\u4f8b\u5408\u8ba1\u5e94\u5c0f\u4e8e\u6216\u7b49\u4e8e100%\u3002", (String)"NewInvestAssetSaveOp", (String)"taxc-tccit", (Object[])new Object[0]));
                    return;
                }
            }
        });
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection details = dataEntity.getDynamicObjectCollection("tccit_new_invest_detail");
            BigDecimal tzcbrzjeSum = details.stream().map(d -> d.getBigDecimal("tzcbrzje")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal tradetaxfeeSum = details.stream().map(d -> d.getBigDecimal("tradetaxfee")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal taxbaseSum = details.stream().map(d -> d.getBigDecimal("taxbase")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            dataEntity.set("ljtzcbrzje", (Object)tzcbrzjeSum);
            dataEntity.set("ljjysf", (Object)tradetaxfeeSum);
            dataEntity.set("ljjsjc", (Object)taxbaseSum);
        }
    }
}

