/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.opplugin.taxbook;

import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class OtherTaxDeductionSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObjectCollection query;
                    DynamicObject entity = dataEntity.getDataEntity();
                    DynamicObject org = entity.getDynamicObject("org");
                    Date year = entity.getDate("year");
                    Object pkid = entity.getPkValue();
                    DynamicObjectCollection entryentity = entity.getDynamicObjectCollection("entryentity");
                    Map<Long, String> projectMap = entryentity.stream().filter(s -> s.getDynamicObject("project") != null).collect(Collectors.toMap(s -> s.getDynamicObject("project").getLong("id"), s -> s.getDynamicObject("project").getString("projectname")));
                    if (org == null || year == null || projectMap.size() <= 0 || (query = OtherTaxDeductionSaveOp.this.query(org, year)) == null || query.size() <= 0) continue;
                    for (DynamicObject obj : query) {
                        Long id = obj.getLong("entryentity.project");
                        String mainId = obj.getString("id");
                        if (pkid != null && mainId.equals(pkid.toString()) || id == null || !projectMap.containsKey(id)) continue;
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u4f18\u60e0\u9879\u76ee\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OtherTaxDeductionSaveOp_0", (String)"taxc-tccit", (Object[])new Object[0]));
                        return;
                    }
                }
            }
        });
    }

    private DynamicObjectCollection query(DynamicObject org, Date year) {
        QFilter filter = new QFilter("org.id", "=", (Object)org.getLong("id"));
        filter.and(new QFilter("year", ">=", (Object)DateUtils.getFirstDateOfYear((Date)year)));
        filter.and(new QFilter("year", "<=", (Object)DateUtils.getLastDateOfYear((Date)year)));
        return QueryServiceHelper.query((String)"tccit_other_deductions", (String)"id,entryentity.project", (QFilter[])new QFilter[]{filter});
    }
}

