/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tccit.opplugin.taxbook;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class SpecificBusinessRealDevEnterSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject entity = dataEntity.getDataEntity();
                    DynamicObjectCollection entryentity = entity.getDynamicObjectCollection("entryentity");
                    DynamicObjectCollection entryentity1 = entity.getDynamicObjectCollection("entryentity1");
                    String msg1 = this.valid(entryentity, Lists.newArrayList((Object[])new String[]{"salenofinishincome", "sjfsdtaxincome"}));
                    if (StringUtil.isNotBlank((CharSequence)msg1)) {
                        this.addFatalErrorMessage(dataEntity, SpecificBusinessRealDevEnterSaveOp.this.getEntryentityName() + "\n" + msg1);
                        continue;
                    }
                    String msg2 = this.valid(entryentity1, Lists.newArrayList((Object[])new String[]{"salefinishincome", "zhsjfsdtaxincome"}));
                    if (StringUtil.isNotBlank((CharSequence)msg2)) {
                        this.addFatalErrorMessage(dataEntity, SpecificBusinessRealDevEnterSaveOp.this.getEntryentity1Name() + "\n" + msg2);
                        continue;
                    }
                    String msg3 = SpecificBusinessRealDevEnterSaveOp.this.hasIntersection(entryentity, "nofinishperiodstart", "nofinishperiodend");
                    if (StringUtil.isNotBlank((CharSequence)msg3)) {
                        this.addFatalErrorMessage(dataEntity, SpecificBusinessRealDevEnterSaveOp.this.getEntryentityName() + "\n" + msg3);
                        continue;
                    }
                    String msg4 = SpecificBusinessRealDevEnterSaveOp.this.hasIntersection(entryentity1, "finishperiodstart", "finishperiodend");
                    if (StringUtil.isNotBlank((CharSequence)msg4)) {
                        this.addFatalErrorMessage(dataEntity, SpecificBusinessRealDevEnterSaveOp.this.getEntryentity1Name() + "\n" + msg4);
                        continue;
                    }
                    String msg5 = SpecificBusinessRealDevEnterSaveOp.this.checkRepeat(dataEntity);
                    if (!StringUtil.isNotBlank((CharSequence)msg5)) continue;
                    this.addFatalErrorMessage(dataEntity, msg5);
                }
            }

            public String valid(DynamicObjectCollection entryentity, List<String> columns) {
                StringBuilder builder = new StringBuilder();
                if (!CollectionUtils.isEmpty((Collection)entryentity)) {
                    int row = 1;
                    for (DynamicObject object : entryentity) {
                        String content = ((DynamicObject)entryentity.get(0)).getDynamicObjectType().getProperties().stream().filter(s -> columns.contains(s.getName())).filter(s -> object.getBigDecimal((String)columns.get(0)).compareTo(BigDecimal.ZERO) == 0 && object.getBigDecimal((String)columns.get(1)).compareTo(BigDecimal.ZERO) == 0).map(s -> s.getDisplayName().getLocaleValue()).collect(Collectors.joining("\u3001"));
                        if (StringUtil.isNotBlank((CharSequence)content)) {
                            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a%2$s\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5f55\u5165", (String)"SpecificBusinessRealDevEnterSaveOp_0", (String)"taxc-tccit", (Object[])new Object[0]), row, content);
                            builder.append(msg).append("\t\n");
                        }
                        ++row;
                    }
                }
                return builder.toString();
            }
        });
    }

    private String checkRepeat(ExtendedDataEntity dataEntity) {
        StringBuilder builder = new StringBuilder();
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        long id = dynamicObject.getLong("id");
        long orgId = dynamicObject.getDynamicObject("org").getLong("id");
        String itemno = dynamicObject.getString("itemno");
        String itemname = dynamicObject.getString("itemname");
        String sbtype = dynamicObject.getString("sbtype");
        QFilter idQfilter = new QFilter("id", "!=", (Object)id);
        QFilter orgQfilter = new QFilter("org", "=", (Object)orgId);
        List<String> collect = Arrays.stream(sbtype.split(",")).filter(s -> StringUtil.isNotBlank((CharSequence)s)).collect(Collectors.toList());
        QFilter sbtypeQfilter = QFilter.ftlike((String[])collect.toArray(new String[0]), (String[])new String[]{"sbtype"});
        if (QueryServiceHelper.exists((String)this.billEntityType.getName(), (QFilter[])new QFilter[]{idQfilter, orgQfilter, new QFilter("itemno", "=", (Object)itemno), new QFilter("itemname", "!=", (Object)itemname)})) {
            builder.append(ResManager.loadKDString((String)"\u540c\u4e00\u623f\u4ea7\u9879\u76ee\u7f16\u53f7\u4e0b\u5df2\u5b58\u5728\u4e0d\u540c\u623f\u4ea7\u9879\u76ee\u540d\u79f0\uff0c\u8bf7\u6838\u5bf9\u4fe1\u606f\u3002", (String)"SpecificBusinessRealDevEnterSaveOp_1", (String)"taxc-tccit", (Object[])new Object[0]));
            return builder.toString();
        }
        if (QueryServiceHelper.exists((String)this.billEntityType.getName(), (QFilter[])new QFilter[]{idQfilter, orgQfilter, new QFilter("itemno", "!=", (Object)itemno), new QFilter("itemname", "=", (Object)itemname)})) {
            builder.append(ResManager.loadKDString((String)"\u540c\u4e00\u623f\u4ea7\u9879\u76ee\u540d\u79f0\u4e0b\u5df2\u5b58\u5728\u4e0d\u540c\u623f\u4ea7\u9879\u76ee\u7f16\u53f7\uff0c\u8bf7\u6838\u5bf9\u4fe1\u606f\u3002", (String)"SpecificBusinessRealDevEnterSaveOp_2", (String)"taxc-tccit", (Object[])new Object[0]));
            return builder.toString();
        }
        if (QueryServiceHelper.exists((String)this.billEntityType.getName(), (QFilter[])new QFilter[]{idQfilter, orgQfilter, new QFilter("itemno", "=", (Object)itemno), sbtypeQfilter})) {
            builder.append(ResManager.loadKDString((String)"\u8be5\u623f\u4ea7\u9879\u76ee\u5df2\u5b58\u5728\u76f8\u540c\u7533\u62a5\u7c7b\u578b\u7684\u53f0\u8d26\u6570\u636e\uff0c\u8bf7\u6838\u5bf9\u4fe1\u606f\u3002", (String)"SpecificBusinessRealDevEnterSaveOp_3", (String)"taxc-tccit", (Object[])new Object[0]));
            return builder.toString();
        }
        return "";
    }

    private String hasIntersection(DynamicObjectCollection entryentity, String startkey, String endKey) {
        if (entryentity.size() < 2) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        block0: for (int i = 0; i < entryentity.size(); ++i) {
            for (int j = i + 1; j < entryentity.size(); ++j) {
                boolean b;
                DynamicObject o1 = (DynamicObject)entryentity.get(i);
                if (j > entryentity.size() + 1) continue block0;
                DynamicObject o2 = (DynamicObject)entryentity.get(j);
                Date s1 = o1.getDate(startkey);
                Date s2 = o1.getDate(endKey);
                Date t1 = o2.getDate(startkey);
                Date t2 = o2.getDate(endKey);
                boolean bl = b = t2.compareTo(s1) >= 0 && s2.compareTo(t1) >= 0;
                if (!b) continue;
                builder.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u548c\u7b2c%2$s\u884c\u4f1a\u8ba1\u671f\u95f4\u8d77\u6b62\u6709\u4ea4\u53c9\uff01", (String)"SpecificBusinessRealDevEnterSaveOp_4", (String)"taxc-tccit", (Object[])new Object[0]), i + 1, j + 1)).append("\t\n");
            }
        }
        return builder.toString();
    }

    private String getEntryentityName() {
        return ResManager.loadKDString((String)"\u9500\u552e\u672a\u5b8c\u5de5\u5f00\u53d1\u4ea7\u54c1\u7279\u5b9a\u4e1a\u52a1\u53f0\u8d26", (String)"SpecificBusinessRealDevEnterSaveOp_5", (String)"taxc-tccit", (Object[])new Object[0]);
    }

    private String getEntryentity1Name() {
        return ResManager.loadKDString((String)"\u9500\u552e\u7684\u672a\u5b8c\u5de5\u4ea7\u54c1\u8f6c\u5b8c\u5de5\u4ea7\u54c1\u7279\u5b9a\u4e1a\u52a1\u53f0\u8d26", (String)"SpecificBusinessRealDevEnterSaveOp_6", (String)"taxc-tccit", (Object[])new Object[0]);
    }
}

