/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.business.baseconfig;

import com.google.common.collect.Range;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcept.business.basedata.TaxProjectDataService;
import kd.taxc.tcept.common.dto.RulesDto;

public class RuleConfigService {
    public static final String AREA = "area";
    public static final String PRICE = "price";
    public static final String TOTALPRICE = "totalprice";
    public static final String PLOTRATIO = "plotratio";
    public static final String MINAREA = "minarea";
    public static final String MAXAREA = "maxarea";
    public static final String MINPRICE = "minprice";
    public static final String MAXPRICE = "maxprice";
    public static final String MINTOTALPRICE = "mintotalprice";
    public static final String MAXTOTALPRICE = "maxtotalprice";
    public static final String MINPLOTRATIO = "minplotratio";
    public static final String MAXPLOTRATIO = "maxplotratio";
    public static final String TAXSTATE = "taxstate";
    public static final String ENTRYENTITYMAP = "entryentitymap";
    public static final BigDecimal MAX_VALUE = new BigDecimal("9999999999999.9999999999");
    public static final String SIGNING = "signing";
    private static final String TCEPT_RULE_CONFIG = "tcept_rule_config";
    private static final String TCEPT_PROJ_SHARPLAN = "tcept_proj_sharplan";

    public List<RulesDto> loadRuleConfig(DynamicObject rule) {
        DynamicObjectCollection entryentitymap = rule.getDynamicObjectCollection(ENTRYENTITYMAP);
        ArrayList<RulesDto> list = new ArrayList<RulesDto>();
        for (DynamicObject object : entryentitymap) {
            HashMap<String, Range> map = new HashMap<String, Range>(16);
            map.put(AREA, this.getRange(object.getBigDecimal(MINAREA), object.getBigDecimal(MAXAREA)));
            map.put(PRICE, this.getRange(object.getBigDecimal(MINPRICE), object.getBigDecimal(MAXPRICE)));
            map.put(TOTALPRICE, this.getRange(object.getBigDecimal(MINTOTALPRICE), object.getBigDecimal(MAXTOTALPRICE)));
            map.put(PLOTRATIO, this.getRange(object.getBigDecimal(MINPLOTRATIO), object.getBigDecimal(MAXPLOTRATIO)));
            map.put(SIGNING, this.getRangeDate(object.getDate("signingstart"), object.getDate("signingend")));
            RulesDto rulesDto = new RulesDto();
            rulesDto.setTaxState(object.getString(TAXSTATE));
            rulesDto.setMap(map);
            rulesDto.setSalestateIds(object.getDynamicObjectCollection("salestate").stream().map(ss -> ss.getLong("fbasedataid_id")).collect(Collectors.toList()));
            rulesDto.setKszc(object.getString("selfholdstate"));
            list.add(rulesDto);
        }
        return list;
    }

    public List<String> getSaleStateByRuleConfig(Long xsytId, String kszc, Date qyrq, List<RulesDto> conditions, BigDecimal area, BigDecimal totalprice, BigDecimal price, BigDecimal plotratio) {
        return conditions.stream().filter(s -> s.getSalestateIds().contains(xsytId)).filter(s -> s.getKszc().equals(kszc)).filter(s -> {
            Map<String, Range> map = s.getMap();
            boolean test1 = area != null ? map.get(AREA).test((Object)area) : false;
            boolean test2 = price != null ? map.get(PRICE).test((Object)price) : false;
            boolean test3 = totalprice != null ? map.get(TOTALPRICE).test((Object)totalprice) : false;
            boolean test4 = qyrq != null ? map.get(SIGNING).test((Object)qyrq) : true;
            return test1 && test2 && test3 && test4;
        }).map(s -> s.getTaxState()).collect(Collectors.toList());
    }

    private Range<BigDecimal> getRange(BigDecimal min, BigDecimal max) {
        return Range.openClosed((Comparable)min, (Comparable)(BigDecimal.ZERO.compareTo(max) == 0 ? MAX_VALUE : max));
    }

    private Range<Date> getRangeDate(Date min, Date max) {
        if (min == null && max != null) {
            return Range.atMost((Comparable)max);
        }
        if (min != null && max == null) {
            return Range.atLeast((Comparable)min);
        }
        if (min == null && max == null) {
            return Range.all();
        }
        return Range.closed((Comparable)min, (Comparable)max);
    }

    public String queryProjectSwytflByPk(Long pk) {
        if (pk != null) {
            DynamicObject rule = BusinessDataServiceHelper.loadSingle((Object)pk, (String)TCEPT_RULE_CONFIG);
            long projectid = rule.getLong("project.id");
            return TaxProjectDataService.queryProjectSwqsytfl(projectid);
        }
        return "1";
    }

    public List<Object> queryAllSharePks(Long orgid) {
        QFilter qFilter = new QFilter("org", "=", (Object)orgid);
        QFilter qFilter1 = new QFilter("ruletype", "=", (Object)"public");
        QFilter q3 = new QFilter("status", "=", (Object)"C");
        QFilter q4 = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCEPT_RULE_CONFIG, (String)"id", (QFilter[])new QFilter[]{qFilter, qFilter1, q3, q4});
        return query.stream().map(a -> a.get("id")).collect(Collectors.toList());
    }

    public boolean isExists(Long orgid, Long projectId, String ruleType) {
        QFilter q1 = new QFilter("org", "=", (Object)orgid);
        QFilter q2 = new QFilter("project", "=", (Object)projectId);
        QFilter q3 = new QFilter("ruletype", "=", (Object)ruleType);
        return QueryServiceHelper.exists((String)TCEPT_RULE_CONFIG, (QFilter[])new QFilter[]{q1, q2, q3});
    }

    public Map<String, String> getFetchMapping(Long orgid, Long projectId) {
        DynamicObject object = this.queryOneFitRuleByProject(orgid, projectId);
        if (object != null) {
            Map<String, String> entryentityfetch = object.getDynamicObjectCollection("entryentityfetch").stream().filter(s -> StringUtil.isNotEmpty((CharSequence)s.getString("costitemname"))).collect(Collectors.toMap(s -> s.getString("costitemname").trim(), s -> s.getString("fetchtype")));
            return entryentityfetch;
        }
        return new HashMap<String, String>(16);
    }

    public Map<Long, String> existUsableRuleByProject(List<Long> projectids, Long sharplanid) {
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        QFilter qFilter = new QFilter("project", "in", projectids);
        QFilter qFilter1 = new QFilter("ruletype", "in", (Object)"private");
        QFilter q4 = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCEPT_RULE_CONFIG, (String)"project.id projectid,project.name projectname", (QFilter[])new QFilter[]{qFilter1, qFilter, q4});
        for (DynamicObject dynamicObject : query) {
            hashMap.put(dynamicObject.getLong("projectid"), dynamicObject.getString("projectname"));
        }
        QFilter shareProFilter = new QFilter("projectentity.project", "in", projectids);
        if (sharplanid != null) {
            shareProFilter.and("id", "!=", (Object)sharplanid);
        }
        DynamicObjectCollection queryShare = QueryServiceHelper.query((String)TCEPT_PROJ_SHARPLAN, (String)"projectentity.project.id projectid,projectentity.project.name projectname", (QFilter[])new QFilter[]{shareProFilter, shareProFilter});
        for (DynamicObject dynamicObject : queryShare) {
            hashMap.put(dynamicObject.getLong("projectid"), dynamicObject.getString("projectname"));
        }
        return hashMap;
    }

    public Map<Long, String> existUsableRule(Set<Long> orgIds, Long sharplanid) {
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        QFilter qFilter1 = new QFilter("ruletype", "in", (Object)"private");
        QFilter q4 = new QFilter("enable", "=", (Object)"1");
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCEPT_RULE_CONFIG, (String)"project.id projectid,project.name projectname", (QFilter[])new QFilter[]{orgFilter, qFilter1, q4});
        for (DynamicObject dynamicObject : query) {
            hashMap.put(dynamicObject.getLong("projectid"), dynamicObject.getString("projectname"));
        }
        QFilter shareProFilter = new QFilter("projectentity.project", "not in", hashMap.keySet());
        if (sharplanid != null) {
            shareProFilter.and("id", "!=", (Object)sharplanid);
        }
        DynamicObjectCollection queryShare = QueryServiceHelper.query((String)TCEPT_PROJ_SHARPLAN, (String)"projectentity.project.id projectid,projectentity.project.name projectname", (QFilter[])new QFilter[]{shareProFilter, shareProFilter});
        for (DynamicObject dynamicObject : queryShare) {
            hashMap.put(dynamicObject.getLong("projectid"), dynamicObject.getString("projectname"));
        }
        return hashMap;
    }

    public DynamicObject queryOneFitRuleByProject(Long orgId, Long projectid) {
        Long resultPk;
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter ruleFilter = new QFilter("ruletype", "in", (Object)"private");
        QFilter proFilter = new QFilter("project", "=", (Object)projectid);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFiler = new QFilter("enable", "=", (Object)"1");
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)TCEPT_RULE_CONFIG, (String)"id", (QFilter[])new QFilter[]{orgFilter, ruleFilter, proFilter, statusFilter, enableFiler});
        if (queryOne != null) {
            resultPk = queryOne.getLong("id");
        } else {
            QFilter shareOrgFilter = new QFilter("orgentity.org", "=", (Object)orgId);
            QFilter shareProFilter = new QFilter("projectentity.project", "=", (Object)projectid);
            DynamicObjectCollection query = QueryServiceHelper.query((String)TCEPT_PROJ_SHARPLAN, (String)"ruleentity.rule ruleid", (QFilter[])new QFilter[]{shareOrgFilter, shareProFilter, statusFilter, enableFiler});
            List ruleid = query.stream().map(a -> a.getLong("ruleid")).collect(Collectors.toList());
            QFilter ids = new QFilter("id", "in", ruleid);
            QFilter ruleStatusFilter = new QFilter("status", "=", (Object)"C");
            QFilter ruleEnableFiler = new QFilter("enable", "=", (Object)"1");
            DynamicObject queryRule = QueryServiceHelper.queryOne((String)TCEPT_RULE_CONFIG, (String)"id", (QFilter[])new QFilter[]{ids, ruleStatusFilter, ruleEnableFiler});
            Long l = resultPk = queryRule != null ? Long.valueOf(queryRule.getLong("id")) : null;
        }
        if (resultPk != null) {
            return BusinessDataServiceHelper.loadSingle((Object)resultPk, (String)TCEPT_RULE_CONFIG);
        }
        return null;
    }
}

