/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.business.basedata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tcept.business.basedata.SchemaDataService;

public class CostReportDataService {
    private static final String TDM_COSTREPORT = "tdm_costrpt";
    private static final String TDM_COSTITEM = "tdm_costitem";
    private static final String TDM_COSTREPORT_TPL = "tdm_costtpl";

    public static Set<String> queryCostItemsUpLevelNumbers(Collection<Object> costitemIds) {
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])costitemIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TDM_COSTITEM));
        HashSet<String> set = new HashSet<String>();
        for (DynamicObject dynamicObject : load) {
            String[] split;
            String longnumber = dynamicObject.getString("longnumber");
            if (longnumber == null) continue;
            for (String s : split = longnumber.split("\\.")) {
                set.add(s);
            }
        }
        return set;
    }

    public static List<DynamicObject> queryCostreportTplCostItems(Object id) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)TDM_COSTREPORT_TPL);
        List ids = object.getDynamicObjectCollection("entryentity").stream().filter(a -> a.getDynamicObject("costitem") != null).map(a -> a.get("costitem.id")).collect(Collectors.toList());
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TDM_COSTITEM));
        return Arrays.stream(load).collect(Collectors.toList());
    }

    public static DynamicObject queryAllPeriodData(Long orgid, Long projectid, Long schemeId, String version) {
        QFilter taxorg = new QFilter("createorg", "=", (Object)orgid);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter project = new QFilter("taxproject", "=", (Object)projectid);
        Long costVer = SchemaDataService.queryVersionEntryCostVer(schemeId, version);
        QFilter qFilter = new QFilter("version", "=", (Object)costVer);
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)TDM_COSTREPORT, (String)"id", (QFilter[])new QFilter[]{taxorg, project, enable, status, qFilter});
        if (queryOne != null) {
            return BusinessDataServiceHelper.loadSingle((Object)queryOne.get("id"), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TDM_COSTREPORT));
        }
        return null;
    }

    public static List<DynamicObject> queryCostItemOfTplByReport(Long orgid, Long projectid, Long schemeId, String version) {
        DynamicObject costReport = CostReportDataService.queryAllPeriodData(orgid, projectid, schemeId, version);
        if (costReport != null) {
            Object costreporttplid = costReport.get("costreporttpl.id");
            return CostReportDataService.queryCostreportTplCostItems(costreporttplid);
        }
        return new ArrayList<DynamicObject>();
    }

    public static Set<Object> getLastLevelCostItemIdsByUniq(Object org, Object houseproject, Long schemeId, String version) {
        Long costVer = SchemaDataService.queryVersionEntryCostVer(schemeId, version);
        QFilter qFilter = new QFilter("createorg", "=", org);
        QFilter qFilter2 = new QFilter("taxproject", "=", houseproject);
        QFilter qFilter3 = new QFilter("version", "=", (Object)costVer);
        DynamicObjectCollection cbbb = QueryServiceHelper.query((String)TDM_COSTREPORT, (String)"entryentity.costitem costitem", (QFilter[])new QFilter[]{qFilter, qFilter2, qFilter3});
        Set costitem = cbbb.stream().map(a -> a.get("costitem")).collect(Collectors.toSet());
        QFilter qFilter5 = new QFilter("id", "in", costitem);
        QFilter qFilter4 = new QFilter("level", "<=", (Object)3);
        cbbb = QueryServiceHelper.query((String)TDM_COSTITEM, (String)"id,parent", (QFilter[])new QFilter[]{qFilter5, qFilter4});
        Map<Object, String> parentMap = cbbb.stream().collect(Collectors.toMap(a -> a.get("parent"), b -> "1", (m, n) -> m));
        Iterator iterator = cbbb.iterator();
        while (iterator.hasNext()) {
            DynamicObject next = (DynamicObject)iterator.next();
            if (!parentMap.containsKey(next.get("id"))) continue;
            iterator.remove();
        }
        return cbbb.stream().map(a -> a.get("id")).collect(Collectors.toSet());
    }
}

