/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.business.basedata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcept.business.statistics.DeskService;
import kd.taxc.tcept.common.enums.ClearPeriodEnum;

public class SchemaDataService {
    private static final String TCEPT_SCHEME = "tcept_scheme";
    public static final String TCEPT_PROJECT_DESK = "tcept_project_desk";
    public static final String TCEPT_DESK_BILL_RECORD = "tcept_desk_bill_record";

    public static Long queryLastScheme(Long orgid, Long projectid) {
        QFilter taxorg = new QFilter("org", "=", (Object)orgid);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter project = new QFilter("project", "=", (Object)projectid);
        DynamicObjectCollection id = QueryServiceHelper.query((String)TCEPT_SCHEME, (String)"id", (QFilter[])new QFilter[]{taxorg, project, enable, status}, (String)"modifytime desc");
        return id.size() == 0 ? null : Long.valueOf(((DynamicObject)id.get(0)).getLong("id"));
    }

    public static Boolean querySchemeReshareofuncleart(Long schemeId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)TCEPT_SCHEME);
        String sameclearofcost = dynamicObject.getString("reshareofunclear");
        return "1".equals(sameclearofcost);
    }

    public static Boolean querySchemeSameclearofcost(Long schemeId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)TCEPT_SCHEME);
        String sameclearofcost = dynamicObject.getString("sameclearofcost");
        return "1".equals(sameclearofcost);
    }

    public static Map<String, String> queryVersionNameMap() {
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCEPT_SCHEME, (String)"id, entryentity.versioncode versioncode, entryentity.versionname versionname", (QFilter[])QFilter.isNotNull((String)"id").toArray());
        return query.stream().collect(Collectors.toMap(a -> a.getString("id") + a.getString("versioncode"), b -> StringUtil.isNotEmpty((CharSequence)b.getString("versionname")) ? b.getString("versionname") : "", (m, n) -> m));
    }

    public List<ComboItem> queryVersionComboItems() {
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCEPT_SCHEME, (String)"id, entryentity.versioncode versioncode, entryentity.versionname versionname", (QFilter[])QFilter.isNotNull((String)"id").toArray());
        return query.stream().filter(s -> StringUtil.isNotEmpty((CharSequence)s.getString("versioncode"))).map(s -> new ComboItem(new LocaleString(s.getString("versionname")), s.getString("versioncode"))).collect(Collectors.toList());
    }

    public static Long queryVersionEntryIncomeVer(Long scheme, String version) {
        DynamicObject dynamicObject = SchemaDataService.queryVersionEntry(scheme, version);
        if (dynamicObject != null) {
            return dynamicObject.getLong("incomever.id");
        }
        return 0L;
    }

    public static Long queryVersionEntryCostVer(Long scheme, String version) {
        DynamicObject dynamicObject = SchemaDataService.queryVersionEntry(scheme, version);
        if (dynamicObject != null) {
            return dynamicObject.getLong("costver.id");
        }
        return 0L;
    }

    public static DynamicObject queryVersionEntry(Long scheme, String version) {
        Optional<DynamicObject> first;
        DynamicObject schemeSingle = SchemaDataService.querySchemeSingle(scheme);
        if (schemeSingle != null && version != null && (first = schemeSingle.getDynamicObjectCollection("entryentity").stream().filter(a -> version.equals(a.getString("versioncode"))).findFirst()).isPresent()) {
            return first.get();
        }
        return null;
    }

    public static String queryVersionName(Long scheme, String version) {
        Optional<String> first;
        DynamicObject schemeSingle = SchemaDataService.querySchemeSingle(scheme);
        if (schemeSingle != null && (first = schemeSingle.getDynamicObjectCollection("entryentity").stream().filter(a -> version.equals(a.getString("versioncode"))).map(a -> a.getString("versionname")).findFirst()).isPresent()) {
            return first.get();
        }
        return null;
    }

    public static DynamicObject querySchemeSingle(Long schemeId) {
        if (schemeId != null && QueryServiceHelper.exists((String)TCEPT_SCHEME, (Object)schemeId)) {
            return BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)TCEPT_SCHEME);
        }
        return null;
    }

    public static int querySchemeClearperiod(Long schemeId) {
        DynamicObject scheme;
        if (schemeId != null && (scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)TCEPT_SCHEME)) != null) {
            String clearperiod = scheme.getString("clearperiod");
            int intValue = new BigDecimal(clearperiod).intValue();
            return intValue;
        }
        return 1;
    }

    public static int querySchemeClearperiod(Long orgId, Long projectId, Long schemeId) {
        QFilter q1 = new QFilter("id", "=", (Object)schemeId);
        QFilter q2 = new QFilter("org", "=", (Object)orgId);
        QFilter q3 = new QFilter("project", "=", (Object)projectId);
        QFilter q4 = new QFilter("enable", "=", (Object)"1");
        QFilter q5 = new QFilter("status", "=", (Object)"C");
        DynamicObject object = QueryServiceHelper.queryOne((String)TCEPT_SCHEME, (String)"clearperiod", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5});
        return object != null ? Integer.parseInt(object.getString("clearperiod")) : 0;
    }

    public static List<ComboItem> getItemsByClearPeriod(int clearperiod) {
        return ClearPeriodEnum.getClearPeriods(clearperiod);
    }

    public void syncCreateBill(DynamicObject[] dataEntities) {
        DynamicObjectCollection projectDesks = new DynamicObjectCollection();
        DynamicObjectCollection billRecordDesks = new DynamicObjectCollection();
        for (DynamicObject dataEntity : dataEntities) {
            long orgId = dataEntity.getDynamicObject("org").getLong("id");
            long projectId = dataEntity.getDynamicObject("project").getLong("id");
            long schemeId = dataEntity.getLong("id");
            List<String> existsVersionInfoOfProjectDesks = this.getExistsVersionInfoOfProjectDesk(orgId, projectId, schemeId);
            List<String> existsVersionInfoOfBillRecords = this.getExistsVersionInfoOfBillRecordKey(orgId, projectId, schemeId);
            Map<String, Map<String, DynamicObject>> existsVersionInfoOfBillRecordMap = this.getExistsVersionInfoOfBillRecordMap(orgId, projectId, schemeId);
            DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("entryentity");
            List<DynamicObject> controlRange = new DeskService().getControlRange();
            for (DynamicObject row : rows) {
                if (!existsVersionInfoOfProjectDesks.contains(row.getString("versioncode"))) {
                    projectDesks.add((Object)this.initProjectDesk(dataEntity, row));
                }
                for (int i = 0; i < controlRange.size(); ++i) {
                    DynamicObject versionRecord;
                    DynamicObject recordMeta = controlRange.get(i);
                    String number = recordMeta.getString("number");
                    String name = recordMeta.getString("name");
                    if (!existsVersionInfoOfBillRecords.contains(row.getString("versioncode") + "_" + number)) {
                        DynamicObject item = this.initBillRecordDesk(dataEntity, row, i + 1, number, name);
                        billRecordDesks.add((Object)item);
                        continue;
                    }
                    Map<String, DynamicObject> map = existsVersionInfoOfBillRecordMap.get(number);
                    if (map == null || (versionRecord = map.get(row.getString("versioncode"))) == null) continue;
                    DynamicObject item = this.updateBillRecordDesk(versionRecord, row, i + 1, name);
                    item.set("version", (Object)row.getString("versioncode"));
                    item.set("versionname", (Object)row.getString("versionname"));
                    billRecordDesks.add((Object)item);
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)projectDesks)) {
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])projectDesks.toArray((Object[])new DynamicObject[0])));
        }
        if (!CollectionUtils.isEmpty((Collection)billRecordDesks)) {
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])billRecordDesks.toArray((Object[])new DynamicObject[0])));
        }
    }

    private DynamicObject updateBillRecordDesk(DynamicObject dynamicObject, DynamicObject entryrow, int seq, String name) {
        dynamicObject.set("controlseq", (Object)seq);
        dynamicObject.set("billname", (Object)name);
        return dynamicObject;
    }

    private Map<String, Map<String, DynamicObject>> getExistsVersionInfoOfBillRecordMap(long orgId, long projectId, long schemeId) {
        DynamicObjectCollection query = this.getBillRecord(orgId, projectId, schemeId);
        List id = query.stream().map(a -> a.get("id")).collect(Collectors.toList());
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])id.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCEPT_DESK_BILL_RECORD));
        Map<String, List<DynamicObject>> firstGroup = Arrays.stream(load).collect(Collectors.groupingBy(a -> a.getString("billmetanumber")));
        HashMap<String, Map<String, DynamicObject>> hashMap = new HashMap<String, Map<String, DynamicObject>>();
        for (Map.Entry<String, List<DynamicObject>> entry : firstGroup.entrySet()) {
            String key = entry.getKey();
            List<DynamicObject> value = entry.getValue();
            HashMap<String, DynamicObject> hashMap1 = new HashMap<String, DynamicObject>(8);
            for (DynamicObject k : value) {
                hashMap1.put(k.getString("version"), k);
            }
            hashMap.put(key, hashMap1);
        }
        return hashMap;
    }

    private List<String> getExistsVersionInfoOfProjectDesk(long orgId, long projectId, long schemeId) {
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter("project", "=", (Object)projectId);
        QFilter q3 = new QFilter("scheme", "=", (Object)schemeId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCEPT_PROJECT_DESK, (String)"billno", (QFilter[])new QFilter[]{q1, q2, q3});
        if (!CollectionUtils.isEmpty((Collection)query)) {
            return query.stream().map(s -> s.getString("billno")).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private List<String> getExistsVersionInfoOfBillRecordKey(long orgId, long projectId, long schemeId) {
        DynamicObjectCollection query = this.getBillRecord(orgId, projectId, schemeId);
        if (!CollectionUtils.isEmpty((Collection)query)) {
            return query.stream().map(s -> s.getString("version") + "_" + s.getString("billmetanumber")).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private DynamicObjectCollection getBillRecord(long orgId, long projectId, long schemeId) {
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter("project", "=", (Object)projectId);
        QFilter q3 = new QFilter("scheme", "=", (Object)schemeId);
        return QueryServiceHelper.query((String)TCEPT_DESK_BILL_RECORD, (String)"version,billmetanumber,id", (QFilter[])new QFilter[]{q1, q2, q3});
    }

    private DynamicObject initProjectDesk(DynamicObject dataEntity, DynamicObject object) {
        DynamicObject projectDesk = BusinessDataServiceHelper.newDynamicObject((String)TCEPT_PROJECT_DESK);
        projectDesk.set("billno", (Object)object.getString("versioncode"));
        projectDesk.set("versionname", (Object)object.getString("versionname"));
        projectDesk.set("billstatus", (Object)"A");
        projectDesk.set("org", (Object)dataEntity.getDynamicObject("org").getLong("id"));
        projectDesk.set("project", (Object)dataEntity.getDynamicObject("project").getLong("id"));
        projectDesk.set("scheme", (Object)dataEntity.getLong("id"));
        return projectDesk;
    }

    private DynamicObject initBillRecordDesk(DynamicObject dataEntity, DynamicObject object, int seq, String number, String name) {
        DynamicObject deskBillRecord = BusinessDataServiceHelper.newDynamicObject((String)TCEPT_DESK_BILL_RECORD);
        deskBillRecord.set("org", (Object)dataEntity.getDynamicObject("org").getLong("id"));
        deskBillRecord.set("project", (Object)dataEntity.getDynamicObject("project").getLong("id"));
        deskBillRecord.set("scheme", (Object)dataEntity.getLong("id"));
        deskBillRecord.set("version", (Object)object.getString("versioncode"));
        deskBillRecord.set("versionname", (Object)object.getString("versionname"));
        deskBillRecord.set("billmetanumber", (Object)number);
        deskBillRecord.set("billname", (Object)name);
        deskBillRecord.set("creater", (Object)RequestContext.get().getCurrUserId());
        deskBillRecord.set("createdate", (Object)new Date());
        deskBillRecord.set("controlseq", (Object)seq);
        deskBillRecord.set("createstatus", (Object)"wbz");
        return deskBillRecord;
    }

    public String createVersionAndSyncData(Long scheme, String versionname) {
        String newVerion = "";
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)scheme, (String)TCEPT_SCHEME);
        String number = object.getString("number");
        DynamicObjectCollection entryentity = object.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryentity)) {
            DynamicObject initRow = entryentity.addNew();
            String versioncode = String.format("%1$s-%2$s", number, "0001");
            initRow.set("versioncode", (Object)versioncode);
            initRow.set("seq", (Object)1);
            initRow.set("versionname", (Object)"V1");
            newVerion = versioncode;
        } else {
            Optional<DynamicObject> original = entryentity.stream().filter(a -> versionname.equals(a.getString("versionname"))).findFirst();
            if (!original.isPresent()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6b64\u7248\u672c\u53f7\uff0c\u8bf7\u786e\u8ba4\u65b9\u6848\u7248\u672c\u53f7\u662f\u5426\u88ab\u5220\u9664\u3002", (String)"SchemaDataService_0", (String)"taxc-tcept", (Object[])new Object[0]));
            }
            DynamicObject maxSeqObj = entryentity.stream().max(Comparator.comparing(s -> s.getLong("id"))).get();
            DynamicObject newRow = entryentity.addNew();
            String[] splits1 = maxSeqObj.getString("versioncode").split("-");
            String[] splits2 = maxSeqObj.getString("versionname").split("V");
            String increaseCode = String.format("%04d", Integer.parseInt(splits1[splits1.length - 1]) + 1);
            Integer newvername = Integer.parseInt(splits2[1]) + 1;
            String versioncode = String.format("%1$s-%2$s", number, increaseCode);
            newRow.set("versioncode", (Object)versioncode);
            newRow.set("seq", (Object)(maxSeqObj.getInt("seq") + 1));
            newRow.set("versionname", (Object)String.format("%1$s%2$s", "V", newvername));
            newRow.set("incomever", original.get().get("incomever"));
            newRow.set("costver", original.get().get("costver"));
            newVerion = versioncode;
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        this.syncCreateBill(new DynamicObject[]{object});
        return newVerion;
    }
}

