/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.business.basedata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class TaxProjectDataService {
    private static final String BASTAX_TAXPROJECT = "bastax_taxproject";

    public static Long queryFirstProjectByOrg(Long orgid) {
        QFilter taxorg = new QFilter("taxorg", "=", (Object)orgid);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter qFilter = new QFilter("group.number", "=", (Object)"001");
        DynamicObject id = QueryServiceHelper.queryOne((String)BASTAX_TAXPROJECT, (String)"id", (QFilter[])new QFilter[]{taxorg, enable, status, qFilter});
        return id == null ? null : Long.valueOf(id.getLong("id"));
    }

    public static List<Long> queryProjectByOrg(List<Long> orgids) {
        QFilter taxorg = new QFilter("taxorg", "in", orgids);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter qFilter = new QFilter("group.number", "=", (Object)"001");
        DynamicObjectCollection query = QueryServiceHelper.query((String)BASTAX_TAXPROJECT, (String)"id", (QFilter[])new QFilter[]{taxorg, enable, status, qFilter});
        List<Long> ids = query.stream().map(a -> a.getLong("id")).collect(Collectors.toList());
        return ids;
    }

    public static String queryProjectSwqsytfl(Long projectId) {
        DynamicObject project;
        if (projectId != null && (project = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)BASTAX_TAXPROJECT)) != null) {
            String swqsytfl = project.getString("swqsytfl");
            return swqsytfl;
        }
        return "1";
    }

    public static String queryProjectSwqsytflNoFit(Long projectId) {
        DynamicObject project;
        if (projectId != null && (project = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)BASTAX_TAXPROJECT)) != null) {
            String swqsytfl = project.getString("swqsytfl");
            return swqsytfl;
        }
        return "";
    }

    public static BigDecimal queryProjectSyslzsl(Long projectId) {
        DynamicObject project;
        if (projectId != null && (project = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)BASTAX_TAXPROJECT)) != null) {
            return project.getBigDecimal("syslzsl");
        }
        return BigDecimal.ZERO;
    }

    public static List<ComboItem> getComboItemsBySwqsytfl(String swqsytfl) {
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(10);
        if (swqsytfl != null) {
            if ("0".equals(swqsytfl)) {
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u666e\u901a\u4f4f\u5b85", (String)"TaxProjectDataService_0", (String)"taxc-tcept", (Object[])new Object[0])), "01"));
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5176\u4ed6\u7c7b\u578b\u623f\u5730\u4ea7", (String)"TaxProjectDataService_1", (String)"taxc-tcept", (Object[])new Object[0])), "03"));
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u975e\u6e05\u7b97\u4e1a\u6001", (String)"TaxProjectDataService_2", (String)"taxc-tcept", (Object[])new Object[0])), "04"));
            }
            if ("1".equals(swqsytfl)) {
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u666e\u901a\u4f4f\u5b85", (String)"TaxProjectDataService_0", (String)"taxc-tcept", (Object[])new Object[0])), "01"));
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u975e\u666e\u901a\u4f4f\u5b85", (String)"TaxProjectDataService_3", (String)"taxc-tcept", (Object[])new Object[0])), "02"));
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5176\u4ed6\u7c7b\u578b\u623f\u5730\u4ea7", (String)"TaxProjectDataService_1", (String)"taxc-tcept", (Object[])new Object[0])), "03"));
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u975e\u6e05\u7b97\u4e1a\u6001", (String)"TaxProjectDataService_2", (String)"taxc-tcept", (Object[])new Object[0])), "04"));
            }
        }
        return data;
    }
}

