/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.business.draft;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.extplugin.PluginProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.helper.OperationResultHelper;
import kd.taxc.bdtaxr.common.utils.ServiceResultUtils;
import kd.taxc.tcept.business.basedata.CostReportDataService;
import kd.taxc.tcept.business.draft.AbstractDeskMeasureService;
import kd.taxc.tcept.business.draft.IncomeAdjustDraftService;
import kd.taxc.tcept.business.extpoint.ICostAdjustDraftExtService;
import kd.taxc.tcept.business.extpoint.IDeskMeasureService;
import kd.taxc.tcept.business.statistics.DeskServiceMediator;
import kd.taxc.tcept.common.utils.DraftCommonUtils;

public class CostAdjustDraftService
implements AbstractDeskMeasureService {
    public static final String TCEPT_COST_ADJ_DRAFT_EXTPLUGIN = "TAXC_TCEPT_COST_ADJ_DRAFT_EXTPLUGIN";
    public static final String ENTITY_KEY = "tcept_cost_adj_draft";

    public static List<Map<String, Object>> calcStxsTz(Long org, Long project, Long scheme, String version) {
        ArrayList<Map<String, Object>> stxstz = new ArrayList<Map<String, Object>>();
        DynamicObject incomeDraft = IncomeAdjustDraftService.queryIncomeDraftByUniq(org, project, scheme, version);
        if (incomeDraft != null) {
            DynamicObjectCollection stxsEntry = incomeDraft.getDynamicObjectCollection("entryentity1");
            for (DynamicObject dynamicObject : stxsEntry) {
                if (dynamicObject.get("costitemtype") == null) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("costadtype", "stxs");
                map.put("clearterm", dynamicObject.get("clearterm1"));
                map.put("costitem", dynamicObject.getLong("costitemtype.id"));
                map.put("sgtzzhsje", dynamicObject.get("stxscosttotal"));
                map.put("sgtzzbhsje", dynamicObject.get("stxscostnotax"));
                stxstz.add(map);
            }
        }
        CostAdjustDraftService.getCostAdjustDraftExtServices().forEach(a -> a.calcStxsTz(org, project, scheme, stxstz));
        return stxstz;
    }

    public static List<ICostAdjustDraftExtService> getCostAdjustDraftExtServices() {
        PluginProxy pluginProxy = PluginProxy.create(ICostAdjustDraftExtService.class, (String)TCEPT_COST_ADJ_DRAFT_EXTPLUGIN);
        return pluginProxy.getPlugins();
    }

    public static List<Map<String, Object>> calcCbHj(Long orgid, Long projectId, Long schemeId, String version, List<Map<String, Object>> stxsTz, List<Map<String, Object>> cbsgtz) {
        ArrayList<Map<String, Object>> cbhj = new ArrayList<Map<String, Object>>();
        DynamicObject costReport = CostReportDataService.queryAllPeriodData(orgid, projectId, schemeId, version);
        if (costReport != null) {
            HashMap<Object, List> costReportsHz = new HashMap<Object, List>(32);
            DynamicObjectCollection entryentity = costReport.getDynamicObjectCollection("entryentity");
            for (DynamicObject object : entryentity) {
                Object costitemId = object.get("costitem.id");
                List periodDataList = costReportsHz.getOrDefault(costitemId, new ArrayList());
                periodDataList.add(object);
                costReportsHz.put(costitemId, periodDataList);
            }
            Map<Object, List<Map>> stxsCostitem = stxsTz.stream().collect(Collectors.groupingBy(a -> a.get("costitem")));
            Map<Object, List<Map>> cbsgtzCostitem = cbsgtz.stream().collect(Collectors.groupingBy(a -> a.get("costitem1")));
            Object costreporttplid = costReport.get("costreporttpl.id");
            List<DynamicObject> costItems = CostReportDataService.queryCostreportTplCostItems(costreporttplid);
            for (DynamicObject cbbbitem : costItems) {
                List<Map> cbsgtzList;
                if (cbbbitem.getInt("level") >= 4) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                Object key = cbbbitem.get("id");
                List periodDataList = costReportsHz.getOrDefault(key, new ArrayList());
                HashMap<String, BigDecimal> totalAmount = CostAdjustDraftService.accumulatePeriodDataList(periodDataList);
                BigDecimal tzqhsje = totalAmount.get("tzqhsje");
                BigDecimal tzqbhsje = totalAmount.get("tzqbhsje");
                BigDecimal sgtzzhsje3 = BigDecimal.ZERO;
                BigDecimal sgtzzbhsje4 = BigDecimal.ZERO;
                List<Map> stxslist = stxsCostitem.get(key);
                if (stxslist != null) {
                    for (Map objectMap : stxslist) {
                        sgtzzhsje3 = sgtzzhsje3.add((BigDecimal)objectMap.get("sgtzzhsje"));
                        sgtzzbhsje4 = sgtzzbhsje4.add((BigDecimal)objectMap.get("sgtzzbhsje"));
                    }
                }
                if ((cbsgtzList = cbsgtzCostitem.get(key)) != null) {
                    for (Map objectMap : cbsgtzList) {
                        sgtzzhsje3 = sgtzzhsje3.add((BigDecimal)objectMap.get("sgtzzhsje1"));
                        sgtzzbhsje4 = sgtzzbhsje4.add((BigDecimal)objectMap.get("sgtzzbhsje1"));
                    }
                }
                map.put("costitemname", CostAdjustDraftService.formatCostItemName(cbbbitem.getString("name"), cbbbitem.getInt("level")));
                map.put("costitem2", key);
                map.put("tzqhsje", tzqhsje);
                map.put("tzqbhsje", tzqbhsje);
                map.put("sgtzzhsje3", sgtzzhsje3);
                map.put("sgtzzbhsje4", sgtzzbhsje4);
                map.put("tzhhsje", sgtzzhsje3.add(tzqhsje));
                map.put("tzhbhsje", sgtzzbhsje4.add(tzqbhsje));
                map.put("parentid", cbbbitem.get("parent.id"));
                map.put("level", cbbbitem.getInt("level"));
                cbhj.add(map);
            }
        }
        CostAdjustDraftService.accumulateCbhjByLevel(cbhj, 3, 2);
        CostAdjustDraftService.accumulateCbhjByLevel(cbhj, 2, 1);
        CostAdjustDraftService.calcHjRow(cbhj);
        return cbhj;
    }

    private static Object formatCostItemName(String name, int level) {
        if (level > 1) {
            for (int i = 0; i < level - 1; ++i) {
                name = "\t" + name;
            }
        }
        return name;
    }

    private static void calcHjRow(List<Map<String, Object>> cbhj) {
        BigDecimal tzqhsje = BigDecimal.ZERO;
        BigDecimal tzqbhsje = BigDecimal.ZERO;
        BigDecimal sgtzzhsje3 = BigDecimal.ZERO;
        BigDecimal sgtzzbhsje4 = BigDecimal.ZERO;
        BigDecimal tzhhsje = BigDecimal.ZERO;
        BigDecimal tzhbhsje = BigDecimal.ZERO;
        for (Map<String, Object> map : cbhj) {
            if ((Integer)map.get("level") == 1) {
                tzqhsje = tzqhsje.add((BigDecimal)map.get("tzqhsje"));
                tzqbhsje = tzqbhsje.add((BigDecimal)map.get("tzqbhsje"));
                sgtzzhsje3 = sgtzzhsje3.add((BigDecimal)map.get("sgtzzhsje3"));
                sgtzzbhsje4 = sgtzzbhsje4.add((BigDecimal)map.get("sgtzzbhsje4"));
                tzhhsje = tzhhsje.add((BigDecimal)map.get("tzhhsje"));
                tzhbhsje = tzhbhsje.add((BigDecimal)map.get("tzhbhsje"));
            }
            map.remove("parentid");
            map.remove("level");
        }
        HashMap<String, Object> hjRowMap = new HashMap<String, Object>();
        hjRowMap.put("costitemname", ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CostAdjustDraftService_0", (String)"taxc-tcept", (Object[])new Object[0]));
        hjRowMap.put("costitem2", 0L);
        hjRowMap.put("tzqhsje", tzqhsje);
        hjRowMap.put("tzqbhsje", tzqbhsje);
        hjRowMap.put("sgtzzhsje3", sgtzzhsje3);
        hjRowMap.put("sgtzzbhsje4", sgtzzbhsje4);
        hjRowMap.put("tzhhsje", sgtzzhsje3.add(tzqhsje));
        hjRowMap.put("tzhbhsje", sgtzzbhsje4.add(tzqbhsje));
        cbhj.add(hjRowMap);
    }

    private static void accumulateCbhjByLevel(List<Map<String, Object>> cbhj, int form, int to) {
        Map<Object, List<Map>> parentidMap = cbhj.stream().filter(a -> (Integer)a.get("level") == form).collect(Collectors.groupingBy(a -> a.get("parentid")));
        for (Map<String, Object> objectMap : cbhj) {
            if ((Integer)objectMap.get("level") != to) continue;
            BigDecimal tzqhsje = BigDecimal.ZERO;
            BigDecimal tzqbhsje = BigDecimal.ZERO;
            BigDecimal sgtzzhsje3 = BigDecimal.ZERO;
            BigDecimal sgtzzbhsje4 = BigDecimal.ZERO;
            BigDecimal tzhhsje = BigDecimal.ZERO;
            BigDecimal tzhbhsje = BigDecimal.ZERO;
            Object key = objectMap.get("costitem2");
            List<Map> maps = parentidMap.get(key);
            if (maps == null) continue;
            for (Map map : maps) {
                tzqhsje = tzqhsje.add((BigDecimal)map.get("tzqhsje"));
                tzqbhsje = tzqbhsje.add((BigDecimal)map.get("tzqbhsje"));
                sgtzzhsje3 = sgtzzhsje3.add((BigDecimal)map.get("sgtzzhsje3"));
                sgtzzbhsje4 = sgtzzbhsje4.add((BigDecimal)map.get("sgtzzbhsje4"));
                tzhhsje = tzhhsje.add((BigDecimal)map.get("tzhhsje"));
                tzhbhsje = tzhbhsje.add((BigDecimal)map.get("tzhbhsje"));
            }
            objectMap.put("tzqhsje", tzqhsje);
            objectMap.put("tzqbhsje", tzqbhsje);
            objectMap.put("sgtzzhsje3", sgtzzhsje3);
            objectMap.put("sgtzzbhsje4", sgtzzbhsje4);
            objectMap.put("tzhhsje", sgtzzhsje3.add(tzqhsje));
            objectMap.put("tzhbhsje", sgtzzbhsje4.add(tzqbhsje));
        }
    }

    private static HashMap<String, BigDecimal> accumulatePeriodDataList(List<DynamicObject> periodDataList) {
        BigDecimal tzqhsje = BigDecimal.ZERO;
        BigDecimal tzqbhsje = BigDecimal.ZERO;
        for (DynamicObject dynamicObject : periodDataList) {
            tzqhsje = tzqhsje.add(dynamicObject.getBigDecimal("taxamount"));
            tzqbhsje = tzqbhsje.add(dynamicObject.getBigDecimal("amount"));
        }
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        map.put("tzqhsje", tzqhsje);
        map.put("tzqbhsje", tzqbhsje);
        return map;
    }

    public static Map<String, List> callBillAll(Long org, Long project, Long scheme, String version, List<Map<String, Object>> cbsgtz) {
        HashMap<String, List> map = new HashMap<String, List>();
        if (org != null && project != null && scheme != null) {
            List<Map<String, Object>> stxstz = CostAdjustDraftService.calcStxsTz(org, project, scheme, version);
            List<Map<String, Object>> cbhj = CostAdjustDraftService.calcCbHj(org, project, scheme, version, stxstz, cbsgtz);
            map.put("stxstz", stxstz);
            map.put("cbsgtz", cbsgtz);
            map.put("cbhj", cbhj);
        } else {
            map.put("stxstz", new ArrayList(0));
            map.put("cbsgtz", cbsgtz);
            map.put("cbhj", new ArrayList(0));
        }
        return map;
    }

    public static List<Map<String, Object>> getCbsgTzEntryData(Long orgid, Long projectId, Long schemeId, String version) {
        DynamicObject dynamicObject = CostAdjustDraftService.queryCostAdjustDraft(orgid, projectId, schemeId, version);
        if (dynamicObject != null) {
            DynamicObjectCollection cbsgEntity = dynamicObject.getDynamicObjectCollection("entryentity1");
            List<Map<String, Object>> cbsgtz = CostAdjustDraftService.getCbsgTzEntryData(cbsgEntity);
            return cbsgtz;
        }
        return new ArrayList<Map<String, Object>>();
    }

    public static List<Map<String, Object>> getCbsgTzEntryData(DynamicObjectCollection cbsgEntity) {
        ArrayList<Map<String, Object>> cbsgtz = new ArrayList<Map<String, Object>>();
        for (DynamicObject dynamicObject : cbsgEntity) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("costadtype1", dynamicObject.get("costadtype1"));
            map.put("costitem1", dynamicObject.getLong("costitem1.id"));
            map.put("sgtzzhsje1", dynamicObject.get("sgtzzhsje1"));
            map.put("sgtzzbhsje1", dynamicObject.get("sgtzzbhsje1"));
            map.put("comments", dynamicObject.get("comments"));
            cbsgtz.add(map);
        }
        return cbsgtz;
    }

    public static List<Map<String, Object>> getCbHjEntryData(Long orgid, Long projectId, Long schemeId, String version) {
        DynamicObject dynamicObject = CostAdjustDraftService.queryCostAdjustDraft(orgid, projectId, schemeId, version);
        if (dynamicObject != null) {
            DynamicObjectCollection cbhjEntity = dynamicObject.getDynamicObjectCollection("entryentity2");
            List<Map<String, Object>> cbhj = CostAdjustDraftService.getCbHjEntryData(cbhjEntity);
            return cbhj;
        }
        return new ArrayList<Map<String, Object>>();
    }

    public static List<Map<String, Object>> getCbHjEntryData(DynamicObjectCollection cbhjEntity) {
        ArrayList<Map<String, Object>> cbhj = new ArrayList<Map<String, Object>>();
        for (DynamicObject dynamicObject : cbhjEntity) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("costitemname", dynamicObject.get("costitemname"));
            map.put("costitem2", dynamicObject.get("costitem2"));
            map.put("tzqhsje", dynamicObject.get("tzqhsje"));
            map.put("tzqbhsje", dynamicObject.get("tzqbhsje"));
            map.put("sgtzzhsje3", dynamicObject.get("sgtzzhsje3"));
            map.put("sgtzzbhsje4", dynamicObject.get("sgtzzbhsje4"));
            map.put("tzhhsje", dynamicObject.get("tzhhsje"));
            map.put("tzhbhsje", dynamicObject.get("tzhbhsje"));
            cbhj.add(map);
        }
        return cbhj;
    }

    public static void setStxsEntryEntity(DynamicObjectCollection stxsEntry, List<Map<String, Object>> stxstz) {
        stxsEntry.clear();
        for (int i = 0; i < stxstz.size(); ++i) {
            Map<String, Object> map = stxstz.get(i);
            DynamicObject dynamicObject = stxsEntry.addNew();
            CostAdjustDraftService.getCostAdjustDraftExtServices().forEach(a -> a.setStxsTzFieldDataToDynamic(dynamicObject, map));
            dynamicObject.set("costadtype", map.get("costadtype"));
            dynamicObject.set("clearterm", map.get("clearterm"));
            dynamicObject.set("costitem", map.get("costitem"));
            dynamicObject.set("sgtzzhsje", map.get("sgtzzhsje"));
            dynamicObject.set("sgtzzbhsje", map.get("sgtzzbhsje"));
        }
    }

    public static DynamicObject queryCostAdjustDraft(Long orgid, Long projectId, Long schemeId, String version) {
        QFilter org = new QFilter("org", "=", (Object)orgid);
        QFilter project = new QFilter("houseproject", "=", (Object)projectId);
        QFilter scheme = new QFilter("scheme", "=", (Object)schemeId);
        QFilter versionQF = new QFilter("version", "=", (Object)version);
        DynamicObject id = QueryServiceHelper.queryOne((String)ENTITY_KEY, (String)"id", (QFilter[])new QFilter[]{org, project, scheme, versionQF});
        if (id != null) {
            return BusinessDataServiceHelper.loadSingle((Object)id.get("id"), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)ENTITY_KEY));
        }
        return null;
    }

    public static List<Map<String, Object>> getStxsTzEntryData(Long orgid, Long projectId, Long schemeId, String version) {
        DynamicObject dynamicObject = CostAdjustDraftService.queryCostAdjustDraft(orgid, projectId, schemeId, version);
        if (dynamicObject != null) {
            DynamicObjectCollection stxsEntry = dynamicObject.getDynamicObjectCollection("entryentity");
            List<Map<String, Object>> stxsTzEntryData = CostAdjustDraftService.getStxsTzEntryData(stxsEntry);
            return stxsTzEntryData;
        }
        return new ArrayList<Map<String, Object>>();
    }

    public static List<Map<String, Object>> getStxsTzEntryData(DynamicObjectCollection stxsEntry) {
        ArrayList<Map<String, Object>> cbsgtz = new ArrayList<Map<String, Object>>();
        for (DynamicObject dynamicObject : stxsEntry) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("costadtype", dynamicObject.get("costadtype"));
            map.put("clearterm", dynamicObject.get("clearterm"));
            map.put("costitem", dynamicObject.getLong("costitem.id"));
            map.put("sgtzzhsje", dynamicObject.get("sgtzzhsje"));
            map.put("sgtzzbhsje", dynamicObject.get("sgtzzbhsje"));
            CostAdjustDraftService.getCostAdjustDraftExtServices().forEach(a -> a.setStxsTzFieldDataToMap(dynamicObject, map));
            cbsgtz.add(map);
        }
        return cbsgtz;
    }

    public static void setCbhjEntryEntity(DynamicObjectCollection cbhjEntry, List<Map<String, Object>> cbhj) {
        cbhjEntry.clear();
        for (int i = 0; i < cbhj.size(); ++i) {
            Map<String, Object> map = cbhj.get(i);
            DynamicObject dynamicObject = cbhjEntry.addNew();
            dynamicObject.set("costitemname", map.get("costitemname"));
            dynamicObject.set("costitem2", map.get("costitem2"));
            dynamicObject.set("tzqhsje", map.get("tzqhsje"));
            dynamicObject.set("tzqbhsje", map.get("tzqbhsje"));
            dynamicObject.set("sgtzzhsje3", map.get("sgtzzhsje3"));
            dynamicObject.set("sgtzzbhsje4", map.get("sgtzzbhsje4"));
            dynamicObject.set("tzhhsje", map.get("tzhhsje"));
            dynamicObject.set("tzhbhsje", map.get("tzhbhsje"));
            if (0L != (Long)map.get("costitem2")) continue;
            ((DynamicObject)cbhjEntry.getParent()).set("befortaxamount", map.get("tzqhsje"));
            ((DynamicObject)cbhjEntry.getParent()).set("adjamount", map.get("sgtzzhsje3"));
            ((DynamicObject)cbhjEntry.getParent()).set("aftertaxamount", map.get("tzhhsje"));
        }
    }

    public static OperationResult reCalc(Long billid) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)billid, (String)ENTITY_KEY);
        if (dynamicObject != null) {
            long org = dynamicObject.getLong("org.id");
            long project = dynamicObject.getLong("houseproject.id");
            long scheme = dynamicObject.getLong("scheme.id");
            String version = dynamicObject.getString("version");
            String billStatus = dynamicObject.getString("billstatus");
            if (!"A".equals(billStatus)) {
                OperationResult reclac = OperationResultHelper.getFatalErrorOperateResult((String)"reclac", Collections.singletonList(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u201c\u6682\u5b58\u201d\u7684\u5355\u636e\u3002", (String)"CostAdjustDraftService_3", (String)"taxc-tcept", (Object[])new Object[0])), (String)"", (int)1, new ArrayList());
                return reclac;
            }
            DynamicObjectCollection entryentity2 = dynamicObject.getDynamicObjectCollection("entryentity2");
            boolean changedCostItem = CostAdjustDraftService.isChangedCostItem(org, project, scheme, version, entryentity2);
            if (changedCostItem) {
                OperationResult reclac = OperationResultHelper.getFatalErrorOperateResult((String)"reclac", Collections.singletonList(ResManager.loadKDString((String)"\u6210\u672c\u62a5\u8868\u4e2d\u7684\u6210\u672c\u9879\u76ee\u5df2\u53d8\u66f4\uff0c\u8bf7\u91cd\u7f6e\u5e95\u7a3f\u3002", (String)"CostAdjustDraftService_1", (String)"taxc-tcept", (Object[])new Object[0])), (String)"", (int)1, new ArrayList());
                return reclac;
            }
            CostAdjustDraftService.doRecalc(dynamicObject);
            OperationResult save = OperationServiceHelper.executeOperate((String)"save", (String)ENTITY_KEY, (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create());
            if (save.isSuccess()) {
                DeskServiceMediator.fireBillChange(ENTITY_KEY, billid);
            }
            return save;
        }
        return null;
    }

    private static void doRecalc(DynamicObject dynamicObject) {
        Long orgid = (Long)dynamicObject.get("org.id");
        Long projectId = (Long)dynamicObject.get("houseproject.id");
        Long schemeId = (Long)dynamicObject.get("scheme.id");
        String version = dynamicObject.getString("version");
        List<Map<String, Object>> cbsgtz = CostAdjustDraftService.getCbsgTzEntryData(dynamicObject.getDynamicObjectCollection("entryentity1"));
        Map<String, List> resultListMap = CostAdjustDraftService.callBillAll(orgid, projectId, schemeId, version, cbsgtz);
        CostAdjustDraftService.setStxsEntryEntity(dynamicObject.getDynamicObjectCollection("entryentity"), resultListMap.get("stxstz"));
        CostAdjustDraftService.setCbhjEntryEntity(dynamicObject.getDynamicObjectCollection("entryentity2"), resultListMap.get("cbhj"));
    }

    @Override
    public String getBillNumber() {
        return ENTITY_KEY;
    }

    @Override
    public Map<String, String> getInfoSyncField() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("org_field_key", "org");
        hashMap.put("project_field_key", "houseproject");
        hashMap.put("scheme_field_key", "scheme");
        hashMap.put("version_field_key", "version");
        hashMap.put("billno_field_key", "billno");
        hashMap.put("billstatus_field_key", "billstatus");
        hashMap.put("modifier_field_key", "modifier");
        hashMap.put("modifydate_field_key", "modifytime");
        return hashMap;
    }

    @Override
    public Map<String, Object> copy(Long originalPk, Long org, Long project, Long scheme, String version, String newVersion) {
        DynamicObject single = BusinessDataServiceHelper.loadSingle((Object)originalPk, (String)ENTITY_KEY);
        DynamicObject newObj = (DynamicObject)new CloneUtils(false, true).clone((IDataEntityBase)single);
        newObj.set("id", null);
        newObj.set("version", (Object)newVersion);
        String billno = DraftCommonUtils.getDraftNumber(newObj, single.getLong("org.id"));
        newObj.set("billno", (Object)billno);
        newObj.set("billstatus", (Object)"A");
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newObj});
        return ServiceResultUtils.returnResultHandler((Object)save[0]);
    }

    @Override
    public boolean isSupportRecalc() {
        return true;
    }

    @Override
    public Map<String, Object> recalc(Long billpk, Long org, Long project, Long scheme, String version) {
        OperationResult save;
        boolean exists = QueryServiceHelper.exists((String)this.getBillNumber(), (Object)billpk);
        if (exists && (save = CostAdjustDraftService.reCalc(billpk)) != null) {
            return AbstractDeskMeasureService.getResultMapFormOpRe(null, save);
        }
        return IDeskMeasureService.createReturnResultObject(Boolean.FALSE, "-1", ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u65e0\u9700\u64cd\u4f5c\u3002", (String)"CostAdjustDraftService_2", (String)"taxc-tcept", (Object[])new Object[0]), null);
    }

    public static boolean isChangedCostItem(Long org, Long project, Long scheme, String version, DynamicObjectCollection entryentity2) {
        Set dbSets = entryentity2.stream().map(a -> a.getDynamicObject("costitem2")).filter(b -> b != null).map(c -> c.getLong("id")).collect(Collectors.toSet());
        DynamicObject costReport = CostReportDataService.queryAllPeriodData(org, project, scheme, version);
        Set<Object> nowSets = new HashSet(4);
        if (costReport != null) {
            Object costreporttplid = costReport.get("costreporttpl.id");
            List<DynamicObject> costItems = CostReportDataService.queryCostreportTplCostItems(costreporttplid);
            nowSets = costItems.stream().filter(b -> b.getInt("level") < 4).map(c -> c.getLong("id")).collect(Collectors.toSet());
        }
        Sets.SetView difference = Sets.difference(dbSets, nowSets);
        Sets.SetView difference1 = Sets.difference(nowSets, dbSets);
        return difference.size() > 0 || difference1.size() > 0;
    }
}

