/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.business.draft;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.helper.OperationResultHelper;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.utils.ServiceResultUtils;
import kd.taxc.tcept.business.basedata.CostItemDataService;
import kd.taxc.tcept.business.basedata.CostReportDataService;
import kd.taxc.tcept.business.basedata.SchemaDataService;
import kd.taxc.tcept.business.basedata.TaxProjectDataService;
import kd.taxc.tcept.business.draft.AbstractDeskMeasureService;
import kd.taxc.tcept.business.draft.CostAdjustDraftService;
import kd.taxc.tcept.business.draft.ManualAdjustDetailService;
import kd.taxc.tcept.business.extpoint.IDeskMeasureService;
import kd.taxc.tcept.business.statistics.DeskServiceMediator;
import kd.taxc.tcept.common.constant.CostSplitFieldMappingEnum;
import kd.taxc.tcept.common.dto.AdjustRecordDto;
import kd.taxc.tcept.common.enums.ClearPeriodEnum;
import kd.taxc.tcept.common.utils.CollectionTool;
import kd.taxc.tcept.common.utils.DraftCommonUtils;

public class CostSplitDraftService
implements AbstractDeskMeasureService {
    private static final Log LOGGER = LogFactory.getLog(CostSplitDraftService.class);
    public static final int STEP_NUM = 3;
    public static final String STATUS_STEP1 = "1";
    public static final String STATUS_STEP2 = "2";
    public static final String STATUS_STEP3 = "3";
    public static final String MANUAL_INFO_CHANGE_KEY = "manualinfochange";
    public static final String RECALC_CHANGE_KEY = "recalcchange";
    public static final String STEP_FORM1 = "tcept_cost_split_peri_rat";
    public static final String STEP_FORM2 = "tcept_cost_split_taxt_rat";
    public static final String STEP_FORM3 = "tcept_cost_split_table";
    public static final String TCEPT_COST_SPLIT_DRAFT = "tcept_cost_split_draft";
    public static final String ADJUST_DETAIL_TABLE = "tcept_cost_split_draft_entryentity2";
    private static final String T_TCEPT_CBFTDG_FQJ_FT = "t_tcept_cbftdg_fqj_ft";
    public static final String ADJUST_CACHE_KEY = "AdjustRecordDto";
    public static final String TCEPT_COST_SPLIT_PAGE = "tcept_cost_split_page";

    public static String getPageFormByStep(String step) {
        if (step != null) {
            switch (step) {
                case "1": {
                    return STEP_FORM1;
                }
                case "2": {
                    return STEP_FORM2;
                }
                case "3": {
                    return STEP_FORM3;
                }
            }
        }
        return null;
    }

    public static String getBillStatus(Long billId) {
        DynamicObject dynamicObject;
        if (billId != null && billId != 0L && (dynamicObject = QueryServiceHelper.queryOne((String)TCEPT_COST_SPLIT_DRAFT, (String)"billstatus", (QFilter[])new QFilter("id", "=", (Object)billId).toArray())) != null) {
            return dynamicObject.getString("billstatus");
        }
        return null;
    }

    public static DynamicObject getDraftDataByPk(String bill_id) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(bill_id), (String)TCEPT_COST_SPLIT_DRAFT);
        return object;
    }

    public static DynamicObject getDraftDataByUniKey(Long orgid, Long projectId, Long schemeId, String version) {
        QFilter org = new QFilter("org", "=", (Object)orgid);
        QFilter project = new QFilter("houseproject", "=", (Object)projectId);
        QFilter scheme = new QFilter("scheme", "=", (Object)schemeId);
        QFilter versionQF = new QFilter("version", "=", (Object)version);
        DynamicObject id = QueryServiceHelper.queryOne((String)TCEPT_COST_SPLIT_DRAFT, (String)"id", (QFilter[])new QFilter[]{org, project, scheme, versionQF});
        if (id != null) {
            return BusinessDataServiceHelper.loadSingle((Object)id.get("id"), (String)TCEPT_COST_SPLIT_DRAFT);
        }
        return null;
    }

    public static Map<Object, Map<String, BigDecimal>> getPeriodTaxTypeSplitTableGroup(Long orgid, Long projectId, Long schemeId, String version, String costitemNumber) {
        DynamicObject incomeAdjDraft = CostSplitDraftService.getDraftDataByUniKey(orgid, projectId, schemeId, version);
        if (incomeAdjDraft != null) {
            DynamicObjectCollection entryentity = incomeAdjDraft.getDynamicObjectCollection("entryentity3");
            List<DynamicObject> collect = entryentity.stream().filter(a -> costitemNumber.equals(a.getString("costitem3.number"))).collect(Collectors.toList());
            Map<Object, Map<String, BigDecimal>> objectMapMap = CollectionTool.listGroupOnceGetOneToGroup(collect, "period3", "ptzztaxamount", "ptzznotaxamount", "fptzztaxamount", "fptzznotaxamount", "qtlxfctaxamount", "qtlxfcnotaxamount", "fqsyttaxamount", "fqsytnotaxamount");
            return objectMapMap;
        }
        return new HashMap<Object, Map<String, BigDecimal>>();
    }

    public static DynamicObjectCollection getDraftDataPeriodRateEntryByPk(String bill_id) {
        DynamicObject draftDataByPk = CostSplitDraftService.getDraftDataByPk(bill_id);
        return draftDataByPk.getDynamicObjectCollection("entryentity");
    }

    public static String getSuffixByPeriod(String period) {
        if ("00".equals(period)) {
            return "0";
        }
        ClearPeriodEnum byCode = ClearPeriodEnum.getByCode(period);
        return byCode == null ? "0" : byCode.getOrder().toString();
    }

    private static List<String> getSubGroupSuffix(CostSplitFieldMappingEnum costSplitFieldMappingEnum, DynamicObject dynamicObject) {
        String formFieldKeyPreffix = costSplitFieldMappingEnum.getFormFieldKeyPreffix();
        DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
        List<String> groupS = properties.stream().filter(property -> property.getName().startsWith(formFieldKeyPreffix)).map(a -> a.getName()).collect(Collectors.toList());
        return groupS;
    }

    public static void paddingDataDbToForm(DynamicObjectCollection showEntry, DynamicObjectCollection dbRows, String dbRowGroupField, String subGroupField, List<CostSplitFieldMappingEnum> mappingEnums, BiConsumer<DynamicObject, DynamicObject> consumer) {
        Map<Boolean, List<CostSplitFieldMappingEnum>> mappingEnumsGroup = mappingEnums.stream().collect(Collectors.groupingBy(a -> a.isDirectMap()));
        Map<String, List<DynamicObject>> dbRowGroups = dbRows.stream().collect(Collectors.groupingBy(a -> a.get("seq") + "_" + a.get(dbRowGroupField)));
        ArrayList<String> sortKeys = CostSplitDraftService.getSortKeys(dbRowGroups.keySet());
        for (String key : sortKeys) {
            List<CostSplitFieldMappingEnum> notDirectMappingFields;
            List<DynamicObject> value = dbRowGroups.get(key);
            DynamicObject addNew = showEntry.addNew();
            List<CostSplitFieldMappingEnum> directMappingFields = mappingEnumsGroup.get(Boolean.TRUE);
            DynamicObject rowDynamicObject = value.get(0);
            addNew.set("seq", rowDynamicObject.get("seq"));
            for (CostSplitFieldMappingEnum directMappingField : directMappingFields) {
                if (!addNew.containsProperty(directMappingField.getFormFieldKeyPreffix())) continue;
                addNew.set(directMappingField.getFormFieldKeyPreffix(), rowDynamicObject.get(directMappingField.getBillFieldKey()));
            }
            if (consumer != null) {
                consumer.accept(addNew, rowDynamicObject);
            }
            if ((notDirectMappingFields = mappingEnumsGroup.get(Boolean.FALSE)) == null || notDirectMappingFields.size() <= 0) continue;
            Map<Object, List<DynamicObject>> subGroup = value.stream().collect(Collectors.groupingBy(a -> a.get(subGroupField)));
            for (CostSplitFieldMappingEnum notDirectMappingField : notDirectMappingFields) {
                for (Map.Entry<Object, List<DynamicObject>> subGroupEntry : subGroup.entrySet()) {
                    DynamicObject subDynamicObject = subGroupEntry.getValue().get(0);
                    String suffix = CostSplitDraftService.getSuffixByPeriod((String)subGroupEntry.getKey());
                    String forField = notDirectMappingField.getFormFieldKeyPreffix() + suffix;
                    if (!addNew.containsProperty(forField)) continue;
                    addNew.set(forField, subDynamicObject.get(notDirectMappingField.getBillFieldKey()));
                }
            }
        }
    }

    private static ArrayList<String> getSortKeys(Set<String> keyset) {
        ArrayList<String> keys = new ArrayList<String>(keyset);
        keys.sort((s, v) -> {
            Integer seq1 = Integer.valueOf(s.split("_")[0]);
            Integer seq2 = Integer.valueOf(v.split("_")[0]);
            return seq1.compareTo(seq2);
        });
        return keys;
    }

    public static List<Map<String, Object>> calcCbftbFqj(int clearperiod, Long orgid, Long projectId, Long scheme, String version, Map<Long, Map<String, BigDecimal>> cbxmFqjFtblMap, Boolean removeManualAdjustData, Object bizid, List<AdjustRecordDto> adjustRecordDtos) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List<String> changeFields = Arrays.asList("notaxamount", "taxamount");
        List<Map<String, Object>> stxsTzEntryData = CostAdjustDraftService.getStxsTzEntryData(orgid, projectId, scheme, version);
        Map<Long, Map<String, List<Map<String, Object>>>> stxsGroup = CostSplitDraftService.listGroupTwice(stxsTzEntryData, "costitem", "clearterm");
        List<Map<String, Object>> cbsgTzEntryData = CostAdjustDraftService.getCbsgTzEntryData(orgid, projectId, scheme, version);
        Map<Long, List<Map<String, Object>>> cbsgTzGroup = cbsgTzEntryData.stream().collect(Collectors.groupingBy(a -> (Long)a.get("costitem1")));
        Map<String, List<AdjustRecordDto>> adjustDetailMap = CostSplitDraftService.getAdjustDetailMap(adjustRecordDtos);
        Boolean sameclearofcost = SchemaDataService.querySchemeSameclearofcost(scheme);
        if (sameclearofcost.booleanValue()) {
            CostSplitDraftService.calcFqjForSame(clearperiod, orgid, projectId, scheme, version, cbxmFqjFtblMap, result, stxsGroup, cbsgTzGroup, adjustDetailMap, changeFields);
        } else {
            CostSplitDraftService.calcFqjForNoSame(clearperiod, orgid, projectId, scheme, version, cbxmFqjFtblMap, result, stxsGroup, cbsgTzGroup, adjustDetailMap, changeFields);
        }
        CostSplitDraftService.accumulateFqjFtbByLevel(result, 3, 2, clearperiod);
        CostSplitDraftService.accumulateFqjFtbByLevel(result, 2, 1, clearperiod);
        CostSplitDraftService.calcHjRow(result, clearperiod);
        return result;
    }

    public static Object formatCostItemName(String name, int level) {
        if (level > 1) {
            for (int i = 0; i < level - 1; ++i) {
                name = "\t" + name;
            }
        }
        return name;
    }

    private static void calcFqjForNoSame(int clearperiod, Long orgid, Long projectId, Long scheme, String version, Map<Long, Map<String, BigDecimal>> cbxmFqjFtblMap, List<Map<String, Object>> result, Map<Long, Map<String, List<Map<String, Object>>>> stxsGroup, Map<Long, List<Map<String, Object>>> cbsgTzGroup, Map<String, List<AdjustRecordDto>> adjustDetailMap, List<String> changeFields) {
        List<Map<String, Object>> cbHjEntryData = CostAdjustDraftService.getCbHjEntryData(orgid, projectId, scheme, version);
        Map<Long, Map> cbtzmap = cbHjEntryData.stream().collect(Collectors.toMap(a -> {
            DynamicObject b = (DynamicObject)a.get("costitem2");
            return b != null ? b.getLong("id") : 0L;
        }, v -> v, (m, n) -> m));
        Set<Object> lastLevelCostItemIdsByUniq = CostReportDataService.getLastLevelCostItemIdsByUniq(orgid, projectId, scheme, version);
        List<DynamicObject> dynamicObjectList = CostReportDataService.queryCostItemOfTplByReport(orgid, projectId, scheme, version);
        for (DynamicObject costitemObj : dynamicObjectList) {
            if (costitemObj == null || costitemObj.getInt("level") >= 4) continue;
            Long costitemid = costitemObj.getLong("id");
            Map cbHjEntryDatum = cbtzmap.getOrDefault(costitemid, new HashMap());
            HashMap<String, Object> rowMap = new HashMap<String, Object>(32);
            rowMap.put("costitem", costitemid);
            rowMap.put("rowid", DBUtils.getLongId((String)T_TCEPT_CBFTDG_FQJ_FT));
            Boolean lastLevel = Boolean.FALSE;
            if (costitemObj != null) {
                int level = costitemObj.getInt("level");
                rowMap.put("costitemname", CostSplitDraftService.formatCostItemName(costitemObj.getString("name"), level));
                rowMap.put("parentid", costitemObj.get("parent.id"));
                lastLevel = lastLevelCostItemIdsByUniq.contains(costitemid);
                rowMap.put("level", level);
                rowMap.put("lastlevel", lastLevel);
            }
            BigDecimal sgtzTaxamountTotal = BigDecimal.ZERO;
            BigDecimal sgtzNotaxamountTotal = BigDecimal.ZERO;
            List<Map<String, Object>> sgtzList = cbsgTzGroup.get(costitemid);
            if (sgtzList != null) {
                for (Map<String, Object> sgtz : sgtzList) {
                    sgtzTaxamountTotal = sgtzTaxamountTotal.add((BigDecimal)sgtz.get("sgtzzhsje1"));
                    sgtzNotaxamountTotal = sgtzNotaxamountTotal.add((BigDecimal)sgtz.get("sgtzzbhsje1"));
                }
            }
            Map<String, BigDecimal> splitRate = cbxmFqjFtblMap.get(costitemid);
            BigDecimal cbhjTaxamountTotal = cbHjEntryDatum.getOrDefault("tzqhsje", BigDecimal.ZERO);
            BigDecimal cbhjNotaxamountTotal = cbHjEntryDatum.getOrDefault("tzqbhsje", BigDecimal.ZERO);
            for (int i = 1; i <= clearperiod; ++i) {
                BigDecimal taxamount = BigDecimal.ZERO;
                BigDecimal notaxamount = BigDecimal.ZERO;
                ClearPeriodEnum periodEnum = ClearPeriodEnum.getByOrder(i);
                String code = periodEnum.getCode();
                Map<String, List<Map<String, Object>>> stxsItemGroup = stxsGroup.get(costitemid);
                if (stxsItemGroup != null && stxsItemGroup.get(code) != null) {
                    List<Map<String, Object>> stxsList = stxsItemGroup.get(code);
                    BigDecimal sgtzzhsje = stxsList.stream().map(a -> (BigDecimal)a.get("sgtzzhsje")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal sgtzzbhsje = stxsList.stream().map(a -> (BigDecimal)a.get("sgtzzbhsje")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    taxamount = taxamount.add(sgtzzhsje);
                    notaxamount = notaxamount.add(sgtzzbhsje);
                }
                if (splitRate != null && splitRate.get("" + i) != null) {
                    BigDecimal rate = splitRate.get("" + i);
                    taxamount = taxamount.add(sgtzTaxamountTotal.multiply(rate));
                    notaxamount = notaxamount.add(sgtzNotaxamountTotal.multiply(rate));
                    taxamount = taxamount.add(cbhjTaxamountTotal.multiply(rate));
                    notaxamount = notaxamount.add(cbhjNotaxamountTotal.multiply(rate));
                }
                if (lastLevel.booleanValue()) {
                    for (String changeField : changeFields) {
                        String key = costitemid.toString() + changeField + code;
                        if (!adjustDetailMap.containsKey(key)) continue;
                        AdjustRecordDto changeData = adjustDetailMap.get(key).get(0);
                        String adjustvalue = changeData.getAdjustvalue();
                        BigDecimal changeAmount = ManualAdjustDetailService.convertBigDecimal(adjustvalue);
                        if ("notaxamount".equals(changeField)) {
                            notaxamount = notaxamount.add(changeAmount);
                            continue;
                        }
                        if (!"taxamount".equals(changeField)) continue;
                        taxamount = taxamount.add(changeAmount);
                    }
                }
                rowMap.put("taxamount" + i, taxamount);
                rowMap.put("notaxamount" + i, notaxamount);
            }
            CostSplitDraftService.calcHjColumn(rowMap, "taxamount", 0, clearperiod);
            CostSplitDraftService.calcHjColumn(rowMap, "notaxamount", 0, clearperiod);
            result.add(rowMap);
        }
    }

    private static void calcFqjForSame(int clearperiod, Long orgid, Long projectId, Long schemeId, String version, Map<Long, Map<String, BigDecimal>> cbxmFqjFtblMap, List<Map<String, Object>> result, Map<Long, Map<String, List<Map<String, Object>>>> stxsGroup, Map<Long, List<Map<String, Object>>> cbsgTzGroup, Map<String, List<AdjustRecordDto>> adjustDetailMap, List<String> changeFields) {
        DynamicObject costReport = CostReportDataService.queryAllPeriodData(orgid, projectId, schemeId, version);
        if (costReport != null) {
            DynamicObjectCollection entryentity = costReport.getDynamicObjectCollection("entryentity");
            HashMap<Long, Map> costReportsPeriodData = new HashMap<Long, Map>(32);
            for (DynamicObject dynamicObject : entryentity) {
                Long costitemId = (Long)dynamicObject.get("costitem.id");
                Map periodDataMap = costReportsPeriodData.getOrDefault(costitemId, new HashMap());
                String periodcount = dynamicObject.getInt("periodnum") + "";
                periodDataMap.put(periodcount, dynamicObject);
                costReportsPeriodData.put(costitemId, periodDataMap);
            }
            Object costreporttplid = costReport.get("costreporttpl.id");
            List<DynamicObject> costItems = CostReportDataService.queryCostreportTplCostItems(costreporttplid);
            Set<Object> lastLevelCostItemIdsByUniq = CostReportDataService.getLastLevelCostItemIdsByUniq(orgid, projectId, schemeId, version);
            for (DynamicObject cbbbitem : costItems) {
                int level = cbbbitem.getInt("level");
                if (level >= 4) continue;
                Long costitemid = cbbbitem.getLong("id");
                Boolean lastLevel = lastLevelCostItemIdsByUniq.contains(costitemid);
                HashMap<String, Object> rowMap = new HashMap<String, Object>(32);
                rowMap.put("costitem", costitemid);
                rowMap.put("rowid", DBUtils.getLongId((String)T_TCEPT_CBFTDG_FQJ_FT));
                rowMap.put("level", level);
                rowMap.put("lastlevel", lastLevel);
                rowMap.put("costitemname", CostSplitDraftService.formatCostItemName(cbbbitem.getString("name"), level));
                rowMap.put("parentid", cbbbitem.get("parent.id"));
                BigDecimal sgtzTaxamountTotal = BigDecimal.ZERO;
                BigDecimal sgtzNotaxamountTotal = BigDecimal.ZERO;
                List<Map<String, Object>> sgtzList = cbsgTzGroup.get(costitemid);
                if (sgtzList != null) {
                    for (Map<String, Object> sgtz : sgtzList) {
                        sgtzTaxamountTotal = sgtzTaxamountTotal.add((BigDecimal)sgtz.get("sgtzzhsje1"));
                        sgtzNotaxamountTotal = sgtzNotaxamountTotal.add((BigDecimal)sgtz.get("sgtzzbhsje1"));
                    }
                }
                for (int i = 1; i <= clearperiod; ++i) {
                    Map<String, BigDecimal> splitRate;
                    Map<String, List<Map<String, Object>>> stxsItemGroup;
                    DynamicObject row;
                    BigDecimal taxamount = BigDecimal.ZERO;
                    BigDecimal notaxamount = BigDecimal.ZERO;
                    ClearPeriodEnum periodEnum = ClearPeriodEnum.getByOrder(i);
                    String code = periodEnum.getCode();
                    if (costReportsPeriodData.containsKey(costitemid) && (row = (DynamicObject)((Map)costReportsPeriodData.get(costitemid)).get("" + i)) != null) {
                        taxamount = row.getBigDecimal("taxamount");
                        notaxamount = row.getBigDecimal("amount");
                    }
                    if ((stxsItemGroup = stxsGroup.get(costitemid)) != null && stxsItemGroup.get(code) != null) {
                        List<Map<String, Object>> stxsList = stxsItemGroup.get(code);
                        BigDecimal sgtzzhsje = stxsList.stream().map(a -> (BigDecimal)a.get("sgtzzhsje")).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal sgtzzbhsje = stxsList.stream().map(a -> (BigDecimal)a.get("sgtzzbhsje")).reduce(BigDecimal.ZERO, BigDecimal::add);
                        taxamount = taxamount.add(sgtzzhsje);
                        notaxamount = notaxamount.add(sgtzzbhsje);
                    }
                    if ((splitRate = cbxmFqjFtblMap.get(costitemid)) != null && splitRate.get("" + i) != null) {
                        BigDecimal rate = splitRate.get("" + i);
                        taxamount = taxamount.add(sgtzTaxamountTotal.multiply(rate));
                        notaxamount = notaxamount.add(sgtzNotaxamountTotal.multiply(rate));
                    }
                    if (lastLevel.booleanValue()) {
                        for (String changeField : changeFields) {
                            String key = costitemid.toString() + changeField + code;
                            if (!adjustDetailMap.containsKey(key)) continue;
                            AdjustRecordDto changeData = adjustDetailMap.get(key).get(0);
                            String adjustvalue = changeData.getAdjustvalue();
                            BigDecimal changeAmount = ManualAdjustDetailService.convertBigDecimal(adjustvalue);
                            if ("notaxamount".equals(changeField)) {
                                notaxamount = notaxamount.add(changeAmount);
                                continue;
                            }
                            if (!"taxamount".equals(changeField)) continue;
                            taxamount = taxamount.add(changeAmount);
                        }
                    }
                    rowMap.put("taxamount" + i, taxamount);
                    rowMap.put("notaxamount" + i, notaxamount);
                }
                CostSplitDraftService.calcHjColumn(rowMap, "taxamount", 0, clearperiod);
                CostSplitDraftService.calcHjColumn(rowMap, "notaxamount", 0, clearperiod);
                result.add(rowMap);
            }
        }
    }

    private static void accumulateFswytFtbByLevel(List<Map<String, Object>> dataMap, int form, int to, int clearperiod) {
        Map<Object, List<Map>> parentidMap = dataMap.stream().filter(a -> (Integer)a.get("level") == form).collect(Collectors.groupingBy(a -> a.get("parentid")));
        List<String> fields = CostSplitDraftService.getFswytFtbFieldPrefix();
        for (Map<String, Object> rowMap : dataMap) {
            Object key;
            List<Map> maps;
            if ((Integer)rowMap.get("level") != to || (maps = parentidMap.get(key = rowMap.get("costitem1"))) == null) continue;
            for (int i = 1; i <= clearperiod; ++i) {
                for (String field : fields) {
                    BigDecimal ptzztaxamount = BigDecimal.ZERO;
                    for (Map map : maps) {
                        ptzztaxamount = ptzztaxamount.add((BigDecimal)map.get(field + i));
                    }
                    rowMap.put(field + i, ptzztaxamount);
                }
            }
        }
    }

    private static void accumulateFqjFtbByLevel(List<Map<String, Object>> dataMap, int form, int to, int clearperiod) {
        Map<Object, List<Map>> parentidMap = dataMap.stream().filter(a -> (Integer)a.get("level") == form).collect(Collectors.groupingBy(a -> a.get("parentid")));
        for (Map<String, Object> rowMap : dataMap) {
            Object key;
            List<Map> maps;
            if ((Integer)rowMap.get("level") != to || (maps = parentidMap.get(key = rowMap.get("costitem"))) == null) continue;
            for (int i = 0; i <= clearperiod; ++i) {
                BigDecimal taxamount = BigDecimal.ZERO;
                BigDecimal notaxamount = BigDecimal.ZERO;
                for (Map map : maps) {
                    taxamount = taxamount.add((BigDecimal)map.get("taxamount" + i));
                    notaxamount = notaxamount.add((BigDecimal)map.get("notaxamount" + i));
                }
                rowMap.put("taxamount" + i, taxamount);
                rowMap.put("notaxamount" + i, notaxamount);
            }
        }
    }

    private static void calcHjRow(List<Map<String, Object>> noHjRowDatas, int clearperiod) {
        HashMap<String, Object> hjRowMap = new HashMap<String, Object>();
        hjRowMap.put("costitem", 0L);
        hjRowMap.put("costitemname", ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CostSplitDraftService_0", (String)"taxc-tcept", (Object[])new Object[0]));
        hjRowMap.put("lastlevel", Boolean.TRUE);
        hjRowMap.put("rowid", DBUtils.getLongId((String)T_TCEPT_CBFTDG_FQJ_FT));
        for (Map<String, Object> map : noHjRowDatas) {
            if ((Integer)map.get("level") != 1) continue;
            for (int i = 1; i <= clearperiod; ++i) {
                BigDecimal taxamount = (BigDecimal)map.get("taxamount" + i);
                BigDecimal notaxamount = (BigDecimal)map.get("notaxamount" + i);
                BigDecimal hjrowtaxamount = (BigDecimal)hjRowMap.getOrDefault("taxamount" + i, BigDecimal.ZERO);
                BigDecimal hjrownotaxamount = (BigDecimal)hjRowMap.getOrDefault("notaxamount" + i, BigDecimal.ZERO);
                hjRowMap.put("taxamount" + i, hjrowtaxamount.add(taxamount));
                hjRowMap.put("notaxamount" + i, hjrownotaxamount.add(notaxamount));
            }
        }
        CostSplitDraftService.calcHjColumn(hjRowMap, "taxamount", 0, clearperiod);
        CostSplitDraftService.calcHjColumn(hjRowMap, "notaxamount", 0, clearperiod);
        noHjRowDatas.add(hjRowMap);
    }

    private static void calcHjColumn(Map<String, Object> hjRowMap, String columnKey, int hjSuffix, int clearperiod) {
        BigDecimal hjAmount = BigDecimal.ZERO;
        for (int i1 = 1; i1 <= clearperiod; ++i1) {
            BigDecimal amount = (BigDecimal)hjRowMap.getOrDefault(columnKey + i1, BigDecimal.ZERO);
            hjAmount = hjAmount.add(amount);
        }
        hjRowMap.put(columnKey + hjSuffix, hjAmount);
    }

    public static int deleteAdjustDetails(Object bizid) {
        if (bizid != null) {
            return ManualAdjustDetailService.deleteDataByBiz(ADJUST_DETAIL_TABLE, bizid);
        }
        return 0;
    }

    private static Map<String, List<DynamicObject>> getAdjustDetailMap(Boolean removeManualAdjustData, Object bizid) {
        DynamicObjectCollection adjustDetail = ManualAdjustDetailService.queryDataByBiz(ADJUST_DETAIL_TABLE, bizid);
        return removeManualAdjustData != false ? new HashMap<String, List<DynamicObject>>() : adjustDetail.stream().collect(Collectors.groupingBy(a -> a.getLong("subbizid") + a.getString("bizfield") + a.getString("convertkey")));
    }

    private static Map<String, List<AdjustRecordDto>> getAdjustDetailMap(List<AdjustRecordDto> adjustDetail) {
        Map<String, List<AdjustRecordDto>> collect = adjustDetail.stream().collect(Collectors.groupingBy(a -> a.getSubbizid() + a.getBizfield() + a.getConvertkey()));
        return collect;
    }

    public static List<Map<String, Object>> calcCbftbFswyt(int clearperiod, Map<Long, Map<String, DynamicObject>> cbxmFswytFtbl, List<Map<String, Object>> fqjTable) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(64);
        for (Map<String, Object> fqjRowMap : fqjTable) {
            Long costitemid = (Long)fqjRowMap.get("costitem");
            Integer n = (Integer)fqjRowMap.get("level");
            if (costitemid == null || costitemid.equals(0L)) continue;
            HashMap<String, Object> rowMap = new HashMap<String, Object>(128);
            Object costitemname = fqjRowMap.get("costitemname");
            rowMap.put("costitem1", costitemid);
            rowMap.put("rowid1", DBUtils.getLongId((String)"t_tcept_cbftdg_fwyt_ft"));
            rowMap.put("costitemname1", costitemname);
            rowMap.put("level", n);
            rowMap.put("parentid", fqjRowMap.get("parentid"));
            Map<String, DynamicObject> periodRateObj = cbxmFswytFtbl.get(costitemid);
            for (int i = 1; i <= clearperiod; ++i) {
                BigDecimal taxamount = (BigDecimal)fqjRowMap.get("taxamount" + i);
                BigDecimal notaxamount = (BigDecimal)fqjRowMap.get("notaxamount" + i);
                BigDecimal ptzztaxamount = BigDecimal.ZERO;
                BigDecimal fptzztaxamount = BigDecimal.ZERO;
                BigDecimal qtlxfctaxamount = BigDecimal.ZERO;
                BigDecimal fqsyttaxamount = BigDecimal.ZERO;
                BigDecimal ptzznotaxamount = BigDecimal.ZERO;
                BigDecimal fptzznotaxamount = BigDecimal.ZERO;
                BigDecimal qtlxfcnotaxamount = BigDecimal.ZERO;
                BigDecimal fqsytnotaxamount = BigDecimal.ZERO;
                if (periodRateObj != null && periodRateObj.get("" + i) != null) {
                    DynamicObject rateObj = periodRateObj.get("" + i);
                    ptzztaxamount = taxamount.multiply(rateObj.getBigDecimal("splitrate1"));
                    fptzztaxamount = taxamount.multiply(rateObj.getBigDecimal("splitrate2"));
                    qtlxfctaxamount = taxamount.multiply(rateObj.getBigDecimal("splitrate3"));
                    fqsyttaxamount = taxamount.multiply(rateObj.getBigDecimal("splitrate4"));
                    ptzznotaxamount = notaxamount.multiply(rateObj.getBigDecimal("splitrate1"));
                    fptzznotaxamount = notaxamount.multiply(rateObj.getBigDecimal("splitrate2"));
                    qtlxfcnotaxamount = notaxamount.multiply(rateObj.getBigDecimal("splitrate3"));
                    fqsytnotaxamount = notaxamount.multiply(rateObj.getBigDecimal("splitrate4"));
                }
                rowMap.put("ptzztaxamount" + i, ptzztaxamount);
                rowMap.put("ptzznotaxamount" + i, ptzznotaxamount);
                rowMap.put("fptzztaxamount" + i, fptzztaxamount);
                rowMap.put("fptzznotaxamount" + i, fptzznotaxamount);
                rowMap.put("qtlxfctaxamount" + i, qtlxfctaxamount);
                rowMap.put("qtlxfcnotaxamount" + i, qtlxfcnotaxamount);
                rowMap.put("fqsyttaxamount" + i, fqsyttaxamount);
                rowMap.put("fqsytnotaxamount" + i, fqsytnotaxamount);
            }
            result.add(rowMap);
        }
        CostSplitDraftService.accumulateFswytFtbByLevel(result, 3, 2, clearperiod);
        CostSplitDraftService.accumulateFswytFtbByLevel(result, 2, 1, clearperiod);
        HashMap<String, Object> hjRowMap = new HashMap<String, Object>();
        hjRowMap.put("costitem1", 0L);
        hjRowMap.put("costitemname1", ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CostSplitDraftService_0", (String)"taxc-tcept", (Object[])new Object[0]));
        hjRowMap.put("rowid1", DBUtils.getLongId((String)"t_tcept_cbftdg_fwyt_ft"));
        List<String> fields = CostSplitDraftService.getFswytFtbFieldPrefix();
        for (Map map : result) {
            if ((Integer)map.get("level") != 1) continue;
            for (int i = 1; i <= clearperiod; ++i) {
                for (String field : fields) {
                    BigDecimal taxamount = (BigDecimal)map.get(field + i);
                    BigDecimal hjrowtaxamount = hjRowMap.getOrDefault(field + i, BigDecimal.ZERO);
                    hjRowMap.put(field + i, hjrowtaxamount.add(taxamount));
                }
            }
        }
        result.add(hjRowMap);
        return result;
    }

    private static List<String> getFswytFtbFieldPrefix() {
        return Arrays.asList("ptzztaxamount", "ptzznotaxamount", "fptzztaxamount", "fptzznotaxamount", "qtlxfctaxamount", "qtlxfcnotaxamount", "fqsyttaxamount", "fqsytnotaxamount");
    }

    public static Map<String, List<Map<String, Object>>> calcCbftMxbAllByPk(Object pk, Boolean removeManualAdjustData) {
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>();
        DynamicObject draft = BusinessDataServiceHelper.loadSingle((Object)pk, (String)TCEPT_COST_SPLIT_DRAFT);
        long org = draft.getLong("org.id");
        long scheme = draft.getLong("scheme.id");
        long project = draft.getLong("houseproject.id");
        String version = draft.getString("version");
        int clearperiod = SchemaDataService.querySchemeClearperiod(scheme);
        Map<Long, Map<String, BigDecimal>> cbxmFqjFtblFromDb = CostSplitDraftService.getCbxmFqjFtblFromDb(draft.getDynamicObjectCollection("entryentity"));
        Map<Long, Map<String, DynamicObject>> cbxmFswytFtbl = CostSplitDraftService.getCbxmFswytFtbl(draft.getDynamicObjectCollection("entryentity1"));
        DynamicObjectCollection adjustDetail = ManualAdjustDetailService.queryDataByBiz(ADJUST_DETAIL_TABLE, pk);
        List<AdjustRecordDto> adjustRecordDtos = adjustDetail.stream().map(a -> AdjustRecordDto.transformFromDynObj(a)).collect(Collectors.toList());
        List<Map<String, Object>> fqj = CostSplitDraftService.calcCbftbFqj(clearperiod, org, project, scheme, version, cbxmFqjFtblFromDb, removeManualAdjustData, pk, adjustRecordDtos);
        List<Map<String, Object>> fswyt = CostSplitDraftService.calcCbftbFswyt(clearperiod, cbxmFswytFtbl, fqj);
        result.put("fqj", fqj);
        result.put("fswyt", fswyt);
        return result;
    }

    public static Map<Long, Map<String, List<Map<String, Object>>>> listGroupTwice(List<Map<String, Object>> stxsTzEntryData, String firstGroupKey, String secondGroupKey) {
        Map<Long, List<Map>> stxsGroup = stxsTzEntryData.stream().collect(Collectors.groupingBy(a -> (Long)a.get(firstGroupKey)));
        HashMap<Long, Map<String, List<Map<String, Object>>>> hashMap = new HashMap<Long, Map<String, List<Map<String, Object>>>>();
        for (Map.Entry<Long, List<Map>> entry : stxsGroup.entrySet()) {
            Long key = entry.getKey();
            List<Map> value = entry.getValue();
            Map<String, List<Map>> clearterm = value.stream().collect(Collectors.groupingBy(a -> (String)a.get(secondGroupKey)));
            hashMap.put(key, clearterm);
        }
        return hashMap;
    }

    public static List<Map<String, Object>> getCbxmFqjRowFtbl(Long orgid, Long projectId, Long scheme, String version) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        DynamicObject draftDataByUniKey = CostSplitDraftService.getDraftDataByUniKey(orgid, projectId, scheme, version);
        if (draftDataByUniKey != null) {
            int clearperiod = SchemaDataService.querySchemeClearperiod(scheme);
            DynamicObjectCollection entryentity = draftDataByUniKey.getDynamicObjectCollection("entryentity");
            Map<Long, List<DynamicObject>> rowidMaps = entryentity.stream().collect(Collectors.groupingBy(a -> (Long)a.get("rowid")));
            for (Map.Entry<Long, List<DynamicObject>> entry : rowidMaps.entrySet()) {
                Long key = entry.getKey();
                List<DynamicObject> value = entry.getValue();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                Map<String, List<DynamicObject>> periodMap = entryentity.stream().collect(Collectors.groupingBy(a -> a.getString("period")));
                for (int i = 1; i <= clearperiod; ++i) {
                    ClearPeriodEnum byOrder = ClearPeriodEnum.getByOrder(i);
                    if (byOrder == null || periodMap.get(byOrder.getCode()) == null) continue;
                    DynamicObject dynamicObject = periodMap.get(byOrder.getCode()).get(0);
                    hashMap.put("splitrate" + i, dynamicObject.get("splitrate"));
                }
                hashMap.put("rowid", key);
                hashMap.put("costsplitmethod", value.get(0).getDynamicObject("costsplitmethod").getLong("id"));
                result.add(hashMap);
            }
        }
        return result;
    }

    public static Map<Long, Map<String, BigDecimal>> getCbxmFqjFtbl(int clearperiod, DynamicObjectCollection entryentity) {
        HashMap<Long, Map<String, BigDecimal>> result = new HashMap<Long, Map<String, BigDecimal>>();
        for (DynamicObject row : entryentity) {
            DynamicObjectCollection costitems = row.getDynamicObjectCollection("costitem");
            for (DynamicObject costitem : costitems) {
                HashMap<String, BigDecimal> periodRate = new HashMap<String, BigDecimal>();
                for (int i = 1; i <= clearperiod; ++i) {
                    BigDecimal splitrate = row.getBigDecimal("splitrate" + i);
                    periodRate.put("" + i, splitrate);
                }
                result.put(costitem.getLong("fbasedataid_id"), periodRate);
            }
        }
        return result;
    }

    public static Map<Long, Map<String, BigDecimal>> getCbxmFqjFtblFromDb(DynamicObjectCollection entryentity) {
        HashMap<Long, Map<String, BigDecimal>> result = new HashMap<Long, Map<String, BigDecimal>>();
        for (DynamicObject row : entryentity) {
            DynamicObjectCollection costitems = row.getDynamicObjectCollection("costitem");
            if (costitems == null || row.get("costsplitmethod") == null || "00".equals(row.getString("period"))) continue;
            for (DynamicObject costitem : costitems) {
                Map periodRate = result.getOrDefault(costitem.getLong("fbasedataid_id"), new HashMap());
                BigDecimal splitrate = row.getBigDecimal("splitrate");
                ClearPeriodEnum period = ClearPeriodEnum.getByCode(row.getString("period"));
                periodRate.put("" + period.getOrder(), splitrate);
                result.put(costitem.getLong("fbasedataid_id"), periodRate);
            }
        }
        return result;
    }

    public static Map<Long, Map<String, DynamicObject>> getCbxmFswytFtbl(DynamicObjectCollection entryentity) {
        HashMap<Long, Map<String, DynamicObject>> result = new HashMap<Long, Map<String, DynamicObject>>();
        for (DynamicObject row : entryentity) {
            DynamicObjectCollection costitems = row.getDynamicObjectCollection("costitem1");
            if (costitems == null || row.get("costsplitmethod1") == null || row.get("clearterm1") == null) continue;
            ClearPeriodEnum clearterm = ClearPeriodEnum.getByCode(row.getString("clearterm1"));
            String fq = clearterm.getOrder() + "";
            for (DynamicObject costitem : costitems) {
                Map periodRate = result.getOrDefault(costitem.getLong("fbasedataid_id"), new HashMap());
                periodRate.put(fq, row);
                result.put(costitem.getLong("fbasedataid_id"), periodRate);
            }
        }
        return result;
    }

    public static OperationResult reCalcOne(Object primaryKeyValue, Boolean removeManualAdjustData) {
        ClearPeriodEnum value;
        DynamicObject addNew;
        int i;
        DynamicObject draft = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)TCEPT_COST_SPLIT_DRAFT);
        long org = draft.getLong("org.id");
        long project = draft.getLong("houseproject.id");
        long scheme = draft.getLong("scheme.id");
        String version = draft.getString("version");
        String billStatus = draft.getString("billstatus");
        if (!"A".equals(billStatus)) {
            OperationResult reclac = OperationResultHelper.getFatalErrorOperateResult((String)"reclac", Collections.singletonList(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u201c\u6682\u5b58\u201d\u7684\u5355\u636e\u3002", (String)"CostSplitDraftService_6", (String)"taxc-tcept", (Object[])new Object[0])), (String)"", (int)1, new ArrayList());
            return reclac;
        }
        DynamicObjectCollection fqjftbDbEntry = draft.getDynamicObjectCollection("entryentity2");
        boolean changedCostItem = CostSplitDraftService.isChangedCostItem(org, project, scheme, version, fqjftbDbEntry, STATUS_STEP2);
        if (changedCostItem) {
            OperationResult reclac = OperationResultHelper.getFatalErrorOperateResult((String)"reclac", Collections.singletonList(ResManager.loadKDString((String)"\u6210\u672c\u62a5\u8868\u4e2d\u7684\u6210\u672c\u9879\u76ee\u5df2\u53d8\u66f4\uff0c\u8bf7\u91cd\u7f6e\u5e95\u7a3f\u3002", (String)"CostSplitDraftService_4", (String)"taxc-tcept", (Object[])new Object[0])), (String)"", (int)1, new ArrayList());
            return reclac;
        }
        Map<String, List<Map<String, Object>>> map = CostSplitDraftService.calcCbftMxbAllByPk(primaryKeyValue, removeManualAdjustData);
        int clearperiod = SchemaDataService.querySchemeClearperiod(scheme);
        String swqsytfl = TaxProjectDataService.queryProjectSwqsytfl(project);
        List fqj = map.getOrDefault("fqj", new ArrayList());
        List fswyt = map.getOrDefault("fswyt", new ArrayList());
        DynamicObjectCollection fswytftbDbEntry = draft.getDynamicObjectCollection("entryentity3");
        Map<Integer, ClearPeriodEnum> clearPeriodEnumMap = Arrays.stream(ClearPeriodEnum.values()).collect(Collectors.toMap(a -> a.getOrder(), b -> b, (m, n) -> m));
        fqjftbDbEntry.clear();
        BigDecimal estatecosttotal = BigDecimal.ZERO;
        BigDecimal feetotal = BigDecimal.ZERO;
        BigDecimal taxamounttotal = BigDecimal.ZERO;
        BigDecimal landcost = BigDecimal.ZERO;
        BigDecimal costtotal = BigDecimal.ZERO;
        int seq = 1;
        for (Map object : fqj) {
            for (i = 0; i <= clearperiod; ++i) {
                addNew = fqjftbDbEntry.addNew();
                addNew.set("seq", (Object)seq);
                addNew.set("costitem2", object.get("costitem"));
                addNew.set("rowid2", object.get("rowid"));
                value = clearPeriodEnumMap.get(i);
                addNew.set("period2", (Object)(value == null ? "00" : value.getCode()));
                addNew.set("hsje", object.get("taxamount" + i));
                addNew.set("bhsje", object.get("notaxamount" + i));
                if (i != 0) continue;
                if (object.get("costitem") == null || "0".equals(object.get("costitem").toString())) {
                    costtotal = (BigDecimal)object.get("taxamount0");
                    continue;
                }
                if (object.get("costitem") != null && CostItemDataService.COSTITEM_NAME_FDCKFCB.equals(object.get("costitemname"))) {
                    estatecosttotal = (BigDecimal)object.get("taxamount0");
                    continue;
                }
                if (object.get("costitem") != null && CostItemDataService.COSTITEM_NAME_FDCKFFY.equals(object.get("costitemname"))) {
                    feetotal = (BigDecimal)object.get("taxamount0");
                    continue;
                }
                if (object.get("costitem") != null && CostItemDataService.COSTITEM_NAME_SJ.equals(object.get("costitemname"))) {
                    taxamounttotal = (BigDecimal)object.get("taxamount0");
                    continue;
                }
                if (object.get("costitem") == null || !CostItemDataService.COSTITEM_NAME_TDCB.equals(object.get("costitemname"))) continue;
                landcost = (BigDecimal)object.get("taxamount0");
            }
            ++seq;
        }
        fswytftbDbEntry.clear();
        seq = 1;
        for (Map object : fswyt) {
            for (i = 0; i <= clearperiod; ++i) {
                addNew = fswytftbDbEntry.addNew();
                addNew.set("seq", (Object)seq);
                addNew.set("costitem3", object.get("costitem1"));
                addNew.set("rowid3", object.get("rowid1"));
                value = clearPeriodEnumMap.get(i);
                addNew.set("period3", (Object)(value == null ? "00" : value.getCode()));
                addNew.set("ptzztaxamount", object.get("ptzztaxamount" + i));
                addNew.set("ptzznotaxamount", object.get("ptzznotaxamount" + i));
                addNew.set("fptzztaxamount", object.get("fptzztaxamount" + i));
                addNew.set("fptzznotaxamount", object.get("fptzznotaxamount" + i));
                addNew.set("qtlxfctaxamount", object.get("qtlxfctaxamount" + i));
                addNew.set("qtlxfcnotaxamount", object.get("qtlxfcnotaxamount" + i));
                addNew.set("fqsyttaxamount", object.get("fqsyttaxamount" + i));
                addNew.set("fqsytnotaxamount", object.get("fqsytnotaxamount" + i));
            }
            ++seq;
        }
        long currUserId = RequestContext.get() != null ? RequestContext.get().getCurrUserId() : 0L;
        draft.set("clearperiod", (Object)clearperiod);
        draft.set("swqsytfl", (Object)swqsytfl);
        draft.set("estatecosttotal", (Object)estatecosttotal);
        draft.set("feetotal", (Object)feetotal);
        draft.set("taxamounttotal", (Object)taxamounttotal);
        draft.set("landcost", (Object)landcost);
        draft.set("costtotal", (Object)costtotal);
        draft.set("modifytime", (Object)new Date());
        draft.set("modifier", (Object)currUserId);
        boolean valid = CostSplitDraftService.checkBeforeSave(primaryKeyValue, fqjftbDbEntry, org, project, scheme, version, true);
        if (valid) {
            Throwable throwable = null;
            try (TXHandle h = TX.required();){
                OperationResult save = OperationServiceHelper.executeOperate((String)"save", (String)TCEPT_COST_SPLIT_DRAFT, (DynamicObject[])new DynamicObject[]{draft}, (OperateOption)OperateOption.create());
                if (save.isSuccess()) {
                    CostSplitDraftService.deleteAdjustDetails(primaryKeyValue);
                    DeskServiceMediator.fireBillChange(TCEPT_COST_SPLIT_DRAFT, (Long)primaryKeyValue);
                }
                OperationResult operationResult = save;
                return operationResult;
            }
            catch (Exception e) {
                try {
                    h.markRollback();
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        return null;
    }

    public static boolean saveFormDataToDraft(int clearperiod, String swqsytfl, String billNo, Long mainbillpk, Long orgid, Long projectId, Long schemeId, String schemeVersion, DynamicObjectCollection fqjBlEntry, DynamicObjectCollection fswytBlEntry, DynamicObjectCollection fqjftbEntry, DynamicObjectCollection fswytftbEntry, List<AdjustRecordDto> adjustRecordDtos) {
        boolean valid = CostSplitDraftService.checkBeforeSave(mainbillpk, fqjftbEntry, orgid, projectId, schemeId, schemeVersion, false);
        if (valid) {
            long currUserId;
            ClearPeriodEnum value;
            DynamicObject addNew;
            boolean exists = QueryServiceHelper.exists((String)TCEPT_COST_SPLIT_DRAFT, (Object)mainbillpk);
            DynamicObject dynamicObject = !exists ? BusinessDataServiceHelper.newDynamicObject((String)TCEPT_COST_SPLIT_DRAFT) : BusinessDataServiceHelper.loadSingle((Object)mainbillpk, (String)TCEPT_COST_SPLIT_DRAFT);
            DynamicObjectCollection fqjEntry = dynamicObject.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection fswytEntry = dynamicObject.getDynamicObjectCollection("entryentity1");
            DynamicObjectCollection fqjftbDbEntry = dynamicObject.getDynamicObjectCollection("entryentity2");
            DynamicObjectCollection fswytftbDbEntry = dynamicObject.getDynamicObjectCollection("entryentity3");
            fqjEntry.clear();
            Map<Integer, ClearPeriodEnum> clearPeriodEnumMap = Arrays.stream(ClearPeriodEnum.values()).collect(Collectors.toMap(a -> a.getOrder(), b -> b, (m, n) -> m));
            for (DynamicObject object : fqjBlEntry) {
                for (int i = 0; i <= clearperiod; ++i) {
                    DynamicObject addNew2 = fqjEntry.addNew();
                    DynamicObjectCollection costitem1 = object.getDynamicObjectCollection("costitem");
                    if (costitem1 == null || object.get("costsplitmethod") == null) continue;
                    Iterator costitem12 = addNew2.getDynamicObjectCollection("costitem");
                    for (DynamicObject dynamicObject1 : costitem1) {
                        DynamicObject dynamicObject2 = costitem12.addNew();
                        dynamicObject2.set("fbasedataid_id", dynamicObject1.get("fbasedataid_id"));
                    }
                    addNew2.set("costsplitmethod", object.get("costsplitmethod"));
                    addNew2.set("rowid", object.get("rowid"));
                    addNew2.set("seq", object.get("seq"));
                    ClearPeriodEnum value2 = clearPeriodEnumMap.get(i);
                    addNew2.set("period", (Object)(value2 == null ? "00" : value2.getCode()));
                    addNew2.set("basenum", object.get("basenum" + i));
                    addNew2.set("splitrate", object.get("splitrate" + i));
                }
            }
            fswytEntry.clear();
            for (DynamicObject object : fswytBlEntry) {
                DynamicObject addNew3 = fswytEntry.addNew();
                DynamicObjectCollection costitem1 = object.getDynamicObjectCollection("costitem1");
                if (costitem1 == null || object.get("costsplitmethod1") == null || object.get("clearterm1") == null) continue;
                DynamicObjectCollection costitem12 = addNew3.getDynamicObjectCollection("costitem1");
                for (DynamicObject dynamicObject1 : costitem1) {
                    DynamicObject dynamicObject2 = costitem12.addNew();
                    dynamicObject2.set("fbasedataid_id", dynamicObject1.get("fbasedataid_id"));
                }
                addNew3.set("seq", object.get("seq"));
                addNew3.set("costitem1", (Object)costitem12);
                addNew3.set("costsplitmethod1", object.get("costsplitmethod1"));
                addNew3.set("clearterm1", object.get("clearterm1"));
                addNew3.set("basenum1", object.get("basenum1"));
                addNew3.set("splitrate1", object.get("splitrate1"));
                addNew3.set("basenum2", object.get("basenum2"));
                addNew3.set("splitrate2", object.get("splitrate2"));
                addNew3.set("basenum3", object.get("basenum3"));
                addNew3.set("splitrate3", object.get("splitrate3"));
                addNew3.set("basenum4", object.get("basenum4"));
                addNew3.set("splitrate4", object.get("splitrate4"));
                addNew3.set("basenum0", object.get("basenum0"));
                addNew3.set("splitrate0", object.get("splitrate0"));
            }
            fqjftbDbEntry.clear();
            BigDecimal estatecosttotal = BigDecimal.ZERO;
            BigDecimal feetotal = BigDecimal.ZERO;
            BigDecimal taxamounttotal = BigDecimal.ZERO;
            BigDecimal landcost = BigDecimal.ZERO;
            BigDecimal costtotal = BigDecimal.ZERO;
            for (DynamicObject object : fqjftbEntry) {
                for (int i = 0; i <= clearperiod; ++i) {
                    addNew = fqjftbDbEntry.addNew();
                    addNew.set("costitem2", object.get("costitem"));
                    addNew.set("rowid2", object.get("rowid"));
                    addNew.set("seq", object.get("seq"));
                    value = clearPeriodEnumMap.get(i);
                    addNew.set("period2", (Object)(value == null ? "00" : value.getCode()));
                    addNew.set("hsje", object.get("taxamount" + i));
                    addNew.set("bhsje", object.get("notaxamount" + i));
                    if (i != 0) continue;
                    if (object.get("costitem") == null) {
                        costtotal = object.getBigDecimal("taxamount0");
                        continue;
                    }
                    if (object.get("costitem") != null && CostItemDataService.COSTITEM_NAME_FDCKFCB.equals(object.getString("costitem.name"))) {
                        estatecosttotal = object.getBigDecimal("taxamount0");
                        continue;
                    }
                    if (object.get("costitem") != null && CostItemDataService.COSTITEM_NAME_FDCKFFY.equals(object.getString("costitem.name"))) {
                        feetotal = object.getBigDecimal("taxamount0");
                        continue;
                    }
                    if (object.get("costitem") != null && CostItemDataService.COSTITEM_NAME_SJ.equals(object.getString("costitem.name"))) {
                        taxamounttotal = object.getBigDecimal("taxamount0");
                        continue;
                    }
                    if (object.get("costitem") == null || !CostItemDataService.COSTITEM_NAME_TDCB.equals(object.getString("costitem.name"))) continue;
                    landcost = object.getBigDecimal("taxamount0");
                }
            }
            fswytftbDbEntry.clear();
            for (DynamicObject object : fswytftbEntry) {
                for (int i = 1; i <= clearperiod; ++i) {
                    addNew = fswytftbDbEntry.addNew();
                    addNew.set("costitem3", object.get("costitem1"));
                    addNew.set("rowid3", object.get("rowid1"));
                    addNew.set("seq", object.get("seq"));
                    value = clearPeriodEnumMap.get(i);
                    addNew.set("period3", (Object)(value == null ? "00" : value.getCode()));
                    addNew.set("ptzztaxamount", object.get("ptzztaxamount" + i));
                    addNew.set("ptzznotaxamount", object.get("ptzznotaxamount" + i));
                    addNew.set("fptzztaxamount", object.get("fptzztaxamount" + i));
                    addNew.set("fptzznotaxamount", object.get("fptzznotaxamount" + i));
                    addNew.set("qtlxfctaxamount", object.get("qtlxfctaxamount" + i));
                    addNew.set("qtlxfcnotaxamount", object.get("qtlxfcnotaxamount" + i));
                    addNew.set("fqsyttaxamount", object.get("fqsyttaxamount" + i));
                    addNew.set("fqsytnotaxamount", object.get("fqsytnotaxamount" + i));
                }
            }
            long l = currUserId = RequestContext.get() != null ? RequestContext.get().getCurrUserId() : 0L;
            if (!exists) {
                String billno = DraftCommonUtils.getDraftNumber(dynamicObject, orgid);
                dynamicObject.set("billno", (Object)billno);
                dynamicObject.set("id", (Object)mainbillpk);
                dynamicObject.set("org", (Object)orgid);
                dynamicObject.set("houseproject", (Object)projectId);
                dynamicObject.set("scheme", (Object)schemeId);
                dynamicObject.set("version", (Object)schemeVersion);
                dynamicObject.set("createtime", (Object)new Date());
                dynamicObject.set("creator", (Object)currUserId);
                dynamicObject.set("billstatus", (Object)"A");
            }
            dynamicObject.set("clearperiod", (Object)clearperiod);
            dynamicObject.set("swqsytfl", (Object)swqsytfl);
            dynamicObject.set("estatecosttotal", (Object)estatecosttotal);
            dynamicObject.set("feetotal", (Object)feetotal);
            dynamicObject.set("taxamounttotal", (Object)taxamounttotal);
            dynamicObject.set("landcost", (Object)landcost);
            dynamicObject.set("costtotal", (Object)costtotal);
            dynamicObject.set("modifytime", (Object)new Date());
            dynamicObject.set("modifier", (Object)currUserId);
            try (TXHandle h = TX.required();){
                try {
                    Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                    ManualAdjustDetailService.saveDtoToPersistent(adjustRecordDtos, mainbillpk, ADJUST_DETAIL_TABLE);
                    long id = ((DynamicObject)save[0]).getLong("id");
                    DeskServiceMediator.fireBillChange(TCEPT_COST_SPLIT_DRAFT, id);
                }
                catch (Exception e) {
                    h.markRollback();
                    throw e;
                }
            }
            return true;
        }
        return false;
    }

    private static boolean checkBeforeSave(Object mainbillpk, DynamicObjectCollection fqjftbEntry, Long orgid, Long projectId, Long schemeId, String version, boolean formDb) {
        DynamicObject dynamicObject;
        Optional<DynamicObject> hjRow = fqjftbEntry.stream().filter(a -> formDb ? a.get("costitem2") == null && "00".equals(a.getString("period2")) : a.get("costitem") == null).findFirst();
        if (hjRow.isPresent()) {
            BigDecimal taxamount0 = formDb ? hjRow.get().getBigDecimal("hsje") : hjRow.get().getBigDecimal("taxamount0");
            BigDecimal notaxamount0 = formDb ? hjRow.get().getBigDecimal("bhsje") : hjRow.get().getBigDecimal("notaxamount0");
            List<Map<String, Object>> cbHjEntryData = CostAdjustDraftService.getCbHjEntryData(orgid, projectId, schemeId, version);
            if (cbHjEntryData != null && cbHjEntryData.size() > 0) {
                Map<String, Object> hjMap = cbHjEntryData.get(cbHjEntryData.size() - 1);
                BigDecimal tzhbhsje = (BigDecimal)hjMap.getOrDefault("tzhbhsje", BigDecimal.ZERO);
                BigDecimal tzhhsje = (BigDecimal)hjMap.getOrDefault("tzhhsje", BigDecimal.ZERO);
                BigDecimal subtract = notaxamount0.subtract(tzhbhsje);
                BigDecimal subtract1 = taxamount0.subtract(tzhhsje);
                if (subtract.compareTo(BigDecimal.ZERO) != 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6210\u672c\u5206\u644a\u8868\u7684\u3010\u5408\u8ba1\u3011\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0e\u201c\u6210\u672c\u8c03\u6574\u5e95\u7a3f-\u6210\u672c\u5408\u8ba1\u201d\u7684\u4e0d\u542b\u7a0e\u91d1\u989d\u5dee\u989d\u4e3a%s\uff0c\u8bf7\u8c03\u6574\u5dee\u989d\u81f30\u540e\u65b9\u53ef\u4fdd\u5b58\u3002", (String)"CostSplitDraftService_1", (String)"taxc-tcept", (Object[])new Object[0]), subtract.toPlainString()));
                }
                if (subtract1.compareTo(BigDecimal.ZERO) != 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6210\u672c\u5206\u644a\u8868\u7684\u3010\u5408\u8ba1\u3011\u542b\u7a0e\u91d1\u989d\u4e0e\u201c\u6210\u672c\u8c03\u6574\u5e95\u7a3f-\u6210\u672c\u5408\u8ba1\u201d\u7684\u542b\u7a0e\u91d1\u989d\u5dee\u989d\u4e3a%s\uff0c\u8bf7\u8c03\u6574\u5dee\u989d\u81f30\u540e\u65b9\u53ef\u4fdd\u5b58\u3002", (String)"CostSplitDraftService_2", (String)"taxc-tcept", (Object[])new Object[0]), subtract1.toPlainString()));
                }
            }
        }
        QFilter org = new QFilter("org", "=", (Object)orgid);
        QFilter scheme = new QFilter("scheme", "=", (Object)schemeId);
        QFilter schemeversion = new QFilter("version", "=", (Object)version);
        QFilter houseproject = new QFilter("houseproject", "=", (Object)projectId);
        if (mainbillpk != null) {
            houseproject.and("id", "!=", mainbillpk);
        }
        if ((dynamicObject = QueryServiceHelper.queryOne((String)TCEPT_COST_SPLIT_DRAFT, (String)"houseproject.name houseproject,scheme.name scheme", (QFilter[])new QFilter[]{org, scheme, houseproject, schemeversion})) != null) {
            String versionName = SchemaDataService.queryVersionName(schemeId, version);
            versionName = versionName == null ? version : versionName;
            String houseprojectName = dynamicObject.getString("houseproject") != null ? dynamicObject.getString("houseproject") : "";
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a\u201c%1$s\u201d\u5728\u201c%2$s\u201d\u4e2d\u5df2\u5b58\u5728\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CostSplitDraftService_3", (String)"taxc-tcept", (Object[])new Object[0]), versionName, houseprojectName));
        }
        return true;
    }

    @Override
    public String getBillNumber() {
        return TCEPT_COST_SPLIT_DRAFT;
    }

    @Override
    public String getFormNumber() {
        return TCEPT_COST_SPLIT_PAGE;
    }

    @Override
    public Map<String, String> getInfoSyncField() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("org_field_key", "org");
        hashMap.put("project_field_key", "houseproject");
        hashMap.put("scheme_field_key", "scheme");
        hashMap.put("version_field_key", "version");
        hashMap.put("billno_field_key", "billno");
        hashMap.put("billstatus_field_key", "billstatus");
        hashMap.put("modifier_field_key", "modifier");
        hashMap.put("modifydate_field_key", "modifytime");
        return hashMap;
    }

    @Override
    public Map<String, Object> copy(Long originalPk, Long org, Long project, Long scheme, String version, String newVersion) {
        DynamicObject single = BusinessDataServiceHelper.loadSingle((Object)originalPk, (String)TCEPT_COST_SPLIT_DRAFT);
        DynamicObject newObj = (DynamicObject)new CloneUtils(false, true).clone((IDataEntityBase)single);
        long id = single.getLong("id");
        long newId = DBUtils.getLongId((String)"t_tcept_cost_split_draft");
        newObj.set("id", (Object)newId);
        newObj.set("version", (Object)newVersion);
        String billno = DraftCommonUtils.getDraftNumber(newObj, single.getLong("org.id"));
        newObj.set("billno", (Object)billno);
        newObj.set("billstatus", (Object)"A");
        ArrayList<DynamicObject> adjustRecords = ManualAdjustDetailService.copy(ADJUST_DETAIL_TABLE, id, newId);
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            Object[] save1 = SaveServiceHelper.save((DynamicObject[])adjustRecords.toArray(new DynamicObject[adjustRecords.size()]));
            Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newObj});
            Map map = ServiceResultUtils.returnResultHandler((Object)save[0]);
            return map;
        }
        catch (Exception e) {
            try {
                LOGGER.error((Throwable)e);
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public boolean isSupportRecalc() {
        return true;
    }

    @Override
    public Map<String, Object> recalc(Long billpk, Long org, Long project, Long scheme, String version) {
        boolean exists = QueryServiceHelper.exists((String)this.getBillNumber(), (Object)billpk);
        if (exists) {
            try {
                OperationResult save = CostSplitDraftService.reCalcOne(billpk, false);
                if (save != null) {
                    return AbstractDeskMeasureService.getResultMapFormOpRe(null, save);
                }
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
                return IDeskMeasureService.createReturnResultObject(Boolean.FALSE, "-1", e.getMessage(), null);
            }
        }
        return IDeskMeasureService.createReturnResultObject(Boolean.FALSE, "-1", ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u65e0\u9700\u64cd\u4f5c\u3002", (String)"CostSplitDraftService_5", (String)"taxc-tcept", (Object[])new Object[0]), null);
    }

    public static boolean isChangedCostItem(Long org, Long project, Long scheme, String version, DynamicObjectCollection entryentity2, String costitemFieldSuffix) {
        Set dbSets = entryentity2.stream().map(a -> a.getDynamicObject("costitem" + costitemFieldSuffix)).filter(b -> b != null).map(c -> c.getLong("id")).collect(Collectors.toSet());
        DynamicObject costReport = CostReportDataService.queryAllPeriodData(org, project, scheme, version);
        if (costReport != null) {
            Object costreporttplid = costReport.get("costreporttpl.id");
            List<DynamicObject> costItems = CostReportDataService.queryCostreportTplCostItems(costreporttplid);
            Set nowSets = costItems.stream().filter(b -> b.getInt("level") < 4).map(c -> c.getLong("id")).collect(Collectors.toSet());
            Sets.SetView difference = Sets.difference(dbSets, nowSets);
            Sets.SetView difference1 = Sets.difference(nowSets, dbSets);
            return difference.size() > 0 || difference1.size() > 0;
        }
        return false;
    }
}

