/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.business.draft;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.utils.ServiceResultUtils;
import kd.taxc.tcept.business.draft.AbstractDeskMeasureService;
import kd.taxc.tcept.common.utils.CollectionTool;
import kd.taxc.tcept.common.utils.DraftCommonUtils;

public class IncomeAdjustDraftService
implements AbstractDeskMeasureService {
    public static final String TCEPT_INCO_ADJ_DRAFT = "tcept_inco_adj_draft";

    public static DynamicObject queryIncomeDraftByUniq(Long org, Long project, Long scheme, String version) {
        QFilter qFilter = new QFilter("org", "=", (Object)org);
        QFilter qFilter1 = new QFilter("scheme", "=", (Object)scheme);
        QFilter qFilter2 = new QFilter("houseproject", "=", (Object)project);
        QFilter qFilterversion = new QFilter("version", "=", (Object)version);
        DynamicObject incomeDraft = QueryServiceHelper.queryOne((String)TCEPT_INCO_ADJ_DRAFT, (String)"id", (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2, qFilterversion});
        if (incomeDraft != null) {
            return BusinessDataServiceHelper.loadSingle((Object)incomeDraft.get("id"), (String)TCEPT_INCO_ADJ_DRAFT);
        }
        return null;
    }

    public static Map<Object, Map<Object, BigDecimal>> getNotaxrevenueGroup(Long orgid, Long projectId, Long schemeId, String version) {
        DynamicObject incomeAdjDraft = IncomeAdjustDraftService.queryIncomeDraftByUniq(orgid, projectId, schemeId, version);
        if (incomeAdjDraft != null) {
            DynamicObjectCollection entryentity = incomeAdjDraft.getDynamicObjectCollection("entryentity");
            return CollectionTool.listGroupTwiceSumReduceOneKey((List<DynamicObject>)entryentity, "clearterm", "taxtype", "notaxrevenue");
        }
        return new HashMap<Object, Map<Object, BigDecimal>>();
    }

    public static Map<Object, Map<Object, BigDecimal>> getStxsincomenotaxGroup(Long orgid, Long projectId, Long schemeId, String version) {
        DynamicObject incomeAdjDraft = IncomeAdjustDraftService.queryIncomeDraftByUniq(orgid, projectId, schemeId, version);
        if (incomeAdjDraft != null) {
            DynamicObjectCollection entryentity = incomeAdjDraft.getDynamicObjectCollection("entryentity1");
            return CollectionTool.listGroupTwiceSumReduceOneKey((List<DynamicObject>)entryentity, "clearterm1", "taxtype1", "stxsincomenotax");
        }
        return new HashMap<Object, Map<Object, BigDecimal>>();
    }

    public static Map<Object, Map<Object, BigDecimal>> getNotaxrevenue2Group(Long orgid, Long projectId, Long schemeId, String version) {
        DynamicObject incomeAdjDraft = IncomeAdjustDraftService.queryIncomeDraftByUniq(orgid, projectId, schemeId, version);
        if (incomeAdjDraft != null) {
            DynamicObjectCollection entryentity = incomeAdjDraft.getDynamicObjectCollection("entryentity2");
            return CollectionTool.listGroupTwiceSumReduceOneKey((List<DynamicObject>)entryentity, "clearterm2", "taxtype2", "notaxrevenue2");
        }
        return new HashMap<Object, Map<Object, BigDecimal>>();
    }

    public static DynamicObject query(Long orgId, Long projectId, Long schemeId, String version) {
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter("houseproject", "=", (Object)projectId);
        QFilter q3 = new QFilter("scheme", "=", (Object)schemeId);
        QFilter q4 = new QFilter("version", "=", (Object)version);
        return Optional.ofNullable(QueryServiceHelper.queryOne((String)TCEPT_INCO_ADJ_DRAFT, (String)"id", (QFilter[])new QFilter[]{q1, q2, q3, q4})).map(s -> BusinessDataServiceHelper.loadSingle((Object)s.getLong("id"), (String)TCEPT_INCO_ADJ_DRAFT)).orElseGet(() -> null);
    }

    @Override
    public String getBillNumber() {
        return TCEPT_INCO_ADJ_DRAFT;
    }

    @Override
    public Map<String, String> getInfoSyncField() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("org_field_key", "org");
        hashMap.put("project_field_key", "houseproject");
        hashMap.put("scheme_field_key", "scheme");
        hashMap.put("version_field_key", "version");
        hashMap.put("billno_field_key", "billno");
        hashMap.put("billstatus_field_key", "billstatus");
        hashMap.put("modifier_field_key", "modifier");
        hashMap.put("modifydate_field_key", "modifytime");
        return hashMap;
    }

    @Override
    public Map<String, Object> copy(Long originalPk, Long org, Long project, Long scheme, String version, String newVersion) {
        DynamicObject single = BusinessDataServiceHelper.loadSingle((Object)originalPk, (String)TCEPT_INCO_ADJ_DRAFT);
        DynamicObject newObj = (DynamicObject)new CloneUtils(false, true).clone((IDataEntityBase)single);
        newObj.set("id", null);
        newObj.set("version", (Object)newVersion);
        String billno = DraftCommonUtils.getDraftNumber(newObj, single.getLong("org.id"));
        newObj.set("billno", (Object)billno);
        newObj.set("billstatus", (Object)"A");
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newObj});
        return ServiceResultUtils.returnResultHandler((Object)save[0]);
    }
}

