/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.business.draft;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.utils.ServiceResultUtils;
import kd.taxc.tcept.business.draft.AbstractDeskMeasureService;
import kd.taxc.tcept.common.utils.CollectionTool;
import kd.taxc.tcept.common.utils.DraftCommonUtils;

public class IncomeDraftService
implements AbstractDeskMeasureService {
    private static final String TCEPT_INCOME_BOOK = "tcept_income_book";

    public Long getDefaultProject(Long orgId) {
        QFilter q1 = new QFilter("taxorg", "=", (Object)orgId);
        QFilter q2 = new QFilter("status", "=", (Object)"C");
        QFilter q3 = new QFilter("group.number", "=", (Object)"001");
        QFilter q4 = new QFilter("enable", "=", (Object)"1");
        return Optional.ofNullable(QueryServiceHelper.queryOne((String)"bastax_taxproject", (String)"id", (QFilter[])new QFilter[]{q1, q2, q3, q4})).map(s -> s.getLong("id")).orElseGet(() -> null);
    }

    public Long getDefaultScheme(Long orgId, Long projectId) {
        QFilter q1 = new QFilter("project", "=", (Object)projectId);
        QFilter q2 = new QFilter("org", "=", (Object)orgId);
        QFilter q3 = new QFilter("enable", "=", (Object)"1");
        QFilter q4 = new QFilter("status", "=", (Object)"C");
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"tcept_scheme", (String)"id", (QFilter[])new QFilter[]{q1, q2, q3, q4}, (String)"createtime desc");
        return CollectionUtils.isEmpty((Collection)objects) ? null : Long.valueOf(((DynamicObject)objects.get(0)).getLong("id"));
    }

    public static Set<Object> queryIncomeBookSelltypeIds(Long org, Long project, Long scheme, String version) {
        DynamicObject dynamicObject = IncomeDraftService.loadSingleByUniq(org, project, scheme, version);
        if (dynamicObject != null) {
            DynamicObject incomeBook = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.get("id"), (String)TCEPT_INCOME_BOOK);
            Set<Object> selltypeIds = incomeBook.getDynamicObjectCollection("entryentity").stream().map(a -> a.get("salestate.id")).collect(Collectors.toSet());
            return selltypeIds;
        }
        return new HashSet<Object>(0);
    }

    private static DynamicObject loadSingleByUniq(Long org, Long project, Long scheme, String version) {
        QFilter qFilter = new QFilter("org", "=", (Object)org);
        QFilter qFilter1 = new QFilter("scheme", "=", (Object)scheme);
        QFilter qFilter2 = new QFilter("project", "=", (Object)project);
        QFilter qFilterversion = new QFilter("version", "=", (Object)version);
        return QueryServiceHelper.queryOne((String)TCEPT_INCOME_BOOK, (String)"id", (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2, qFilterversion});
    }

    public static Map<Object, Map<Object, BigDecimal>> getRoomDetailGoodValueGroup(Long orgid, Long projectId, Long schemeId, String version) {
        DynamicObject dynamicObject = IncomeDraftService.loadSingleByUniq(orgid, projectId, schemeId, version);
        if (dynamicObject != null) {
            DynamicObject incomeBook = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.get("id"), (String)TCEPT_INCOME_BOOK);
            DynamicObjectCollection entryentity = incomeBook.getDynamicObjectCollection("entryentity");
            return CollectionTool.listGroupTwiceSumReduceOneKey((List<DynamicObject>)entryentity, "clearperiod", "taxstate", "goodsvalue");
        }
        return new HashMap<Object, Map<Object, BigDecimal>>();
    }

    public DynamicObject query(Long orgId, Long projectId, Long schemeId, String version) {
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter("project", "=", (Object)projectId);
        QFilter q3 = new QFilter("scheme", "=", (Object)schemeId);
        QFilter q4 = new QFilter("version", "=", (Object)version);
        return Optional.ofNullable(QueryServiceHelper.queryOne((String)TCEPT_INCOME_BOOK, (String)"id", (QFilter[])new QFilter[]{q1, q2, q3, q4})).map(s -> BusinessDataServiceHelper.loadSingle((Object)s.getLong("id"), (String)TCEPT_INCOME_BOOK)).orElseGet(() -> null);
    }

    @Override
    public String getBillNumber() {
        return TCEPT_INCOME_BOOK;
    }

    @Override
    public Map<String, Object> copy(Long originalPk, Long org, Long project, Long scheme, String version, String newVersion) {
        DynamicObject single = BusinessDataServiceHelper.loadSingle((Object)originalPk, (String)TCEPT_INCOME_BOOK);
        DynamicObject newObj = (DynamicObject)new CloneUtils(false, true).clone((IDataEntityBase)single);
        newObj.set("id", null);
        newObj.set("version", (Object)newVersion);
        String billno = DraftCommonUtils.getDraftNumber(newObj, single.getLong("org.id"));
        newObj.set("billno", (Object)billno);
        newObj.set("billstatus", (Object)"A");
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newObj});
        return ServiceResultUtils.returnResultHandler((Object)save[0]);
    }
}

