/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.business.draft;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tcept.common.dto.AdjustRecordDto;

public class ManualAdjustDetailService {
    private static final Log LOGGER = LogFactory.getLog(ManualAdjustDetailService.class);
    public static String ENTITY_KEY = "tcept_adj_record";
    public static String BIZSTATUS = "bizstatus";
    public static String BIZSTATUS_TEMP = "0";
    public static String BIZSTATUS_PERS = "1";

    public static Map<Object, Boolean> existAdjustDetail(String biztable, Object[] bizids) {
        HashMap<Object, Boolean> result = new HashMap<Object, Boolean>(64);
        for (Object bizid : bizids) {
            QFilter qFilter1 = new QFilter("biztable", "=", (Object)biztable);
            QFilter qFilter2 = new QFilter("bizid", "=", bizid);
            Boolean exists = QueryServiceHelper.exists((String)ENTITY_KEY, (QFilter[])new QFilter[]{qFilter1, qFilter2});
            result.put(bizid, exists);
        }
        return result;
    }

    public static DynamicObjectCollection queryDataByBiz(String biztable, Object bizid) {
        QFilter qFilter1 = new QFilter("biztable", "=", (Object)biztable);
        QFilter qFilter2 = new QFilter("bizid", "=", bizid);
        DynamicObjectCollection query = QueryServiceHelper.query((String)ENTITY_KEY, (String)"id,biztable,bizid,subbizid,bizfield,convertkey,bizrowtype,beforevalue,aftervalue,updateor,updatetime,remark,originalvalue,adjustvalue,totalvalue", (QFilter[])new QFilter[]{qFilter1, qFilter2}, (String)"updatetime desc");
        return query;
    }

    public static DynamicObjectCollection queryDataByBiz(String biztable, Object bizid, Object subbizid, String bizfield, String convertkey) {
        QFilter qFilter1 = new QFilter("biztable", "=", (Object)biztable);
        QFilter qFilter2 = new QFilter("bizid", "=", bizid);
        if (subbizid != null) {
            qFilter2.and("subbizid", "=", subbizid);
        }
        QFilter qFilter3 = new QFilter("bizfield", "=", (Object)bizfield);
        if (convertkey != null) {
            qFilter3.and(new QFilter("convertkey", "=", (Object)convertkey));
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)ENTITY_KEY, (String)"biztable,bizid,bizfield,convertkey,bizrowtype,beforevalue,aftervalue,updateor,updatetime,remark,originalvalue,adjustvalue,totalvalue", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3}, (String)"updatetime desc");
        return query;
    }

    public static int deleteTemp(Object bizid, String biztable) {
        QFilter qFilter1 = new QFilter("biztable", "=", (Object)biztable);
        QFilter qFilter2 = new QFilter("bizid", "=", bizid);
        QFilter qFilter3 = new QFilter(BIZSTATUS, "=", (Object)BIZSTATUS_TEMP);
        return DeleteServiceHelper.delete((String)ENTITY_KEY, (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
    }

    public static void saveTempToPersistent(Object bizid, String biztable) {
        DynamicObject[] query;
        QFilter qFilter1 = new QFilter("biztable", "=", (Object)biztable);
        QFilter qFilter2 = new QFilter("bizid", "=", bizid);
        QFilter qFilter3 = new QFilter(BIZSTATUS, "=", (Object)BIZSTATUS_TEMP);
        for (DynamicObject dynamicObject : query = BusinessDataServiceHelper.load((String)ENTITY_KEY, (String)("id," + BIZSTATUS), (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3})) {
            dynamicObject.set(BIZSTATUS, (Object)BIZSTATUS_PERS);
        }
        SaveServiceHelper.save((DynamicObject[])query);
    }

    public static void saveDtoToPersistent(List<AdjustRecordDto> adjustRecordDtos, Object bizid, String biztable) {
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        for (AdjustRecordDto adjustRecordDto : adjustRecordDtos) {
            DynamicObject dynamicObject = AdjustRecordDto.transformToDynObj(adjustRecordDto, BusinessDataServiceHelper.newDynamicObject((String)ENTITY_KEY));
            dynamicObject.set(BIZSTATUS, (Object)BIZSTATUS_PERS);
            dynamicObjects.add(dynamicObject);
        }
        ManualAdjustDetailService.deleteDataByBiz(biztable, bizid);
        SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[dynamicObjects.size()]));
    }

    public static void saveForm(Map<String, Object> customParams, DynamicObjectCollection entryentitycard, BigDecimal originalvalue, BigDecimal totalvalue) {
        if (entryentitycard.size() > 0) {
            DynamicObject oneCard = (DynamicObject)entryentitycard.get(0);
            Object bizid = customParams.get("bizid");
            if (bizid == null) {
                return;
            }
            Object subbizid = customParams.get("subbizid");
            String biztable = (String)customParams.get("biztable");
            String bizfield = (String)customParams.get("bizfield");
            String convertkey = (String)customParams.get("convertkey");
            String bizstatus = (String)customParams.get(BIZSTATUS);
            BigDecimal adjustamount = oneCard.getBigDecimal("adjustamount");
            DynamicObjectCollection dynamicObjectCollection = ManualAdjustDetailService.queryDataByBiz(biztable, bizid, subbizid, bizfield, convertkey);
            String beforeTotalValue = "0";
            if (dynamicObjectCollection.size() > 0) {
                BigDecimal dbValue = ManualAdjustDetailService.convertBigDecimal(((DynamicObject)dynamicObjectCollection.get(0)).getString("adjustvalue"));
                if (dbValue.compareTo(adjustamount) == 0) {
                    return;
                }
                beforeTotalValue = ((DynamicObject)dynamicObjectCollection.get(0)).getString("totalvalue");
            } else {
                beforeTotalValue = originalvalue.toPlainString();
            }
            DynamicObject adjustObj = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_KEY);
            adjustObj.set("bizrowtype", (Object)"2");
            adjustObj.set("bizid", bizid);
            adjustObj.set("subbizid", subbizid);
            adjustObj.set("biztable", (Object)biztable);
            adjustObj.set("bizfield", (Object)bizfield);
            adjustObj.set("bizstatus", (Object)bizstatus);
            adjustObj.set("convertkey", (Object)convertkey);
            adjustObj.set("updateor", (Object)RequestContext.get().getCurrUserId());
            adjustObj.set("updatetime", (Object)new Date());
            adjustObj.set("remark", (Object)oneCard.getString("cardadjustexplain"));
            adjustObj.set("adjustvalue", (Object)adjustamount.toPlainString());
            adjustObj.set("originalvalue", (Object)originalvalue.toPlainString());
            adjustObj.set("totalvalue", (Object)totalvalue.toPlainString());
            adjustObj.set("beforevalue", (Object)beforeTotalValue);
            adjustObj.set("aftervalue", (Object)totalvalue.toPlainString());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{adjustObj});
        }
    }

    public static AdjustRecordDto setDataInDto(AdjustRecordDto adjustRecordDto, Map<String, Object> customParams, DynamicObjectCollection entryentitycard, BigDecimal originalvalue, BigDecimal totalvalue) {
        if (entryentitycard.size() > 0) {
            DynamicObject oneCard = (DynamicObject)entryentitycard.get(0);
            Object bizid = customParams.get("bizid");
            if (bizid == null) {
                return null;
            }
            Object subbizid = customParams.get("subbizid");
            String biztable = (String)customParams.get("biztable");
            String bizfield = (String)customParams.get("bizfield");
            String convertkey = (String)customParams.get("convertkey");
            String bizstatus = (String)customParams.get(BIZSTATUS);
            BigDecimal adjustamount = oneCard.getBigDecimal("adjustamount");
            String adjust_cache = (String)customParams.get("adjust_cache");
            List list = SerializationUtils.fromJsonStringToList((String)adjust_cache, AdjustRecordDto.class);
            List collect = list.stream().filter(a -> Objects.equals(String.valueOf(subbizid), String.valueOf(a.getSubbizid()))).filter(a -> Objects.equals(convertkey, a.getConvertkey())).filter(a -> Objects.equals(bizfield, a.getBizfield())).collect(Collectors.toList());
            String beforeTotalValue = "0";
            if (BigDecimal.ZERO.compareTo(adjustamount) == 0) {
                return null;
            }
            if (collect.size() > 0) {
                BigDecimal dbValue = ManualAdjustDetailService.convertBigDecimal(((AdjustRecordDto)collect.get(0)).getAdjustvalue());
                if (dbValue.compareTo(adjustamount) == 0) {
                    return null;
                }
                beforeTotalValue = ((AdjustRecordDto)collect.get(0)).getTotalvalue();
            } else {
                beforeTotalValue = originalvalue.toPlainString();
            }
            adjustRecordDto.setBiztable(biztable);
            adjustRecordDto.setBizid(Long.parseLong(bizid.toString()));
            adjustRecordDto.setSubbizid(Long.parseLong(subbizid.toString()));
            adjustRecordDto.setBizfield(bizfield);
            adjustRecordDto.setConvertkey(convertkey);
            adjustRecordDto.setBizstatus(bizstatus);
            adjustRecordDto.setBizrowtype("2");
            adjustRecordDto.setBeforevalue(beforeTotalValue);
            adjustRecordDto.setAftervalue(totalvalue.toPlainString());
            adjustRecordDto.setUpdateor(RequestContext.get().getCurrUserId());
            adjustRecordDto.setUpdatetime(new Date());
            adjustRecordDto.setRemark(oneCard.getString("cardadjustexplain"));
            adjustRecordDto.setOriginalvalue(originalvalue.toPlainString());
            adjustRecordDto.setAdjustvalue(adjustamount.toPlainString());
            adjustRecordDto.setTotalvalue(totalvalue.toPlainString());
        }
        return adjustRecordDto;
    }

    public static BigDecimal convertBigDecimal(String originalvalue) {
        if (originalvalue == null) {
            return BigDecimal.ZERO;
        }
        try {
            return new BigDecimal(originalvalue);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Throwable)e);
            return BigDecimal.ZERO;
        }
    }

    public static int deleteDataByBiz(String biztable, Object bizid) {
        QFilter qFilter1 = new QFilter("biztable", "=", (Object)biztable);
        QFilter qFilter2 = new QFilter("bizid", "=", bizid);
        return DeleteServiceHelper.delete((String)ENTITY_KEY, (QFilter[])new QFilter[]{qFilter1, qFilter2});
    }

    public static int deleteDataByBizids(String biztable, List<Object> bizids) {
        QFilter qFilter1 = new QFilter("biztable", "=", (Object)biztable);
        QFilter qFilter2 = new QFilter("bizid", "in", bizids);
        return DeleteServiceHelper.delete((String)ENTITY_KEY, (QFilter[])new QFilter[]{qFilter1, qFilter2});
    }

    public static ArrayList<DynamicObject> copy(String biztable, Object bizid, Object newbizid) {
        DynamicObject[] load;
        ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>();
        DynamicObjectCollection dynamicObjectCollection = ManualAdjustDetailService.queryDataByBiz(biztable, bizid);
        Set id = dynamicObjectCollection.stream().map(a -> a.get("id")).collect(Collectors.toSet());
        for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((Object[])id.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)ENTITY_KEY))) {
            DynamicObject newObj = (DynamicObject)new CloneUtils(false, true).clone((IDataEntityBase)dynamicObject);
            newObj.set("bizid", newbizid);
            arrayList.add(newObj);
        }
        return arrayList;
    }
}

