/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.business.draft;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.helper.OperationResultHelper;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.ServiceResultUtils;
import kd.taxc.tcept.business.baseconfig.RuleConfigService;
import kd.taxc.tcept.business.basedata.SchemaDataService;
import kd.taxc.tcept.business.draft.AbstractDeskMeasureService;
import kd.taxc.tcept.business.draft.CostSplitDraftService;
import kd.taxc.tcept.business.extpoint.IDeskMeasureService;
import kd.taxc.tcept.business.statistics.DeskServiceMediator;
import kd.taxc.tcept.common.enums.ClearPeriodEnum;
import kd.taxc.tcept.common.enums.TaxStateEnum;
import kd.taxc.tcept.common.utils.CollectionTool;
import kd.taxc.tcept.common.utils.DraftCommonUtils;

public class QiTaAdjustDraftService
implements AbstractDeskMeasureService {
    public static final String DJDJ = "djdj";
    public static final String SJJJKC = "sjjjkc";
    public static final String JJKC = "jjkc";
    public static final String ENTITY_1_P = "entity1_p_";
    public static final String ENTITY_2_PTZZ_P_ = "entity2_ptzz_p_";
    public static final String ENTITY_2_FPTZZ_P_ = "entity2_fptzz_p_";
    public static final String ENTITY_2_QTLX_P_ = "entity2_qtlx_p_";
    public static final String ENTITY_2_FQSYT_P_ = "entity2_fqsyt_p_";
    public static final String ENTRY_2_GROUP_P = "entry2_group_p_";
    public static final String JJKCTAXSTATE = "jjkctaxstate";
    public static final String JJKCCLEARPERIOD = "jjkcclearperiod";
    public static final String ENTRYENTITY_1 = "entryentity1";
    public static final String ENTRYENTITY_2 = "entryentity2";
    public static final String ENTRYENTITY_3 = "entryentity3";
    public static final String ENTRYENTITY_4 = "entryentity4";
    public static final String ENTITY_1_FTFF = "entity1_ftff";
    public static final String ENTITY_1_P_ = "entity1_p_";
    public static final String ENTITY_2_FTFF = "entity2_ftff";
    public static final String TCEPT_QITA_DRAFT_BILL = "tcept_qita_draft_bill";
    private RuleConfigService ruleConfigService = new RuleConfigService();
    private Map<String, List<String>> STEP_ENTITY_MAPPING = new HashMap(){
        {
            this.put(QiTaAdjustDraftService.DJDJ, Lists.newArrayList((Object[])new String[]{QiTaAdjustDraftService.ENTRYENTITY_1, QiTaAdjustDraftService.ENTRYENTITY_2}));
            this.put(QiTaAdjustDraftService.SJJJKC, Collections.singletonList(QiTaAdjustDraftService.ENTRYENTITY_3));
            this.put(QiTaAdjustDraftService.JJKC, Collections.singletonList(QiTaAdjustDraftService.ENTRYENTITY_4));
        }
    };
    private Map<String, String> COST_SPLIT_RATE_MAPPING = new HashMap(){
        {
            this.put("ptzz", "splitrate1");
            this.put("fptzz", "splitrate2");
            this.put("qtlx", "splitrate3");
            this.put("fqsyt", "splitrate4");
        }
    };

    public static DynamicObject queryDraftByUniq(Long org, Long project, Long scheme, String version) {
        QFilter q1 = new QFilter("org", "=", (Object)org);
        QFilter q2 = new QFilter("project", "=", (Object)project);
        QFilter q3 = new QFilter("scheme", "=", (Object)scheme);
        QFilter q4 = new QFilter("version", "=", (Object)version);
        DynamicObject draft = QueryServiceHelper.queryOne((String)TCEPT_QITA_DRAFT_BILL, (String)"id", (QFilter[])new QFilter[]{q1, q2, q3, q4});
        if (draft != null) {
            return BusinessDataServiceHelper.loadSingle((Object)draft.get("id"), (String)TCEPT_QITA_DRAFT_BILL);
        }
        return null;
    }

    public static Map<Object, Map<String, BigDecimal>> getPeriodSplitTaxTypeTableGroup(Long orgid, Long projectId, Long schemeId, String version) {
        DynamicObject incomeAdjDraft = QiTaAdjustDraftService.queryDraftByUniq(orgid, projectId, schemeId, version);
        if (incomeAdjDraft != null) {
            DynamicObjectCollection entryentity = incomeAdjDraft.getDynamicObjectCollection(ENTRYENTITY_2);
            Map<Object, Map<String, BigDecimal>> objectMapMap = CollectionTool.listGroupOnceGetSumToGroup((List<DynamicObject>)entryentity, "period", "ptzz", "fptzz", "qtlx", "fqsyt");
            return objectMapMap;
        }
        return new HashMap<Object, Map<String, BigDecimal>>();
    }

    public static Map<Object, Map<Object, Map<String, BigDecimal>>> getAddDecutPeriodSplitTaxTypeGroup(Long orgid, Long projectId, Long schemeId, String version) {
        DynamicObject incomeAdjDraft = QiTaAdjustDraftService.queryDraftByUniq(orgid, projectId, schemeId, version);
        if (incomeAdjDraft != null) {
            DynamicObjectCollection entryentity = incomeAdjDraft.getDynamicObjectCollection(ENTRYENTITY_4);
            return CollectionTool.listGroupTwiceSumReduceKeys((List<DynamicObject>)entryentity, JJKCCLEARPERIOD, JJKCTAXSTATE, "tdcb", "fdcdevcb", "qtfdcdevfy", "qtkcxm", "cwfy");
        }
        return new HashMap<Object, Map<Object, Map<String, BigDecimal>>>();
    }

    public boolean isExists(String number, Long orgId, Long projectId, Long schemeId, String version) {
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter("project", "=", (Object)projectId);
        QFilter q3 = new QFilter("scheme", "=", (Object)schemeId);
        QFilter q4 = new QFilter("version", "=", (Object)version);
        QFilter q5 = new QFilter("billno", "!=", (Object)number);
        return QueryServiceHelper.exists((String)TCEPT_QITA_DRAFT_BILL, (QFilter[])new QFilter[]{q1, q2, q3, q4, q5});
    }

    public List<String> getEntity1List() {
        return IntStream.rangeClosed(1, 10).boxed().map(a -> "entity1_p_" + a).collect(Collectors.toList());
    }

    public List<String> getEntity2List() {
        return Lists.newArrayList((Object[])new String[]{ENTITY_2_PTZZ_P_, ENTITY_2_FPTZZ_P_, ENTITY_2_QTLX_P_, ENTITY_2_FQSYT_P_}).stream().flatMap(a -> IntStream.rangeClosed(1, 10).boxed().map(b -> a + b)).collect(Collectors.toList());
    }

    public List<String> getEntity2GroupList() {
        return IntStream.rangeClosed(1, 10).boxed().map(a -> ENTRY_2_GROUP_P + a).collect(Collectors.toList());
    }

    public List<String> getVisibleEntity1List(int maxClearPeriods) {
        return this.getEntity1List().stream().filter(s -> Integer.parseInt(s.split("_")[2]) <= maxClearPeriods).collect(Collectors.toList());
    }

    public List<String> getVisibleEntity2List(int maxClearPeriods, String swqsytfl) {
        return this.getEntity2List().stream().filter(s -> "0".equals(swqsytfl) ? !s.contains(ENTITY_2_FPTZZ_P_) : true).filter(s -> Integer.parseInt(s.split("_")[3]) <= maxClearPeriods).collect(Collectors.toList());
    }

    public List<String> getVisibleEntity2GroupList(int maxClearPeriods) {
        return this.getEntity2GroupList().stream().filter(s -> Integer.parseInt(s.split("_")[3]) <= maxClearPeriods).collect(Collectors.toList());
    }

    public List<String> getListBanners(String djdjmethod, String jjkcadjust) {
        if (Lists.newArrayList((Object[])new String[]{"1", "2"}).contains(djdjmethod) && "1".equals(jjkcadjust)) {
            return Lists.newArrayList((Object[])new String[]{DJDJ, SJJJKC, JJKC});
        }
        if (Lists.newArrayList((Object[])new String[]{"3"}).contains(djdjmethod) && "0".equals(jjkcadjust)) {
            return Lists.newArrayList((Object[])new String[]{JJKC});
        }
        if (Lists.newArrayList((Object[])new String[]{"1", "2"}).contains(djdjmethod) && "0".equals(jjkcadjust)) {
            return Lists.newArrayList((Object[])new String[]{DJDJ, JJKC});
        }
        if (Lists.newArrayList((Object[])new String[]{"3"}).contains(djdjmethod) && "1".equals(jjkcadjust)) {
            return Lists.newArrayList((Object[])new String[]{SJJJKC, JJKC});
        }
        return Lists.newArrayList();
    }

    public String getNextPageStep(List<String> listBanners, String currentStep) {
        if (listBanners.isEmpty()) {
            return null;
        }
        String nextStep = null;
        try {
            nextStep = listBanners.get(listBanners.indexOf(currentStep) + 1);
        }
        catch (Exception e) {
            nextStep = currentStep;
        }
        return nextStep;
    }

    public String getPreviousPageStep(List<String> listBanners, String currentStep) {
        if (listBanners.isEmpty()) {
            return null;
        }
        String previousStep = null;
        try {
            previousStep = listBanners.get(listBanners.indexOf(currentStep) - 1);
        }
        catch (Exception e) {
            previousStep = currentStep;
        }
        return previousStep;
    }

    public DynamicObjectCollection getCostSplitTaxStateData(Long orgId, Long projectId, Long schemeId, String version) {
        DynamicObject object = CostSplitDraftService.getDraftDataByUniKey(orgId, projectId, schemeId, version);
        if (object != null) {
            return object.getDynamicObjectCollection(ENTRYENTITY_3);
        }
        return new DynamicObjectCollection();
    }

    private Object getCountAmount(String field, String taxstate, List<Map<String, Object>> list) {
        BigDecimal reduce = list.stream().filter(s -> taxstate.equals(s.get(JJKCTAXSTATE)) && !"count".equals(s.get(JJKCCLEARPERIOD))).map(s -> (BigDecimal)s.get(field)).reduce(BigDecimal.ZERO, BigDecimal::add);
        return reduce;
    }

    public Map<String, BigDecimal> getAdjustAmount(DynamicObjectCollection entity, String field) {
        Map<String, List<DynamicObject>> collect = entity.stream().collect(Collectors.groupingBy(s -> s.getString("clearperiod") + s.getString("taxstate") + s.getString(field)));
        Map<String, BigDecimal> adjustamount = collect.entrySet().stream().collect(Collectors.toMap(s -> (String)s.getKey(), s -> ((List)s.getValue()).stream().map(m -> m.getBigDecimal("adjustamount")).reduce(BigDecimal.ZERO, BigDecimal::add)));
        return adjustamount;
    }

    private HashBasedTable<String, String, String> getMappingTable() {
        HashBasedTable table = HashBasedTable.create();
        table.put((Object)"includingtax", (Object)"normal_house", (Object)"ptzztaxamount");
        table.put((Object)"includingtax", (Object)"un_normal_house", (Object)"fptzztaxamount");
        table.put((Object)"includingtax", (Object)"un_house", (Object)"qtlxfctaxamount");
        table.put((Object)"includingtax", (Object)"un_calc_state", (Object)"fqsyttaxamount");
        table.put((Object)"excludingtax", (Object)"normal_house", (Object)"ptzznotaxamount");
        table.put((Object)"excludingtax", (Object)"un_normal_house", (Object)"fptzznotaxamount");
        table.put((Object)"excludingtax", (Object)"un_house", (Object)"qtlxfcnotaxamount");
        table.put((Object)"excludingtax", (Object)"un_calc_state", (Object)"fqsytnotaxamount");
        return table;
    }

    private BigDecimal getAmount(DynamicObjectCollection costSplitTaxStateData, String period, String taxstate, String fetchtype, String name) {
        String field;
        HashBasedTable<String, String, String> mappingTable = this.getMappingTable();
        BigDecimal result = BigDecimal.ZERO;
        List collect = costSplitTaxStateData.stream().filter(s -> s != null && s.getDynamicObject("costitem3") != null && s.getDynamicObject("costitem3").getString("name").equals(name) && s.getString("period3").equals(period)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect) && StringUtil.isNotEmpty((CharSequence)(field = (String)mappingTable.get((Object)fetchtype, (Object)taxstate)))) {
            result = ((DynamicObject)collect.get(0)).getBigDecimal(field);
        }
        return result;
    }

    private BigDecimal getAmount(String field, String period, String taxstate, Map<String, String> fetchMapping, DynamicObjectCollection costSplitTaxStateData, Map<String, BigDecimal> adjustAmount) {
        String fetchtype;
        String name;
        BigDecimal amount = BigDecimal.ZERO;
        if ("tdcb".equals(field)) {
            name = ResManager.loadKDString((String)"\u571f\u5730\u6210\u672c", (String)"QiTaAdjustDraftService_0", (String)"taxc-tcept", (Object[])new Object[0]);
            fetchtype = fetchMapping.get(name);
            amount = this.getAmount(costSplitTaxStateData, period, taxstate, fetchtype, name);
        }
        if ("fdcdevcb".equals(field)) {
            name = ResManager.loadKDString((String)"\u623f\u5730\u4ea7\u5f00\u53d1\u6210\u672c", (String)"QiTaAdjustDraftService_1", (String)"taxc-tcept", (Object[])new Object[0]);
            fetchtype = fetchMapping.get(name);
            amount = this.getAmount(costSplitTaxStateData, period, taxstate, fetchtype, name);
        }
        if ("sgtzsxamount".equals(field)) {
            BigDecimal a = Optional.ofNullable(adjustAmount.get(period + taxstate + "0")).orElseGet(() -> BigDecimal.ZERO);
            BigDecimal b = Optional.ofNullable(adjustAmount.get(period + taxstate + "1")).orElseGet(() -> BigDecimal.ZERO);
            return BigDecimalUtil.addObject((Object)a, (Object)b);
        }
        if ("cwfy".equals(field)) {
            name = ResManager.loadKDString((String)"\u8d22\u52a1\u8d39\u7528", (String)"QiTaAdjustDraftService_2", (String)"taxc-tcept", (Object[])new Object[0]);
            amount = this.getAmount(costSplitTaxStateData, period, taxstate, "includingtax", name);
        }
        return amount;
    }

    public List<Map<String, Object>> calcData(Long orgId, Long projectId, Long schemeId, String version, String swqsytfl, String deductbycost, DynamicObjectCollection entryentity3) {
        int maxClearPeriods = SchemaDataService.querySchemeClearperiod(orgId, projectId, schemeId);
        Map<String, String> fetchMapping = this.ruleConfigService.getFetchMapping(orgId, projectId);
        DynamicObjectCollection costSplitTaxStateData = this.getCostSplitTaxStateData(orgId, projectId, schemeId, version);
        List<ComboItem> taxStateItems = TaxStateEnum.getComboItem(swqsytfl);
        List<ComboItem> clearPeriodItems = ClearPeriodEnum.getClearPeriodsWithCount(maxClearPeriods);
        Map<String, BigDecimal> adjustAmount1 = this.getAdjustAmount(entryentity3, "isdevbase");
        Map<String, BigDecimal> adjustAmount2 = this.getAdjustAmount(entryentity3, "isqitajjkcbase");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (ComboItem clearPeriod : clearPeriodItems) {
            for (ComboItem taxState : taxStateItems) {
                HashMap<String, Object> rowMap = new HashMap<String, Object>(32);
                String clearPeriodCode = clearPeriod.getValue();
                String taxStateCode = taxState.getValue();
                rowMap.put(JJKCCLEARPERIOD, clearPeriodCode);
                rowMap.put(JJKCTAXSTATE, taxStateCode);
                if ("count".equals(clearPeriod.getValue())) {
                    rowMap.put("tdcb", this.getCountAmount("tdcb", taxStateCode, list));
                    rowMap.put("fdcdevcb", this.getCountAmount("fdcdevcb", taxStateCode, list));
                    rowMap.put("sgtzsxamount", this.getCountAmount("sgtzsxamount", taxStateCode, list));
                    rowMap.put("tzhfdcdevfybase", this.getCountAmount("tzhfdcdevfybase", taxStateCode, list));
                    rowMap.put("cwfy", this.getCountAmount("cwfy", taxStateCode, list));
                    rowMap.put("qtfdcdevfy", this.getCountAmount("qtfdcdevfy", taxStateCode, list));
                    rowMap.put("fdcdevfy", this.getCountAmount("fdcdevfy", taxStateCode, list));
                    rowMap.put("tzhqtkcbase", this.getCountAmount("tzhqtkcbase", taxStateCode, list));
                    rowMap.put("qtkcxm", this.getCountAmount("qtkcxm", taxStateCode, list));
                    list.add(rowMap);
                    continue;
                }
                BigDecimal f1 = this.getAmount("tdcb", clearPeriodCode, taxStateCode, fetchMapping, costSplitTaxStateData, adjustAmount1);
                rowMap.put("tdcb", f1);
                BigDecimal f2 = this.getAmount("fdcdevcb", clearPeriodCode, taxStateCode, fetchMapping, costSplitTaxStateData, adjustAmount1);
                rowMap.put("fdcdevcb", f2);
                BigDecimal f3 = this.getAmount("sgtzsxamount", clearPeriodCode, taxStateCode, fetchMapping, costSplitTaxStateData, adjustAmount1);
                rowMap.put("sgtzsxamount", f3);
                BigDecimal a = Optional.ofNullable(adjustAmount1.get(clearPeriodCode + taxStateCode + "1")).orElseGet(() -> BigDecimal.ZERO);
                BigDecimal f4 = f1.add(f2).add(f3).subtract(a);
                rowMap.put("tzhfdcdevfybase", f4);
                BigDecimal f5 = "1".equals(deductbycost) ? this.getAmount("cwfy", clearPeriodCode, taxStateCode, fetchMapping, costSplitTaxStateData, adjustAmount1) : f4.multiply(new BigDecimal("0.05")).setScale(2, 4);
                rowMap.put("cwfy", f5);
                BigDecimal f6 = f4.multiply(new BigDecimal("0.05"));
                rowMap.put("qtfdcdevfy", f6);
                BigDecimal f7 = f5.add(f6);
                rowMap.put("fdcdevfy", f7);
                BigDecimal b = Optional.ofNullable(adjustAmount2.get(clearPeriodCode + taxStateCode + "1")).orElseGet(() -> BigDecimal.ZERO);
                BigDecimal f8 = f1.add(f2).add(f3).subtract(b);
                rowMap.put("tzhqtkcbase", f8);
                BigDecimal f9 = f8.multiply(new BigDecimal("0.20"));
                rowMap.put("qtkcxm", f9);
                list.add(rowMap);
            }
        }
        return list;
    }

    public BigDecimal getSumSum(String type, DynamicObjectCollection entity, String field) {
        if (CollectionUtils.isEmpty((Collection)entity)) {
            return BigDecimal.ZERO;
        }
        if (ENTRYENTITY_1.equals(type)) {
            return entity.stream().map(s -> s.getBigDecimal(field)).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (ENTRYENTITY_4.equals(type)) {
            return entity.stream().filter(s -> "count".equals(s.getString(JJKCCLEARPERIOD))).map(s -> s.getBigDecimal(field)).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return BigDecimal.ZERO;
    }

    public OperationResult createOrUpdate(String number, Long orgId, Long projectId, Long schemeId, String version, String swqsytfl, int maxClearPeriods, String focusstep, String djdjmethod, String jjkcadjust, DynamicObjectCollection entity1, DynamicObjectCollection entity2, DynamicObjectCollection entity3, DynamicObjectCollection entity4) {
        DynamicObject object = Optional.ofNullable(QueryServiceHelper.queryOne((String)TCEPT_QITA_DRAFT_BILL, (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)number)})).map(s -> BusinessDataServiceHelper.loadSingle((Object)s.get("id"), (String)TCEPT_QITA_DRAFT_BILL)).orElseGet(() -> BusinessDataServiceHelper.newDynamicObject((String)TCEPT_QITA_DRAFT_BILL));
        object.set("billno", (Object)number);
        object.set("billstatus", (Object)"A");
        object.set("modifier", (Object)RequestContext.get().getUserId());
        object.set("modifytime", (Object)new Date());
        object.set("org", (Object)orgId);
        object.set("project", (Object)projectId);
        object.set("scheme", (Object)schemeId);
        object.set("version", (Object)version);
        object.set("maxclearperiod", (Object)maxClearPeriods);
        object.set("swqsytfl", (Object)(StringUtil.isBlank((CharSequence)swqsytfl) ? "1" : swqsytfl));
        object.set("tdcbsum", (Object)this.getSumSum(ENTRYENTITY_4, entity4, "tdcb"));
        object.set("fdcdevcbsum", (Object)this.getSumSum(ENTRYENTITY_4, entity4, "fdcdevcb"));
        object.set("cwfysum", (Object)this.getSumSum(ENTRYENTITY_4, entity4, "cwfy"));
        object.set("qtfdcdevsum", (Object)this.getSumSum(ENTRYENTITY_4, entity4, "qtfdcdevfy"));
        object.set("fdcdevfysum", (Object)this.getSumSum(ENTRYENTITY_4, entity4, "fdcdevfy"));
        object.set("qtkcxmsum", (Object)this.getSumSum(ENTRYENTITY_4, entity4, "qtkcxm"));
        object.set("djdjxxsum", (Object)this.getSumSum(ENTRYENTITY_1, entity1, "entity1_djdjsum"));
        object.set("focusstep", (Object)focusstep);
        object.set("djdjmethod", (Object)djdjmethod);
        object.set("jjkcadjust", (Object)jjkcadjust);
        List<String> listBanners = this.getListBanners(djdjmethod, jjkcadjust);
        object.set("menulist", (Object)listBanners.stream().collect(Collectors.joining(",")));
        this.setValueFromSourceToTarget(ENTRYENTITY_1, listBanners, entity1, object);
        this.setValueFromSourceToDynTarget(ENTRYENTITY_2, listBanners, maxClearPeriods, entity2, object);
        this.setValueFromSourceToTarget(ENTRYENTITY_3, listBanners, entity3, object);
        this.setValueFromSourceToTarget(ENTRYENTITY_4, listBanners, entity4, object);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)TCEPT_QITA_DRAFT_BILL, (DynamicObject[])new DynamicObject[]{object}, (OperateOption)OperateOption.create());
        return operationResult;
    }

    private void setValueFromSourceToDynTarget(String type, List<String> listBanners, int maxClearPeriod, DynamicObjectCollection entity2, DynamicObject object) {
        DynamicObjectCollection list = object.getDynamicObjectCollection(type);
        boolean anyMatch = listBanners.stream().anyMatch(s -> this.STEP_ENTITY_MAPPING.get(s).contains(type));
        if (!anyMatch) {
            return;
        }
        list.clear();
        if (ENTRYENTITY_2.equals(type)) {
            DynamicObject row = (DynamicObject)entity2.get(0);
            for (int i = 1; i <= maxClearPeriod; ++i) {
                DynamicObject target = list.addNew();
                target.set(ENTITY_2_FTFF, (Object)Optional.ofNullable(row.getDynamicObject(ENTITY_2_FTFF)).map(s -> s.getLong("id")).orElseGet(() -> 0L));
                target.set("ptzz", row.get(ENTITY_2_PTZZ_P_ + i));
                target.set("fptzz", row.get(ENTITY_2_FPTZZ_P_ + i));
                target.set("qtlx", row.get(ENTITY_2_QTLX_P_ + i));
                target.set("fqsyt", row.get(ENTITY_2_FQSYT_P_ + i));
                target.set("period", (Object)ClearPeriodEnum.getByOrder(i).getCode());
                target.set("rowid", (Object)DBUtils.getLongId((String)"t_tcept_qita_draft_det2"));
            }
        }
    }

    public void setValueFromSourceToTarget(String type, List<String> listBanners, DynamicObjectCollection entity, DynamicObject object) {
        if (CollectionUtils.isEmpty((Collection)entity)) {
            return;
        }
        boolean anyMatch = listBanners.stream().anyMatch(s -> this.STEP_ENTITY_MAPPING.get(s).contains(type));
        if (!anyMatch) {
            return;
        }
        DynamicObjectCollection list = object.getDynamicObjectCollection(type);
        list.clear();
        for (DynamicObject source : entity) {
            DynamicObject target = list.addNew();
            DataEntityPropertyCollection properties = target.getDynamicObjectType().getProperties();
            for (IDataEntityProperty property : properties) {
                if (!source.getDynamicObjectType().getProperties().containsKey((Object)property.getName())) continue;
                target.set(property.getName(), source.get(property.getName()));
            }
        }
    }

    @Override
    public String getBillNumber() {
        return TCEPT_QITA_DRAFT_BILL;
    }

    @Override
    public String getFormNumber() {
        return "tcept_qita_adjust_draft";
    }

    @Override
    public Map<String, Object> copy(Long originalPk, Long org, Long project, Long scheme, String version, String newVersion) {
        DynamicObject single = BusinessDataServiceHelper.loadSingle((Object)originalPk, (String)TCEPT_QITA_DRAFT_BILL);
        DynamicObject newObj = (DynamicObject)new CloneUtils(false, true).clone((IDataEntityBase)single);
        newObj.set("id", null);
        newObj.set("version", (Object)newVersion);
        String billno = DraftCommonUtils.getDraftNumber(newObj, single.getLong("org.id"));
        newObj.set("billno", (Object)billno);
        newObj.set("billstatus", (Object)"A");
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newObj});
        return ServiceResultUtils.returnResultHandler((Object)save[0]);
    }

    public Map<String, BigDecimal> getCostSplitTaxRateMapping(DynamicObjectCollection entryentity22) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(16);
        for (DynamicObject row : entryentity22) {
            for (String s : this.COST_SPLIT_RATE_MAPPING.values()) {
                String key = this.getKeyWord(row.getDynamicObject("costsplitmethod1").getString("id"), row.getString("clearterm1"), s);
                map.put(key, row.getBigDecimal(s));
            }
        }
        return map;
    }

    public String getKeyWord(String methodId, String clearPeriod, String rate) {
        return String.format("%1$s_%2$s_%3$s", methodId, clearPeriod, rate);
    }

    public void calcDjdjList(Long orgId, Long projectId, Long schemeId, String version, int clearPeriods, String swqsytfl, String djdjmethod, String jjkcadjust, DynamicObjectCollection entryentity1, DynamicObjectCollection entryentity2) {
        List<String> listBanners = this.getListBanners(djdjmethod, jjkcadjust);
        if (listBanners.contains(DJDJ)) {
            DynamicObject object;
            if (entryentity1.size() > 0) {
                List<Map<String, Object>> rowDatas = CostSplitDraftService.getCbxmFqjRowFtbl(orgId, projectId, schemeId, version);
                DynamicObject rowEntity = (DynamicObject)entryentity1.get(0);
                List<String> entity1List = this.getVisibleEntity1List(clearPeriods);
                BigDecimal sum = BigDecimal.ZERO;
                BigDecimal newValue = rowEntity.getBigDecimal("entity1_djdjsum");
                String lastPeriod = entity1List.get(entity1List.size() - 1);
                for (String field : entity1List) {
                    BigDecimal o = (BigDecimal)rowDatas.stream().filter(s -> rowEntity.getDynamicObject(ENTITY_1_FTFF) != null).filter(s -> ((Long)s.get("costsplitmethod")).longValue() == rowEntity.getDynamicObject(ENTITY_1_FTFF).getLong("id")).map(s -> s.get("splitrate" + field.split("_")[2])).findFirst().orElseGet(() -> BigDecimal.ZERO);
                    BigDecimal amount = newValue.multiply(o).setScale(2, 4);
                    if (field.equals(lastPeriod) && !rowDatas.isEmpty()) {
                        rowEntity.set(field, (Object)newValue.subtract(sum));
                    } else {
                        rowEntity.set(field, (Object)amount);
                    }
                    sum = sum.add(amount);
                }
            }
            if (entryentity2.size() > 0 && (object = CostSplitDraftService.getDraftDataByUniKey(orgId, projectId, schemeId, version)) != null) {
                Map<String, BigDecimal> costSplitTaxRateMapping = this.getCostSplitTaxRateMapping(object.getDynamicObjectCollection(ENTRYENTITY_1));
                Map<String, BigDecimal> spiltPeriodMapping = this.getSpiltPeriodMapping(entryentity1);
                List<String> visibleEntity2List = this.getVisibleEntity2List(clearPeriods, swqsytfl);
                for (DynamicObject row : entryentity2) {
                    long methodId = row.getLong("entity2_ftff.id");
                    String period = row.getString("period");
                    Integer fqInt = ClearPeriodEnum.getByCode(period).getOrder();
                    for (String field : visibleEntity2List) {
                        BigDecimal a = this.getfqjAmount(methodId, field, spiltPeriodMapping);
                        BigDecimal b = this.getfswytfpbl(methodId, field, costSplitTaxRateMapping);
                        if (field.equals(ENTITY_2_PTZZ_P_ + fqInt)) {
                            row.set("ptzz", (Object)a.multiply(b).setScale(2, 4));
                            continue;
                        }
                        if (field.equals(ENTITY_2_FPTZZ_P_ + fqInt)) {
                            row.set("fptzz", (Object)a.multiply(b).setScale(2, 4));
                            continue;
                        }
                        if (field.equals(ENTITY_2_QTLX_P_ + fqInt)) {
                            row.set("qtlx", (Object)a.multiply(b).setScale(2, 4));
                            continue;
                        }
                        if (!field.equals(ENTITY_2_FQSYT_P_ + fqInt)) continue;
                        row.set("fqsyt", (Object)a.multiply(b).setScale(2, 4));
                    }
                }
            }
        }
    }

    public BigDecimal getfswytfpbl(Long methodId, String field, Map<String, BigDecimal> map) {
        String clearPeriod = String.format("%02d", Integer.parseInt(field.split("_")[3]));
        String type = field.split("_")[1];
        String key = this.getKeyWord(String.valueOf(methodId), clearPeriod, this.COST_SPLIT_RATE_MAPPING.get(type));
        return map.getOrDefault(key, BigDecimal.ZERO);
    }

    public BigDecimal getfqjAmount(Long methodId, String field, Map<String, BigDecimal> spiltPeriodMapping) {
        String clearPeriod = String.format("%02d", Integer.parseInt(field.split("_")[3]));
        return spiltPeriodMapping.getOrDefault(clearPeriod, BigDecimal.ZERO);
    }

    public Map<String, BigDecimal> getSpiltPeriodMapping(DynamicObjectCollection entity1) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(16);
        entity1.stream().forEach(e -> e.getDataEntityType().getProperties().stream().forEach(p -> {
            String name = p.getName();
            if (name.startsWith("entity1_p_")) {
                String clearPeriod = String.format("%02d", Integer.parseInt(name.split("_")[2]));
                map.put(clearPeriod, e.getBigDecimal(p));
            }
        }));
        return map;
    }

    public void setEntry4Value(String swqsytfl, int maxclearperiod, DynamicObjectCollection entryentity4, List<Map<String, Object>> list) {
        entryentity4.clear();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Map<String, Object> map = list.get(i);
                DynamicObject dynamicObject = entryentity4.addNew();
                dynamicObject.set(JJKCCLEARPERIOD, map.get(JJKCCLEARPERIOD));
                dynamicObject.set(JJKCTAXSTATE, map.get(JJKCTAXSTATE));
                dynamicObject.set("tdcb", map.get("tdcb"));
                dynamicObject.set("fdcdevcb", map.get("fdcdevcb"));
                dynamicObject.set("sgtzsxamount", map.get("sgtzsxamount"));
                dynamicObject.set("tzhfdcdevfybase", map.get("tzhfdcdevfybase"));
                dynamicObject.set("cwfy", map.get("cwfy"));
                dynamicObject.set("qtfdcdevfy", map.get("qtfdcdevfy"));
                dynamicObject.set("fdcdevfy", map.get("fdcdevfy"));
                dynamicObject.set("tzhqtkcbase", map.get("tzhqtkcbase"));
                dynamicObject.set("qtkcxm", map.get("qtkcxm"));
            }
        } else {
            List<ComboItem> taxStateItems = TaxStateEnum.getComboItem(swqsytfl);
            List<ComboItem> clearPeriodItems = ClearPeriodEnum.getClearPeriodsWithCount(maxclearperiod);
            for (ComboItem clearPeriod : clearPeriodItems) {
                for (ComboItem taxState : taxStateItems) {
                    DynamicObject dynamicObject = entryentity4.addNew();
                    String clearPeriodCode = clearPeriod.getValue();
                    String taxStateCode = taxState.getValue();
                    dynamicObject.set(JJKCCLEARPERIOD, (Object)clearPeriodCode);
                    dynamicObject.set(JJKCTAXSTATE, (Object)taxStateCode);
                    dynamicObject.set("tdcb", (Object)BigDecimal.ZERO);
                    dynamicObject.set("fdcdevcb", (Object)BigDecimal.ZERO);
                    dynamicObject.set("sgtzsxamount", (Object)BigDecimal.ZERO);
                    dynamicObject.set("tzhfdcdevfybase", (Object)BigDecimal.ZERO);
                    dynamicObject.set("cwfy", (Object)BigDecimal.ZERO);
                    dynamicObject.set("qtfdcdevfy", (Object)BigDecimal.ZERO);
                    dynamicObject.set("fdcdevfy", (Object)BigDecimal.ZERO);
                    dynamicObject.set("tzhqtkcbase", (Object)BigDecimal.ZERO);
                    dynamicObject.set("qtkcxm", (Object)BigDecimal.ZERO);
                }
            }
        }
    }

    @Override
    public boolean isSupportRecalc() {
        return true;
    }

    @Override
    public Map<String, Object> recalc(Long billpk, Long org, Long project, Long scheme, String version) {
        boolean exists = QueryServiceHelper.exists((String)this.getBillNumber(), (Object)billpk);
        if (exists) {
            OperationResult save = this.doRecalc(billpk);
            return AbstractDeskMeasureService.getResultMapFormOpRe(null, save);
        }
        return IDeskMeasureService.createReturnResultObject(Boolean.FALSE, "-1", ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u65e0\u9700\u64cd\u4f5c\u3002", (String)"QiTaAdjustDraftService_3", (String)"taxc-tcept", (Object[])new Object[0]), null);
    }

    public OperationResult doRecalc(Long billpk) {
        DynamicObject draft = BusinessDataServiceHelper.loadSingle((Object)billpk, (String)TCEPT_QITA_DRAFT_BILL);
        DynamicObject scheme = draft.getDynamicObject("scheme");
        long schemeId = scheme.getLong("id");
        long projectId = draft.getLong("project.id");
        long orgId = draft.getLong("org.id");
        String billStatus = draft.getString("billstatus");
        if (!"A".equals(billStatus)) {
            OperationResult reclac = OperationResultHelper.getFatalErrorOperateResult((String)"reclac", Collections.singletonList(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u201c\u6682\u5b58\u201d\u7684\u5355\u636e\u3002", (String)"QiTaAdjustDraftService_4", (String)"taxc-tcept", (Object[])new Object[0])), (String)"", (int)1, new ArrayList());
            return reclac;
        }
        String version = draft.getString("version");
        String swqsytfl = draft.getString("swqsytfl");
        String deductbycost = scheme.getString("deductbycost");
        int maxclearperiod = draft.getInt("maxclearperiod");
        String djdjmethod = draft.getString("djdjmethod");
        String jjkcadjust = draft.getString("jjkcadjust");
        DynamicObjectCollection entryentity1 = draft.getDynamicObjectCollection(ENTRYENTITY_1);
        DynamicObjectCollection entryentity2 = draft.getDynamicObjectCollection(ENTRYENTITY_2);
        DynamicObjectCollection entryentity3 = draft.getDynamicObjectCollection(ENTRYENTITY_3);
        DynamicObjectCollection entryentity4 = draft.getDynamicObjectCollection(ENTRYENTITY_4);
        this.calcDjdjList(orgId, projectId, schemeId, version, maxclearperiod, swqsytfl, djdjmethod, jjkcadjust, entryentity1, entryentity2);
        List<Map<String, Object>> list = this.calcData(orgId, projectId, schemeId, version, swqsytfl, deductbycost, entryentity3);
        this.setEntry4Value(swqsytfl, maxclearperiod, entryentity4, list);
        OperationResult save = OperationServiceHelper.executeOperate((String)"save", (String)TCEPT_QITA_DRAFT_BILL, (DynamicObject[])new DynamicObject[]{draft}, (OperateOption)OperateOption.create());
        if (save.isSuccess()) {
            DeskServiceMediator.fireBillChange(this.getBillNumber(), billpk);
        }
        return save;
    }
}

