/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.business.measure;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.helper.OperationResultHelper;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.utils.ServiceResultUtils;
import kd.taxc.tcept.business.basedata.SchemaDataService;
import kd.taxc.tcept.business.basedata.TaxProjectDataService;
import kd.taxc.tcept.business.draft.AbstractDeskMeasureService;
import kd.taxc.tcept.business.draft.CostSplitDraftService;
import kd.taxc.tcept.business.draft.IncomeAdjustDraftService;
import kd.taxc.tcept.business.draft.IncomeDraftService;
import kd.taxc.tcept.business.draft.ManualAdjustDetailService;
import kd.taxc.tcept.business.draft.QiTaAdjustDraftService;
import kd.taxc.tcept.business.ext.proxy.TaxPredicationService;
import kd.taxc.tcept.business.extpoint.IDeskMeasureService;
import kd.taxc.tcept.business.measure.PreLandMeasureService;
import kd.taxc.tcept.business.statistics.DeskServiceMediator;
import kd.taxc.tcept.common.dto.AdjustRecordDto;
import kd.taxc.tcept.common.enums.BaseCostItemEnum;
import kd.taxc.tcept.common.enums.ClearPeriodEnum;
import kd.taxc.tcept.common.enums.LandValueTaxTableEnum;
import kd.taxc.tcept.common.enums.TaxStateEnum;
import kd.taxc.tcept.common.utils.DraftCommonUtils;

public class LandValueTaxLiquCalcService
implements AbstractDeskMeasureService {
    private static final Log LOGGER = LogFactory.getLog(LandValueTaxLiquCalcService.class);
    public static final String ADJUST_DETAIL_TABLE = "tcept_liquida_calc_entryentity";
    public static final String ENTITY_KEY = "tcept_liquida_calc";
    public static final String ADJUST_CACHE_KEY = "AdjustRecordDto";
    public static final ArrayList<String> FIELD_PREFIX = Lists.newArrayList((Object[])new String[]{"ptzz", "fptzz", "qtlxfc", "fqsyt"});

    public static List<Map<String, Object>> callMeasureTable(Long orgid, Long projectId, Long schemeId, String version, int clearperiod, String swytfl, Long billid, boolean removeManualAdj, List<AdjustRecordDto> adjustRecordDtos) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(32);
        if (removeManualAdj) {
            ManualAdjustDetailService.deleteDataByBiz(ADJUST_DETAIL_TABLE, billid);
        }
        NeedDataParams needDataParams = NeedDataParams.build(orgid, projectId, schemeId, version, swytfl, billid, removeManualAdj, adjustRecordDtos);
        TreeMap orderMap = Arrays.stream(LandValueTaxTableEnum.values()).sorted(Comparator.comparing(a -> a.getCalcOrder())).collect(Collectors.groupingBy(col -> col.getCalcOrder(), TreeMap::new, Collectors.toList()));
        HashMap<Integer, Map<String, Object>> tableMap = new HashMap<Integer, Map<String, Object>>(64);
        for (Map.Entry entry : orderMap.entrySet()) {
            List landValueTaxTableEnums = (List)entry.getValue();
            landValueTaxTableEnums.sort(Comparator.comparing(a -> a.getRowNo()));
            for (LandValueTaxTableEnum tableRow : landValueTaxTableEnums) {
                HashMap<String, Object> rowMap = new HashMap<String, Object>(64);
                rowMap.put("rowno", tableRow.getRowNo());
                rowMap.put("item", tableRow.getRowName());
                if (tableRow.getCalcOrder() == 1) {
                    LandValueTaxLiquCalcService.calcOuterDataLevel(tableRow, rowMap, needDataParams, clearperiod, FIELD_PREFIX);
                } else {
                    LandValueTaxLiquCalcService.calcInnerDataLevel(tableRow, rowMap, tableMap, clearperiod, FIELD_PREFIX);
                }
                if (tableRow.getRowNo() >= 15 && tableRow.getRowNo() <= 20) {
                    for (int i = 1; i <= clearperiod; ++i) {
                        String columnKey = "fqsyt" + i;
                        rowMap.put(columnKey, BigDecimal.ZERO);
                    }
                }
                BigDecimal rowHj = BigDecimal.ZERO;
                if (tableRow.getRowNo() < 15 || tableRow.getRowNo() > 17) {
                    rowHj = LandValueTaxLiquCalcService.calcHjColumn(tableRow.getRowNo(), rowMap, clearperiod, FIELD_PREFIX);
                }
                rowMap.put("hj", rowHj);
                tableMap.put(tableRow.getRowNo(), rowMap);
            }
        }
        result.addAll(tableMap.values());
        Boolean showDjdjmethod = TaxPredicationService.getInstance().isNeedDjdjmethodRow();
        if (!showDjdjmethod.booleanValue()) {
            String djdjmethod = needDataParams.getDjdjmethod();
            Iterator<Map<String, Object>> iterator = result.iterator();
            while (iterator.hasNext()) {
                Map<String, Object> next = iterator.next();
                Integer rowno = (Integer)next.get("rowno");
                if ((rowno != 3 || "1".equals(djdjmethod)) && (rowno != 7 || "2".equals(djdjmethod))) continue;
                iterator.remove();
            }
        }
        return result;
    }

    private static void calcOuterDataLevel(LandValueTaxTableEnum tableRow, Map<String, Object> rowMap, NeedDataParams needDataParams, int clearperiod, ArrayList<String> amountFieldPrefix) {
        switch (tableRow.getRowNo()) {
            case 2: {
                LandValueTaxLiquCalcService.calcTwoRow(rowMap, needDataParams, clearperiod);
                break;
            }
            case 3: {
                LandValueTaxLiquCalcService.calcThreeRow(rowMap, needDataParams, clearperiod, amountFieldPrefix);
                break;
            }
            case 6: {
                LandValueTaxLiquCalcService.calcSixRow(rowMap, needDataParams, clearperiod, "tdcb");
                break;
            }
            case 7: {
                LandValueTaxLiquCalcService.calcSevenRow(rowMap, needDataParams, clearperiod, amountFieldPrefix);
                break;
            }
            case 8: {
                LandValueTaxLiquCalcService.calcSixRow(rowMap, needDataParams, clearperiod, "fdcdevcb");
                break;
            }
            case 10: {
                LandValueTaxLiquCalcService.calcSixRow(rowMap, needDataParams, clearperiod, "cwfy");
                break;
            }
            case 11: {
                LandValueTaxLiquCalcService.calcSixRow(rowMap, needDataParams, clearperiod, "qtfdcdevfy");
                break;
            }
            case 12: {
                LandValueTaxLiquCalcService.calcTwelveRow(tableRow, rowMap, needDataParams, clearperiod, amountFieldPrefix);
                break;
            }
            case 13: {
                LandValueTaxLiquCalcService.calcSixRow(rowMap, needDataParams, clearperiod, "qtkcxm");
                break;
            }
            case 19: {
                LandValueTaxLiquCalcService.calcNineteenRow(rowMap, needDataParams, clearperiod);
            }
        }
    }

    private static void calcNineteenRow(Map<String, Object> rowMap, NeedDataParams needDataParams, int clearperiod) {
        Map<Object, Map<String, BigDecimal>> yjTzsCsTaxTypeGroup = needDataParams.getYjTzsCsTaxTypeGroup();
        for (int i = 1; i <= clearperiod; ++i) {
            Map swytflMap1 = yjTzsCsTaxTypeGroup.getOrDefault(TaxStateEnum.NORMAL_HOUSE.getCode(), new HashMap());
            Map swytflMap2 = yjTzsCsTaxTypeGroup.getOrDefault(TaxStateEnum.UN_NORMAL_HOUSE.getCode(), new HashMap());
            Map swytflMap3 = yjTzsCsTaxTypeGroup.getOrDefault(TaxStateEnum.UN_HOUSE.getCode(), new HashMap());
            Map swytflMap4 = yjTzsCsTaxTypeGroup.getOrDefault(TaxStateEnum.UN_CALC_STATE.getCode(), new HashMap());
            BigDecimal ptzz = swytflMap1.getOrDefault("pre_landtax_amount_" + i, BigDecimal.ZERO);
            BigDecimal fptzz = swytflMap2.getOrDefault("pre_landtax_amount_" + i, BigDecimal.ZERO);
            BigDecimal qtlxfc = swytflMap3.getOrDefault("pre_landtax_amount_" + i, BigDecimal.ZERO);
            BigDecimal fqsyt = swytflMap4.getOrDefault("pre_landtax_amount_" + i, BigDecimal.ZERO);
            rowMap.put("ptzz" + i, ptzz.setScale(4, RoundingMode.HALF_UP));
            rowMap.put("fptzz" + i, fptzz.setScale(4, RoundingMode.HALF_UP));
            rowMap.put("qtlxfc" + i, qtlxfc.setScale(4, RoundingMode.HALF_UP));
            rowMap.put("fqsyt" + i, fqsyt.setScale(4, RoundingMode.HALF_UP));
        }
    }

    private static void calcTwelveRow(LandValueTaxTableEnum tableRow, Map<String, Object> rowMap, NeedDataParams needDataParams, int clearperiod, ArrayList<String> amountFieldPrefix) {
        Map<Object, Map<String, BigDecimal>> sjGroup = needDataParams.getFtDgSjGroup();
        Map<String, List<AdjustRecordDto>> adjustDetailDtoMap = needDataParams.getAdjustDetailDtoMap();
        Map<Integer, ClearPeriodEnum> orderMap = ClearPeriodEnum.getOrderMap();
        for (int i = 1; i <= clearperiod; ++i) {
            String code = orderMap.get(i).getCode();
            Map orDefault = sjGroup.getOrDefault(code, new HashMap());
            BigDecimal ptzz = orDefault.getOrDefault("ptzztaxamount", BigDecimal.ZERO);
            BigDecimal fptzz = orDefault.getOrDefault("fptzztaxamount", BigDecimal.ZERO);
            BigDecimal qtlxfc = orDefault.getOrDefault("qtlxfctaxamount", BigDecimal.ZERO);
            BigDecimal fqsyt = orDefault.getOrDefault("fqsyttaxamount", BigDecimal.ZERO);
            ptzz = LandValueTaxLiquCalcService.addAdjustAmount(tableRow.getRowNo(), adjustDetailDtoMap, i, ptzz, "ptzz");
            fptzz = LandValueTaxLiquCalcService.addAdjustAmount(tableRow.getRowNo(), adjustDetailDtoMap, i, fptzz, "fptzz");
            qtlxfc = LandValueTaxLiquCalcService.addAdjustAmount(tableRow.getRowNo(), adjustDetailDtoMap, i, qtlxfc, "qtlxfc");
            fqsyt = LandValueTaxLiquCalcService.addAdjustAmount(tableRow.getRowNo(), adjustDetailDtoMap, i, fqsyt, "fqsyt");
            rowMap.put("ptzz" + i, ptzz.setScale(4, RoundingMode.HALF_UP));
            rowMap.put("fptzz" + i, fptzz.setScale(4, RoundingMode.HALF_UP));
            rowMap.put("qtlxfc" + i, qtlxfc.setScale(4, RoundingMode.HALF_UP));
            rowMap.put("fqsyt" + i, fqsyt.setScale(4, RoundingMode.HALF_UP));
        }
    }

    private static BigDecimal addAdjustAmount(int rowno, Map<String, List<AdjustRecordDto>> adjustDetailMap, int columnindex, BigDecimal ptzz, String fieldPrefix) {
        String key = rowno + fieldPrefix + columnindex;
        if (adjustDetailMap.containsKey(key)) {
            AdjustRecordDto changeData = adjustDetailMap.get(key).get(0);
            String adjustvalue = changeData.getAdjustvalue();
            BigDecimal changeAmount = ManualAdjustDetailService.convertBigDecimal(adjustvalue);
            ptzz = ptzz.add(changeAmount);
        }
        return ptzz;
    }

    private static void calcSevenRow(Map<String, Object> rowMap, NeedDataParams needDataParams, int clearperiod, ArrayList<String> amountFieldPrefix) {
        String djdjmethod = needDataParams.getDjdjmethod();
        if ("2".equals(djdjmethod)) {
            Map<Object, Map<String, BigDecimal>> qtSplitTaxTypeGroup = needDataParams.getQtSplitTaxTypeGroup();
            Map<Integer, ClearPeriodEnum> orderMap = ClearPeriodEnum.getOrderMap();
            for (int i = 1; i <= clearperiod; ++i) {
                String code = orderMap.get(i).getCode();
                Map swytflMap = qtSplitTaxTypeGroup.getOrDefault(code, new HashMap());
                BigDecimal ptzz = swytflMap.getOrDefault(TaxStateEnum.NORMAL_HOUSE.getColumnCode(), BigDecimal.ZERO);
                BigDecimal fptzz = swytflMap.getOrDefault(TaxStateEnum.UN_NORMAL_HOUSE.getColumnCode(), BigDecimal.ZERO);
                BigDecimal qtlxfc = swytflMap.getOrDefault(TaxStateEnum.UN_HOUSE.getColumnCode(), BigDecimal.ZERO);
                BigDecimal fqsyt = swytflMap.getOrDefault(TaxStateEnum.UN_CALC_STATE.getColumnCode(), BigDecimal.ZERO);
                rowMap.put("ptzz" + i, BigDecimal.ZERO.subtract(ptzz.setScale(4, RoundingMode.HALF_UP)));
                rowMap.put("fptzz" + i, BigDecimal.ZERO.subtract(fptzz.setScale(4, RoundingMode.HALF_UP)));
                rowMap.put("qtlxfc" + i, BigDecimal.ZERO.subtract(qtlxfc.setScale(4, RoundingMode.HALF_UP)));
                rowMap.put("fqsyt" + i, BigDecimal.ZERO.subtract(fqsyt.setScale(4, RoundingMode.HALF_UP)));
            }
        } else {
            for (int i = 1; i <= clearperiod; ++i) {
                for (String fieldPrefix : amountFieldPrefix) {
                    rowMap.put(fieldPrefix + clearperiod, BigDecimal.ZERO);
                }
            }
        }
    }

    private static void calcSixRow(Map<String, Object> rowMap, NeedDataParams needDataParams, int clearperiod, String xm) {
        Map<Object, Map<Object, Map<String, BigDecimal>>> qtSplitTaxTypeGroup = needDataParams.getAddDecutPeriodSplitTaxTypeGroup();
        Map<Integer, ClearPeriodEnum> orderMap = ClearPeriodEnum.getOrderMap();
        for (int i = 1; i <= clearperiod; ++i) {
            String code = orderMap.get(i).getCode();
            Map swytflMap = qtSplitTaxTypeGroup.getOrDefault(code, new HashMap());
            BigDecimal ptzz = ((Map)swytflMap.getOrDefault(TaxStateEnum.NORMAL_HOUSE.getCode(), new HashMap())).getOrDefault(xm, BigDecimal.ZERO);
            BigDecimal fptzz = ((Map)swytflMap.getOrDefault(TaxStateEnum.UN_NORMAL_HOUSE.getCode(), new HashMap())).getOrDefault(xm, BigDecimal.ZERO);
            BigDecimal qtlxfc = ((Map)swytflMap.getOrDefault(TaxStateEnum.UN_HOUSE.getCode(), new HashMap())).getOrDefault(xm, BigDecimal.ZERO);
            BigDecimal fqsyt = ((Map)swytflMap.getOrDefault(TaxStateEnum.UN_CALC_STATE.getCode(), new HashMap())).getOrDefault(xm, BigDecimal.ZERO);
            rowMap.put("ptzz" + i, ptzz.setScale(4, RoundingMode.HALF_UP));
            rowMap.put("fptzz" + i, fptzz.setScale(4, RoundingMode.HALF_UP));
            rowMap.put("qtlxfc" + i, qtlxfc.setScale(4, RoundingMode.HALF_UP));
            rowMap.put("fqsyt" + i, fqsyt.setScale(4, RoundingMode.HALF_UP));
        }
    }

    private static void calcThreeRow(Map<String, Object> rowMap, NeedDataParams needDataParams, int clearperiod, ArrayList<String> amountFieldPrefix) {
        String djdjmethod = needDataParams.getDjdjmethod();
        if ("1".equals(djdjmethod)) {
            Map<Object, Map<String, BigDecimal>> qtSplitTaxTypeGroup = needDataParams.getQtSplitTaxTypeGroup();
            Map<Integer, ClearPeriodEnum> orderMap = ClearPeriodEnum.getOrderMap();
            for (int i = 1; i <= clearperiod; ++i) {
                String code = orderMap.get(i).getCode();
                Map swytflMap = qtSplitTaxTypeGroup.getOrDefault(code, new HashMap());
                BigDecimal ptzz = swytflMap.getOrDefault(TaxStateEnum.NORMAL_HOUSE.getColumnCode(), BigDecimal.ZERO);
                BigDecimal fptzz = swytflMap.getOrDefault(TaxStateEnum.UN_NORMAL_HOUSE.getColumnCode(), BigDecimal.ZERO);
                BigDecimal qtlxfc = swytflMap.getOrDefault(TaxStateEnum.UN_HOUSE.getColumnCode(), BigDecimal.ZERO);
                BigDecimal fqsyt = swytflMap.getOrDefault(TaxStateEnum.UN_CALC_STATE.getColumnCode(), BigDecimal.ZERO);
                rowMap.put("ptzz" + i, ptzz.setScale(4, RoundingMode.HALF_UP));
                rowMap.put("fptzz" + i, fptzz.setScale(4, RoundingMode.HALF_UP));
                rowMap.put("qtlxfc" + i, qtlxfc.setScale(4, RoundingMode.HALF_UP));
                rowMap.put("fqsyt" + i, fqsyt.setScale(4, RoundingMode.HALF_UP));
            }
        } else {
            for (int i = 1; i <= clearperiod; ++i) {
                for (String fieldPrefix : amountFieldPrefix) {
                    rowMap.put(fieldPrefix + clearperiod, BigDecimal.ZERO);
                }
            }
        }
    }

    private static void calcTwoRow(Map<String, Object> rowMap, NeedDataParams needDataParams, int clearperiod) {
        BigDecimal zzssl = needDataParams.getZzssl();
        Boolean reshareofuncleart = needDataParams.getReshareofuncleart();
        Map<Object, Map<Object, BigDecimal>> roomDetailGoodValueGroup = needDataParams.getRoomDetailGoodValueGroup();
        Map<Object, Map<Object, BigDecimal>> notaxrevenue2Group = needDataParams.getNotaxrevenue2Group();
        Map<Object, Map<Object, BigDecimal>> notaxrevenueGroup = needDataParams.getNotaxrevenueGroup();
        Map<Object, Map<Object, BigDecimal>> stxsincomenotaxGroup = needDataParams.getStxsincomenotaxGroup();
        Map<Integer, ClearPeriodEnum> orderMap = ClearPeriodEnum.getOrderMap();
        for (int i = 1; i <= clearperiod; ++i) {
            BigDecimal ptzz = BigDecimal.ZERO;
            BigDecimal fptzz = BigDecimal.ZERO;
            BigDecimal qtlxfc = BigDecimal.ZERO;
            BigDecimal fqsyt = BigDecimal.ZERO;
            String code = orderMap.get(i).getCode();
            Map swytflMap = roomDetailGoodValueGroup.getOrDefault(code, new HashMap());
            ptzz = ptzz.add(swytflMap.getOrDefault(TaxStateEnum.NORMAL_HOUSE.getCode(), BigDecimal.ZERO).divide(zzssl, 10, RoundingMode.HALF_UP));
            fptzz = fptzz.add(swytflMap.getOrDefault(TaxStateEnum.UN_NORMAL_HOUSE.getCode(), BigDecimal.ZERO).divide(zzssl, 10, RoundingMode.HALF_UP));
            qtlxfc = qtlxfc.add(swytflMap.getOrDefault(TaxStateEnum.UN_HOUSE.getCode(), BigDecimal.ZERO).divide(zzssl, 10, RoundingMode.HALF_UP));
            fqsyt = fqsyt.add(swytflMap.getOrDefault(TaxStateEnum.UN_CALC_STATE.getCode(), BigDecimal.ZERO).divide(zzssl, 10, RoundingMode.HALF_UP));
            swytflMap = notaxrevenue2Group.getOrDefault(code, new HashMap());
            ptzz = ptzz.add(swytflMap.getOrDefault(TaxStateEnum.NORMAL_HOUSE.getQtCode(), BigDecimal.ZERO));
            fptzz = fptzz.add(swytflMap.getOrDefault(TaxStateEnum.UN_NORMAL_HOUSE.getQtCode(), BigDecimal.ZERO));
            qtlxfc = qtlxfc.add(swytflMap.getOrDefault(TaxStateEnum.UN_HOUSE.getQtCode(), BigDecimal.ZERO));
            fqsyt = fqsyt.add(swytflMap.getOrDefault(TaxStateEnum.UN_CALC_STATE.getQtCode(), BigDecimal.ZERO));
            swytflMap = stxsincomenotaxGroup.getOrDefault(code, new HashMap());
            ptzz = ptzz.add(swytflMap.getOrDefault(TaxStateEnum.NORMAL_HOUSE.getQtCode(), BigDecimal.ZERO));
            fptzz = fptzz.add(swytflMap.getOrDefault(TaxStateEnum.UN_NORMAL_HOUSE.getQtCode(), BigDecimal.ZERO));
            qtlxfc = qtlxfc.add(swytflMap.getOrDefault(TaxStateEnum.UN_HOUSE.getQtCode(), BigDecimal.ZERO));
            fqsyt = fqsyt.add(swytflMap.getOrDefault(TaxStateEnum.UN_CALC_STATE.getQtCode(), BigDecimal.ZERO));
            swytflMap = notaxrevenueGroup.getOrDefault(code, new HashMap());
            ptzz = ptzz.add(swytflMap.getOrDefault(TaxStateEnum.NORMAL_HOUSE.getQtCode(), BigDecimal.ZERO));
            fptzz = fptzz.add(swytflMap.getOrDefault(TaxStateEnum.UN_NORMAL_HOUSE.getQtCode(), BigDecimal.ZERO));
            qtlxfc = qtlxfc.add(swytflMap.getOrDefault(TaxStateEnum.UN_HOUSE.getQtCode(), BigDecimal.ZERO));
            fqsyt = fqsyt.add(swytflMap.getOrDefault(TaxStateEnum.UN_CALC_STATE.getQtCode(), BigDecimal.ZERO));
            if (reshareofuncleart.booleanValue()) {
                BigDecimal total = ptzz.add(fptzz).add(qtlxfc);
                if (total.compareTo(BigDecimal.ZERO) > 0) {
                    ptzz = ptzz.add(fqsyt.multiply(ptzz.divide(total, 10, RoundingMode.HALF_UP)));
                    fptzz = fptzz.add(fqsyt.multiply(fptzz.divide(total, 10, RoundingMode.HALF_UP)));
                    qtlxfc = qtlxfc.add(fqsyt.multiply(qtlxfc.divide(total, 10, RoundingMode.HALF_UP)));
                }
                fqsyt = BigDecimal.ZERO;
            }
            rowMap.put("ptzz" + i, ptzz.setScale(4, RoundingMode.HALF_UP));
            rowMap.put("fptzz" + i, fptzz.setScale(4, RoundingMode.HALF_UP));
            rowMap.put("qtlxfc" + i, qtlxfc.setScale(4, RoundingMode.HALF_UP));
            rowMap.put("fqsyt" + i, fqsyt.setScale(4, RoundingMode.HALF_UP));
        }
    }

    private static void calcInnerDataLevel(LandValueTaxTableEnum tableRow, Map<String, Object> rowMap, Map<Integer, Map<String, Object>> tableMap, int clearperiod, ArrayList<String> amountFieldPrefix) {
        switch (tableRow.getRowNo()) {
            case 1: {
                LandValueTaxLiquCalcService.accumulateByRowNo(null, rowMap, tableMap, clearperiod, amountFieldPrefix, 2, 3);
                break;
            }
            case 4: {
                LandValueTaxLiquCalcService.accumulateByRowNo(a -> a.compareTo(BigDecimal.ZERO) > 0 ? a : BigDecimal.ZERO, rowMap, tableMap, clearperiod, amountFieldPrefix, 5, 8, 9, 12, 13);
                break;
            }
            case 5: {
                LandValueTaxLiquCalcService.accumulateByRowNo(null, rowMap, tableMap, clearperiod, amountFieldPrefix, 6, 7);
                break;
            }
            case 9: {
                LandValueTaxLiquCalcService.accumulateByRowNo(null, rowMap, tableMap, clearperiod, amountFieldPrefix, 10, 11);
                break;
            }
            case 14: {
                LandValueTaxLiquCalcService.binaryCalcByRowNo((a, b) -> a.subtract((BigDecimal)b), rowMap, tableMap, clearperiod, amountFieldPrefix, 1, 4);
                break;
            }
            case 15: {
                LandValueTaxLiquCalcService.binaryCalcByRowNo((a, b) -> a.compareTo(BigDecimal.ZERO) > 0 && b.compareTo(BigDecimal.ZERO) > 0 ? a.divide((BigDecimal)b, 4, 4) : BigDecimal.ZERO, rowMap, tableMap, clearperiod, amountFieldPrefix, 14, 4);
                break;
            }
            case 16: {
                LandValueTaxLiquCalcService.oneBaseCalcByRowNo((a, b) -> {
                    if ("ptzz".equals(b)) {
                        if (a.compareTo(new BigDecimal("0.2")) <= 0) {
                            return new BigDecimal("0.0");
                        }
                        if (a.compareTo(new BigDecimal("0.5")) <= 0) {
                            return new BigDecimal("0.3");
                        }
                        if (a.compareTo(new BigDecimal("1")) <= 0) {
                            return new BigDecimal("0.4");
                        }
                        if (a.compareTo(new BigDecimal("2")) <= 0) {
                            return new BigDecimal("0.5");
                        }
                        return new BigDecimal("0.6");
                    }
                    if (a.compareTo(new BigDecimal("0.0")) <= 0) {
                        return new BigDecimal("0.0");
                    }
                    if (a.compareTo(new BigDecimal("0.5")) <= 0) {
                        return new BigDecimal("0.3");
                    }
                    if (a.compareTo(new BigDecimal("1")) <= 0) {
                        return new BigDecimal("0.4");
                    }
                    if (a.compareTo(new BigDecimal("2")) <= 0) {
                        return new BigDecimal("0.5");
                    }
                    return new BigDecimal("0.6");
                }, rowMap, tableMap, clearperiod, amountFieldPrefix, 15);
                break;
            }
            case 17: {
                LandValueTaxLiquCalcService.oneBaseCalcByRowNo((a, b) -> {
                    if (a.compareTo(new BigDecimal("0.5")) <= 0) {
                        return BigDecimal.ZERO;
                    }
                    if (a.compareTo(new BigDecimal("1")) <= 0) {
                        return new BigDecimal("0.05");
                    }
                    if (a.compareTo(new BigDecimal("2")) <= 0) {
                        return new BigDecimal("0.15");
                    }
                    return new BigDecimal("0.35");
                }, rowMap, tableMap, clearperiod, amountFieldPrefix, 15);
                break;
            }
            case 18: {
                for (int i = 1; i <= clearperiod; ++i) {
                    for (String fieldPrefix : amountFieldPrefix) {
                        String columnKey = fieldPrefix + i;
                        BigDecimal bigDecimal14 = ((Map)tableMap.getOrDefault(14, new HashMap())).getOrDefault(columnKey, BigDecimal.ZERO);
                        BigDecimal bigDecimal16 = ((Map)tableMap.getOrDefault(16, new HashMap())).getOrDefault(columnKey, BigDecimal.ZERO);
                        BigDecimal bigDecimal17 = ((Map)tableMap.getOrDefault(17, new HashMap())).getOrDefault(columnKey, BigDecimal.ZERO);
                        BigDecimal bigDecimal4 = ((Map)tableMap.getOrDefault(4, new HashMap())).getOrDefault(columnKey, BigDecimal.ZERO);
                        BigDecimal source = bigDecimal14.compareTo(BigDecimal.ZERO) <= 0 ? BigDecimal.ZERO : bigDecimal14.multiply(bigDecimal16).subtract(bigDecimal17.multiply(bigDecimal4));
                        rowMap.put(columnKey, source);
                    }
                }
                break;
            }
            case 20: {
                LandValueTaxLiquCalcService.binaryCalcByRowNo((a, b) -> a.subtract((BigDecimal)b), rowMap, tableMap, clearperiod, amountFieldPrefix, 18, 19);
            }
        }
    }

    private static void oneBaseCalcByRowNo(BiFunction<BigDecimal, String, BigDecimal> function, Map<String, Object> rowMap, Map<Integer, Map<String, Object>> tableMap, int clearperiod, ArrayList<String> amountFieldPrefix, int from) {
        for (int i = 1; i <= clearperiod; ++i) {
            for (String fieldPrefix : amountFieldPrefix) {
                String columnKey = fieldPrefix + i;
                BigDecimal source = (BigDecimal)rowMap.getOrDefault(columnKey, BigDecimal.ZERO);
                Map formMap = tableMap.getOrDefault(from, new HashMap());
                BigDecimal fromV = formMap.getOrDefault(columnKey, BigDecimal.ZERO);
                if (function != null) {
                    source = function.apply(fromV, fieldPrefix);
                }
                rowMap.put(columnKey, source);
            }
        }
    }

    private static void binaryCalcByRowNo(BiFunction<BigDecimal, BigDecimal, BigDecimal> function, Map<String, Object> rowMap, Map<Integer, Map<String, Object>> tableMap, int clearperiod, ArrayList<String> amountFieldPrefix, int from, int to) {
        for (int i = 1; i <= clearperiod; ++i) {
            for (String fieldPrefix : amountFieldPrefix) {
                String columnKey = fieldPrefix + i;
                BigDecimal source = (BigDecimal)rowMap.getOrDefault(columnKey, BigDecimal.ZERO);
                Map formMap = tableMap.getOrDefault(from, new HashMap());
                Map toMap = tableMap.getOrDefault(to, new HashMap());
                BigDecimal fromV = formMap.getOrDefault(columnKey, BigDecimal.ZERO);
                BigDecimal toV = toMap.getOrDefault(columnKey, BigDecimal.ZERO);
                if (function != null) {
                    source = function.apply(fromV, toV);
                }
                rowMap.put(columnKey, source);
            }
        }
    }

    private static void accumulateByRowNo(Function<BigDecimal, BigDecimal> function, Map<String, Object> rowMap, Map<Integer, Map<String, Object>> tableMap, int clearperiod, ArrayList<String> amountFieldPrefix, int ... rows) {
        for (int i = 1; i <= clearperiod; ++i) {
            for (String fieldPrefix : amountFieldPrefix) {
                String columnKey = fieldPrefix + i;
                BigDecimal source = (BigDecimal)rowMap.getOrDefault(columnKey, BigDecimal.ZERO);
                for (int row : rows) {
                    Map targetMap = tableMap.getOrDefault(row, new HashMap());
                    BigDecimal three = targetMap.getOrDefault(columnKey, BigDecimal.ZERO);
                    source = source.add(three);
                }
                if (function != null) {
                    source = function.apply(source);
                }
                rowMap.put(columnKey, source);
            }
        }
    }

    private static BigDecimal calcHjColumn(int rowNo, Map<String, Object> rowMap, int clearperiod, ArrayList<String> amountFieldPrefix) {
        BigDecimal hj = BigDecimal.ZERO;
        if (rowNo != 15 && rowNo != 16 && rowNo != 17) {
            for (int i = 1; i <= clearperiod; ++i) {
                for (String fieldPrefix : amountFieldPrefix) {
                    BigDecimal orDefault = (BigDecimal)rowMap.getOrDefault(fieldPrefix + i, BigDecimal.ZERO);
                    hj = hj.add(orDefault);
                }
            }
        }
        return hj;
    }

    public static OperationResult reCalc(Long billid) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)billid, (String)ENTITY_KEY);
        if (dynamicObject != null) {
            Long orgid = (Long)dynamicObject.get("org.id");
            Long projectId = (Long)dynamicObject.get("houseproject.id");
            Long schemeId = (Long)dynamicObject.get("scheme.id");
            String version = dynamicObject.getString("version");
            String billStatus = dynamicObject.getString("billstatus");
            if (!"A".equals(billStatus)) {
                OperationResult reclac = OperationResultHelper.getFatalErrorOperateResult((String)"reclac", Collections.singletonList(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u201c\u6682\u5b58\u201d\u7684\u5355\u636e\u3002", (String)"LandValueTaxLiquCalcService_1", (String)"taxc-tcept", (Object[])new Object[0])), (String)"", (int)1, new ArrayList());
                return reclac;
            }
            String swytfl = TaxProjectDataService.queryProjectSwqsytfl(projectId);
            int clearperiod = SchemaDataService.querySchemeClearperiod(schemeId);
            DynamicObjectCollection adjustDetail = ManualAdjustDetailService.queryDataByBiz(ADJUST_DETAIL_TABLE, billid);
            List<AdjustRecordDto> adjustRecordDtos = adjustDetail.stream().map(a -> AdjustRecordDto.transformFromDynObj(a)).collect(Collectors.toList());
            List<Map<String, Object>> resultListMap = LandValueTaxLiquCalcService.callMeasureTable(orgid, projectId, schemeId, version, clearperiod, swytfl, billid, false, adjustRecordDtos);
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            entryentity.clear();
            HashMap hjColumn = new HashMap();
            for (int i = 0; i < resultListMap.size(); ++i) {
                Map<String, Object> map = resultListMap.get(i);
                DynamicObject row = entryentity.addNew();
                for (Map.Entry entry : map.entrySet()) {
                    row.set((String)entry.getKey(), entry.getValue());
                }
                hjColumn.put("" + map.get("rowno"), map.get("hj"));
            }
            List<LandValueTaxTableEnum> listShowEnums = LandValueTaxTableEnum.getListShowEnums();
            for (LandValueTaxTableEnum showEnum : listShowEnums) {
                dynamicObject.set(showEnum.getListShowKey(), (Object)hjColumn.getOrDefault(showEnum.getRowNo() + "", BigDecimal.ZERO));
            }
            OperationResult save = OperationServiceHelper.executeOperate((String)"save", (String)ENTITY_KEY, (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create());
            if (save.isSuccess()) {
                DeskServiceMediator.fireBillChange(ENTITY_KEY, billid);
            }
            return save;
        }
        return null;
    }

    @Override
    public String getBillNumber() {
        return ENTITY_KEY;
    }

    @Override
    public Map<String, String> getInfoSyncField() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("org_field_key", "org");
        hashMap.put("project_field_key", "houseproject");
        hashMap.put("scheme_field_key", "scheme");
        hashMap.put("version_field_key", "version");
        hashMap.put("billno_field_key", "billno");
        hashMap.put("billstatus_field_key", "billstatus");
        hashMap.put("modifier_field_key", "modifier");
        hashMap.put("modifydate_field_key", "modifytime");
        return hashMap;
    }

    @Override
    public Map<String, Object> copy(Long originalPk, Long org, Long project, Long scheme, String version, String newVersion) {
        DynamicObject single = BusinessDataServiceHelper.loadSingle((Object)originalPk, (String)ENTITY_KEY);
        DynamicObject newObj = (DynamicObject)new CloneUtils(false, true).clone((IDataEntityBase)single);
        long id = single.getLong("id");
        long newId = DBUtils.getLongId((String)"t_tcept_liquida_calc");
        newObj.set("id", (Object)newId);
        newObj.set("version", (Object)newVersion);
        String billno = DraftCommonUtils.getDraftNumber(newObj, single.getLong("org.id"));
        newObj.set("billno", (Object)billno);
        newObj.set("billstatus", (Object)"A");
        ArrayList<DynamicObject> adjustRecords = ManualAdjustDetailService.copy(ADJUST_DETAIL_TABLE, id, newId);
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            Object[] save1 = SaveServiceHelper.save((DynamicObject[])adjustRecords.toArray(new DynamicObject[adjustRecords.size()]));
            Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newObj});
            Map map = ServiceResultUtils.returnResultHandler((Object)save[0]);
            return map;
        }
        catch (Exception e) {
            try {
                LOGGER.error((Throwable)e);
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public boolean isSupportRecalc() {
        return true;
    }

    @Override
    public Map<String, Object> recalc(Long billpk, Long org, Long project, Long scheme, String version) {
        OperationResult operationResult;
        boolean exists = QueryServiceHelper.exists((String)this.getBillNumber(), (Object)billpk);
        if (exists && (operationResult = LandValueTaxLiquCalcService.reCalc(billpk)) != null) {
            return AbstractDeskMeasureService.getResultMapFormOpRe(null, operationResult);
        }
        return IDeskMeasureService.createReturnResultObject(Boolean.FALSE, "-1", ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u65e0\u9700\u64cd\u4f5c\u3002", (String)"LandValueTaxLiquCalcService_0", (String)"taxc-tcept", (Object[])new Object[0]), null);
    }

    private static class NeedDataParams {
        Map<String, List<DynamicObject>> adjustDetailMap = new HashMap<String, List<DynamicObject>>();
        Map<String, List<AdjustRecordDto>> adjustDetailDtoMap = new HashMap<String, List<AdjustRecordDto>>();
        Boolean reshareofuncleart = false;
        Boolean dichotomy = false;
        BigDecimal zzssl = BigDecimal.ZERO;
        Map<Object, Map<Object, BigDecimal>> roomDetailGoodValueGroup = new HashMap<Object, Map<Object, BigDecimal>>();
        Map<Object, Map<Object, BigDecimal>> notaxrevenueGroup = new HashMap<Object, Map<Object, BigDecimal>>();
        Map<Object, Map<Object, BigDecimal>> stxsincomenotaxGroup = new HashMap<Object, Map<Object, BigDecimal>>();
        Map<Object, Map<Object, BigDecimal>> notaxrevenue2Group = new HashMap<Object, Map<Object, BigDecimal>>();
        String djdjmethod = "";
        Map<Object, Map<String, BigDecimal>> qtSplitTaxTypeGroup = new HashMap<Object, Map<String, BigDecimal>>();
        Map<Object, Map<Object, Map<String, BigDecimal>>> addDecutPeriodSplitTaxTypeGroup = new HashMap<Object, Map<Object, Map<String, BigDecimal>>>();
        Map<Object, Map<String, BigDecimal>> ftDgSjGroup = new HashMap<Object, Map<String, BigDecimal>>();
        Map<Object, Map<String, BigDecimal>> yjTzsCsTaxTypeGroup = new HashMap<Object, Map<String, BigDecimal>>();

        private NeedDataParams() {
        }

        public static NeedDataParams build(Long orgid, Long projectId, Long schemeId, String version, String swytfl, Long billid, boolean removeManualAdj, List<AdjustRecordDto> adjustRecordDtos) {
            NeedDataParams needDataParams = new NeedDataParams();
            Map<String, List<AdjustRecordDto>> adjustDetailDtoMap = adjustRecordDtos.stream().collect(Collectors.groupingBy(a -> a.getSubbizid() + a.getBizfield()));
            Boolean reshareofuncleart = SchemaDataService.querySchemeReshareofuncleart(schemeId);
            Boolean dichotomy = "0".equals(swytfl);
            BigDecimal zzssl = BigDecimal.ONE.add(TaxProjectDataService.queryProjectSyslzsl(projectId));
            Map<Object, Map<Object, BigDecimal>> roomDetailGoodValueGroup = IncomeDraftService.getRoomDetailGoodValueGroup(orgid, projectId, schemeId, version);
            Map<Object, Map<Object, BigDecimal>> notaxrevenueGroup = IncomeAdjustDraftService.getNotaxrevenueGroup(orgid, projectId, schemeId, version);
            Map<Object, Map<Object, BigDecimal>> stxsincomenotaxGroup = IncomeAdjustDraftService.getStxsincomenotaxGroup(orgid, projectId, schemeId, version);
            Map<Object, Map<Object, BigDecimal>> notaxrevenue2Group = IncomeAdjustDraftService.getNotaxrevenue2Group(orgid, projectId, schemeId, version);
            DynamicObject qtDraft = QiTaAdjustDraftService.queryDraftByUniq(orgid, projectId, schemeId, version);
            String djdjmethod = qtDraft != null ? qtDraft.getString("djdjmethod") : "";
            Map<Object, Map<String, BigDecimal>> qtSplitTaxTypeGroup = QiTaAdjustDraftService.getPeriodSplitTaxTypeTableGroup(orgid, projectId, schemeId, version);
            Map<Object, Map<Object, Map<String, BigDecimal>>> addDecutPeriodSplitTaxTypeGroup = QiTaAdjustDraftService.getAddDecutPeriodSplitTaxTypeGroup(orgid, projectId, schemeId, version);
            Map<Object, Map<String, BigDecimal>> periodTaxTypeSplitTableGroup = CostSplitDraftService.getPeriodTaxTypeSplitTableGroup(orgid, projectId, schemeId, version, BaseCostItemEnum.SJ.getNumber());
            Map<Object, Map<String, BigDecimal>> yjTzsCsTaxTypeGroup = PreLandMeasureService.getYjTzsCsTaxTypeGroup(orgid, projectId, schemeId, version);
            needDataParams.setAdjustDetailDtoMap(adjustDetailDtoMap);
            needDataParams.setReshareofuncleart(reshareofuncleart);
            needDataParams.setDichotomy(dichotomy);
            needDataParams.setZzssl(zzssl);
            needDataParams.setRoomDetailGoodValueGroup(roomDetailGoodValueGroup);
            needDataParams.setNotaxrevenueGroup(notaxrevenueGroup);
            needDataParams.setStxsincomenotaxGroup(stxsincomenotaxGroup);
            needDataParams.setNotaxrevenue2Group(notaxrevenue2Group);
            needDataParams.setDjdjmethod(djdjmethod);
            needDataParams.setQtSplitTaxTypeGroup(qtSplitTaxTypeGroup);
            needDataParams.setAddDecutPeriodSplitTaxTypeGroup(addDecutPeriodSplitTaxTypeGroup);
            needDataParams.setFtDgSjGroup(periodTaxTypeSplitTableGroup);
            needDataParams.setYjTzsCsTaxTypeGroup(yjTzsCsTaxTypeGroup);
            return needDataParams;
        }

        private static Map<String, List<DynamicObject>> queryAdjustDetailMap(Boolean removeManualAdjustData, Object bizid) {
            DynamicObjectCollection adjustDetail = ManualAdjustDetailService.queryDataByBiz(LandValueTaxLiquCalcService.ADJUST_DETAIL_TABLE, bizid);
            return removeManualAdjustData != false ? new HashMap<String, List<DynamicObject>>() : adjustDetail.stream().collect(Collectors.groupingBy(a -> a.getLong("subbizid") + a.getString("bizfield")));
        }

        public Map<String, List<AdjustRecordDto>> getAdjustDetailDtoMap() {
            return this.adjustDetailDtoMap;
        }

        public void setAdjustDetailDtoMap(Map<String, List<AdjustRecordDto>> adjustDetailDtoMap) {
            this.adjustDetailDtoMap = adjustDetailDtoMap;
        }

        public Map<String, List<DynamicObject>> getAdjustDetailMap() {
            return this.adjustDetailMap;
        }

        public void setAdjustDetailMap(Map<String, List<DynamicObject>> adjustDetailMap) {
            this.adjustDetailMap = adjustDetailMap;
        }

        public Boolean getReshareofuncleart() {
            return this.reshareofuncleart;
        }

        public void setReshareofuncleart(Boolean reshareofuncleart) {
            this.reshareofuncleart = reshareofuncleart;
        }

        public Boolean getDichotomy() {
            return this.dichotomy;
        }

        public void setDichotomy(Boolean dichotomy) {
            this.dichotomy = dichotomy;
        }

        public BigDecimal getZzssl() {
            return this.zzssl;
        }

        public void setZzssl(BigDecimal zzssl) {
            this.zzssl = zzssl;
        }

        public Map<Object, Map<Object, BigDecimal>> getRoomDetailGoodValueGroup() {
            return this.roomDetailGoodValueGroup;
        }

        public void setRoomDetailGoodValueGroup(Map<Object, Map<Object, BigDecimal>> roomDetailGoodValueGroup) {
            this.roomDetailGoodValueGroup = roomDetailGoodValueGroup;
        }

        public Map<Object, Map<Object, BigDecimal>> getNotaxrevenueGroup() {
            return this.notaxrevenueGroup;
        }

        public void setNotaxrevenueGroup(Map<Object, Map<Object, BigDecimal>> notaxrevenueGroup) {
            this.notaxrevenueGroup = notaxrevenueGroup;
        }

        public Map<Object, Map<Object, BigDecimal>> getStxsincomenotaxGroup() {
            return this.stxsincomenotaxGroup;
        }

        public void setStxsincomenotaxGroup(Map<Object, Map<Object, BigDecimal>> stxsincomenotaxGroup) {
            this.stxsincomenotaxGroup = stxsincomenotaxGroup;
        }

        public Map<Object, Map<Object, BigDecimal>> getNotaxrevenue2Group() {
            return this.notaxrevenue2Group;
        }

        public void setNotaxrevenue2Group(Map<Object, Map<Object, BigDecimal>> notaxrevenue2Group) {
            this.notaxrevenue2Group = notaxrevenue2Group;
        }

        public String getDjdjmethod() {
            return this.djdjmethod;
        }

        public void setDjdjmethod(String djdjmethod) {
            this.djdjmethod = djdjmethod;
        }

        public Map<Object, Map<String, BigDecimal>> getQtSplitTaxTypeGroup() {
            return this.qtSplitTaxTypeGroup;
        }

        public void setQtSplitTaxTypeGroup(Map<Object, Map<String, BigDecimal>> qtSplitTaxTypeGroup) {
            this.qtSplitTaxTypeGroup = qtSplitTaxTypeGroup;
        }

        public Map<Object, Map<Object, Map<String, BigDecimal>>> getAddDecutPeriodSplitTaxTypeGroup() {
            return this.addDecutPeriodSplitTaxTypeGroup;
        }

        public void setAddDecutPeriodSplitTaxTypeGroup(Map<Object, Map<Object, Map<String, BigDecimal>>> addDecutPeriodSplitTaxTypeGroup) {
            this.addDecutPeriodSplitTaxTypeGroup = addDecutPeriodSplitTaxTypeGroup;
        }

        public Map<Object, Map<String, BigDecimal>> getFtDgSjGroup() {
            return this.ftDgSjGroup;
        }

        public void setFtDgSjGroup(Map<Object, Map<String, BigDecimal>> ftDgSjGroup) {
            this.ftDgSjGroup = ftDgSjGroup;
        }

        public Map<Object, Map<String, BigDecimal>> getYjTzsCsTaxTypeGroup() {
            return this.yjTzsCsTaxTypeGroup;
        }

        public void setYjTzsCsTaxTypeGroup(Map<Object, Map<String, BigDecimal>> yjTzsCsTaxTypeGroup) {
            this.yjTzsCsTaxTypeGroup = yjTzsCsTaxTypeGroup;
        }
    }
}

